/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.customobject.resource;

import com.pg85.otg.config.biome.BiomeResourceBase;
import com.pg85.otg.customobject.CustomObject;
import com.pg85.otg.customobject.CustomObjectManager;
import com.pg85.otg.customobject.config.CustomObjectResourcesManager;
import com.pg85.otg.customobject.resource.ICustomStructureResource;
import com.pg85.otg.customobject.structures.StructuredCustomObject;
import com.pg85.otg.exceptions.InvalidConfigException;
import com.pg85.otg.interfaces.IBiomeConfig;
import com.pg85.otg.interfaces.ICustomObjectManager;
import com.pg85.otg.interfaces.ICustomObjectResourcesManager;
import com.pg85.otg.interfaces.ICustomStructureGen;
import com.pg85.otg.interfaces.ILogger;
import com.pg85.otg.interfaces.IMaterialReader;
import com.pg85.otg.interfaces.IModLoadedChecker;
import com.pg85.otg.interfaces.IStructuredCustomObject;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

public class CustomStructureResource
extends BiomeResourceBase
implements ICustomStructureResource,
ICustomStructureGen {
    private final List<Double> objectChances;
    public final List<String> objectNames = new ArrayList<String>();

    public CustomStructureResource(IBiomeConfig biomeConfig, List<String> args, ILogger logger, IMaterialReader materialReader) throws InvalidConfigException {
        super(biomeConfig, args, logger, materialReader);
        this.objectChances = new ArrayList<Double>();
        for (int i = 0; i < args.size() - 1; i += 2) {
            this.objectNames.add(args.get(i));
            this.objectChances.add(this.readRarity(args.get(i + 1)));
        }
        biomeConfig.setStructureGen(this);
    }

    @Override
    public Double getObjectChance(int i) {
        return this.objectChances.size() < i + 1 ? null : this.objectChances.get(i);
    }

    @Override
    public String getObjectName(int i) {
        return this.objectNames.size() < i + 1 ? null : this.objectNames.get(i);
    }

    @Override
    public boolean isEmpty() {
        return this.objectNames.isEmpty();
    }

    @Override
    public List<IStructuredCustomObject> getObjects(String presetFolderName, Path otgRootFolder, ILogger logger, ICustomObjectManager customObjectManager, IMaterialReader materialReader, ICustomObjectResourcesManager manager, IModLoadedChecker modLoadedChecker) {
        ArrayList<IStructuredCustomObject> objects = new ArrayList<IStructuredCustomObject>();
        if (!this.objectNames.isEmpty()) {
            for (int i = 0; i < this.objectNames.size(); ++i) {
                CustomObject object = ((CustomObjectManager)customObjectManager).getGlobalObjects().getObjectByName(this.objectNames.get(i), presetFolderName, otgRootFolder, logger, (CustomObjectManager)customObjectManager, materialReader, (CustomObjectResourcesManager)manager, modLoadedChecker);
                objects.add((StructuredCustomObject)object);
            }
        }
        return objects;
    }

    @Override
    public String toString() {
        if (this.objectNames.isEmpty()) {
            return "CustomStructure()";
        }
        String output = "CustomStructure(" + this.objectNames.get(0) + "," + this.objectChances.get(0);
        for (int i = 1; i < this.objectNames.size(); ++i) {
            output = output + "," + this.objectNames.get(i) + "," + this.objectChances.get(i);
        }
        return output + ")";
    }
}

