/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.customobject.resource;

import com.pg85.otg.constants.SettingsEnums;
import com.pg85.otg.customobject.CustomObjectManager;
import com.pg85.otg.customobject.config.CustomObjectResourcesManager;
import com.pg85.otg.customobject.structures.CustomStructureCache;
import com.pg85.otg.customobject.structures.bo3.BO3CustomStructure;
import com.pg85.otg.interfaces.IMaterialReader;
import com.pg85.otg.interfaces.IModLoadedChecker;
import com.pg85.otg.interfaces.IWorldGenRegion;
import java.nio.file.Path;
import java.util.Random;

public interface ICustomStructureResource {
    default public void processForChunkDecoration(CustomStructureCache structureCache, IWorldGenRegion worldGenRegion, Random random, Path otgRootFolder, CustomObjectManager customObjectManager, IMaterialReader materialReader, CustomObjectResourcesManager manager, IModLoadedChecker modLoadedChecker) {
        this.spawnForChunkDecoration(structureCache, worldGenRegion, random, otgRootFolder, customObjectManager, materialReader, manager, modLoadedChecker);
    }

    default public void spawnForChunkDecoration(CustomStructureCache structureCache, IWorldGenRegion worldGenRegion, Random random, Path otgRootFolder, CustomObjectManager customObjectManager, IMaterialReader materialReader, CustomObjectResourcesManager manager, IModLoadedChecker modLoadedChecker) {
        if (worldGenRegion.getWorldConfig().getCustomStructureType() != SettingsEnums.CustomStructureType.BO4) {
            int searchRadius = worldGenRegion.getWorldConfig().getMaximumCustomStructureRadius();
            int currentChunkX = worldGenRegion.getDecorationArea().getChunkBeingDecorated().getChunkX();
            int currentChunkZ = worldGenRegion.getDecorationArea().getChunkBeingDecorated().getChunkZ();
            for (int searchChunkX = currentChunkX - searchRadius; searchChunkX < currentChunkX + searchRadius; ++searchChunkX) {
                for (int searchChunkZ = currentChunkZ - searchRadius; searchChunkZ < currentChunkZ + searchRadius; ++searchChunkZ) {
                    BO3CustomStructure structureStart = structureCache.getBo3StructureStart(worldGenRegion, random, searchChunkX, searchChunkZ, otgRootFolder, customObjectManager, materialReader, manager, modLoadedChecker);
                    if (structureStart == null) continue;
                    structureStart.spawnInChunk(structureCache, worldGenRegion, otgRootFolder, customObjectManager, materialReader, manager, modLoadedChecker);
                }
            }
        }
    }
}

