/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.customobject.structures;

import com.pg85.otg.customobject.CustomObject;
import com.pg85.otg.customobject.CustomObjectManager;
import com.pg85.otg.customobject.config.CustomObjectResourcesManager;
import com.pg85.otg.customobject.structures.StructuredCustomObject;
import com.pg85.otg.interfaces.ILogger;
import com.pg85.otg.interfaces.IMaterialReader;
import com.pg85.otg.interfaces.IModLoadedChecker;
import com.pg85.otg.interfaces.IStructuredCustomObject;
import com.pg85.otg.util.bo3.Rotation;
import com.pg85.otg.util.helpers.MathHelper;
import com.pg85.otg.util.logging.LogCategory;
import com.pg85.otg.util.logging.LogLevel;
import java.nio.file.Path;

public abstract class CustomStructureCoordinate {
    public String bo3Name;
    public String presetFolderName;
    protected transient IStructuredCustomObject object;
    public Rotation rotation;
    public int x;
    public short y;
    public int z;

    protected CustomStructureCoordinate() {
    }

    public int getX() {
        return this.x;
    }

    public short getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public Rotation getRotation() {
        return this.rotation;
    }

    public final int getChunkX() {
        return MathHelper.floor((double)this.x / 16.0);
    }

    public final int getChunkZ() {
        return MathHelper.floor((double)this.z / 16.0);
    }

    public IStructuredCustomObject getObject(Path otgRootFolder, ILogger logger, CustomObjectManager customObjectManager, IMaterialReader materialReader, CustomObjectResourcesManager manager, IModLoadedChecker modLoadedChecker) {
        if (this.object == null) {
            CustomObject object = customObjectManager.getGlobalObjects().getObjectByName(this.bo3Name, this.presetFolderName, otgRootFolder, logger, customObjectManager, materialReader, manager, modLoadedChecker);
            if (object == null || !(object instanceof StructuredCustomObject)) {
                object = null;
                if (logger.getLogCategoryEnabled(LogCategory.CUSTOM_OBJECTS)) {
                    logger.log(LogLevel.ERROR, LogCategory.CUSTOM_OBJECTS, "Could not find BO3/BO4 " + this.bo3Name + " in GlobalObjects or WorldObjects directory.");
                }
            }
            this.bo3Name = object != null ? object.getName() : this.bo3Name;
            this.object = (StructuredCustomObject)object;
            return this.object;
        }
        return this.object;
    }

    public int hashCode() {
        return this.x >> 13 ^ this.y >> 7 ^ this.z ^ this.object.getName().hashCode() ^ this.rotation.toString().hashCode();
    }

    public boolean equals(Object otherObject) {
        if (otherObject == null) {
            return false;
        }
        if (!(otherObject instanceof CustomStructureCoordinate)) {
            return false;
        }
        CustomStructureCoordinate otherCoord = (CustomStructureCoordinate)otherObject;
        if (otherCoord.x != this.x) {
            return false;
        }
        if (otherCoord.y != this.y) {
            return false;
        }
        if (otherCoord.z != this.z) {
            return false;
        }
        if (!otherCoord.rotation.equals((Object)this.rotation)) {
            return false;
        }
        return otherCoord.object.getName().equals(this.object.getName());
    }
}

