/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.customobject.structures;

import com.pg85.otg.constants.Constants;
import com.pg85.otg.customobject.CustomObjectManager;
import com.pg85.otg.customobject.config.CustomObjectResourcesManager;
import com.pg85.otg.customobject.structures.CustomStructure;
import com.pg85.otg.customobject.structures.CustomStructureCoordinate;
import com.pg85.otg.customobject.structures.PlottedChunksRegion;
import com.pg85.otg.customobject.structures.StructureDataRegion;
import com.pg85.otg.customobject.structures.bo3.BO3CustomStructure;
import com.pg85.otg.customobject.structures.bo3.BO3CustomStructureCoordinate;
import com.pg85.otg.customobject.structures.bo4.BO4CustomStructure;
import com.pg85.otg.customobject.structures.bo4.BO4CustomStructureCoordinate;
import com.pg85.otg.customobject.structures.bo4.CustomStructurePlaceHolder;
import com.pg85.otg.customobject.structures.bo4.smoothing.SmoothingAreaLine;
import com.pg85.otg.interfaces.ILogger;
import com.pg85.otg.interfaces.IMaterialReader;
import com.pg85.otg.interfaces.IModLoadedChecker;
import com.pg85.otg.util.ChunkCoordinate;
import com.pg85.otg.util.CompressionUtils;
import com.pg85.otg.util.bo3.Rotation;
import com.pg85.otg.util.helpers.MathHelper;
import com.pg85.otg.util.helpers.StreamHelper;
import com.pg85.otg.util.logging.LogCategory;
import com.pg85.otg.util.logging.LogLevel;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Stack;

public class CustomStructureFileManager {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void savePlottedChunksData(Path worldSaveDir, String presetFolderName, Map<ChunkCoordinate, PlottedChunksRegion> decoratedChunks, ILogger logger) {
        int regionsSaved = 0;
        if (decoratedChunks.size() > 0) {
            for (Map.Entry<ChunkCoordinate, PlottedChunksRegion> chunkPerRegionEntry : decoratedChunks.entrySet()) {
                if (!chunkPerRegionEntry.getValue().requiresSave()) continue;
                chunkPerRegionEntry.getValue().markSaved();
                ++regionsSaved;
                File occupiedChunksFile = new File(worldSaveDir + File.separator + "OpenTerrainGenerator" + File.separator + presetFolderName + File.separator + Constants.PlottedChunksDataFolderName + File.separator + chunkPerRegionEntry.getKey().getChunkX() + "_" + chunkPerRegionEntry.getKey().getChunkZ() + ".dat");
                File occupiedChunksBackupFile = new File(worldSaveDir + File.separator + "OpenTerrainGenerator" + File.separator + presetFolderName + File.separator + Constants.PlottedChunksDataFolderName + File.separator + chunkPerRegionEntry.getKey().getChunkX() + "_" + chunkPerRegionEntry.getKey().getChunkZ() + "-backup.dat");
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                DataOutputStream dos = new DataOutputStream(bos);
                boolean[][] entriesByStructureName = chunkPerRegionEntry.getValue().getArray();
                try {
                    int version = 1;
                    dos.writeInt(version);
                    dos.writeInt(100);
                    for (int x = 0; x < 100; ++x) {
                        boolean[] structureArr = entriesByStructureName[x];
                        for (int z = 0; z < 100; ++z) {
                            dos.writeBoolean(structureArr[z]);
                        }
                    }
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                    return;
                }
                FilterOutputStream dos2 = null;
                FileOutputStream fos = null;
                try {
                    if (!occupiedChunksFile.exists()) {
                        occupiedChunksFile.getParentFile().mkdirs();
                    } else {
                        Files.move(occupiedChunksFile.toPath(), occupiedChunksBackupFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    }
                    byte[] compressedBytes = CompressionUtils.compress(bos.toByteArray(), logger);
                    dos.close();
                    fos = new FileOutputStream(occupiedChunksFile);
                    dos2 = new DataOutputStream(fos);
                    ((DataOutputStream)dos2).write(compressedBytes, 0, compressedBytes.length);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    logger.log(LogLevel.ERROR, LogCategory.MAIN, "OTG encountered an error writing " + occupiedChunksFile.getAbsolutePath() + ", skipping.");
                }
                finally {
                    try {
                        if (dos != null) {
                            dos.close();
                        }
                    }
                    catch (Exception exception) {}
                    try {
                        if (dos2 != null) {
                            dos2.close();
                        }
                    }
                    catch (Exception exception) {}
                    try {
                        if (fos == null) continue;
                        fos.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        if (logger.getLogCategoryEnabled(LogCategory.STRUCTURE_PLOTTING)) {
            logger.log(LogLevel.INFO, LogCategory.STRUCTURE_PLOTTING, regionsSaved + " plotted chunk regions saved.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<ChunkCoordinate, PlottedChunksRegion> loadPlottedChunksData(Path worldSaveDir, String presetFolderName, ILogger logger) {
        HashMap<ChunkCoordinate, PlottedChunksRegion> output = new HashMap<ChunkCoordinate, PlottedChunksRegion>();
        File occupiedChunksFolder = new File(worldSaveDir + File.separator + "OpenTerrainGenerator" + File.separator + presetFolderName + File.separator + Constants.PlottedChunksDataFolderName + File.separator);
        HashMap<File, File> saveFiles = new HashMap<File, File>();
        ArrayList<Object> mainFiles = new ArrayList<Object>();
        ArrayList<Object> backupFiles = new ArrayList<Object>();
        if (occupiedChunksFolder.exists()) {
            for (File file : occupiedChunksFolder.listFiles()) {
                if (file.getPath().endsWith(".dat") && file.getName().replace(".dat", "").split("_").length == 2 && MathHelper.tryParseInt(file.getName().replace(".dat", "").split("_")[0]) && MathHelper.tryParseInt(file.getName().replace(".dat", "").split("_")[1])) {
                    mainFiles.add(file);
                    continue;
                }
                if (!file.getPath().endsWith("-backup.dat") || file.getName().replace("-backup", "").split("_").length != 2 || !MathHelper.tryParseInt(file.getName().replace("-backup", "").split("_")[0]) || !MathHelper.tryParseInt(file.getName().replace("-backup", "").split("_")[1])) continue;
                backupFiles.add(file);
            }
            for (File file : mainFiles) {
                boolean bFound = false;
                for (File file2 : backupFiles) {
                    if (!file.getPath().replace(".dat", "").equals(file2.getPath().replace("-backup.dat", ""))) continue;
                    saveFiles.put(file, file2);
                    bFound = true;
                    break;
                }
                if (bFound) continue;
                saveFiles.put(file, null);
            }
        }
        for (Map.Entry entry : saveFiles.entrySet()) {
            byte[] decompressedBytes;
            byte[] compressedBytes;
            ByteBuffer buffer;
            int regionZ;
            int regionX;
            String[] chunkCoords;
            PlottedChunksRegion result;
            FileInputStream fis;
            boolean bSuccess = false;
            File file = (File)entry.getKey();
            File file3 = (File)entry.getValue();
            if (!(file != null && file.exists() || file3 != null && file3.exists())) continue;
            ChunkCoordinate regionCoord = null;
            if (file != null && file.exists()) {
                fis = null;
                result = null;
                try {
                    chunkCoords = file.getName().replace(".dat", "").split("_");
                    regionX = Integer.parseInt(chunkCoords[0]);
                    regionZ = Integer.parseInt(chunkCoords[1]);
                    regionCoord = ChunkCoordinate.fromChunkCoords(regionX, regionZ);
                    fis = new FileInputStream(file);
                    buffer = fis.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, fis.getChannel().size());
                    compressedBytes = new byte[(int)fis.getChannel().size()];
                    buffer.get(compressedBytes);
                    decompressedBytes = CompressionUtils.decompress(compressedBytes);
                    buffer = ByteBuffer.wrap(decompressedBytes);
                    result = CustomStructureFileManager.parsePlottedChunksFileFromStream(buffer, logger);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    logger.log(LogLevel.WARN, LogCategory.MAIN, "Failed to load " + file.getAbsolutePath() + ", trying to load backup.");
                }
                finally {
                    if (fis != null) {
                        try {
                            fis.getChannel().close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        try {
                            fis.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
                if (result != null) {
                    bSuccess = true;
                    output.put(regionCoord, result);
                }
            }
            if (!bSuccess && file3 != null && file3.exists()) {
                fis = null;
                result = null;
                try {
                    chunkCoords = file.getName().replace("-backup.dat", "").split("_");
                    regionX = Integer.parseInt(chunkCoords[0]);
                    regionZ = Integer.parseInt(chunkCoords[1]);
                    regionCoord = ChunkCoordinate.fromChunkCoords(regionX, regionZ);
                    fis = new FileInputStream(file3);
                    buffer = fis.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, fis.getChannel().size());
                    compressedBytes = new byte[(int)fis.getChannel().size()];
                    buffer.get(compressedBytes);
                    decompressedBytes = CompressionUtils.decompress(compressedBytes);
                    buffer = ByteBuffer.wrap(decompressedBytes);
                    result = CustomStructureFileManager.parsePlottedChunksFileFromStream(buffer, logger);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                finally {
                    if (fis != null) {
                        try {
                            fis.getChannel().close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        try {
                            fis.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
                if (result != null) {
                    bSuccess = true;
                    output.put(regionCoord, result);
                }
            }
            if (bSuccess) continue;
            if (regionCoord != null) {
                output.put(regionCoord, PlottedChunksRegion.getFilledRegion());
                logger.log(LogLevel.ERROR, LogCategory.MAIN, "OTG encountered an error loading " + file.getAbsolutePath() + " and could not load a backup, substituting a default filled region. This may result in areas with missing BO4's, smoothing areas, /otg structure info and spawners/particles/moddata.");
                continue;
            }
            logger.log(LogLevel.FATAL, LogCategory.MAIN, "OTG encountered a critical error loading " + file.getAbsolutePath() + " and could not load a backup, exiting. OTG automatically backs up files before writing and will try to use the backup when loading. If your dimension's structure data files and backups have been corrupted, you can delete them,at the risk of losing data for unspawned structure parts.");
            throw new RuntimeException("OTG encountered a critical error loading " + file.getAbsolutePath() + " and could not load a backup, exiting. OTG automatically backs up files before writing and will try to use the backup when loading. If your dimension's structure data files and backups have been corrupted, you can delete them,at the risk of losing data for unspawned structure parts.");
        }
        return output.size() > 0 ? output : null;
    }

    private static PlottedChunksRegion parsePlottedChunksFileFromStream(ByteBuffer buffer, ILogger logger) throws IOException {
        buffer.getInt();
        int regionSize = buffer.getInt();
        boolean[][] chunksMatrix = new boolean[100][100];
        if (regionSize == 100) {
            for (int x = 0; x < regionSize; ++x) {
                for (int z = 0; z < regionSize; ++z) {
                    chunksMatrix[x][z] = buffer.get() != 0;
                }
            }
        } else {
            logger.log(LogLevel.ERROR, LogCategory.MAIN, "PlottedChunks region files were corrupted or exported with an incompatible version of OTG, ignoring.");
            return PlottedChunksRegion.getFilledRegion();
        }
        return new PlottedChunksRegion(chunksMatrix);
    }

    static void saveStructureData(Map<ChunkCoordinate, StructureDataRegion> worldInfoChunks, String presetFolderName, Path worldSaveDir, ILogger logger) {
        int regionsSaved = 0;
        for (Map.Entry<ChunkCoordinate, StructureDataRegion> cachedRegion : worldInfoChunks.entrySet()) {
            if (!cachedRegion.getValue().requiresSave()) continue;
            cachedRegion.getValue().markSaved();
            ++regionsSaved;
            HashMap<String, HashMap<CustomStructure, ArrayList<ChunkCoordinate>>> structuresPerRegion = new HashMap<String, HashMap<CustomStructure, ArrayList<ChunkCoordinate>>>();
            for (int internalX = 0; internalX < 100; ++internalX) {
                for (int internalZ = 0; internalZ < 100; ++internalZ) {
                    ChunkCoordinate worldChunkCoord = ChunkCoordinate.fromChunkCoords(cachedRegion.getKey().getChunkX() * 100 + internalX, cachedRegion.getKey().getChunkZ() * 100 + internalZ);
                    CustomStructure structureInChunk = cachedRegion.getValue().getStructure(internalX, internalZ);
                    if (structureInChunk == null) continue;
                    String startBoName = "NULL";
                    if (structureInChunk.start != null) {
                        startBoName = structureInChunk.start.bo3Name;
                    }
                    HashMap<CustomStructure, ArrayList<ChunkCoordinate>> entryByStructureName = structuresPerRegion.get(startBoName);
                    ArrayList<Object> structureChunks = new ArrayList();
                    if (entryByStructureName == null) {
                        entryByStructureName = new HashMap();
                        entryByStructureName.put(structureInChunk, structureChunks);
                        structuresPerRegion.put(startBoName, entryByStructureName);
                    } else {
                        structureChunks = entryByStructureName.get(structureInChunk);
                        if (structureChunks == null) {
                            structureChunks = new ArrayList();
                            entryByStructureName.put(structureInChunk, structureChunks);
                        }
                    }
                    structureChunks.add(worldChunkCoord);
                }
            }
            CustomStructureFileManager.saveStructuresRegionFile(worldSaveDir, presetFolderName, cachedRegion.getKey(), structuresPerRegion, logger);
        }
        if (logger.getLogCategoryEnabled(LogCategory.STRUCTURE_PLOTTING)) {
            logger.log(LogLevel.INFO, LogCategory.STRUCTURE_PLOTTING, regionsSaved + " structure data regions saved.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveStructuresRegionFile(Path worldSaveDir, String presetFolderName, ChunkCoordinate regionCoord, HashMap<String, HashMap<CustomStructure, ArrayList<ChunkCoordinate>>> structuresPerRegion, ILogger logger) {
        File structuresRegionFile = new File(worldSaveDir + File.separator + "OpenTerrainGenerator" + File.separator + presetFolderName + File.separator + "StructureData" + File.separator + regionCoord.getChunkX() + "_" + regionCoord.getChunkZ() + ".dat");
        File structuresRegionBackupFile = new File(worldSaveDir + File.separator + "OpenTerrainGenerator" + File.separator + presetFolderName + File.separator + "StructureData" + File.separator + regionCoord.getChunkX() + "_" + regionCoord.getChunkZ() + "-backup.dat");
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        try {
            int version = 1;
            dos.writeInt(version);
            dos.writeInt(structuresPerRegion.entrySet().size());
            for (Map.Entry<String, HashMap<CustomStructure, ArrayList<ChunkCoordinate>>> entry : structuresPerRegion.entrySet()) {
                StreamHelper.writeStringToStream(dos, entry.getKey());
                dos.writeInt(entry.getValue().entrySet().size());
                for (Map.Entry<CustomStructure, ArrayList<ChunkCoordinate>> entry1 : entry.getValue().entrySet()) {
                    CustomStructure structure = entry1.getKey();
                    if (entry1.getKey().start != null) {
                        dos.writeInt(structure.start.rotation.getRotationId());
                        dos.writeInt(structure.start.getX());
                        dos.writeInt(structure.start.getY());
                        dos.writeInt(structure.start.getZ());
                    }
                    dos.writeInt(entry1.getValue().size());
                    for (ChunkCoordinate chunkCoord : entry1.getValue()) {
                        dos.writeInt(chunkCoord.getChunkX());
                        dos.writeInt(chunkCoord.getChunkZ());
                    }
                    if (structure instanceof BO4CustomStructure && ((BO4CustomStructure)structure).getObjectsToSpawn().entrySet().size() > 0) {
                        dos.writeBoolean(true);
                        HashMap<ChunkCoordinate, Stack<BO4CustomStructureCoordinate>> objectsInRegion = new HashMap<ChunkCoordinate, Stack<BO4CustomStructureCoordinate>>();
                        int size = 0;
                        for (Map.Entry<ChunkCoordinate, Stack<BO4CustomStructureCoordinate>> entry2 : ((BO4CustomStructure)structure).getObjectsToSpawn().entrySet()) {
                            if (!entry2.getKey().toRegionCoord().equals(regionCoord)) continue;
                            objectsInRegion.put(entry2.getKey(), entry2.getValue());
                            ++size;
                        }
                        dos.writeInt(size);
                        for (Map.Entry<ChunkCoordinate, Stack<BO4CustomStructureCoordinate>> entry3 : objectsInRegion.entrySet()) {
                            ChunkCoordinate chunkCoordinate = entry3.getKey();
                            dos.writeInt(chunkCoordinate.getChunkX());
                            dos.writeInt(chunkCoordinate.getChunkZ());
                            Stack<BO4CustomStructureCoordinate> coords = entry3.getValue();
                            dos.writeInt(coords.size());
                            for (CustomStructureCoordinate customStructureCoordinate : coords) {
                                StreamHelper.writeStringToStream(dos, customStructureCoordinate.bo3Name);
                                dos.writeInt(customStructureCoordinate.rotation.getRotationId());
                                dos.writeInt(customStructureCoordinate.getX());
                                dos.writeInt(customStructureCoordinate.getY());
                                dos.writeInt(customStructureCoordinate.getZ());
                            }
                        }
                    } else {
                        dos.writeBoolean(false);
                    }
                    if (structure instanceof BO4CustomStructure && ((BO4CustomStructure)structure).getSmoothingAreaManager().smoothingAreasToSpawn.entrySet().size() > 0) {
                        dos.writeBoolean(true);
                        HashMap<ChunkCoordinate, ArrayList<SmoothingAreaLine>> smoothingAreasPerRegion = new HashMap<ChunkCoordinate, ArrayList<SmoothingAreaLine>>();
                        int size = 0;
                        for (Map.Entry<ChunkCoordinate, ArrayList<SmoothingAreaLine>> entry4 : ((BO4CustomStructure)structure).getSmoothingAreaManager().smoothingAreasToSpawn.entrySet()) {
                            if (!entry4.getKey().toRegionCoord().equals(regionCoord)) continue;
                            smoothingAreasPerRegion.put(entry4.getKey(), entry4.getValue());
                            ++size;
                        }
                        dos.writeInt(size);
                        for (Map.Entry entry5 : smoothingAreasPerRegion.entrySet()) {
                            ChunkCoordinate key = (ChunkCoordinate)entry5.getKey();
                            dos.writeInt(key.getChunkX());
                            dos.writeInt(key.getChunkZ());
                            ArrayList coords2 = (ArrayList)entry5.getValue();
                            dos.writeInt(coords2.size());
                            for (SmoothingAreaLine smoothingAreaLine : coords2) {
                                dos.writeInt(smoothingAreaLine.beginPointX);
                                dos.writeInt(smoothingAreaLine.beginPointY);
                                dos.writeInt(smoothingAreaLine.beginPointZ);
                                dos.writeInt(smoothingAreaLine.endPointX);
                                dos.writeInt(smoothingAreaLine.endPointY);
                                dos.writeInt(smoothingAreaLine.endPointZ);
                                dos.writeInt(smoothingAreaLine.originPointX);
                                dos.writeInt(smoothingAreaLine.originPointY);
                                dos.writeInt(smoothingAreaLine.originPointZ);
                                dos.writeInt(smoothingAreaLine.finalDestinationPointX);
                                dos.writeInt(smoothingAreaLine.finalDestinationPointY);
                                dos.writeInt(smoothingAreaLine.finalDestinationPointZ);
                            }
                        }
                        continue;
                    }
                    dos.writeBoolean(false);
                }
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
            return;
        }
        FilterOutputStream dos2 = null;
        FileOutputStream fos = null;
        try {
            if (!structuresRegionFile.exists()) {
                structuresRegionFile.getParentFile().mkdirs();
            } else {
                Files.move(structuresRegionFile.toPath(), structuresRegionBackupFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            byte[] compressedBytes = CompressionUtils.compress(bos.toByteArray(), logger);
            dos.close();
            fos = new FileOutputStream(structuresRegionFile);
            dos2 = new DataOutputStream(fos);
            ((DataOutputStream)dos2).write(compressedBytes, 0, compressedBytes.length);
        }
        catch (IOException e) {
            logger.log(LogLevel.ERROR, LogCategory.MAIN, "OTG encountered an error writing " + structuresRegionFile.getAbsolutePath() + ", skipping. Exception:");
            e.printStackTrace();
        }
        finally {
            try {
                if (dos != null) {
                    dos.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (dos2 != null) {
                    dos2.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static HashMap<CustomStructure, ArrayList<ChunkCoordinate>> loadStructureData(String presetFolderName, Path worldSaveDir, long worldSeed, boolean isBO4Enabled, Path otgRootFolder, ILogger logger, CustomObjectManager customObjectManager, IMaterialReader materialReader, CustomObjectResourcesManager manager, IModLoadedChecker modLoadedChecker) {
        HashMap<CustomStructure, ArrayList<ChunkCoordinate>> output = new HashMap<CustomStructure, ArrayList<ChunkCoordinate>>();
        File structureDataFolder = new File(worldSaveDir + File.separator + "OpenTerrainGenerator" + File.separator + presetFolderName + File.separator + "StructureData" + File.separator);
        HashMap<File, File> saveFiles = new HashMap<File, File>();
        ArrayList<Object> mainFiles = new ArrayList<Object>();
        ArrayList<Object> backupFiles = new ArrayList<Object>();
        if (structureDataFolder.exists()) {
            for (File file : structureDataFolder.listFiles()) {
                if (file.getPath().endsWith(".dat") && file.getName().replace(".dat", "").split("_").length == 2 && MathHelper.tryParseInt(file.getName().replace(".dat", "").split("_")[0]) && MathHelper.tryParseInt(file.getName().replace(".dat", "").split("_")[1])) {
                    mainFiles.add(file);
                    continue;
                }
                if (!file.getPath().endsWith("-backup.dat") || file.getName().replace("-backup", "").split("_").length != 2 || !MathHelper.tryParseInt(file.getName().replace("-backup", "").split("_")[0]) || !MathHelper.tryParseInt(file.getName().replace("-backup", "").split("_")[1])) continue;
                backupFiles.add(file);
            }
            for (File file : mainFiles) {
                boolean bFound = false;
                for (File file2 : backupFiles) {
                    if (!file.getPath().replace(".dat", "").equals(file2.getPath().replace("-backup.dat", ""))) continue;
                    saveFiles.put(file, file2);
                    bFound = true;
                    break;
                }
                if (bFound) continue;
                saveFiles.put(file, null);
            }
        }
        for (Map.Entry entry : saveFiles.entrySet()) {
            byte[] decompressedBytes;
            byte[] compressedBytes;
            ByteBuffer buffer;
            int regionZ;
            int regionX;
            HashMap<CustomStructure, ArrayList<ChunkCoordinate>> result;
            FileInputStream fis;
            ChunkCoordinate regionCoord = null;
            boolean bl = false;
            File file = (File)entry.getKey();
            File structureDataBackupFile = (File)entry.getValue();
            if ((file == null || !file.exists()) && (structureDataBackupFile == null || !structureDataBackupFile.exists())) continue;
            if (file != null && file.exists()) {
                fis = null;
                result = null;
                try {
                    regionX = Integer.parseInt(file.getName().replace(".dat", "").split("_")[0]);
                    regionZ = Integer.parseInt(file.getName().replace(".dat", "").split("_")[1]);
                    regionCoord = ChunkCoordinate.fromChunkCoords(regionX, regionZ);
                    fis = new FileInputStream(file);
                    buffer = fis.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, fis.getChannel().size());
                    compressedBytes = new byte[(int)fis.getChannel().size()];
                    buffer.get(compressedBytes);
                    decompressedBytes = CompressionUtils.decompress(compressedBytes);
                    buffer = ByteBuffer.wrap(decompressedBytes);
                    result = CustomStructureFileManager.parseStructuresFileFromStream(buffer, regionCoord, presetFolderName, worldSeed, isBO4Enabled, otgRootFolder, logger, customObjectManager, materialReader, manager, modLoadedChecker);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    logger.log(LogLevel.WARN, LogCategory.MAIN, "Failed to load " + file.getAbsolutePath() + ", trying to load backup.");
                }
                finally {
                    if (fis != null) {
                        try {
                            fis.getChannel().close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        try {
                            fis.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
                if (result != null) {
                    bl = true;
                    CustomStructureFileManager.mergeRegionData(result, output);
                }
            }
            if (!bl && structureDataBackupFile != null && structureDataBackupFile.exists()) {
                fis = null;
                result = null;
                try {
                    regionX = Integer.parseInt(structureDataBackupFile.getName().replace("-backup", "").split("_")[0]);
                    regionZ = Integer.parseInt(structureDataBackupFile.getName().replace("-backup", "").split("_")[1]);
                    regionCoord = ChunkCoordinate.fromChunkCoords(regionX, regionZ);
                    fis = new FileInputStream(structureDataBackupFile);
                    buffer = fis.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, fis.getChannel().size());
                    compressedBytes = new byte[(int)fis.getChannel().size()];
                    buffer.get(compressedBytes);
                    decompressedBytes = CompressionUtils.decompress(compressedBytes);
                    buffer = ByteBuffer.wrap(decompressedBytes);
                    result = CustomStructureFileManager.parseStructuresFileFromStream(buffer, regionCoord, presetFolderName, worldSeed, isBO4Enabled, otgRootFolder, logger, customObjectManager, materialReader, manager, modLoadedChecker);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                finally {
                    if (fis != null) {
                        try {
                            fis.getChannel().close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        try {
                            fis.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
                if (result != null) {
                    bl = true;
                    CustomStructureFileManager.mergeRegionData(result, output);
                }
            }
            if (bl) continue;
            logger.log(LogLevel.ERROR, LogCategory.MAIN, "OTG encountered an error loading " + file.getAbsolutePath() + " and could not load a backup, ignoring. This may result in areas with missing BO4's, smoothing areas, /otg structure info and spawners/particles/moddata.");
        }
        return output.size() > 0 ? output : null;
    }

    private static void mergeRegionData(HashMap<CustomStructure, ArrayList<ChunkCoordinate>> result, HashMap<CustomStructure, ArrayList<ChunkCoordinate>> output) {
        block0: for (Map.Entry<CustomStructure, ArrayList<ChunkCoordinate>> entryResult : result.entrySet()) {
            if (output.containsKey(entryResult.getKey())) {
                for (Map.Entry<CustomStructure, ArrayList<ChunkCoordinate>> entryOutput : new HashSet<Map.Entry<CustomStructure, ArrayList<ChunkCoordinate>>>(output.entrySet())) {
                    ArrayList<ChunkCoordinate> coords;
                    if (!entryResult.getKey().equals(entryOutput.getKey())) continue;
                    if (entryResult.getKey() instanceof CustomStructurePlaceHolder) {
                        ((CustomStructurePlaceHolder)entryResult.getKey()).mergeWithCustomStructure((BO4CustomStructure)entryOutput.getKey());
                        coords = entryOutput.getValue();
                        coords.addAll((Collection<ChunkCoordinate>)entryResult.getValue());
                        continue block0;
                    }
                    if (!(entryOutput.getKey() instanceof CustomStructurePlaceHolder)) continue block0;
                    ((CustomStructurePlaceHolder)entryOutput.getKey()).mergeWithCustomStructure((BO4CustomStructure)entryResult.getKey());
                    coords = entryResult.getValue();
                    coords.addAll((Collection<ChunkCoordinate>)entryOutput.getValue());
                    output.remove(entryResult.getKey());
                    output.put(entryResult.getKey(), entryResult.getValue());
                    continue block0;
                }
                continue;
            }
            output.put(entryResult.getKey(), entryResult.getValue());
        }
    }

    private static HashMap<CustomStructure, ArrayList<ChunkCoordinate>> parseStructuresFileFromStream(ByteBuffer buffer, ChunkCoordinate regionCoord, String presetFolderName, long worldSeed, boolean isBO4Enabled, Path otgRootFolder, ILogger logger, CustomObjectManager customObjectManager, IMaterialReader materialReader, CustomObjectResourcesManager manager, IModLoadedChecker modLoadedChecker) throws IOException {
        buffer.getInt();
        HashMap<CustomStructure, ArrayList<ChunkCoordinate>> structuresFile = new HashMap<CustomStructure, ArrayList<ChunkCoordinate>>();
        int structureNamesSize = buffer.getInt();
        for (int i = 0; i < structureNamesSize; ++i) {
            String structureName = StreamHelper.readStringFromBuffer(buffer);
            int structuresSize = buffer.getInt();
            for (int j = 0; j < structuresSize; ++j) {
                CustomStructure structure;
                int coordsSize;
                CustomStructureCoordinate structureStart = null;
                if (!structureName.equals("NULL")) {
                    Rotation startRotationId = Rotation.getRotation(buffer.getInt());
                    int startX = buffer.getInt();
                    int startY = buffer.getInt();
                    int startZ = buffer.getInt();
                    structureStart = isBO4Enabled ? new BO4CustomStructureCoordinate(presetFolderName, null, structureName, startRotationId, startX, (short)startY, startZ, 0, false, false, null) : new BO3CustomStructureCoordinate(presetFolderName, null, structureName, startRotationId, startX, (short)startY, startZ);
                }
                int chunksSize = buffer.getInt();
                ArrayList<ChunkCoordinate> chunkCoords = new ArrayList<ChunkCoordinate>();
                for (int k = 0; k < chunksSize; ++k) {
                    int chunkX = buffer.getInt();
                    int chunkZ = buffer.getInt();
                    chunkCoords.add(ChunkCoordinate.fromChunkCoords(chunkX, chunkZ));
                }
                HashMap<ChunkCoordinate, Stack<BO4CustomStructureCoordinate>> objectsToSpawn = new HashMap<ChunkCoordinate, Stack<BO4CustomStructureCoordinate>>();
                if (buffer.get() != 0) {
                    int objectsToSpawnSize = buffer.getInt();
                    for (int l = 0; l < objectsToSpawnSize; ++l) {
                        ChunkCoordinate chunkCoord = ChunkCoordinate.fromChunkCoords(buffer.getInt(), buffer.getInt());
                        Stack<BO4CustomStructureCoordinate> coords = new Stack<BO4CustomStructureCoordinate>();
                        coordsSize = buffer.getInt();
                        for (int m = 0; m < coordsSize; ++m) {
                            String bo3Name = StreamHelper.readStringFromBuffer(buffer);
                            Rotation coordRotation = Rotation.getRotation(buffer.getInt());
                            int coordX = buffer.getInt();
                            int coordY = buffer.getInt();
                            int coordZ = buffer.getInt();
                            coords.add(new BO4CustomStructureCoordinate(presetFolderName, null, bo3Name, coordRotation, coordX, (short)coordY, coordZ, 0, false, false, null));
                        }
                        objectsToSpawn.put(chunkCoord, coords);
                    }
                }
                HashMap<ChunkCoordinate, ArrayList<SmoothingAreaLine>> smoothingAreasToSpawn = new HashMap<ChunkCoordinate, ArrayList<SmoothingAreaLine>>();
                if (buffer.get() != 0) {
                    int smoothingAreasToSpawnSize = buffer.getInt();
                    for (int l = 0; l < smoothingAreasToSpawnSize; ++l) {
                        ChunkCoordinate chunkCoord = ChunkCoordinate.fromChunkCoords(buffer.getInt(), buffer.getInt());
                        coordsSize = buffer.getInt();
                        ArrayList<SmoothingAreaLine> smoothingAreaLines = new ArrayList<SmoothingAreaLine>();
                        for (int m = 0; m < coordsSize; ++m) {
                            int beginPointX = buffer.getInt();
                            int beginPointY = buffer.getInt();
                            int beginPointZ = buffer.getInt();
                            int endPointX = buffer.getInt();
                            int endPointY = buffer.getInt();
                            int endPointZ = buffer.getInt();
                            int originPointX = buffer.getInt();
                            int originPointY = buffer.getInt();
                            int originPointZ = buffer.getInt();
                            int finalDestinationPointX = buffer.getInt();
                            int finalDestinationPointY = buffer.getInt();
                            int finalDestinationPointZ = buffer.getInt();
                            SmoothingAreaLine smoothingAreaLine = new SmoothingAreaLine(beginPointX, (short)beginPointY, beginPointZ, endPointX, (short)endPointY, endPointZ, originPointX, (short)originPointY, originPointZ, finalDestinationPointX, (short)finalDestinationPointY, finalDestinationPointZ);
                            smoothingAreaLines.add(smoothingAreaLine);
                        }
                        smoothingAreasToSpawn.put(chunkCoord, smoothingAreaLines);
                    }
                }
                if (isBO4Enabled) {
                    ChunkCoordinate startChunkCoord = ChunkCoordinate.fromChunkCoords(structureStart.getChunkX(), structureStart.getChunkZ());
                    structure = !startChunkCoord.toRegionCoord().equals(regionCoord) ? new CustomStructurePlaceHolder(worldSeed, (BO4CustomStructureCoordinate)structureStart, objectsToSpawn, smoothingAreasToSpawn, 0, otgRootFolder, logger, customObjectManager, materialReader, manager, modLoadedChecker) : new BO4CustomStructure(worldSeed, (BO4CustomStructureCoordinate)structureStart, objectsToSpawn, smoothingAreasToSpawn, 0, otgRootFolder, logger, customObjectManager, materialReader, manager, modLoadedChecker);
                    ((BO4CustomStructure)structure).setStartChunkBlockChecksDone();
                } else {
                    structure = new BO3CustomStructure((BO3CustomStructureCoordinate)structureStart);
                }
                structuresFile.put(structure, chunkCoords);
            }
        }
        return structuresFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveChunksMapFile(Path worldSaveDir, String presetFolderName, HashMap<String, ArrayList<ChunkCoordinate>> spawnedStructuresByName, HashMap<String, HashMap<ChunkCoordinate, Integer>> spawnedStructuresByGroup, ILogger logger) {
        File occupiedChunksFile = new File(worldSaveDir + File.separator + "OpenTerrainGenerator" + File.separator + presetFolderName + File.separator + Constants.SpawnedStructuresFileName);
        File occupiedChunksBackupFile = new File(worldSaveDir + File.separator + "OpenTerrainGenerator" + File.separator + presetFolderName + File.separator + Constants.SpawnedStructuresBackupFileName);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        if (spawnedStructuresByName.size() > 0) {
            try {
                int version = 1;
                dos.writeInt(version);
                dos.writeInt(spawnedStructuresByName.entrySet().size());
                for (Map.Entry<String, ArrayList<ChunkCoordinate>> entry : spawnedStructuresByName.entrySet()) {
                    StreamHelper.writeStringToStream(dos, entry.getKey());
                    dos.writeInt(entry.getValue().size());
                    for (ChunkCoordinate chunkCoordinate : entry.getValue()) {
                        dos.writeInt(chunkCoordinate.getChunkX());
                        dos.writeInt(chunkCoordinate.getChunkZ());
                    }
                }
                dos.writeInt(spawnedStructuresByGroup.entrySet().size());
                for (Map.Entry<String, Cloneable> entry : spawnedStructuresByGroup.entrySet()) {
                    StreamHelper.writeStringToStream(dos, entry.getKey());
                    dos.writeInt(((HashMap)entry.getValue()).entrySet().size());
                    for (Map.Entry entry2 : ((HashMap)entry.getValue()).entrySet()) {
                        dos.writeInt(((ChunkCoordinate)entry2.getKey()).getChunkX());
                        dos.writeInt(((ChunkCoordinate)entry2.getKey()).getChunkZ());
                        dos.writeInt((Integer)entry2.getValue());
                    }
                }
            }
            catch (IOException e1) {
                e1.printStackTrace();
                return;
            }
            FilterOutputStream dos2 = null;
            FileOutputStream fos = null;
            try {
                if (!occupiedChunksFile.exists()) {
                    occupiedChunksFile.getParentFile().mkdirs();
                } else {
                    Files.move(occupiedChunksFile.toPath(), occupiedChunksBackupFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
                byte[] byArray = CompressionUtils.compress(bos.toByteArray(), logger);
                fos = new FileOutputStream(occupiedChunksFile);
                dos2 = new DataOutputStream(fos);
                ((DataOutputStream)dos2).write(byArray, 0, byArray.length);
            }
            catch (IOException exception) {
                logger.log(LogLevel.ERROR, LogCategory.MAIN, "OTG encountered an error writing " + occupiedChunksFile.getAbsolutePath() + ", skipping. Exception: ");
                exception.printStackTrace();
            }
            finally {
                try {
                    if (dos != null) {
                        dos.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (dos2 != null) {
                        dos2.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadChunksMapFile(Path worldSaveDir, String presetFolderName, boolean isBO4Enabled, HashMap<String, ArrayList<ChunkCoordinate>> spawnedStructuresByName, HashMap<String, HashMap<ChunkCoordinate, Integer>> spawnedStructuresByGroup, ILogger logger) {
        FileInputStream fis;
        File occupiedChunksFile = new File(worldSaveDir + File.separator + "OpenTerrainGenerator" + File.separator + presetFolderName + File.separator + Constants.SpawnedStructuresFileName);
        File occupiedChunksBackupFile = new File(worldSaveDir + File.separator + "OpenTerrainGenerator" + File.separator + presetFolderName + File.separator + Constants.SpawnedStructuresBackupFileName);
        if (!occupiedChunksFile.exists() && !occupiedChunksBackupFile.exists()) {
            return;
        }
        if (occupiedChunksFile.exists()) {
            fis = null;
            try {
                fis = new FileInputStream(occupiedChunksFile);
                ByteBuffer buffer = fis.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, fis.getChannel().size());
                byte[] compressedBytes = new byte[(int)fis.getChannel().size()];
                buffer.get(compressedBytes);
                byte[] decompressedBytes = CompressionUtils.decompress(compressedBytes);
                buffer = ByteBuffer.wrap(decompressedBytes);
                CustomStructureFileManager.parseChunksMapFileFromStream(buffer, spawnedStructuresByName, spawnedStructuresByGroup);
                return;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                logger.log(LogLevel.WARN, LogCategory.MAIN, "Failed to load " + occupiedChunksFile.getAbsolutePath() + ", trying to load backup.");
            }
            finally {
                if (fis != null) {
                    try {
                        fis.getChannel().close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    try {
                        fis.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        if (occupiedChunksBackupFile.exists()) {
            fis = null;
            try {
                fis = new FileInputStream(occupiedChunksBackupFile);
                ByteBuffer buffer = fis.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, fis.getChannel().size());
                byte[] compressedBytes = new byte[(int)fis.getChannel().size()];
                buffer.get(compressedBytes);
                byte[] decompressedBytes = CompressionUtils.decompress(compressedBytes);
                buffer = ByteBuffer.wrap(decompressedBytes);
                CustomStructureFileManager.parseChunksMapFileFromStream(buffer, spawnedStructuresByName, spawnedStructuresByGroup);
                return;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                if (fis != null) {
                    try {
                        fis.getChannel().close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    try {
                        fis.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        logger.log(LogLevel.ERROR, LogCategory.MAIN, "OTG encountered an error loading " + occupiedChunksFile.getAbsolutePath() + " and could not load a backup, skipping. ");
    }

    private static void parseChunksMapFileFromStream(ByteBuffer buffer, HashMap<String, ArrayList<ChunkCoordinate>> spawnedStructuresByName, HashMap<String, HashMap<ChunkCoordinate, Integer>> spawnedStructuresByGroup) throws IOException {
        Cloneable coords;
        HashMap<String, Cloneable> chunksByName = new HashMap<String, Cloneable>();
        HashMap<String, Cloneable> chunksByGroup = new HashMap<String, Cloneable>();
        buffer.getInt();
        int spawnedStructuresByNameSize = buffer.getInt();
        for (int i = 0; i < spawnedStructuresByNameSize; ++i) {
            String name = StreamHelper.readStringFromBuffer(buffer);
            int coordsSize = buffer.getInt();
            coords = new ArrayList();
            for (int j = 0; j < coordsSize; ++j) {
                ((ArrayList)coords).add(ChunkCoordinate.fromChunkCoords(buffer.getInt(), buffer.getInt()));
            }
            chunksByName.put(name, coords);
        }
        int spawnedStructuresByGroupSize = buffer.getInt();
        for (int k = 0; k < spawnedStructuresByGroupSize; ++k) {
            String name = StreamHelper.readStringFromBuffer(buffer);
            coords = new HashMap();
            int coordsSize = buffer.getInt();
            for (int l = 0; l < coordsSize; ++l) {
                ((HashMap)coords).put(ChunkCoordinate.fromChunkCoords(buffer.getInt(), buffer.getInt()), buffer.getInt());
            }
            chunksByGroup.put(name, coords);
        }
        spawnedStructuresByName.clear();
        spawnedStructuresByName.putAll(chunksByName);
        spawnedStructuresByGroup.clear();
        spawnedStructuresByGroup.putAll(chunksByGroup);
    }
}

