/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.customobject.structures.bo3;

import com.pg85.otg.customobject.CustomObjectManager;
import com.pg85.otg.customobject.bo3.BO3;
import com.pg85.otg.customobject.config.CustomObjectResourcesManager;
import com.pg85.otg.customobject.structures.CustomStructureCoordinate;
import com.pg85.otg.customobject.util.BoundingBox;
import com.pg85.otg.interfaces.ILogger;
import com.pg85.otg.interfaces.IMaterialReader;
import com.pg85.otg.interfaces.IModLoadedChecker;
import com.pg85.otg.interfaces.IStructuredCustomObject;
import com.pg85.otg.util.ChunkCoordinate;
import com.pg85.otg.util.bo3.Rotation;
import com.pg85.otg.util.logging.LogCategory;
import com.pg85.otg.util.logging.LogLevel;
import java.nio.file.Path;

public class BO3CustomStructureCoordinate
extends CustomStructureCoordinate {
    public BO3CustomStructureCoordinate(String presetFolderName, IStructuredCustomObject object, String customObjectName, Rotation rotation, int x, short y, int z) {
        this.presetFolderName = presetFolderName;
        this.object = object;
        this.bo3Name = object != null ? object.getName() : (customObjectName != null && customObjectName.length() > 0 ? customObjectName : null);
        this.rotation = rotation;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    ChunkCoordinate getDecoratingChunk(Path otgRootFolder, ILogger logger, CustomObjectManager customObjectManager, IMaterialReader materialReader, CustomObjectResourcesManager manager, IModLoadedChecker modLoadedChecker) {
        IStructuredCustomObject object = this.getObject(otgRootFolder, logger, customObjectManager, materialReader, manager, modLoadedChecker);
        if (object == null) {
            return null;
        }
        if (!(object instanceof BO3)) {
            if (logger.getLogCategoryEnabled(LogCategory.CUSTOM_OBJECTS)) {
                logger.log(LogLevel.ERROR, LogCategory.CUSTOM_OBJECTS, "BO3CustomStructure loaded with non-BO3 object " + object.getName());
            }
            return null;
        }
        BoundingBox box = ((BO3)object).getBoundingBox(this.rotation);
        int centerX = this.x + box.getMinX() + box.getWidth() / 2;
        int centerZ = this.z + box.getMinZ() + box.getDepth() / 2;
        return ChunkCoordinate.fromBlockCoords(centerX - 8, centerZ - 8);
    }
}

