/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.customobject.structures.bo4;

import com.pg85.otg.customobject.CustomObject;
import com.pg85.otg.customobject.CustomObjectManager;
import com.pg85.otg.customobject.config.CustomObjectResourcesManager;
import com.pg85.otg.customobject.structures.CustomStructureCoordinate;
import com.pg85.otg.customobject.structures.StructuredCustomObject;
import com.pg85.otg.interfaces.ILogger;
import com.pg85.otg.interfaces.IMaterialReader;
import com.pg85.otg.interfaces.IModLoadedChecker;
import com.pg85.otg.interfaces.IStructuredCustomObject;
import com.pg85.otg.util.bo3.Rotation;
import com.pg85.otg.util.logging.LogCategory;
import com.pg85.otg.util.logging.LogLevel;
import java.nio.file.Path;

public class BO4CustomStructureCoordinate
extends CustomStructureCoordinate {
    public boolean isSpawned;
    int branchDepth;
    boolean isRequiredBranch;
    boolean isWeightedBranch;
    String branchGroup;

    public BO4CustomStructureCoordinate(String presetFolderName, IStructuredCustomObject object, String customObjectName, Rotation rotation, int x, short y, int z, int branchDepth, boolean isRequiredBranch, boolean isWeightedBranch, String branchGroup) {
        this.presetFolderName = presetFolderName;
        this.bo3Name = object != null ? object.getName() : (customObjectName != null && customObjectName.length() > 0 ? customObjectName : null);
        this.object = object;
        this.rotation = rotation != null ? rotation : Rotation.NORTH;
        this.x = x;
        this.y = y;
        this.z = z;
        this.branchDepth = branchDepth;
        this.isRequiredBranch = isRequiredBranch;
        this.isWeightedBranch = isWeightedBranch;
        this.branchGroup = branchGroup;
    }

    @Override
    public IStructuredCustomObject getObject(Path otgRootFolder, ILogger logger, CustomObjectManager customObjectManager, IMaterialReader materialReader, CustomObjectResourcesManager manager, IModLoadedChecker modLoadedChecker) {
        if (this.object == null) {
            CustomObject object = customObjectManager.getGlobalObjects().getObjectByName(this.bo3Name, this.presetFolderName, otgRootFolder, logger, customObjectManager, materialReader, manager, modLoadedChecker);
            if (object == null || !(object instanceof StructuredCustomObject)) {
                object = null;
                if (logger.getLogCategoryEnabled(LogCategory.CUSTOM_OBJECTS)) {
                    logger.log(LogLevel.ERROR, LogCategory.CUSTOM_OBJECTS, "Could not find BO3/BO4 " + this.bo3Name + " in GlobalObjects or WorldObjects directory.");
                }
            }
            this.bo3Name = object != null ? object.getName() : this.bo3Name;
            this.object = (StructuredCustomObject)object;
            return this.object;
        }
        return this.object;
    }

    StructuredCustomObject getStructuredObject(Path otgRootFolder, ILogger logger, CustomObjectManager customObjectManager, IMaterialReader materialReader, CustomObjectResourcesManager manager, IModLoadedChecker modLoadedChecker) {
        return (StructuredCustomObject)this.getObject(otgRootFolder, logger, customObjectManager, materialReader, manager, modLoadedChecker);
    }

    @Override
    public int hashCode() {
        return this.x >> 13 ^ this.y >> 7 ^ this.z ^ this.object.getName().hashCode() ^ this.rotation.toString().hashCode();
    }

    @Override
    public boolean equals(Object otherObject) {
        if (otherObject == null) {
            return false;
        }
        if (!(otherObject instanceof BO4CustomStructureCoordinate)) {
            return false;
        }
        BO4CustomStructureCoordinate otherCoord = (BO4CustomStructureCoordinate)otherObject;
        if (otherCoord.x != this.x) {
            return false;
        }
        if (otherCoord.y != this.y) {
            return false;
        }
        if (otherCoord.z != this.z) {
            return false;
        }
        if (!otherCoord.rotation.equals((Object)this.rotation)) {
            return false;
        }
        return otherCoord.object.getName().equals(this.object.getName());
    }

    public static BO4CustomStructureCoordinate getRotatedBO3CoordsJustified(int x, int y, int z, Rotation newRotation) {
        int rotations = newRotation.getRotationId();
        int rotatedX = x;
        int rotatedZ = z;
        int newX = x;
        int newZ = z;
        for (int i = 0; i < rotations; ++i) {
            newX = 15 - rotatedZ;
            newZ = rotatedX;
            rotatedX = newX;
            rotatedZ = newZ;
        }
        return new BO4CustomStructureCoordinate(null, null, null, newRotation, rotatedX, (short)y, rotatedZ, 0, false, false, null);
    }

    public static BO4CustomStructureCoordinate getRotatedCoord(int x, int y, int z, Rotation newRotation) {
        int rotations = newRotation.getRotationId();
        int rotatedX = x;
        int rotatedZ = z;
        int newX = x;
        int newZ = z;
        for (int i = 0; i < rotations; ++i) {
            newX = rotatedZ;
            newZ = -rotatedX;
            rotatedX = newX;
            rotatedZ = newZ;
        }
        return new BO4CustomStructureCoordinate(null, null, null, newRotation, rotatedX, (short)y, rotatedZ, 0, false, false, null);
    }

    public static BO4CustomStructureCoordinate getRotatedBO3Coords(int x, int y, int z, Rotation newRotation) {
        int rotations = newRotation.getRotationId();
        int rotatedX = x;
        int rotatedZ = z;
        int newX = x;
        int newZ = z;
        for (int i = 0; i < rotations; ++i) {
            newX = rotatedZ - 1;
            newZ = -rotatedX;
            rotatedX = newX;
            rotatedZ = newZ;
        }
        return new BO4CustomStructureCoordinate(null, null, null, newRotation, rotatedX, (short)y, rotatedZ, 0, false, false, null);
    }

    public static BO4CustomStructureCoordinate getRotatedSmoothingCoords(int x, short y, int z, Rotation newRotation) {
        int newX = 0;
        short newY = 0;
        int newZ = 0;
        int rotations = 0;
        if (newRotation == Rotation.WEST) {
            rotations = 1;
        } else if (newRotation == Rotation.SOUTH) {
            rotations = 2;
        } else if (newRotation == Rotation.EAST) {
            rotations = 3;
        }
        if (rotations == 0) {
            newX = x;
            newZ = z;
        }
        if (rotations == 1) {
            newX = z;
            newZ = -x + 15;
        }
        if (rotations == 2) {
            newX = -x + 15;
            newZ = -z + 15;
        }
        if (rotations == 3) {
            newX = -z + 15;
            newZ = x;
        }
        newY = y;
        return new BO4CustomStructureCoordinate(null, null, null, newRotation, newX, newY, newZ, 0, false, false, null);
    }
}

