/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.customobject.structures.bo4;

import com.pg85.otg.customobject.CustomObjectManager;
import com.pg85.otg.customobject.bo4.BO4;
import com.pg85.otg.customobject.config.CustomObjectResourcesManager;
import com.pg85.otg.customobject.structures.CustomStructure;
import com.pg85.otg.customobject.structures.CustomStructureCache;
import com.pg85.otg.customobject.structures.CustomStructureFileManager;
import com.pg85.otg.customobject.structures.PlottedChunksRegion;
import com.pg85.otg.customobject.structures.bo4.BO4CustomStructure;
import com.pg85.otg.customobject.structures.bo4.BO4CustomStructureCoordinate;
import com.pg85.otg.exceptions.InvalidConfigException;
import com.pg85.otg.interfaces.IBiomeConfig;
import com.pg85.otg.interfaces.ICustomStructureGen;
import com.pg85.otg.interfaces.ILogger;
import com.pg85.otg.interfaces.IMaterialReader;
import com.pg85.otg.interfaces.IModLoadedChecker;
import com.pg85.otg.interfaces.IStructuredCustomObject;
import com.pg85.otg.interfaces.IWorldGenRegion;
import com.pg85.otg.util.ChunkCoordinate;
import com.pg85.otg.util.FifoMap;
import com.pg85.otg.util.bo3.Rotation;
import com.pg85.otg.util.logging.LogCategory;
import com.pg85.otg.util.logging.LogLevel;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class CustomStructurePlotter {
    private final Map<ChunkCoordinate, BO4CustomStructure[][]> bo4StructureCache;
    private final Map<ChunkCoordinate, PlottedChunksRegion> plottedChunks;
    private final HashMap<String, ArrayList<ChunkCoordinate>> spawnedStructuresByName;
    private final HashMap<String, HashMap<ChunkCoordinate, Integer>> spawnedStructuresByGroup;
    private final Object processingLock = new Object();
    private boolean processing = false;
    private boolean structurePlottedAtSpawn;
    private final FifoMap<ChunkCoordinate, ArrayList<String>> structureNamesPerChunk = new FifoMap(2048);
    private final FifoMap<ChunkCoordinate, Object> plottedChunksFastCache = new FifoMap(2048);

    public CustomStructurePlotter() {
        this.spawnedStructuresByName = new HashMap();
        this.spawnedStructuresByGroup = new HashMap();
        this.bo4StructureCache = new HashMap<ChunkCoordinate, BO4CustomStructure[][]>();
        this.plottedChunks = new HashMap<ChunkCoordinate, PlottedChunksRegion>();
    }

    private boolean structureCacheContainsKey(ChunkCoordinate chunkCoordinate) {
        ChunkCoordinate regionCoord = chunkCoordinate.toRegionCoord();
        BO4CustomStructure[][] chunkRegion = this.bo4StructureCache.get(regionCoord);
        return chunkRegion != null && chunkRegion[chunkCoordinate.getRegionInternalX()][chunkCoordinate.getRegionInternalZ()] != null;
    }

    private void addToStructureCache(ChunkCoordinate chunkCoordinate, BO4CustomStructure structure) {
        ChunkCoordinate regionCoord = chunkCoordinate.toRegionCoord();
        BO4CustomStructure[][] chunkRegion = this.bo4StructureCache.get(regionCoord);
        if (chunkRegion == null) {
            chunkRegion = new BO4CustomStructure[100][100];
            this.bo4StructureCache.put(regionCoord, chunkRegion);
        }
        chunkRegion[chunkCoordinate.getRegionInternalX()][chunkCoordinate.getRegionInternalZ()] = structure;
    }

    private void removeFromStructureCache(ChunkCoordinate chunkCoordinate) {
        ChunkCoordinate regionCoord = chunkCoordinate.toRegionCoord();
        BO4CustomStructure[][] chunkRegion = this.bo4StructureCache.get(regionCoord);
        if (chunkRegion != null) {
            chunkRegion[chunkCoordinate.getRegionInternalX()][chunkCoordinate.getRegionInternalZ()] = null;
        }
    }

    private BO4CustomStructure getFromStructureCache(ChunkCoordinate chunkCoordinate) {
        ChunkCoordinate regionCoord = chunkCoordinate.toRegionCoord();
        BO4CustomStructure[][] chunkRegion = this.bo4StructureCache.get(regionCoord);
        if (chunkRegion != null) {
            return chunkRegion[chunkCoordinate.getRegionInternalX()][chunkCoordinate.getRegionInternalZ()];
        }
        return null;
    }

    private boolean plottedChunksContainsKey(ChunkCoordinate chunkCoordinate) {
        ChunkCoordinate regionCoord = chunkCoordinate.toRegionCoord();
        PlottedChunksRegion chunkRegion = this.plottedChunks.get(regionCoord);
        return chunkRegion != null && chunkRegion.getChunk(chunkCoordinate.getRegionInternalX(), chunkCoordinate.getRegionInternalZ());
    }

    private void addToPlottedChunks(ChunkCoordinate chunkCoordinate) {
        ChunkCoordinate regionCoord = chunkCoordinate.toRegionCoord();
        PlottedChunksRegion chunkRegion = this.plottedChunks.get(regionCoord);
        if (chunkRegion == null) {
            chunkRegion = new PlottedChunksRegion();
            this.plottedChunks.put(regionCoord, chunkRegion);
        }
        chunkRegion.setChunk(chunkCoordinate.getRegionInternalX(), chunkCoordinate.getRegionInternalZ());
    }

    public boolean isBo4ChunkPlotted(ChunkCoordinate chunkCoordinate) {
        boolean bFound;
        boolean bl = bFound = this.plottedChunksFastCache.containsKey(chunkCoordinate) || this.plottedChunksContainsKey(chunkCoordinate);
        if (bFound) {
            this.plottedChunksFastCache.put(chunkCoordinate, (Object)null);
        }
        return bFound;
    }

    public void addBo4ToStructureCache(ChunkCoordinate chunkCoordinate, BO4CustomStructure structure) {
        this.addToStructureCache(chunkCoordinate, structure);
        this.addToPlottedChunks(chunkCoordinate);
        this.setChunkOccupied(chunkCoordinate);
    }

    public void spawnBO4Chunk(ChunkCoordinate chunkCoordinate, CustomStructureCache structureCache, IWorldGenRegion worldGenRegion, Path otgRootFolder, ILogger logger, CustomObjectManager customObjectManager, IMaterialReader materialReader, CustomObjectResourcesManager manager, IModLoadedChecker modLoadedChecker) {
        BO4CustomStructure structureStart = this.getFromStructureCache(chunkCoordinate);
        if (structureStart != null && structureStart.start != null) {
            structureStart.spawnInChunk(chunkCoordinate, structureCache, worldGenRegion, otgRootFolder, logger, customObjectManager, materialReader, manager, modLoadedChecker);
        } else if (structureStart != null && structureStart.start == null) {
            throw new RuntimeException("This shouldn't happen, please contact Team OTG about this crash.");
        }
        this.removeFromStructureCache(chunkCoordinate);
        this.setChunkOccupied(chunkCoordinate);
    }

    public ChunkCoordinate plotStructures(CustomStructureCache structureCache, IWorldGenRegion worldGenRegion, Random rand, ChunkCoordinate chunkCoord, Path otgRootFolder, ILogger logger, CustomObjectManager customObjectManager, IMaterialReader materialReader, CustomObjectResourcesManager manager, IModLoadedChecker modLoadedChecker) {
        return this.plotStructures(null, null, structureCache, worldGenRegion, rand, chunkCoord, otgRootFolder, logger, customObjectManager, materialReader, manager, modLoadedChecker, false);
    }

    public ChunkCoordinate plotStructures(BO4 targetStructure, ArrayList<String> targetBiomes, CustomStructureCache structureCache, IWorldGenRegion worldGenRegion, Random rand, ChunkCoordinate chunkCoord, Path otgRootFolder, ILogger logger, CustomObjectManager customObjectManager, IMaterialReader materialReader, CustomObjectResourcesManager manager, IModLoadedChecker modLoadedChecker, boolean force) {
        return this.plotStructures(targetStructure, targetBiomes, structureCache, worldGenRegion, rand, chunkCoord, false, otgRootFolder, logger, customObjectManager, materialReader, manager, modLoadedChecker, force);
    }

    private void setChunkOccupied(ChunkCoordinate chunkCoord) {
        this.structureNamesPerChunk.put(chunkCoord, new ArrayList());
        this.plottedChunksFastCache.put(chunkCoord, (Object)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private ChunkCoordinate plotStructures(BO4 targetStructure, ArrayList<String> targetBiomes, CustomStructureCache structureCache, IWorldGenRegion worldGenRegion, Random rand, ChunkCoordinate chunkCoord, boolean spawningStructureAtSpawn, Path otgRootFolder, ILogger logger, CustomObjectManager customObjectManager, IMaterialReader materialReader, CustomObjectResourcesManager manager, IModLoadedChecker modLoadedChecker, boolean force) {
        long startTime;
        block105: {
            double BO3size;
            Object[] topLeftAndLowerRightChunkCoordinates;
            if (!this.structurePlottedAtSpawn) {
                this.structurePlottedAtSpawn = true;
                this.plotStructures(targetStructure, targetBiomes, structureCache, worldGenRegion, rand, worldGenRegion.getSpawnChunk(), true, otgRootFolder, logger, customObjectManager, materialReader, manager, modLoadedChecker, force);
            }
            while (true) {
                Object object = this.processingLock;
                synchronized (object) {
                    if (!this.processing) {
                        this.processing = true;
                        break;
                    }
                    if (targetStructure != null) {
                        return null;
                    }
                }
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    throw new RuntimeException("This shouldn't happen, please ask for help on the OTG Discord or file an issue on the OTG github.");
                }
            }
            startTime = System.currentTimeMillis();
            if (this.isBo4ChunkPlotted(chunkCoord)) break block105;
            IBiomeConfig biomeConfig = worldGenRegion.getCachedBiomeProvider().getBiomeConfig(chunkCoord.getBlockX() + 8, chunkCoord.getBlockZ() + 7);
            ArrayList<ICustomStructureGen> customStructureGens = new ArrayList<ICustomStructureGen>();
            if (targetStructure == null && !worldGenRegion.chunkHasDefaultStructure(rand, chunkCoord)) {
                for (ICustomStructureGen iCustomStructureGen : biomeConfig.getCustomStructures()) {
                    customStructureGens.add(iCustomStructureGen);
                }
            }
            if (targetStructure == null && customStructureGens.size() <= 0) break block105;
            HashMap<IStructuredCustomObject, Double> structuredCustomObjects = new HashMap<IStructuredCustomObject, Double>();
            if (targetStructure != null) {
                if (targetBiomes.size() == 0 || targetBiomes.contains(biomeConfig.getName())) {
                    structuredCustomObjects.put(targetStructure, 100.0);
                }
            } else {
                for (ICustomStructureGen iCustomStructureGen : customStructureGens) {
                    int i = 0;
                    for (IStructuredCustomObject structure : iCustomStructureGen.getObjects(worldGenRegion.getPresetFolderName(), otgRootFolder, logger, customObjectManager, materialReader, manager, modLoadedChecker)) {
                        if (structure == null) continue;
                        if (structure instanceof BO4) {
                            structuredCustomObjects.put(structure, iCustomStructureGen.getObjectChance(i));
                            ++i;
                            continue;
                        }
                        if (!logger.getLogCategoryEnabled(LogCategory.STRUCTURE_PLOTTING)) continue;
                        logger.log(LogLevel.ERROR, LogCategory.STRUCTURE_PLOTTING, "CustomStructure " + structure.getName() + " in biome " + biomeConfig.getName() + " has IsOTGPlus:false and/or is not a BO4, ignoring.");
                    }
                }
            }
            if (structuredCustomObjects.size() <= 0) break block105;
            Object var20_25 = null;
            Object var21_33 = null;
            ArrayList<Object[]> bo4sBySize = new ArrayList<Object[]>();
            ArrayList<String> structuresToSpawn1 = new ArrayList<String>();
            if (targetStructure == null && spawningStructureAtSpawn) {
                for (Map.Entry bo4AndRarity : structuredCustomObjects.entrySet()) {
                    if (((BO4)bo4AndRarity.getKey()).isInvalidConfig || !((BO4)bo4AndRarity.getKey()).getConfig().isSpawnPoint) continue;
                    structuresToSpawn1.add(((IStructuredCustomObject)bo4AndRarity.getKey()).getName());
                    BO4CustomStructureCoordinate bO4CustomStructureCoordinate = new BO4CustomStructureCoordinate(worldGenRegion.getPresetFolderName(), (IStructuredCustomObject)bo4AndRarity.getKey(), null, Rotation.NORTH, chunkCoord.getBlockX(), 0, chunkCoord.getBlockZ(), 0, false, false, null);
                    BO4CustomStructure bO4CustomStructure = new BO4CustomStructure(worldGenRegion.getSeed(), bO4CustomStructureCoordinate, otgRootFolder, logger, customObjectManager, materialReader, manager, modLoadedChecker);
                    try {
                        topLeftAndLowerRightChunkCoordinates = bO4CustomStructure.getMinimumSize(structureCache, worldGenRegion, otgRootFolder, logger, customObjectManager, materialReader, manager, modLoadedChecker);
                        BO3size = Math.abs((Integer)topLeftAndLowerRightChunkCoordinates[0] - -((Integer)topLeftAndLowerRightChunkCoordinates[2]).intValue()) * Math.abs((Integer)topLeftAndLowerRightChunkCoordinates[1] - -((Integer)topLeftAndLowerRightChunkCoordinates[3]).intValue());
                        bo4sBySize.add(new Object[]{bo4AndRarity.getKey(), topLeftAndLowerRightChunkCoordinates, BO3size, bo4AndRarity.getValue()});
                    }
                    catch (InvalidConfigException e) {
                        ((BO4)bo4AndRarity.getKey()).isInvalidConfig = true;
                    }
                }
            }
            if (!spawningStructureAtSpawn || bo4sBySize.size() == 0) {
                if (spawningStructureAtSpawn && bo4sBySize.size() == 0) {
                    spawningStructureAtSpawn = false;
                }
                for (Map.Entry bo4AndRarity : structuredCustomObjects.entrySet()) {
                    if (((BO4)bo4AndRarity.getKey()).isInvalidConfig || (int)Math.round((Double)bo4AndRarity.getValue()) <= 0 || !this.isBO4AllowedToSpawnAtByFrequency(chunkCoord, (BO4)bo4AndRarity.getKey())) continue;
                    structuresToSpawn1.add(((IStructuredCustomObject)bo4AndRarity.getKey()).getName());
                    BO4CustomStructureCoordinate bO4CustomStructureCoordinate = new BO4CustomStructureCoordinate(worldGenRegion.getPresetFolderName(), (IStructuredCustomObject)bo4AndRarity.getKey(), null, Rotation.NORTH, chunkCoord.getBlockX(), 0, chunkCoord.getBlockZ(), 0, false, false, null);
                    BO4CustomStructure bO4CustomStructure = new BO4CustomStructure(worldGenRegion.getSeed(), bO4CustomStructureCoordinate, otgRootFolder, logger, customObjectManager, materialReader, manager, modLoadedChecker);
                    try {
                        topLeftAndLowerRightChunkCoordinates = bO4CustomStructure.getMinimumSize(structureCache, worldGenRegion, otgRootFolder, logger, customObjectManager, materialReader, manager, modLoadedChecker);
                        BO3size = Math.abs((Integer)topLeftAndLowerRightChunkCoordinates[0] - -((Integer)topLeftAndLowerRightChunkCoordinates[2]).intValue()) * Math.abs((Integer)topLeftAndLowerRightChunkCoordinates[1] - -((Integer)topLeftAndLowerRightChunkCoordinates[3]).intValue());
                        int insertAtIndex = bo4sBySize.size();
                        int i = 0;
                        for (Object[] entry : bo4sBySize) {
                            if (((BO4)bo4AndRarity.getKey()).getConfig().timesSpawned < ((BO4)entry[0]).getConfig().timesSpawned || BO3size > (Double)entry[2] && ((BO4)bo4AndRarity.getKey()).getConfig().timesSpawned == ((BO4)entry[0]).getConfig().timesSpawned) {
                                insertAtIndex = i;
                                break;
                            }
                            ++i;
                        }
                        bo4sBySize.add(insertAtIndex, new Object[]{bo4AndRarity.getKey(), topLeftAndLowerRightChunkCoordinates, BO3size, bo4AndRarity.getValue()});
                    }
                    catch (InvalidConfigException e) {
                        ((BO4)bo4AndRarity.getKey()).isInvalidConfig = true;
                    }
                }
            }
            if (bo4sBySize.size() <= 0) break block105;
            block16: for (Object[] currentStructureSpawning : bo4sBySize) {
                int pass = 0;
                int left = 0;
                int right = 0;
                int top = 0;
                int bottom = 0;
                int areaLength = 0;
                int areaWidth = 0;
                Object[] topLeftAndLowerRightChunkCoordinates2 = (Object[])currentStructureSpawning[1];
                int structureLength = (Integer)topLeftAndLowerRightChunkCoordinates2[1] + (Integer)topLeftAndLowerRightChunkCoordinates2[3] + 1;
                int structureWidth = (Integer)topLeftAndLowerRightChunkCoordinates2[0] + (Integer)topLeftAndLowerRightChunkCoordinates2[2] + 1;
                int structureTop = (Integer)topLeftAndLowerRightChunkCoordinates2[0];
                int structureRight = (Integer)topLeftAndLowerRightChunkCoordinates2[1];
                int structureBottom = (Integer)topLeftAndLowerRightChunkCoordinates2[2];
                int structureLeft = (Integer)topLeftAndLowerRightChunkCoordinates2[3];
                while (pass <= 4) {
                    BO4CustomStructureCoordinate bO4CustomStructureCoordinate;
                    BO4CustomStructure bO4CustomStructure;
                    int spawnCoordZ;
                    int spawnCoordX;
                    ChunkCoordinate spawnChunk;
                    void var52_94;
                    Rotation fixedRotation;
                    block122: {
                        block106: {
                            ++pass;
                            if ((int)Math.round((Double)currentStructureSpawning[3]) <= 0 && (!spawningStructureAtSpawn || !((BO4)currentStructureSpawning[0]).getConfig().isSpawnPoint)) continue;
                            left = 0;
                            right = 0;
                            top = 0;
                            bottom = 0;
                            boolean leftEdgeFound = false;
                            boolean rightEdgeFound = false;
                            boolean topEdgeFound = false;
                            boolean bottomEdgeFound = false;
                            if (pass == 1) {
                                topEdgeFound = true;
                                rightEdgeFound = true;
                            }
                            if (pass == 2) {
                                topEdgeFound = true;
                                leftEdgeFound = true;
                            }
                            if (pass == 3) {
                                bottomEdgeFound = true;
                                rightEdgeFound = true;
                            }
                            if (pass == 4) {
                                bottomEdgeFound = true;
                                leftEdgeFound = true;
                            }
                            int scanDistance = 0;
                            fixedRotation = ((BO4)currentStructureSpawning[0]).getConfig().fixedRotation;
                            if (spawningStructureAtSpawn) break block106;
                            while (!(leftEdgeFound && rightEdgeFound && topEdgeFound && bottomEdgeFound)) {
                                ArrayList<String> structuresToSpawn;
                                ArrayList biomeStructures;
                                IBiomeConfig biomeConfig3;
                                boolean canSpawnHere;
                                int i;
                                block115: {
                                    block111: {
                                        block107: {
                                            ++scanDistance;
                                            if (!rightEdgeFound && (fixedRotation == null && right + left + 1 >= structureWidth && right + left + 1 >= structureLength || (fixedRotation == Rotation.NORTH || fixedRotation == Rotation.SOUTH) && right + left + 1 >= structureWidth || (fixedRotation == Rotation.EAST || fixedRotation == Rotation.WEST) && right + left + 1 >= structureLength)) {
                                                rightEdgeFound = true;
                                            }
                                            if (rightEdgeFound) break block107;
                                            for (i = -top; i <= bottom; ++i) {
                                                block109: {
                                                    block108: {
                                                        block110: {
                                                            canSpawnHere = false;
                                                            if (targetStructure == null) break block108;
                                                            if (this.isBo4ChunkPlotted(chunkCoord) || worldGenRegion.chunkHasDefaultStructure(rand, chunkCoord)) break block109;
                                                            if (targetBiomes.size() != 0) break block110;
                                                            canSpawnHere = true;
                                                            break block109;
                                                        }
                                                        biomeConfig3 = worldGenRegion.getCachedBiomeProvider().getBiomeConfig((chunkCoord.getChunkX() + scanDistance) * 16 + 8, (chunkCoord.getChunkZ() + i) * 16 + 7);
                                                        if (!targetBiomes.contains(biomeConfig3.getName())) break block109;
                                                        canSpawnHere = true;
                                                        break block109;
                                                    }
                                                    biomeStructures = (ArrayList)this.structureNamesPerChunk.get(ChunkCoordinate.fromChunkCoords(chunkCoord.getChunkX() + scanDistance, chunkCoord.getChunkZ() + i));
                                                    if (biomeStructures == null) {
                                                        if (!this.isBo4ChunkPlotted(chunkCoord) && !worldGenRegion.chunkHasDefaultStructure(rand, chunkCoord)) {
                                                            biomeConfig3 = worldGenRegion.getCachedBiomeProvider().getBiomeConfig((chunkCoord.getChunkX() + scanDistance) * 16 + 8, (chunkCoord.getChunkZ() + i) * 16 + 7);
                                                            if (!biomeConfig3.getName().equals(biomeConfig.getName())) {
                                                                structuresToSpawn = new ArrayList<String>();
                                                                for (List list : biomeConfig3.getCustomStructureNames()) {
                                                                    for (String bo4Name : list) {
                                                                        structuresToSpawn.add(bo4Name);
                                                                    }
                                                                }
                                                                biomeStructures = structuresToSpawn;
                                                            } else {
                                                                canSpawnHere = true;
                                                                biomeStructures = structuresToSpawn1;
                                                            }
                                                        } else {
                                                            biomeStructures = new ArrayList();
                                                        }
                                                        this.structureNamesPerChunk.put(ChunkCoordinate.fromChunkCoords(chunkCoord.getChunkX() + scanDistance, chunkCoord.getChunkZ() + i), biomeStructures);
                                                    }
                                                    if (biomeStructures != null) {
                                                        for (String string : biomeStructures) {
                                                            if (!string.equals(((BO4)currentStructureSpawning[0]).getName())) continue;
                                                            canSpawnHere = true;
                                                            break;
                                                        }
                                                    }
                                                }
                                                if (canSpawnHere) continue;
                                                rightEdgeFound = true;
                                            }
                                            if (!rightEdgeFound) {
                                                ++right;
                                            }
                                        }
                                        if (!leftEdgeFound && (fixedRotation == null && right + left + 1 >= structureWidth && right + left + 1 >= structureLength || (fixedRotation == Rotation.NORTH || fixedRotation == Rotation.SOUTH) && right + left + 1 >= structureWidth || (fixedRotation == Rotation.EAST || fixedRotation == Rotation.WEST) && right + left + 1 >= structureLength)) {
                                            leftEdgeFound = true;
                                        }
                                        if (leftEdgeFound) break block111;
                                        for (i = -top; i <= bottom; ++i) {
                                            block113: {
                                                block112: {
                                                    block114: {
                                                        canSpawnHere = false;
                                                        if (targetStructure == null) break block112;
                                                        if (this.isBo4ChunkPlotted(chunkCoord) || worldGenRegion.chunkHasDefaultStructure(rand, chunkCoord)) break block113;
                                                        if (targetBiomes.size() != 0) break block114;
                                                        canSpawnHere = true;
                                                        break block113;
                                                    }
                                                    biomeConfig3 = worldGenRegion.getCachedBiomeProvider().getBiomeConfig((chunkCoord.getChunkX() - scanDistance) * 16 + 8, (chunkCoord.getChunkZ() + i) * 16 + 7);
                                                    if (!targetBiomes.contains(biomeConfig3.getName())) break block113;
                                                    canSpawnHere = true;
                                                    break block113;
                                                }
                                                biomeStructures = (ArrayList)this.structureNamesPerChunk.get(ChunkCoordinate.fromChunkCoords(chunkCoord.getChunkX() - scanDistance, chunkCoord.getChunkZ() + i));
                                                if (biomeStructures == null) {
                                                    if (!this.isBo4ChunkPlotted(chunkCoord) && !worldGenRegion.chunkHasDefaultStructure(rand, chunkCoord)) {
                                                        biomeConfig3 = worldGenRegion.getCachedBiomeProvider().getBiomeConfig((chunkCoord.getChunkX() - scanDistance) * 16 + 8, (chunkCoord.getChunkZ() + i) * 16 + 7);
                                                        if (!biomeConfig3.getName().equals(biomeConfig.getName())) {
                                                            structuresToSpawn = new ArrayList();
                                                            for (List list : biomeConfig3.getCustomStructureNames()) {
                                                                for (String bo4Name : list) {
                                                                    structuresToSpawn.add(bo4Name);
                                                                }
                                                            }
                                                            biomeStructures = structuresToSpawn;
                                                        } else {
                                                            canSpawnHere = true;
                                                            biomeStructures = structuresToSpawn1;
                                                        }
                                                    } else {
                                                        biomeStructures = new ArrayList();
                                                    }
                                                    this.structureNamesPerChunk.put(ChunkCoordinate.fromChunkCoords(chunkCoord.getChunkX() - scanDistance, chunkCoord.getChunkZ() + i), biomeStructures);
                                                }
                                                if (biomeStructures != null) {
                                                    for (String string : biomeStructures) {
                                                        if (!string.equals(((BO4)currentStructureSpawning[0]).getName())) continue;
                                                        canSpawnHere = true;
                                                        break;
                                                    }
                                                }
                                            }
                                            if (canSpawnHere) continue;
                                            leftEdgeFound = true;
                                        }
                                        if (!leftEdgeFound) {
                                            ++left;
                                        }
                                    }
                                    if (!bottomEdgeFound && (fixedRotation == null && bottom + top + 1 >= structureWidth && bottom + top + 1 >= structureLength || (fixedRotation == Rotation.NORTH || fixedRotation == Rotation.SOUTH) && bottom + top + 1 >= structureLength || (fixedRotation == Rotation.EAST || fixedRotation == Rotation.WEST) && bottom + top + 1 >= structureWidth)) {
                                        bottomEdgeFound = true;
                                    }
                                    if (bottomEdgeFound) break block115;
                                    for (i = -left; i <= right; ++i) {
                                        block117: {
                                            block116: {
                                                block118: {
                                                    canSpawnHere = false;
                                                    if (targetStructure == null) break block116;
                                                    if (this.isBo4ChunkPlotted(chunkCoord) || worldGenRegion.chunkHasDefaultStructure(rand, chunkCoord)) break block117;
                                                    if (targetBiomes.size() != 0) break block118;
                                                    canSpawnHere = true;
                                                    break block117;
                                                }
                                                biomeConfig3 = worldGenRegion.getCachedBiomeProvider().getBiomeConfig((chunkCoord.getChunkX() + i) * 16 + 8, (chunkCoord.getChunkZ() + scanDistance) * 16 + 7);
                                                if (!targetBiomes.contains(biomeConfig3.getName())) break block117;
                                                canSpawnHere = true;
                                                break block117;
                                            }
                                            biomeStructures = (ArrayList)this.structureNamesPerChunk.get(ChunkCoordinate.fromChunkCoords(chunkCoord.getChunkX() + i, chunkCoord.getChunkZ() + scanDistance));
                                            if (biomeStructures == null) {
                                                if (!this.isBo4ChunkPlotted(chunkCoord) && !worldGenRegion.chunkHasDefaultStructure(rand, chunkCoord)) {
                                                    biomeConfig3 = worldGenRegion.getCachedBiomeProvider().getBiomeConfig((chunkCoord.getChunkX() + i) * 16 + 8, (chunkCoord.getChunkZ() + scanDistance) * 16 + 7);
                                                    if (!biomeConfig3.getName().equals(biomeConfig.getName())) {
                                                        structuresToSpawn = new ArrayList();
                                                        for (List list : biomeConfig3.getCustomStructureNames()) {
                                                            for (String bo4Name : list) {
                                                                structuresToSpawn.add(bo4Name);
                                                            }
                                                        }
                                                        biomeStructures = structuresToSpawn;
                                                    } else {
                                                        canSpawnHere = true;
                                                        biomeStructures = structuresToSpawn1;
                                                    }
                                                } else {
                                                    biomeStructures = new ArrayList();
                                                }
                                                this.structureNamesPerChunk.put(ChunkCoordinate.fromChunkCoords(chunkCoord.getChunkX() + i, chunkCoord.getChunkZ() + scanDistance), biomeStructures);
                                            }
                                            if (biomeStructures != null) {
                                                for (String string : biomeStructures) {
                                                    if (!string.equals(((BO4)currentStructureSpawning[0]).getName())) continue;
                                                    canSpawnHere = true;
                                                    break;
                                                }
                                            }
                                        }
                                        if (canSpawnHere) continue;
                                        bottomEdgeFound = true;
                                    }
                                    if (!bottomEdgeFound) {
                                        ++bottom;
                                    }
                                }
                                if (!topEdgeFound && (fixedRotation == null && bottom + top + 1 >= structureWidth && bottom + top + 1 >= structureLength || (fixedRotation == Rotation.NORTH || fixedRotation == Rotation.SOUTH) && bottom + top + 1 >= structureLength || (fixedRotation == Rotation.EAST || fixedRotation == Rotation.WEST) && bottom + top + 1 >= structureWidth)) {
                                    topEdgeFound = true;
                                }
                                if (topEdgeFound) continue;
                                for (i = -left; i <= right; ++i) {
                                    block120: {
                                        block119: {
                                            block121: {
                                                canSpawnHere = false;
                                                if (targetStructure == null) break block119;
                                                if (this.isBo4ChunkPlotted(chunkCoord) || worldGenRegion.chunkHasDefaultStructure(rand, chunkCoord)) break block120;
                                                if (targetBiomes.size() != 0) break block121;
                                                canSpawnHere = true;
                                                break block120;
                                            }
                                            biomeConfig3 = worldGenRegion.getCachedBiomeProvider().getBiomeConfig((chunkCoord.getChunkX() + i) * 16 + 8, (chunkCoord.getChunkZ() - scanDistance) * 16 + 7);
                                            if (!targetBiomes.contains(biomeConfig3.getName())) break block120;
                                            canSpawnHere = true;
                                            break block120;
                                        }
                                        biomeStructures = (ArrayList)this.structureNamesPerChunk.get(ChunkCoordinate.fromChunkCoords(chunkCoord.getChunkX() + i, chunkCoord.getChunkZ() - scanDistance));
                                        if (biomeStructures == null) {
                                            if (!this.isBo4ChunkPlotted(chunkCoord) && !worldGenRegion.chunkHasDefaultStructure(rand, chunkCoord)) {
                                                biomeConfig3 = worldGenRegion.getCachedBiomeProvider().getBiomeConfig((chunkCoord.getChunkX() + i) * 16 + 8, (chunkCoord.getChunkZ() - scanDistance) * 16 + 7);
                                                if (!biomeConfig3.getName().equals(biomeConfig.getName())) {
                                                    structuresToSpawn = new ArrayList();
                                                    for (List list : biomeConfig3.getCustomStructureNames()) {
                                                        for (String bo4Name : list) {
                                                            structuresToSpawn.add(bo4Name);
                                                        }
                                                    }
                                                    biomeStructures = structuresToSpawn;
                                                } else {
                                                    canSpawnHere = true;
                                                    biomeStructures = structuresToSpawn1;
                                                }
                                            } else {
                                                biomeStructures = new ArrayList();
                                            }
                                            this.structureNamesPerChunk.put(ChunkCoordinate.fromChunkCoords(chunkCoord.getChunkX() + i, chunkCoord.getChunkZ() - scanDistance), biomeStructures);
                                        }
                                        if (biomeStructures != null) {
                                            for (String string : biomeStructures) {
                                                if (!string.equals(((BO4)currentStructureSpawning[0]).getName())) continue;
                                                canSpawnHere = true;
                                                break;
                                            }
                                        }
                                    }
                                    if (canSpawnHere) continue;
                                    topEdgeFound = true;
                                }
                                if (topEdgeFound) continue;
                                ++top;
                            }
                            break block122;
                        }
                        left = (int)Math.ceil((double)((Integer)topLeftAndLowerRightChunkCoordinates2[3] + (Integer)topLeftAndLowerRightChunkCoordinates2[1]) / 2.0);
                        right = (int)Math.floor((double)((Integer)topLeftAndLowerRightChunkCoordinates2[3] + (Integer)topLeftAndLowerRightChunkCoordinates2[1]) / 2.0);
                        top = (int)Math.ceil((double)((Integer)topLeftAndLowerRightChunkCoordinates2[0] + (Integer)topLeftAndLowerRightChunkCoordinates2[2]) / 2.0);
                        bottom = (int)Math.floor((double)((Integer)topLeftAndLowerRightChunkCoordinates2[0] + (Integer)topLeftAndLowerRightChunkCoordinates2[2]) / 2.0);
                    }
                    areaLength = left + right + 1;
                    areaWidth = top + bottom + 1;
                    if ((fixedRotation != null && fixedRotation != Rotation.NORTH && fixedRotation != Rotation.SOUTH || structureLength > areaLength || structureWidth > areaWidth) && (fixedRotation != null && fixedRotation != Rotation.EAST && fixedRotation != Rotation.WEST || structureLength > areaWidth || structureWidth > areaLength)) continue;
                    Rotation rotation = fixedRotation;
                    if (rotation == null) {
                        boolean bl;
                        boolean canSpawnUnrotated = false;
                        boolean bl2 = false;
                        if (structureLength <= areaLength && structureWidth <= areaWidth) {
                            canSpawnUnrotated = true;
                        }
                        if (structureLength <= areaWidth && structureWidth <= areaLength) {
                            bl = true;
                        }
                        Rotation rotation2 = rotation = rand.nextBoolean() ? Rotation.NORTH : Rotation.SOUTH;
                        if (canSpawnUnrotated && bl) {
                            rotation = Rotation.getRandomRotation(rand);
                        } else if (bl) {
                            rotation = rand.nextBoolean() ? Rotation.EAST : Rotation.WEST;
                        }
                    }
                    int structureLengthRotated = 0;
                    boolean bl = false;
                    if (rotation == Rotation.NORTH || rotation == Rotation.SOUTH) {
                        structureLengthRotated = structureLength;
                        int n = structureWidth;
                    } else {
                        structureLengthRotated = structureWidth;
                        int n = structureLength;
                    }
                    int structureBBInsideAreaX = (int)Math.floor((double)(chunkCoord.getChunkX() - left) + (double)(left + right + 1) / 2.0 - (double)structureLengthRotated / 2.0);
                    if (structureBBInsideAreaX > chunkCoord.getChunkX()) {
                        structureBBInsideAreaX = chunkCoord.getChunkX();
                    } else if (structureBBInsideAreaX + structureLengthRotated < chunkCoord.getChunkX()) {
                        structureBBInsideAreaX = chunkCoord.getChunkX() - structureLengthRotated + 1;
                    }
                    int structureBBInsideAreaZ = (int)Math.floor((double)(chunkCoord.getChunkZ() - top) + (double)(top + bottom + 1) / 2.0 - (double)var52_94 / 2.0);
                    if (structureBBInsideAreaZ > chunkCoord.getChunkZ()) {
                        structureBBInsideAreaZ = chunkCoord.getChunkZ();
                    } else if (structureBBInsideAreaZ + var52_94 < chunkCoord.getChunkZ()) {
                        structureBBInsideAreaZ = chunkCoord.getChunkZ() - var52_94 + 1;
                    }
                    if (!this.isBO4AllowedToSpawnAtByFrequency(spawnChunk = ChunkCoordinate.fromChunkCoords(spawnCoordX = structureBBInsideAreaX + (rotation == Rotation.NORTH ? structureLeft : (rotation == Rotation.EAST ? structureBottom : (rotation == Rotation.SOUTH ? structureRight : structureTop))), spawnCoordZ = structureBBInsideAreaZ + (rotation == Rotation.NORTH ? structureTop : (rotation == Rotation.EAST ? structureLeft : (rotation == Rotation.SOUTH ? structureBottom : structureRight)))), (BO4)currentStructureSpawning[0]) || !(bO4CustomStructure = new BO4CustomStructure(structureCache, worldGenRegion, bO4CustomStructureCoordinate = new BO4CustomStructureCoordinate(worldGenRegion.getPresetFolderName(), (BO4)currentStructureSpawning[0], null, rotation, spawnCoordX * 16, 0, spawnCoordZ * 16, 0, false, false, null), spawningStructureAtSpawn, force, targetBiomes, chunkCoord, otgRootFolder, logger, customObjectManager, materialReader, manager, modLoadedChecker)).isSpawned()) continue block16;
                    structureCache.addBo4ToStructureCache(spawnChunk, bO4CustomStructure);
                    BO4 structureCoordConfig = (BO4)bO4CustomStructureCoordinate.getObject(otgRootFolder, logger, customObjectManager, materialReader, manager, modLoadedChecker);
                    ++structureCoordConfig.getConfig().timesSpawned;
                    if (logger.getLogCategoryEnabled(LogCategory.STRUCTURE_PLOTTING)) {
                        logger.log(LogLevel.INFO, LogCategory.STRUCTURE_PLOTTING, "Plotted structure " + structureCoordConfig.getName() + " at chunk " + spawnCoordX + " " + spawnCoordZ + " (" + spawnCoordX * 16 + " 100 " + spawnCoordZ * 16 + ")");
                    }
                    if (((BO4)currentStructureSpawning[0]).getConfig().frequency > 0 || ((BO4)currentStructureSpawning[0]).getConfig().bo4Groups.size() > 0) {
                        String bO3Name = ((BO4)currentStructureSpawning[0]).getName();
                        ChunkCoordinate bo4SpawnCoord = ChunkCoordinate.fromChunkCoords(spawnCoordX, spawnCoordZ);
                        ArrayList<ChunkCoordinate> chunkCoords = this.spawnedStructuresByName.get(bO3Name);
                        if (chunkCoords == null) {
                            chunkCoords = new ArrayList();
                            this.spawnedStructuresByName.put(bO3Name, chunkCoords);
                        }
                        chunkCoords.add(bo4SpawnCoord);
                        if (((BO4)currentStructureSpawning[0]).getConfig().bo4Groups.size() > 0) {
                            int structureCenterX = structureBBInsideAreaX + (int)Math.floor((double)(rotation == Rotation.NORTH || rotation == Rotation.SOUTH ? structureLeft + structureRight + 1 : structureBottom + structureTop + 1) / 2.0);
                            int structureCenterZ = structureBBInsideAreaZ + (int)Math.floor((double)(rotation == Rotation.NORTH || rotation == Rotation.SOUTH ? structureTop + structureBottom + 1 : structureLeft + structureRight + 1) / 2.0);
                            ChunkCoordinate bo4CenterSpawnCoord = ChunkCoordinate.fromChunkCoords(structureCenterX, structureCenterZ);
                            for (Map.Entry<String, Integer> entry : ((BO4)currentStructureSpawning[0]).getConfig().bo4Groups.entrySet()) {
                                String bo4GroupName = entry.getKey();
                                int bo4GroupFrequency = entry.getValue();
                                if (bo4GroupFrequency <= 0) continue;
                                HashMap<ChunkCoordinate, Integer> spawnedStructures = this.spawnedStructuresByGroup.get(bo4GroupName);
                                if (spawnedStructures == null) {
                                    spawnedStructures = new HashMap();
                                    spawnedStructures.put(bo4CenterSpawnCoord, entry.getValue());
                                    this.spawnedStructuresByGroup.put(bo4GroupName, spawnedStructures);
                                    continue;
                                }
                                Integer frequency = spawnedStructures.get(bo4CenterSpawnCoord);
                                if (frequency != null) {
                                    if (frequency >= bo4GroupFrequency) continue;
                                    spawnedStructures.put(bo4CenterSpawnCoord, (int)entry.getValue());
                                    continue;
                                }
                                spawnedStructures.put(bo4CenterSpawnCoord, (int)entry.getValue());
                            }
                        }
                    }
                    if (logger.getLogCategoryEnabled(LogCategory.PERFORMANCE) && System.currentTimeMillis() - startTime > 50L) {
                        IBiomeConfig biomeConfig4 = worldGenRegion.getCachedBiomeProvider().getBiomeConfig(chunkCoord.getBlockX() + 8, chunkCoord.getBlockZ() + 7);
                        logger.log(LogLevel.WARN, LogCategory.PERFORMANCE, "Warning: Plotting BO4's for biome " + biomeConfig4.getName() + " at " + (chunkCoord.getBlockX() + 8) + " ~ " + (chunkCoord.getBlockZ() + 7) + " took " + (System.currentTimeMillis() - startTime) + " Ms.");
                        startTime = System.currentTimeMillis();
                    }
                    if (!this.structureCacheContainsKey(chunkCoord) && targetStructure == null) continue block16;
                    this.processing = false;
                    return spawnChunk;
                }
            }
        }
        this.addToPlottedChunks(chunkCoord);
        this.setChunkOccupied(chunkCoord);
        this.processing = false;
        if (logger.getLogCategoryEnabled(LogCategory.PERFORMANCE) && System.currentTimeMillis() - startTime > 50L) {
            IBiomeConfig biomeConfig4 = worldGenRegion.getCachedBiomeProvider().getBiomeConfig(chunkCoord.getBlockX() + 8, chunkCoord.getBlockZ() + 7);
            logger.log(LogLevel.WARN, LogCategory.PERFORMANCE, "Warning: Plotting BO4's for biome " + biomeConfig4.getName() + " at " + (chunkCoord.getBlockX() + 8) + " ~ " + (chunkCoord.getBlockZ() + 7) + " took " + (System.currentTimeMillis() - startTime) + " Ms.");
        }
        return null;
    }

    private boolean isBO4AllowedToSpawnAtByFrequency(ChunkCoordinate chunkCoord, BO4 BO3ToSpawn) {
        float distanceBetweenStructures;
        int radius = BO3ToSpawn.getConfig().frequency;
        String bO3Name = BO3ToSpawn.getName();
        if (radius > 0) {
            distanceBetweenStructures = 0.0f;
            ArrayList<ChunkCoordinate> chunkCoords = this.spawnedStructuresByName.get(bO3Name);
            if (chunkCoords != null) {
                for (ChunkCoordinate cachedChunk : chunkCoords) {
                    distanceBetweenStructures = (int)Math.floor(Math.sqrt(Math.pow(chunkCoord.getChunkX() - cachedChunk.getChunkX(), 2.0) + Math.pow(chunkCoord.getChunkZ() - cachedChunk.getChunkZ(), 2.0)));
                    if (!(distanceBetweenStructures <= (float)radius)) continue;
                    return false;
                }
            }
        }
        if (BO3ToSpawn.getConfig().bo4Groups.size() > 0) {
            distanceBetweenStructures = 0.0f;
            int cachedChunkRadius = 0;
            ChunkCoordinate cachedChunk = null;
            for (Map.Entry<String, Integer> entry : BO3ToSpawn.getConfig().bo4Groups.entrySet()) {
                HashMap<ChunkCoordinate, Integer> spawnedStructure = this.spawnedStructuresByGroup.get(entry.getKey());
                if (spawnedStructure == null) continue;
                for (Map.Entry<ChunkCoordinate, Integer> cachedChunkEntry : spawnedStructure.entrySet()) {
                    cachedChunk = cachedChunkEntry.getKey();
                    cachedChunkRadius = cachedChunkEntry.getValue();
                    int n = radius = entry.getValue() >= cachedChunkRadius ? entry.getValue() : cachedChunkRadius;
                    distanceBetweenStructures = (int)Math.floor(Math.sqrt(Math.pow(chunkCoord.getChunkX() - cachedChunk.getChunkX(), 2.0) + Math.pow(chunkCoord.getChunkZ() - cachedChunk.getChunkZ(), 2.0)));
                    if (!(distanceBetweenStructures <= (float)radius)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private void savePlottedChunks(Path worldSaveDir, String presetFolderName, ILogger logger) {
        CustomStructureFileManager.savePlottedChunksData(worldSaveDir, presetFolderName, this.plottedChunks, logger);
    }

    private void loadPlottedChunks(Path worldSaveDir, String presetFolderName, ILogger logger) {
        this.plottedChunks.clear();
        this.plottedChunks.putAll(CustomStructureFileManager.loadPlottedChunksData(worldSaveDir, presetFolderName, logger));
    }

    private void saveSpawnedStructures(Path worldSaveDir, String presetFolderName, ILogger logger) {
        CustomStructureFileManager.saveChunksMapFile(worldSaveDir, presetFolderName, this.spawnedStructuresByName, this.spawnedStructuresByGroup, logger);
    }

    private void loadSpawnedStructures(Path worldSaveDir, String presetFolderName, boolean isBO4Enabled, ILogger logger) {
        CustomStructureFileManager.loadChunksMapFile(worldSaveDir, presetFolderName, isBO4Enabled, this.spawnedStructuresByName, this.spawnedStructuresByGroup, logger);
    }

    public void saveStructureCache(Path worldSaveDir, String presetFolderName, boolean isBO4Enabled, ILogger logger) {
        if (isBO4Enabled) {
            this.savePlottedChunks(worldSaveDir, presetFolderName, logger);
            this.saveSpawnedStructures(worldSaveDir, presetFolderName, logger);
        }
    }

    public void loadStructureCache(Path worldSaveDir, String presetFolderName, boolean isBO4Enabled, Map<CustomStructure, ArrayList<ChunkCoordinate>> loadedStructures, ILogger logger) {
        this.bo4StructureCache.clear();
        if (isBO4Enabled) {
            if (loadedStructures != null) {
                for (Map.Entry<CustomStructure, ArrayList<ChunkCoordinate>> loadedStructure : loadedStructures.entrySet()) {
                    if (loadedStructure == null) {
                        throw new RuntimeException("This shouldn't happen, please ask for help on the OTG Discord and/or file an issue on the OTG github.");
                    }
                    for (ChunkCoordinate chunkCoord : ((BO4CustomStructure)loadedStructure.getKey()).getObjectsToSpawn().keySet()) {
                        this.addToStructureCache(chunkCoord, (BO4CustomStructure)loadedStructure.getKey());
                    }
                    for (ChunkCoordinate chunkCoord : ((BO4CustomStructure)loadedStructure.getKey()).getSmoothingAreaManager().getSmoothingAreaChunkCoords()) {
                        this.addToStructureCache(chunkCoord, (BO4CustomStructure)loadedStructure.getKey());
                    }
                }
            }
            this.loadPlottedChunks(worldSaveDir, presetFolderName, logger);
            this.loadSpawnedStructures(worldSaveDir, presetFolderName, isBO4Enabled, logger);
            for (ChunkCoordinate chunkCoord : this.bo4StructureCache.keySet()) {
                this.setChunkOccupied(chunkCoord);
            }
        }
    }
}

