/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.customobject.structures.bo4.smoothing;

import com.pg85.otg.customobject.bo4.BO4Config;
import com.pg85.otg.customobject.structures.bo4.smoothing.SmoothingAreaBlock;
import com.pg85.otg.exceptions.InvalidConfigException;
import com.pg85.otg.interfaces.IBiomeConfig;
import com.pg85.otg.interfaces.ILogger;
import com.pg85.otg.interfaces.IMaterialReader;
import com.pg85.otg.interfaces.IWorldGenRegion;
import com.pg85.otg.util.logging.LogCategory;
import com.pg85.otg.util.logging.LogLevel;
import com.pg85.otg.util.materials.LocalMaterialData;
import com.pg85.otg.util.materials.LocalMaterials;
import java.util.ArrayList;

class SmoothingAreaColumn {
    private int x;
    private int z;
    private final ArrayList<SmoothingAreaBlock> blocks = new ArrayList();
    private SmoothingAreaBlock highestFillingBlock = null;
    private SmoothingAreaBlock lowestCuttingBlock = null;

    SmoothingAreaColumn(int x, int z) {
        this.x = x;
        this.z = z;
    }

    void addBlock(SmoothingAreaBlock block) {
        this.blocks.add(block);
    }

    void processBlocks(IWorldGenRegion worldGenRegion, BO4Config bo4Config, ILogger logger, IMaterialReader materialReader) {
        if (this.highestFillingBlock == null && this.lowestCuttingBlock == null) {
            for (SmoothingAreaBlock block : this.blocks) {
                if (block.smoothingBlockType == SmoothingAreaBlock.enumSmoothingBlockType.FILLING && (this.highestFillingBlock == null || this.highestFillingBlock.y < block.y)) {
                    this.highestFillingBlock = block;
                }
                if (block.smoothingBlockType != SmoothingAreaBlock.enumSmoothingBlockType.CUTTING || this.lowestCuttingBlock != null && this.lowestCuttingBlock.y <= block.y) continue;
                this.lowestCuttingBlock = block;
            }
            if (this.highestFillingBlock != null && this.lowestCuttingBlock != null && this.lowestCuttingBlock.y > this.highestFillingBlock.y) {
                this.lowestCuttingBlock.y = this.highestFillingBlock.y;
            }
        }
        this.spawn(worldGenRegion, bo4Config, logger, materialReader);
    }

    private void spawn(IWorldGenRegion worldGenRegion, BO4Config bo4Config, ILogger logger, IMaterialReader materialReader) {
        block38: {
            LocalMaterialData blockAbove;
            LocalMaterialData surfaceBlock;
            int y;
            LocalMaterialData smoothingGroundBlock;
            LocalMaterialData smoothingSurfaceBlock;
            LocalMaterialData replaceAboveMaterial;
            IBiomeConfig biomeConfig;
            block37: {
                block36: {
                    block35: {
                        biomeConfig = worldGenRegion.getBiomeConfigForDecoration(this.x, this.z);
                        replaceAboveMaterial = null;
                        if (bo4Config.replaceAbove != null && !bo4Config.replaceAbove.trim().isEmpty()) {
                            try {
                                replaceAboveMaterial = materialReader.readMaterial(bo4Config.replaceAbove);
                            }
                            catch (InvalidConfigException e) {
                                if (!logger.getLogCategoryEnabled(LogCategory.CUSTOM_OBJECTS)) break block35;
                                logger.log(LogLevel.ERROR, LogCategory.CUSTOM_OBJECTS, "ReplaceAbove: " + bo4Config.replaceAbove + " could not be parsed as a material for BO4 " + bo4Config.getName());
                            }
                        }
                    }
                    smoothingSurfaceBlock = null;
                    smoothingGroundBlock = null;
                    if (bo4Config.smoothingSurfaceBlock != null && !bo4Config.smoothingSurfaceBlock.trim().isEmpty()) {
                        try {
                            smoothingSurfaceBlock = materialReader.readMaterial(bo4Config.smoothingSurfaceBlock);
                        }
                        catch (InvalidConfigException e) {
                            if (!logger.getLogCategoryEnabled(LogCategory.CUSTOM_OBJECTS)) break block36;
                            logger.log(LogLevel.ERROR, LogCategory.CUSTOM_OBJECTS, "SmoothingSurfaceBlock: " + bo4Config.smoothingSurfaceBlock + " could not be parsed as a material for BO4 " + bo4Config.getName());
                        }
                    }
                }
                if (bo4Config.smoothingGroundBlock != null && !bo4Config.smoothingGroundBlock.trim().isEmpty()) {
                    try {
                        smoothingGroundBlock = materialReader.readMaterial(bo4Config.smoothingGroundBlock);
                    }
                    catch (InvalidConfigException e) {
                        if (!logger.getLogCategoryEnabled(LogCategory.CUSTOM_OBJECTS)) break block37;
                        logger.log(LogLevel.ERROR, LogCategory.CUSTOM_OBJECTS, "SmoothingGroundBlock: " + bo4Config.smoothingGroundBlock + " could not be parsed as a material for BO4 " + bo4Config.getName());
                    }
                }
            }
            int highestBlockInWorld = -1;
            if (this.lowestCuttingBlock != null && this.highestFillingBlock == null && replaceAboveMaterial != null) {
                if (highestBlockInWorld == -1) {
                    highestBlockInWorld = worldGenRegion.getHighestBlockYAt(this.x, this.z, true, false, true, true, true);
                }
                for (y = highestBlockInWorld; y > this.lowestCuttingBlock.y; --y) {
                    if (y <= 0) continue;
                    worldGenRegion.setBlock(this.x, y, this.z, replaceAboveMaterial);
                }
                if (highestBlockInWorld > this.lowestCuttingBlock.y && this.lowestCuttingBlock.y > 0) {
                    surfaceBlock = null;
                    boolean needsReplaceBlocks = bo4Config.doReplaceBlocks;
                    if (smoothingSurfaceBlock != null && !bo4Config.replaceWithBiomeBlocks) {
                        surfaceBlock = smoothingSurfaceBlock;
                    } else {
                        blockAbove = worldGenRegion.getMaterial(this.x, this.lowestCuttingBlock.y + 1, this.z);
                        surfaceBlock = blockAbove != null && (blockAbove.isSolid() || blockAbove.isLiquid()) ? biomeConfig.getGroundBlockAtHeight(worldGenRegion, this.x, this.lowestCuttingBlock.y, this.z) : biomeConfig.getSurfaceBlockAtHeight(worldGenRegion, this.x, this.lowestCuttingBlock.y, this.z);
                        needsReplaceBlocks = false;
                        if (surfaceBlock.isAir()) {
                            surfaceBlock = this.lowestCuttingBlock.y < biomeConfig.getWaterLevelMax() && worldGenRegion.getMaterial(this.x, this.lowestCuttingBlock.y, this.z).isAir() ? LocalMaterials.WATER : null;
                        }
                    }
                    if (surfaceBlock != null) {
                        if (needsReplaceBlocks) {
                            worldGenRegion.setBlock(this.x, (int)this.lowestCuttingBlock.y, this.z, surfaceBlock, biomeConfig.getReplaceBlocks());
                        } else {
                            worldGenRegion.setBlock(this.x, this.lowestCuttingBlock.y, this.z, surfaceBlock);
                        }
                    }
                }
            }
            if (this.highestFillingBlock == null) break block38;
            if (highestBlockInWorld == -1) {
                highestBlockInWorld = worldGenRegion.getHighestBlockYAt(this.x, this.z, true, false, true, true, true);
            }
            if (replaceAboveMaterial != null) {
                for (y = highestBlockInWorld; y > this.highestFillingBlock.y; --y) {
                    if (y <= 0) continue;
                    worldGenRegion.setBlock(this.x, y, this.z, replaceAboveMaterial);
                }
            }
            surfaceBlock = null;
            boolean needsReplaceBlocks = bo4Config.doReplaceBlocks;
            if (smoothingSurfaceBlock != null && !bo4Config.replaceWithBiomeBlocks) {
                surfaceBlock = smoothingSurfaceBlock;
            } else {
                blockAbove = worldGenRegion.getMaterial(this.x, this.highestFillingBlock.y + 1, this.z);
                surfaceBlock = blockAbove != null && (blockAbove.isSolid() || blockAbove.isLiquid()) ? biomeConfig.getGroundBlockAtHeight(worldGenRegion, this.x, this.highestFillingBlock.y, this.z) : biomeConfig.getSurfaceBlockAtHeight(worldGenRegion, this.x, this.highestFillingBlock.y, this.z);
                needsReplaceBlocks = false;
                if (surfaceBlock.isAir()) {
                    surfaceBlock = this.highestFillingBlock.y < biomeConfig.getWaterLevelMax() && worldGenRegion.getMaterial(this.x, this.highestFillingBlock.y, this.z).isAir() ? LocalMaterials.WATER : null;
                }
            }
            if (surfaceBlock != null && this.highestFillingBlock.y > 0) {
                if (needsReplaceBlocks) {
                    worldGenRegion.setBlock(this.x, (int)this.highestFillingBlock.y, this.z, surfaceBlock, biomeConfig.getReplaceBlocks());
                } else {
                    worldGenRegion.setBlock(this.x, this.highestFillingBlock.y, this.z, surfaceBlock);
                }
            }
            if (smoothingGroundBlock != null && !bo4Config.replaceWithBiomeBlocks) {
                for (y = this.highestFillingBlock.y - 1; y >= highestBlockInWorld; --y) {
                    if (y <= 0) continue;
                    LocalMaterialData groundBlock = smoothingGroundBlock;
                    needsReplaceBlocks = bo4Config.doReplaceBlocks;
                    if (groundBlock.isAir() && y < biomeConfig.getWaterLevelMax()) {
                        groundBlock = LocalMaterials.WATER;
                        needsReplaceBlocks = false;
                    }
                    if (needsReplaceBlocks) {
                        worldGenRegion.setBlock(this.x, y, this.z, groundBlock, biomeConfig.getReplaceBlocks());
                        continue;
                    }
                    worldGenRegion.setBlock(this.x, y, this.z, groundBlock);
                }
            } else {
                for (y = this.highestFillingBlock.y - 1; y >= highestBlockInWorld; --y) {
                    if (y <= 0) continue;
                    LocalMaterialData groundBlock = biomeConfig.getGroundBlockAtHeight(worldGenRegion, this.x, (short)y, this.z);
                    if (groundBlock.isAir() && y < biomeConfig.getWaterLevelMax()) {
                        groundBlock = LocalMaterials.WATER;
                    }
                    worldGenRegion.setBlock(this.x, y, this.z, groundBlock);
                }
            }
        }
    }
}

