/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.customobject.structures.bo4.smoothing;

import com.pg85.otg.customobject.CustomObjectManager;
import com.pg85.otg.customobject.bo4.BO4;
import com.pg85.otg.customobject.bo4.BO4Config;
import com.pg85.otg.customobject.bo4.bo4function.BO4BlockFunction;
import com.pg85.otg.customobject.bo4.bo4function.BO4RandomBlockFunction;
import com.pg85.otg.customobject.config.CustomObjectResourcesManager;
import com.pg85.otg.customobject.structures.CustomStructureCache;
import com.pg85.otg.customobject.structures.CustomStructureCoordinate;
import com.pg85.otg.customobject.structures.bo4.BO4CustomStructureCoordinate;
import com.pg85.otg.customobject.structures.bo4.smoothing.BlockCoordsAndNeighbours;
import com.pg85.otg.customobject.structures.bo4.smoothing.SmoothingAreaBlock;
import com.pg85.otg.customobject.structures.bo4.smoothing.SmoothingAreaColumn;
import com.pg85.otg.customobject.structures.bo4.smoothing.SmoothingAreaLine;
import com.pg85.otg.interfaces.ILogger;
import com.pg85.otg.interfaces.IMaterialReader;
import com.pg85.otg.interfaces.IModLoadedChecker;
import com.pg85.otg.interfaces.IWorldGenRegion;
import com.pg85.otg.util.ChunkCoordinate;
import com.pg85.otg.util.bo3.Rotation;
import com.pg85.otg.util.materials.LocalMaterialData;
import java.awt.geom.Point2D;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;

public class SmoothingAreaGenerator {
    public Map<ChunkCoordinate, ArrayList<SmoothingAreaLine>> smoothingAreasToSpawn = new HashMap<ChunkCoordinate, ArrayList<SmoothingAreaLine>>();
    private Map<ChunkCoordinate, ArrayList<SmoothingAreaLine>> smoothingAreasToSpawnPerLineDestination = new HashMap<ChunkCoordinate, ArrayList<SmoothingAreaLine>>();

    public ArrayList<ChunkCoordinate> getSmoothingAreaChunkCoords() {
        return new ArrayList<ChunkCoordinate>(this.smoothingAreasToSpawn.keySet());
    }

    public void calculateSmoothingAreas(Map<ChunkCoordinate, Stack<BO4CustomStructureCoordinate>> objectsToSpawn, BO4CustomStructureCoordinate start, IWorldGenRegion worldGenRegion, Path otgRootFolder, ILogger logger, CustomObjectManager customObjectManager, IMaterialReader materialReader, CustomObjectResourcesManager manager, IModLoadedChecker modLoadedChecker) {
        HashMap<ChunkCoordinate, ArrayList<BlockCoordsAndNeighbours>> smoothToBlocksPerChunk = new HashMap<ChunkCoordinate, ArrayList<BlockCoordsAndNeighbours>>();
        BO4 startBO4 = (BO4)start.getObject(otgRootFolder, logger, customObjectManager, materialReader, manager, modLoadedChecker);
        BO4Config startBO4Config = startBO4.getConfig();
        for (Map.Entry<ChunkCoordinate, Stack<BO4CustomStructureCoordinate>> chunkCoordSet : objectsToSpawn.entrySet()) {
            ChunkCoordinate chunkCoord = chunkCoordSet.getKey();
            Stack<BO4CustomStructureCoordinate> bO3sInChunk = chunkCoordSet.getValue();
            ArrayList<BlockCoordsAndNeighbours> smoothToBlocks = new ArrayList<BlockCoordsAndNeighbours>();
            for (BO4CustomStructureCoordinate objectInChunk : bO3sInChunk) {
                int smoothRadius;
                if (objectInChunk.isSpawned) continue;
                BO4 bO3InChunk = (BO4)objectInChunk.getObject(otgRootFolder, logger, customObjectManager, materialReader, manager, modLoadedChecker);
                boolean smoothStartTop = startBO4Config.overrideChildSettings && bO3InChunk.getConfig().overrideChildSettings ? startBO4Config.smoothStartTop : bO3InChunk.getConfig().smoothStartTop;
                int n = smoothRadius = startBO4Config.overrideChildSettings && bO3InChunk.getConfig().overrideChildSettings && bO3InChunk.getConfig().smoothRadius == -1 ? -1 : startBO4Config.smoothRadius;
                if (smoothRadius == -1 || bO3InChunk.getConfig().smoothRadius == -1) {
                    smoothRadius = 0;
                }
                if (smoothRadius <= 0) continue;
                BO4BlockFunction[][] heightMap = bO3InChunk.getConfig().getSmoothingHeightMap(startBO4, worldGenRegion.getPresetFolderName(), otgRootFolder, logger, customObjectManager, materialReader, manager, modLoadedChecker);
                for (int x = 0; x <= 15; ++x) {
                    for (int z = 0; z <= 15; ++z) {
                        Object[] smoothDirections;
                        BO4CustomStructureCoordinate blockCoords;
                        int normalizedNeigbouringBlockZ;
                        int normalizedNeigbouringBlockY;
                        int normalizedNeigbouringBlockX;
                        BO4CustomStructureCoordinate neighbouringBlockCoords;
                        BO4BlockFunction block = heightMap[x][z];
                        if (block == null) continue;
                        boolean bFoundNeighbour1 = false;
                        boolean bFoundNeighbour2 = false;
                        boolean bFoundNeighbour3 = false;
                        boolean bFoundNeighbour4 = false;
                        if (block.x - 1 >= 0 && heightMap[block.x - 1][block.z] != null) {
                            bFoundNeighbour1 = true;
                        }
                        if (block.x + 1 <= 15 && heightMap[block.x + 1][block.z] != null) {
                            bFoundNeighbour2 = true;
                        }
                        if (block.z - 1 >= 0 && heightMap[block.x][block.z - 1] != null) {
                            bFoundNeighbour3 = true;
                        }
                        if (block.z + 1 <= 15 && heightMap[block.x][block.z + 1] != null) {
                            bFoundNeighbour4 = true;
                        }
                        if (!bFoundNeighbour1 && block.x - 1 < 0) {
                            neighbouringBlockCoords = BO4CustomStructureCoordinate.getRotatedSmoothingCoords(block.x - 1, block.y, block.z, objectInChunk.getRotation());
                            normalizedNeigbouringBlockX = neighbouringBlockCoords.getX() + objectInChunk.getX();
                            normalizedNeigbouringBlockY = neighbouringBlockCoords.getY() + objectInChunk.getY();
                            normalizedNeigbouringBlockZ = neighbouringBlockCoords.getZ() + objectInChunk.getZ();
                            bFoundNeighbour1 = this.findNeighbouringBlock(smoothStartTop, normalizedNeigbouringBlockX, normalizedNeigbouringBlockY, normalizedNeigbouringBlockZ, objectsToSpawn, objectInChunk, start, worldGenRegion.getPresetFolderName(), otgRootFolder, logger, customObjectManager, materialReader, manager, modLoadedChecker);
                        }
                        if (!bFoundNeighbour2 && block.x + 1 > 15) {
                            neighbouringBlockCoords = BO4CustomStructureCoordinate.getRotatedSmoothingCoords(block.x + 1, block.y, block.z, objectInChunk.getRotation());
                            normalizedNeigbouringBlockX = neighbouringBlockCoords.getX() + objectInChunk.getX();
                            normalizedNeigbouringBlockY = neighbouringBlockCoords.getY() + objectInChunk.getY();
                            normalizedNeigbouringBlockZ = neighbouringBlockCoords.getZ() + objectInChunk.getZ();
                            bFoundNeighbour2 = this.findNeighbouringBlock(smoothStartTop, normalizedNeigbouringBlockX, normalizedNeigbouringBlockY, normalizedNeigbouringBlockZ, objectsToSpawn, objectInChunk, start, worldGenRegion.getPresetFolderName(), otgRootFolder, logger, customObjectManager, materialReader, manager, modLoadedChecker);
                        }
                        if (!bFoundNeighbour3 && block.z - 1 < 0) {
                            neighbouringBlockCoords = BO4CustomStructureCoordinate.getRotatedSmoothingCoords(block.x, block.y, block.z - 1, objectInChunk.getRotation());
                            normalizedNeigbouringBlockX = neighbouringBlockCoords.getX() + objectInChunk.getX();
                            normalizedNeigbouringBlockY = neighbouringBlockCoords.getY() + objectInChunk.getY();
                            normalizedNeigbouringBlockZ = neighbouringBlockCoords.getZ() + objectInChunk.getZ();
                            bFoundNeighbour3 = this.findNeighbouringBlock(smoothStartTop, normalizedNeigbouringBlockX, normalizedNeigbouringBlockY, normalizedNeigbouringBlockZ, objectsToSpawn, objectInChunk, start, worldGenRegion.getPresetFolderName(), otgRootFolder, logger, customObjectManager, materialReader, manager, modLoadedChecker);
                        }
                        if (!bFoundNeighbour4 && block.z + 1 > 15) {
                            neighbouringBlockCoords = BO4CustomStructureCoordinate.getRotatedSmoothingCoords(block.x, block.y, block.z + 1, objectInChunk.getRotation());
                            normalizedNeigbouringBlockX = neighbouringBlockCoords.getX() + objectInChunk.getX();
                            normalizedNeigbouringBlockY = neighbouringBlockCoords.getY() + objectInChunk.getY();
                            normalizedNeigbouringBlockZ = neighbouringBlockCoords.getZ() + objectInChunk.getZ();
                            bFoundNeighbour4 = this.findNeighbouringBlock(smoothStartTop, normalizedNeigbouringBlockX, normalizedNeigbouringBlockY, normalizedNeigbouringBlockZ, objectsToSpawn, objectInChunk, start, worldGenRegion.getPresetFolderName(), otgRootFolder, logger, customObjectManager, materialReader, manager, modLoadedChecker);
                        }
                        if (bFoundNeighbour1 && bFoundNeighbour2 && bFoundNeighbour3 && bFoundNeighbour4) continue;
                        int xOffset = 0;
                        int yOffset = 0;
                        int zOffset = 0;
                        int smoothHeightOffset = startBO4Config.overrideChildSettings && bO3InChunk.getConfig().overrideChildSettings ? startBO4Config.smoothHeightOffset : bO3InChunk.getConfig().smoothHeightOffset;
                        yOffset += smoothHeightOffset;
                        if (!bFoundNeighbour1) {
                            xOffset = -1;
                            blockCoords = BO4CustomStructureCoordinate.getRotatedSmoothingCoords(block.x + xOffset, (short)(block.y + yOffset), block.z, objectInChunk.getRotation());
                            smoothDirections = this.rotateSmoothDirections(true, false, false, false, objectInChunk.getRotation());
                            smoothToBlocks.add(new BlockCoordsAndNeighbours(objectInChunk, blockCoords.getX(), blockCoords.getY(), blockCoords.getZ(), (Boolean)smoothDirections[0], (Boolean)smoothDirections[1], (Boolean)smoothDirections[2], (Boolean)smoothDirections[3]));
                            if (!bFoundNeighbour3) {
                                zOffset = -1;
                                blockCoords = BO4CustomStructureCoordinate.getRotatedSmoothingCoords(block.x + xOffset, (short)(block.y + yOffset), block.z + zOffset, objectInChunk.getRotation());
                                smoothDirections = this.rotateSmoothDirections(true, false, true, false, objectInChunk.getRotation());
                                smoothToBlocks.add(new BlockCoordsAndNeighbours(objectInChunk, blockCoords.getX(), blockCoords.getY(), blockCoords.getZ(), (Boolean)smoothDirections[0], (Boolean)smoothDirections[1], (Boolean)smoothDirections[2], (Boolean)smoothDirections[3]));
                            }
                            if (!bFoundNeighbour4) {
                                zOffset = 1;
                                blockCoords = BO4CustomStructureCoordinate.getRotatedSmoothingCoords(block.x + xOffset, (short)(block.y + yOffset), block.z + zOffset, objectInChunk.getRotation());
                                smoothDirections = this.rotateSmoothDirections(true, false, false, true, objectInChunk.getRotation());
                                smoothToBlocks.add(new BlockCoordsAndNeighbours(objectInChunk, blockCoords.getX(), blockCoords.getY(), blockCoords.getZ(), (Boolean)smoothDirections[0], (Boolean)smoothDirections[1], (Boolean)smoothDirections[2], (Boolean)smoothDirections[3]));
                            }
                        }
                        if (!bFoundNeighbour2) {
                            xOffset = 1;
                            blockCoords = BO4CustomStructureCoordinate.getRotatedSmoothingCoords(block.x + xOffset, (short)(block.y + yOffset), block.z, objectInChunk.getRotation());
                            smoothDirections = this.rotateSmoothDirections(false, true, false, false, objectInChunk.getRotation());
                            smoothToBlocks.add(new BlockCoordsAndNeighbours(objectInChunk, blockCoords.getX(), blockCoords.getY(), blockCoords.getZ(), (Boolean)smoothDirections[0], (Boolean)smoothDirections[1], (Boolean)smoothDirections[2], (Boolean)smoothDirections[3]));
                            if (!bFoundNeighbour3) {
                                zOffset = -1;
                                blockCoords = BO4CustomStructureCoordinate.getRotatedSmoothingCoords(block.x + xOffset, (short)(block.y + yOffset), block.z + zOffset, objectInChunk.getRotation());
                                smoothDirections = this.rotateSmoothDirections(false, true, true, false, objectInChunk.getRotation());
                                smoothToBlocks.add(new BlockCoordsAndNeighbours(objectInChunk, blockCoords.getX(), blockCoords.getY(), blockCoords.getZ(), (Boolean)smoothDirections[0], (Boolean)smoothDirections[1], (Boolean)smoothDirections[2], (Boolean)smoothDirections[3]));
                            }
                            if (!bFoundNeighbour4) {
                                zOffset = 1;
                                blockCoords = BO4CustomStructureCoordinate.getRotatedSmoothingCoords(block.x + xOffset, (short)(block.y + yOffset), block.z + zOffset, objectInChunk.getRotation());
                                smoothDirections = this.rotateSmoothDirections(false, true, false, true, objectInChunk.getRotation());
                                smoothToBlocks.add(new BlockCoordsAndNeighbours(objectInChunk, blockCoords.getX(), blockCoords.getY(), blockCoords.getZ(), (Boolean)smoothDirections[0], (Boolean)smoothDirections[1], (Boolean)smoothDirections[2], (Boolean)smoothDirections[3]));
                            }
                        }
                        if (!bFoundNeighbour3) {
                            zOffset = -1;
                            blockCoords = BO4CustomStructureCoordinate.getRotatedSmoothingCoords(block.x, (short)(block.y + yOffset), block.z + zOffset, objectInChunk.getRotation());
                            smoothDirections = this.rotateSmoothDirections(false, false, true, false, objectInChunk.getRotation());
                            smoothToBlocks.add(new BlockCoordsAndNeighbours(objectInChunk, blockCoords.getX(), blockCoords.getY(), blockCoords.getZ(), (Boolean)smoothDirections[0], (Boolean)smoothDirections[1], (Boolean)smoothDirections[2], (Boolean)smoothDirections[3]));
                        }
                        if (bFoundNeighbour4) continue;
                        zOffset = 1;
                        blockCoords = BO4CustomStructureCoordinate.getRotatedSmoothingCoords(block.x, (short)(block.y + yOffset), block.z + zOffset, objectInChunk.getRotation());
                        smoothDirections = this.rotateSmoothDirections(false, false, false, true, objectInChunk.getRotation());
                        smoothToBlocks.add(new BlockCoordsAndNeighbours(objectInChunk, blockCoords.getX(), blockCoords.getY(), blockCoords.getZ(), (Boolean)smoothDirections[0], (Boolean)smoothDirections[1], (Boolean)smoothDirections[2], (Boolean)smoothDirections[3]));
                    }
                }
            }
            if (!smoothToBlocksPerChunk.containsKey(chunkCoord)) {
                smoothToBlocksPerChunk.put(chunkCoord, smoothToBlocks);
                continue;
            }
            ((ArrayList)smoothToBlocksPerChunk.get(chunkCoord)).addAll(smoothToBlocks);
        }
        this.calculateBeginAndEndPointsPerChunk(smoothToBlocksPerChunk, startBO4Config.smoothRadius - 1);
    }

    private Object[] rotateSmoothDirections(Boolean smoothDirection1, Boolean smoothDirection2, Boolean smoothDirection3, Boolean smoothDirection4, Rotation rotation) {
        if (rotation == Rotation.NORTH) {
            return new Object[]{smoothDirection1, smoothDirection2, smoothDirection3, smoothDirection4};
        }
        if (rotation == Rotation.EAST) {
            return new Object[]{smoothDirection4, smoothDirection3, smoothDirection1, smoothDirection2};
        }
        if (rotation == Rotation.SOUTH) {
            return new Object[]{smoothDirection2, smoothDirection1, smoothDirection4, smoothDirection3};
        }
        return new Object[]{smoothDirection3, smoothDirection4, smoothDirection2, smoothDirection1};
    }

    private boolean findNeighbouringBlock(boolean SmoothStartTop, int normalizedNeigbouringBlockX, int normalizedNeigbouringBlockY, int normalizedNeigbouringBlockZ, Map<ChunkCoordinate, Stack<BO4CustomStructureCoordinate>> objectsToSpawn, BO4CustomStructureCoordinate objectInChunk, BO4CustomStructureCoordinate start, String presetFolderName, Path otgRootFolder, ILogger logger, CustomObjectManager customObjectManager, IMaterialReader materialReader, CustomObjectResourcesManager manager, IModLoadedChecker modLoadedChecker) {
        Stack<BO4CustomStructureCoordinate> bO3sInNeighbouringBlockChunk;
        BO4 startBO4 = (BO4)start.getObject(otgRootFolder, logger, customObjectManager, materialReader, manager, modLoadedChecker);
        ChunkCoordinate neighbouringBlockChunk = null;
        ChunkCoordinate searchTarget = ChunkCoordinate.fromBlockCoords(normalizedNeigbouringBlockX, normalizedNeigbouringBlockZ);
        for (ChunkCoordinate chunkInStructure : objectsToSpawn.keySet()) {
            if (chunkInStructure.getChunkX() != searchTarget.getChunkX() || chunkInStructure.getChunkZ() != searchTarget.getChunkZ()) continue;
            neighbouringBlockChunk = chunkInStructure;
            break;
        }
        if (neighbouringBlockChunk != null && (bO3sInNeighbouringBlockChunk = objectsToSpawn.get(neighbouringBlockChunk)) != null) {
            for (CustomStructureCoordinate customStructureCoordinate : bO3sInNeighbouringBlockChunk) {
                if (customStructureCoordinate == objectInChunk) continue;
                BO4BlockFunction[][] neighbouringBO3HeightMap = ((BO4)customStructureCoordinate.getObject(otgRootFolder, logger, customObjectManager, materialReader, manager, modLoadedChecker)).getConfig().getSmoothingHeightMap(startBO4, presetFolderName, otgRootFolder, logger, customObjectManager, materialReader, manager, modLoadedChecker);
                for (int x = 0; x < 16; ++x) {
                    for (int z = 0; z < 16; ++z) {
                        BO4BlockFunction blockToCheck = neighbouringBO3HeightMap[x][z];
                        if (blockToCheck == null) continue;
                        BO4CustomStructureCoordinate blockToCheckCoords = BO4CustomStructureCoordinate.getRotatedSmoothingCoords(blockToCheck.x, blockToCheck.y, blockToCheck.z, customStructureCoordinate.getRotation());
                        int normalizedBlockToCheckX = blockToCheckCoords.getX() + customStructureCoordinate.getX();
                        int normalizedBlockToCheckY = blockToCheckCoords.getY() + customStructureCoordinate.getY();
                        int normalizedBlockToCheckZ = blockToCheckCoords.getZ() + customStructureCoordinate.getZ();
                        if (normalizedNeigbouringBlockX != normalizedBlockToCheckX || normalizedNeigbouringBlockY != normalizedBlockToCheckY && !SmoothStartTop || normalizedNeigbouringBlockZ != normalizedBlockToCheckZ || !this.isMaterialSmoothingAnchor(blockToCheck, customStructureCoordinate, start, otgRootFolder, logger, customObjectManager, materialReader, manager, modLoadedChecker)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean isMaterialSmoothingAnchor(BO4BlockFunction blockToCheck, CustomStructureCoordinate bO3ToCheck, CustomStructureCoordinate start, Path otgRootFolder, ILogger logger, CustomObjectManager customObjectManager, IMaterialReader materialReader, CustomObjectResourcesManager manager, IModLoadedChecker modLoadedChecker) {
        BO4Config startBO4Config = ((BO4)start.getObject(otgRootFolder, logger, customObjectManager, materialReader, manager, modLoadedChecker)).getConfig();
        BO4Config bo4ToCheckConfig = ((BO4)bO3ToCheck.getObject(otgRootFolder, logger, customObjectManager, materialReader, manager, modLoadedChecker)).getConfig();
        boolean isSmoothAreaAnchor = false;
        if (blockToCheck instanceof BO4RandomBlockFunction) {
            for (LocalMaterialData material : ((BO4RandomBlockFunction)blockToCheck).blocks) {
                if (material == null || !material.isSmoothAreaAnchor(startBO4Config.overrideChildSettings && bo4ToCheckConfig.overrideChildSettings ? startBO4Config.smoothStartWood : bo4ToCheckConfig.smoothStartWood, startBO4Config.spawnUnderWater)) continue;
                isSmoothAreaAnchor = true;
                break;
            }
        }
        return isSmoothAreaAnchor || !(blockToCheck instanceof BO4RandomBlockFunction) && blockToCheck.material.isSmoothAreaAnchor(startBO4Config.overrideChildSettings && bo4ToCheckConfig.overrideChildSettings ? startBO4Config.smoothStartWood : bo4ToCheckConfig.smoothStartWood, startBO4Config.spawnUnderWater);
    }

    private void calculateBeginAndEndPointsPerChunk(Map<ChunkCoordinate, ArrayList<BlockCoordsAndNeighbours>> smoothToBlocksPerChunk, int smoothRadius) {
        HashMap<ChunkCoordinate, ArrayList<SmoothingAreaLine>> smoothingAreasToSpawn = new HashMap<ChunkCoordinate, ArrayList<SmoothingAreaLine>>();
        for (Map.Entry<ChunkCoordinate, ArrayList<BlockCoordsAndNeighbours>> chunkCoordSet : smoothToBlocksPerChunk.entrySet()) {
            for (BlockCoordsAndNeighbours blockCoordsAndNeighbours : chunkCoordSet.getValue()) {
                boolean isCornerBlock;
                boolean bl = isCornerBlock = blockCoordsAndNeighbours.smoothInDirection1 && blockCoordsAndNeighbours.smoothInDirection3 || blockCoordsAndNeighbours.smoothInDirection1 && blockCoordsAndNeighbours.smoothInDirection4 || blockCoordsAndNeighbours.smoothInDirection2 && blockCoordsAndNeighbours.smoothInDirection3 || blockCoordsAndNeighbours.smoothInDirection2 && blockCoordsAndNeighbours.smoothInDirection4;
                if (!isCornerBlock && blockCoordsAndNeighbours.smoothInDirection1) {
                    this.plotStraightLine(blockCoordsAndNeighbours.blockX, blockCoordsAndNeighbours.blockY, blockCoordsAndNeighbours.blockZ, smoothRadius, smoothingAreasToSpawn, blockCoordsAndNeighbours.bO3, 1);
                }
                if (!isCornerBlock && blockCoordsAndNeighbours.smoothInDirection2) {
                    this.plotStraightLine(blockCoordsAndNeighbours.blockX, blockCoordsAndNeighbours.blockY, blockCoordsAndNeighbours.blockZ, smoothRadius, smoothingAreasToSpawn, blockCoordsAndNeighbours.bO3, 2);
                }
                if (!isCornerBlock && blockCoordsAndNeighbours.smoothInDirection3) {
                    this.plotStraightLine(blockCoordsAndNeighbours.blockX, blockCoordsAndNeighbours.blockY, blockCoordsAndNeighbours.blockZ, smoothRadius, smoothingAreasToSpawn, blockCoordsAndNeighbours.bO3, 3);
                }
                if (!isCornerBlock && blockCoordsAndNeighbours.smoothInDirection4) {
                    this.plotStraightLine(blockCoordsAndNeighbours.blockX, blockCoordsAndNeighbours.blockY, blockCoordsAndNeighbours.blockZ, smoothRadius, smoothingAreasToSpawn, blockCoordsAndNeighbours.bO3, 4);
                }
                if (blockCoordsAndNeighbours.smoothInDirection1 && blockCoordsAndNeighbours.smoothInDirection3) {
                    this.plotCorner(blockCoordsAndNeighbours.blockX, blockCoordsAndNeighbours.blockY, blockCoordsAndNeighbours.blockZ, smoothRadius, smoothingAreasToSpawn, blockCoordsAndNeighbours.bO3, 1);
                }
                if (blockCoordsAndNeighbours.smoothInDirection1 && blockCoordsAndNeighbours.smoothInDirection4) {
                    this.plotCorner(blockCoordsAndNeighbours.blockX, blockCoordsAndNeighbours.blockY, blockCoordsAndNeighbours.blockZ, smoothRadius, smoothingAreasToSpawn, blockCoordsAndNeighbours.bO3, 2);
                }
                if (blockCoordsAndNeighbours.smoothInDirection2 && blockCoordsAndNeighbours.smoothInDirection3) {
                    this.plotCorner(blockCoordsAndNeighbours.blockX, blockCoordsAndNeighbours.blockY, blockCoordsAndNeighbours.blockZ, smoothRadius, smoothingAreasToSpawn, blockCoordsAndNeighbours.bO3, 3);
                }
                if (!blockCoordsAndNeighbours.smoothInDirection2 || !blockCoordsAndNeighbours.smoothInDirection4) continue;
                this.plotCorner(blockCoordsAndNeighbours.blockX, blockCoordsAndNeighbours.blockY, blockCoordsAndNeighbours.blockZ, smoothRadius, smoothingAreasToSpawn, blockCoordsAndNeighbours.bO3, 4);
            }
        }
        this.fillSmoothingLineCaches(smoothingAreasToSpawn);
    }

    private void plotStraightLine(int blockX, short blockY, int blockZ, int smoothRadius, Map<ChunkCoordinate, ArrayList<SmoothingAreaLine>> smoothingAreasToSpawn, BO4CustomStructureCoordinate bO4, int direction) {
        int normalizedSmoothStartPointBlockX = 0;
        int normalizedSmoothStartPointBlockZ = 0;
        int normalizedSmoothFinalEndPointBlockX = 0;
        int normalizedSmoothFinalEndPointBlockZ = 0;
        ArrayList<ChunkCoordinate> smoothingAreasToSpawnForThisBlock = new ArrayList<ChunkCoordinate>();
        if (direction == 1) {
            normalizedSmoothFinalEndPointBlockX = blockX - smoothRadius + bO4.getX();
            normalizedSmoothFinalEndPointBlockZ = blockZ + bO4.getZ();
        }
        if (direction == 2) {
            normalizedSmoothFinalEndPointBlockX = blockX + smoothRadius + bO4.getX();
            normalizedSmoothFinalEndPointBlockZ = blockZ + bO4.getZ();
        }
        if (direction == 3) {
            normalizedSmoothFinalEndPointBlockX = blockX + bO4.getX();
            normalizedSmoothFinalEndPointBlockZ = blockZ - smoothRadius + bO4.getZ();
        }
        if (direction == 4) {
            normalizedSmoothFinalEndPointBlockX = blockX + bO4.getX();
            normalizedSmoothFinalEndPointBlockZ = blockZ + smoothRadius + bO4.getZ();
        }
        ChunkCoordinate finalDestinationChunk = ChunkCoordinate.fromBlockCoords(normalizedSmoothFinalEndPointBlockX, normalizedSmoothFinalEndPointBlockZ);
        for (int i = 0; i <= smoothRadius; ++i) {
            if (direction == 1) {
                normalizedSmoothStartPointBlockX = blockX - i + bO4.getX();
                normalizedSmoothStartPointBlockZ = blockZ + bO4.getZ();
            }
            if (direction == 2) {
                normalizedSmoothStartPointBlockX = blockX + i + bO4.getX();
                normalizedSmoothStartPointBlockZ = blockZ + bO4.getZ();
            }
            if (direction == 3) {
                normalizedSmoothStartPointBlockX = blockX + bO4.getX();
                normalizedSmoothStartPointBlockZ = blockZ - i + bO4.getZ();
            }
            if (direction == 4) {
                normalizedSmoothStartPointBlockX = blockX + bO4.getX();
                normalizedSmoothStartPointBlockZ = blockZ + i + bO4.getZ();
            }
            ChunkCoordinate destinationChunk = ChunkCoordinate.fromBlockCoords(normalizedSmoothStartPointBlockX, normalizedSmoothStartPointBlockZ);
            boolean bFound = false;
            for (ChunkCoordinate cCoord : smoothingAreasToSpawnForThisBlock) {
                if (!destinationChunk.equals(cCoord)) continue;
                bFound = true;
                break;
            }
            if (bFound) continue;
            int beginPointX = normalizedSmoothStartPointBlockX;
            short beginPointY = (short)(blockY + bO4.getY());
            int beginPointZ = normalizedSmoothStartPointBlockZ;
            int endPointX = normalizedSmoothStartPointBlockX;
            int endPointZ = normalizedSmoothStartPointBlockZ;
            if (!finalDestinationChunk.equals(destinationChunk)) {
                if (direction == 1) {
                    endPointX = destinationChunk.getChunkX() * 16;
                }
                if (direction == 2) {
                    endPointX = destinationChunk.getChunkX() * 16 + 15;
                }
                if (direction == 3) {
                    endPointZ = destinationChunk.getChunkZ() * 16;
                }
                if (direction == 4) {
                    endPointZ = destinationChunk.getChunkZ() * 16 + 15;
                }
            } else {
                if (direction == 1) {
                    endPointX = normalizedSmoothStartPointBlockX -= smoothRadius - i;
                }
                if (direction == 2) {
                    endPointX = normalizedSmoothStartPointBlockX += smoothRadius - i;
                }
                if (direction == 3) {
                    endPointZ = normalizedSmoothStartPointBlockZ -= smoothRadius - i;
                }
                if (direction == 4) {
                    endPointZ = normalizedSmoothStartPointBlockZ += smoothRadius - i;
                }
            }
            SmoothingAreaLine objectToAdd = new SmoothingAreaLine(beginPointX, beginPointZ, endPointX, endPointZ, blockX + bO4.getX(), beginPointY, blockZ + bO4.getZ(), normalizedSmoothFinalEndPointBlockX, normalizedSmoothFinalEndPointBlockZ);
            ArrayList<SmoothingAreaLine> beginAndEndPoints = smoothingAreasToSpawn.get(destinationChunk);
            if (beginAndEndPoints != null) {
                beginAndEndPoints.add(objectToAdd);
            } else {
                ArrayList<SmoothingAreaLine> beginningAndEndpoints = new ArrayList<SmoothingAreaLine>();
                beginningAndEndpoints.add(objectToAdd);
                smoothingAreasToSpawn.put(destinationChunk, beginningAndEndpoints);
            }
            smoothingAreasToSpawnForThisBlock.add(destinationChunk);
        }
    }

    private void plotCorner(int blockX, int blockY, int blockZ, int smoothRadius, Map<ChunkCoordinate, ArrayList<SmoothingAreaLine>> smoothingAreasToSpawn, BO4CustomStructureCoordinate bO4, int direction) {
        int originPointX = blockX + bO4.getX();
        short originPointY = (short)(blockY + bO4.getY());
        int originPointZ = blockZ + bO4.getZ();
        int minAngle = 0;
        int maxAngle = 0;
        if (direction == 1) {
            minAngle = 180;
            maxAngle = 270;
        }
        if (direction == 2) {
            minAngle = 90;
            maxAngle = 180;
        }
        if (direction == 3) {
            minAngle = 270;
            maxAngle = 360;
        }
        if (direction == 4) {
            minAngle = 0;
            maxAngle = 90;
        }
        double angleChangePerBlock = 360.0 / (Math.PI * 2 * (double)smoothRadius);
        int destinationPointX = 0;
        int destinationPointZ = 0;
        int previousDestinationPointX = 0;
        int previousDestinationPointZ = 0;
        double angle = minAngle;
        while ((int)Math.floor(angle) <= maxAngle) {
            destinationPointX = originPointX + (int)Math.round((double)smoothRadius * Math.cos(angle * Math.PI / 180.0));
            destinationPointZ = originPointZ + (int)Math.round((double)smoothRadius * Math.sin(angle * Math.PI / 180.0));
            if (angle != (double)minAngle && previousDestinationPointX != destinationPointX && previousDestinationPointZ != destinationPointZ) {
                if (direction == 1) {
                    this.plotLineAtAngle(originPointX, originPointY, originPointZ, destinationPointX, destinationPointZ + 1, smoothingAreasToSpawn);
                }
                if (direction == 2) {
                    this.plotLineAtAngle(originPointX, originPointY, originPointZ, destinationPointX + 1, destinationPointZ, smoothingAreasToSpawn);
                }
                if (direction == 3) {
                    this.plotLineAtAngle(originPointX, originPointY, originPointZ, destinationPointX - 1, destinationPointZ, smoothingAreasToSpawn);
                }
                if (direction == 4) {
                    this.plotLineAtAngle(originPointX, originPointY, originPointZ, destinationPointX, destinationPointZ - 1, smoothingAreasToSpawn);
                }
            }
            previousDestinationPointX = destinationPointX;
            previousDestinationPointZ = destinationPointZ;
            this.plotLineAtAngle(originPointX, originPointY, originPointZ, destinationPointX, destinationPointZ, smoothingAreasToSpawn);
            angle += angleChangePerBlock;
        }
    }

    private void plotLineAtAngle(int originPointX, short originPointY, int originPointZ, int destinationPointX, int destinationPointZ, Map<ChunkCoordinate, ArrayList<SmoothingAreaLine>> smoothingAreasToSpawn) {
        ChunkCoordinate previousChunk = null;
        int previousX = 0;
        int previousZ = 0;
        int beginPointX = originPointX;
        int beginPointZ = originPointZ;
        int deltaX = Math.abs(destinationPointX - beginPointX);
        int deltaZ = Math.abs(destinationPointZ - beginPointZ);
        int d = 0;
        int dx2 = 2 * deltaX;
        int dz2 = 2 * deltaZ;
        int ix = beginPointX < destinationPointX ? 1 : -1;
        int iz = beginPointZ < destinationPointZ ? 1 : -1;
        int x = beginPointX;
        int z = beginPointZ;
        if (deltaX >= deltaZ) {
            while (true) {
                ChunkCoordinate currentChunk = ChunkCoordinate.fromBlockCoords(x, z);
                if (previousChunk != null && !previousChunk.equals(currentChunk) || x == destinationPointX && z == destinationPointZ) {
                    ArrayList<SmoothingAreaLine> beginningAndEndpoints;
                    ArrayList<SmoothingAreaLine> beginAndEndPoints = null;
                    SmoothingAreaLine objectToAdd = null;
                    if (previousChunk != null && !previousChunk.equals(currentChunk)) {
                        objectToAdd = new SmoothingAreaLine(beginPointX, beginPointZ, previousX, previousZ, originPointX, originPointY, originPointZ, destinationPointX, destinationPointZ);
                        beginPointX = x;
                        beginPointZ = z;
                        beginAndEndPoints = smoothingAreasToSpawn.get(previousChunk);
                        if (beginAndEndPoints != null) {
                            beginAndEndPoints.add(objectToAdd);
                        } else {
                            beginningAndEndpoints = new ArrayList();
                            beginningAndEndpoints.add(objectToAdd);
                            smoothingAreasToSpawn.put(previousChunk, beginningAndEndpoints);
                        }
                    }
                    if (x == destinationPointX && z == destinationPointZ) {
                        objectToAdd = new SmoothingAreaLine(beginPointX, beginPointZ, x, z, originPointX, originPointY, originPointZ, destinationPointX, destinationPointZ);
                        beginAndEndPoints = smoothingAreasToSpawn.get(currentChunk);
                        if (beginAndEndPoints != null) {
                            beginAndEndPoints.add(objectToAdd);
                        } else {
                            beginningAndEndpoints = new ArrayList<SmoothingAreaLine>();
                            beginningAndEndpoints.add(objectToAdd);
                            smoothingAreasToSpawn.put(currentChunk, beginningAndEndpoints);
                        }
                    }
                }
                previousChunk = ChunkCoordinate.fromBlockCoords(x, z);
                previousX = x;
                previousZ = z;
                if (x != destinationPointX) {
                    x += ix;
                    if ((d += dz2) <= deltaX) continue;
                    z += iz;
                    d -= dx2;
                    continue;
                }
                break;
            }
        } else {
            while (true) {
                ChunkCoordinate currentChunk = ChunkCoordinate.fromBlockCoords(x, z);
                if (previousChunk != null && !previousChunk.equals(currentChunk) || x == destinationPointX && z == destinationPointZ) {
                    ArrayList<SmoothingAreaLine> beginningAndEndpoints;
                    ArrayList<SmoothingAreaLine> beginAndEndPoints = null;
                    SmoothingAreaLine objectToAdd = null;
                    if (previousChunk != null && !previousChunk.equals(currentChunk)) {
                        objectToAdd = new SmoothingAreaLine(beginPointX, beginPointZ, previousX, previousZ, originPointX, originPointY, originPointZ, destinationPointX, destinationPointZ);
                        beginPointX = x;
                        beginPointZ = z;
                        beginAndEndPoints = smoothingAreasToSpawn.get(previousChunk);
                        if (beginAndEndPoints != null) {
                            beginAndEndPoints.add(objectToAdd);
                        } else {
                            beginningAndEndpoints = new ArrayList();
                            beginningAndEndpoints.add(objectToAdd);
                            smoothingAreasToSpawn.put(previousChunk, beginningAndEndpoints);
                        }
                    }
                    if (x == destinationPointX && z == destinationPointZ) {
                        objectToAdd = new SmoothingAreaLine(beginPointX, beginPointZ, x, z, originPointX, originPointY, originPointZ, destinationPointX, destinationPointZ);
                        beginAndEndPoints = smoothingAreasToSpawn.get(currentChunk);
                        if (beginAndEndPoints != null) {
                            beginAndEndPoints.add(objectToAdd);
                        } else {
                            beginningAndEndpoints = new ArrayList<SmoothingAreaLine>();
                            beginningAndEndpoints.add(objectToAdd);
                            smoothingAreasToSpawn.put(currentChunk, beginningAndEndpoints);
                        }
                    }
                }
                previousChunk = ChunkCoordinate.fromBlockCoords(x, z);
                previousX = x;
                previousZ = z;
                if (z == destinationPointZ) break;
                z += iz;
                if ((d += dx2) <= deltaZ) continue;
                x += ix;
                d -= dz2;
            }
        }
    }

    public void fillSmoothingLineCaches(Map<ChunkCoordinate, ArrayList<SmoothingAreaLine>> smoothingAreasToSpawn) {
        this.smoothingAreasToSpawn.clear();
        this.smoothingAreasToSpawnPerLineDestination.clear();
        for (Map.Entry<ChunkCoordinate, ArrayList<SmoothingAreaLine>> smoothingArea : smoothingAreasToSpawn.entrySet()) {
            ArrayList<SmoothingAreaLine> smoothingAreaLines = smoothingArea.getValue();
            for (SmoothingAreaLine smoothingAreaLine : smoothingAreaLines) {
                ChunkCoordinate destinationCoords = ChunkCoordinate.fromChunkCoords(smoothingAreaLine.finalDestinationPointX, smoothingAreaLine.finalDestinationPointZ);
                ArrayList<SmoothingAreaLine> smoothingAreasAtEndpoint = this.smoothingAreasToSpawnPerLineDestination.get(destinationCoords);
                if (smoothingAreasAtEndpoint == null) {
                    smoothingAreasAtEndpoint = new ArrayList();
                    this.smoothingAreasToSpawnPerLineDestination.put(destinationCoords, smoothingAreasAtEndpoint);
                }
                if (smoothingAreasAtEndpoint.contains(smoothingAreaLine)) continue;
                smoothingAreasAtEndpoint.add(smoothingAreaLine);
            }
        }
        this.smoothingAreasToSpawn.putAll(smoothingAreasToSpawn);
    }

    public void clearChunkFromCache(ChunkCoordinate chunkCoordinate) {
        this.smoothingAreasToSpawn.remove(chunkCoordinate);
    }

    public void spawnSmoothAreas(BO4Config startBO4Config, ChunkCoordinate chunkCoordinate, CustomStructureCoordinate start, CustomStructureCache structureCache, IWorldGenRegion worldGenRegion, ILogger logger, IMaterialReader materialReader) {
        ArrayList<SmoothingAreaLine> smoothingAreaInChunk = this.smoothingAreasToSpawn.get(chunkCoordinate);
        if (smoothingAreaInChunk != null && chunkCoordinate != null) {
            this.mergeAndSpawnSmoothingAreas(startBO4Config, chunkCoordinate, smoothingAreaInChunk, structureCache, worldGenRegion, start, logger, materialReader);
        }
    }

    private void mergeAndSpawnSmoothingAreas(BO4Config startBO4Config, ChunkCoordinate chunkCoordinate, ArrayList<SmoothingAreaLine> smoothingAreas, CustomStructureCache structureCache, IWorldGenRegion worldGenRegion, CustomStructureCoordinate start, ILogger logger, IMaterialReader materialReader) {
        int smoothRadius = startBO4Config.smoothRadius - 1;
        for (SmoothingAreaLine smoothingBeginAndEndPoints : smoothingAreas) {
            short relativeY;
            if (smoothingBeginAndEndPoints.finalDestinationPointY == -1) {
                smoothingBeginAndEndPoints.finalDestinationPointY = (short)worldGenRegion.getHighestBlockYAtWithoutLoading(smoothingBeginAndEndPoints.finalDestinationPointX, smoothingBeginAndEndPoints.finalDestinationPointZ, true, false, true, true, true);
                ChunkCoordinate destinationCoords = ChunkCoordinate.fromChunkCoords(smoothingBeginAndEndPoints.finalDestinationPointX, smoothingBeginAndEndPoints.finalDestinationPointZ);
                ArrayList<SmoothingAreaLine> smoothingAreaLinesAtEndPoint = this.smoothingAreasToSpawnPerLineDestination.get(destinationCoords);
                if (smoothingAreaLinesAtEndPoint != null) {
                    for (SmoothingAreaLine lineAtEndPoint : new ArrayList<SmoothingAreaLine>(smoothingAreaLinesAtEndPoint)) {
                        if (lineAtEndPoint.finalDestinationPointX != smoothingBeginAndEndPoints.finalDestinationPointX || lineAtEndPoint.finalDestinationPointZ != smoothingBeginAndEndPoints.finalDestinationPointZ) continue;
                        lineAtEndPoint.finalDestinationPointY = smoothingBeginAndEndPoints.finalDestinationPointY;
                        smoothingAreaLinesAtEndPoint.remove(lineAtEndPoint);
                        if (smoothingAreaLinesAtEndPoint.isEmpty()) {
                            this.smoothingAreasToSpawnPerLineDestination.remove(destinationCoords);
                        }
                        structureCache.markRegionForSaving(ChunkCoordinate.fromBlockCoords(lineAtEndPoint.beginPointX, lineAtEndPoint.beginPointZ).toRegionCoord());
                    }
                }
            }
            if (smoothingBeginAndEndPoints.beginPointY == -1) {
                relativeY = (short)Math.round((double)Math.abs(smoothingBeginAndEndPoints.originPointY - smoothingBeginAndEndPoints.finalDestinationPointY) * (Point2D.distance(smoothingBeginAndEndPoints.originPointX, smoothingBeginAndEndPoints.originPointZ, smoothingBeginAndEndPoints.beginPointX, smoothingBeginAndEndPoints.beginPointZ) / (double)smoothRadius));
                smoothingBeginAndEndPoints.beginPointY = smoothingBeginAndEndPoints.originPointY >= smoothingBeginAndEndPoints.finalDestinationPointY ? (short)(smoothingBeginAndEndPoints.originPointY - relativeY) : (short)(smoothingBeginAndEndPoints.originPointY + relativeY);
            }
            if (smoothingBeginAndEndPoints.endPointY != -1) continue;
            relativeY = (short)Math.round((double)Math.abs(smoothingBeginAndEndPoints.originPointY - smoothingBeginAndEndPoints.finalDestinationPointY) * (Point2D.distance(smoothingBeginAndEndPoints.originPointX, smoothingBeginAndEndPoints.originPointZ, smoothingBeginAndEndPoints.endPointX, smoothingBeginAndEndPoints.endPointZ) / (double)smoothRadius));
            if (smoothingBeginAndEndPoints.originPointY >= smoothingBeginAndEndPoints.finalDestinationPointY) {
                smoothingBeginAndEndPoints.endPointY = (short)(smoothingBeginAndEndPoints.originPointY - relativeY);
                continue;
            }
            smoothingBeginAndEndPoints.endPointY = (short)(smoothingBeginAndEndPoints.originPointY + relativeY);
        }
        HashMap<ChunkCoordinate, SmoothingAreaColumn> smoothingBlocksPerColumn = new HashMap<ChunkCoordinate, SmoothingAreaColumn>();
        for (SmoothingAreaLine smoothingAreaLine : smoothingAreas) {
            this.mergeLine(smoothingAreaLine, chunkCoordinate, smoothingAreaLine, smoothingBlocksPerColumn, smoothRadius);
        }
        for (Map.Entry entry : smoothingBlocksPerColumn.entrySet()) {
            ((SmoothingAreaColumn)entry.getValue()).processBlocks(worldGenRegion, startBO4Config, logger, materialReader);
        }
    }

    private void mergeLine(SmoothingAreaLine smoothingAreaLine, ChunkCoordinate chunkBeingSpawned, SmoothingAreaLine smoothingBeginAndEndPoints, HashMap<ChunkCoordinate, SmoothingAreaColumn> smoothingBlocksPerColumn, int smoothRadius) {
        int deltaX = Math.abs(smoothingAreaLine.finalDestinationPointX - smoothingAreaLine.originPointX);
        int deltaZ = Math.abs(smoothingAreaLine.finalDestinationPointZ - smoothingAreaLine.originPointZ);
        int d = 0;
        int dx2 = 2 * deltaX;
        int dz2 = 2 * deltaZ;
        int ix = smoothingAreaLine.originPointX < smoothingAreaLine.finalDestinationPointX ? 1 : -1;
        int iz = smoothingAreaLine.originPointZ < smoothingAreaLine.finalDestinationPointZ ? 1 : -1;
        int x = smoothingAreaLine.originPointX;
        int z = smoothingAreaLine.originPointZ;
        if (deltaX >= deltaZ) {
            while (true) {
                ChunkCoordinate currentChunk;
                if ((currentChunk = ChunkCoordinate.fromBlockCoords(x, z)).equals(chunkBeingSpawned)) {
                    short relativeY = (short)Math.round((double)Math.abs(smoothingBeginAndEndPoints.originPointY - smoothingBeginAndEndPoints.finalDestinationPointY) * (Point2D.distance(smoothingBeginAndEndPoints.originPointX, smoothingBeginAndEndPoints.originPointZ, x, z) / (double)smoothRadius));
                    short blockY = smoothingBeginAndEndPoints.originPointY >= smoothingBeginAndEndPoints.finalDestinationPointY ? (short)(smoothingBeginAndEndPoints.originPointY - relativeY) : (short)(smoothingBeginAndEndPoints.originPointY + relativeY);
                    ChunkCoordinate columnCoords = ChunkCoordinate.fromChunkCoords(x, z);
                    SmoothingAreaColumn column = smoothingBlocksPerColumn.get(columnCoords);
                    if (column == null) {
                        column = new SmoothingAreaColumn(x, z);
                        smoothingBlocksPerColumn.put(columnCoords, column);
                    }
                    column.addBlock(new SmoothingAreaBlock(x, blockY, z, smoothingBeginAndEndPoints.originPointY >= smoothingBeginAndEndPoints.finalDestinationPointY ? SmoothingAreaBlock.enumSmoothingBlockType.FILLING : SmoothingAreaBlock.enumSmoothingBlockType.CUTTING));
                }
                if (x != smoothingAreaLine.finalDestinationPointX) {
                    x += ix;
                    if ((d += dz2) <= deltaX) continue;
                    z += iz;
                    d -= dx2;
                    continue;
                }
                break;
            }
        } else {
            while (true) {
                ChunkCoordinate currentChunk;
                if ((currentChunk = ChunkCoordinate.fromBlockCoords(x, z)).equals(chunkBeingSpawned)) {
                    short relativeY = (short)Math.round((double)Math.abs(smoothingBeginAndEndPoints.originPointY - smoothingBeginAndEndPoints.finalDestinationPointY) * (Point2D.distance(smoothingBeginAndEndPoints.originPointX, smoothingBeginAndEndPoints.originPointZ, x, z) / (double)smoothRadius));
                    short blockY = smoothingBeginAndEndPoints.originPointY >= smoothingBeginAndEndPoints.finalDestinationPointY ? (short)(smoothingBeginAndEndPoints.originPointY - relativeY) : (short)(smoothingBeginAndEndPoints.originPointY + relativeY);
                    ChunkCoordinate columnCoords = ChunkCoordinate.fromChunkCoords(x, z);
                    SmoothingAreaColumn column = smoothingBlocksPerColumn.get(columnCoords);
                    if (column == null) {
                        column = new SmoothingAreaColumn(x, z);
                        smoothingBlocksPerColumn.put(columnCoords, column);
                    }
                    column.addBlock(new SmoothingAreaBlock(x, blockY, z, smoothingBeginAndEndPoints.originPointY >= smoothingBeginAndEndPoints.finalDestinationPointY ? SmoothingAreaBlock.enumSmoothingBlockType.FILLING : SmoothingAreaBlock.enumSmoothingBlockType.CUTTING));
                }
                if (z == smoothingAreaLine.finalDestinationPointZ) break;
                z += iz;
                if ((d += dx2) <= deltaZ) continue;
                x += ix;
                d -= dz2;
            }
        }
    }
}

