/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge;

import com.pg85.otg.OTGEngine;
import com.pg85.otg.forge.gen.OTGNoiseChunkGenerator;
import com.pg85.otg.forge.materials.ForgeMaterials;
import com.pg85.otg.forge.presets.ForgePresetLoader;
import com.pg85.otg.forge.util.ForgeLogger;
import com.pg85.otg.forge.util.ForgeModLoadedChecker;
import java.io.File;
import java.nio.file.Paths;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLLoader;

public class ForgeEngine
extends OTGEngine {
    public ForgeEngine() {
        super(new ForgeLogger(), Paths.get(FMLLoader.getGamePath().toString(), File.separator + "config" + File.separator + "OpenTerrainGenerator"), new ForgeModLoadedChecker(), new ForgePresetLoader(Paths.get(FMLLoader.getGamePath().toString(), File.separator + "config" + File.separator + "OpenTerrainGenerator")));
    }

    @Override
    public void onStart() {
        ForgeMaterials.init();
        super.onStart();
    }

    public void reloadPreset(String presetFolderName, MutableRegistry<Biome> biomeRegistry) {
        ((ForgePresetLoader)this.presetLoader).reloadPresetFromDisk(presetFolderName, this.biomeResourcesManager, this.logger, biomeRegistry);
    }

    public void onSave(IWorld world) {
        if (!world.func_201670_d() && world.func_72863_F() instanceof ServerChunkProvider && ((ServerChunkProvider)world.func_72863_F()).field_186029_c instanceof OTGNoiseChunkGenerator) {
            ((OTGNoiseChunkGenerator)((ServerChunkProvider)world.func_72863_F()).field_186029_c).saveStructureCache();
        }
    }

    public void onUnload(IWorld world) {
        if (!world.func_201670_d() && world.func_72863_F() instanceof ServerChunkProvider && ((ServerChunkProvider)world.func_72863_F()).field_186029_c instanceof OTGNoiseChunkGenerator) {
            ((OTGNoiseChunkGenerator)((ServerChunkProvider)world.func_72863_F()).field_186029_c).stopWorkerThreads();
        }
    }

    @Override
    public File getJarFile() {
        File modFile = ModList.get().getModFileById("otg").getFile().getFilePath().toFile();
        if (!modFile.isFile()) {
            return null;
        }
        return modFile;
    }
}

