/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge;

import com.mojang.brigadier.CommandDispatcher;
import com.pg85.otg.OTG;
import com.pg85.otg.forge.ForgeEngine;
import com.pg85.otg.forge.biome.OTGBiomeProvider;
import com.pg85.otg.forge.client.MultipleColorHandler;
import com.pg85.otg.forge.commands.OTGCommand;
import com.pg85.otg.forge.dimensions.OTGDimensionType;
import com.pg85.otg.forge.dimensions.OTGWorldType;
import com.pg85.otg.forge.dimensions.portals.OTGCapabilities;
import com.pg85.otg.forge.dimensions.portals.OTGPortalBlocks;
import com.pg85.otg.forge.dimensions.portals.OTGPortalPois;
import com.pg85.otg.forge.gen.OTGNoiseChunkGenerator;
import com.pg85.otg.forge.gui.OTGGui;
import com.pg85.otg.forge.network.OTGClientSyncManager;
import com.pg85.otg.presets.Preset;
import java.nio.file.Path;
import net.minecraft.command.CommandSource;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.FolderName;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.world.ForgeWorldType;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod(value="otg")
@Mod.EventBusSubscriber(modid="otg", bus=Mod.EventBusSubscriber.Bus.MOD)
public class OTGPlugin {
    public OTGPlugin() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::clientSetup);
        modEventBus.addListener(this::commonSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        Registry.func_218322_a((Registry)Registry.field_239689_aA_, (ResourceLocation)new ResourceLocation("otg", "default"), OTGBiomeProvider.CODEC);
        Registry.func_218322_a((Registry)Registry.field_239690_aB_, (ResourceLocation)new ResourceLocation("otg", "default"), OTGNoiseChunkGenerator.CODEC);
        RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation("otg", "default"));
        OTGPortalPois.poi.register(modEventBus);
        OTGPortalBlocks.blocks.register(modEventBus);
        OTGCommand.registerArguments();
    }

    public void commonSetup(FMLCommonSetupEvent event) {
        OTGCapabilities.register();
    }

    private void clientSetup(FMLClientSetupEvent event) {
        OTGGui.init();
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.DEDICATED_SERVER)
    public static void registerWorldType(RegistryEvent.Register<ForgeWorldType> event) {
        ForgeRegistries.WORLD_TYPES.register((IForgeRegistryEntry)new OTGWorldType());
    }

    @SubscribeEvent
    public static void registerBiomes(RegistryEvent.Register<Biome> event) {
        OTG.startEngine(new ForgeEngine());
        OTG.getEngine().getPresetLoader().registerBiomes();
        OTGClientSyncManager.setup();
        MultipleColorHandler.setup();
    }

    @SubscribeEvent
    public void onCommandRegister(RegisterCommandsEvent event) {
        OTGCommand.register((CommandDispatcher<CommandSource>)event.getDispatcher());
    }

    @SubscribeEvent
    public void onSave(WorldEvent.Save event) {
        if (!event.getWorld().func_201670_d() && ((ServerWorld)event.getWorld()).func_201672_e().func_72863_F().field_186029_c instanceof OTGNoiseChunkGenerator) {
            Path datapackDir = ((ServerWorld)event.getWorld()).func_201672_e().func_73046_m().func_240776_a_(FolderName.field_237251_g_);
            Preset preset = ((OTGNoiseChunkGenerator)((ServerWorld)event.getWorld()).func_201672_e().func_72863_F().field_186029_c).getPreset();
            String dimName = ((ServerWorld)event.getWorld()).getWorldServer().func_234923_W_().func_240901_a_().func_110623_a();
            OTGDimensionType.saveDataPackFile(datapackDir, dimName, preset.getWorldConfig(), preset.getFolderName());
        }
        ((ForgeEngine)OTG.getEngine()).onSave(event.getWorld());
    }

    @SubscribeEvent
    public void onUnload(WorldEvent.Unload event) {
        ((ForgeEngine)OTG.getEngine()).onUnload(event.getWorld());
    }
}

