/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.biome;

import com.pg85.otg.OTG;
import com.pg85.otg.config.ConfigFunction;
import com.pg85.otg.config.biome.BiomeConfig;
import com.pg85.otg.config.standard.BiomeStandardValues;
import com.pg85.otg.constants.SettingsEnums;
import com.pg85.otg.gen.resource.RegistryResource;
import com.pg85.otg.interfaces.IBiome;
import com.pg85.otg.interfaces.IBiomeConfig;
import com.pg85.otg.interfaces.IWorldConfig;
import com.pg85.otg.util.biome.OTGBiomeResourceLocation;
import com.pg85.otg.util.biome.WeightedMobSpawnGroup;
import com.pg85.otg.util.logging.LogCategory;
import com.pg85.otg.util.logging.LogLevel;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.audio.BackgroundMusicSelector;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeAmbience;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.DefaultBiomeFeatures;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.biome.MoodSoundAmbience;
import net.minecraft.world.biome.ParticleEffectAmbience;
import net.minecraft.world.biome.SoundAdditionsAmbience;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.ProbabilityConfig;
import net.minecraft.world.gen.feature.StructureFeature;
import net.minecraft.world.gen.feature.structure.BastionRemnantsPieces;
import net.minecraft.world.gen.feature.structure.DesertVillagePools;
import net.minecraft.world.gen.feature.structure.MineshaftConfig;
import net.minecraft.world.gen.feature.structure.MineshaftStructure;
import net.minecraft.world.gen.feature.structure.OceanRuinConfig;
import net.minecraft.world.gen.feature.structure.OceanRuinStructure;
import net.minecraft.world.gen.feature.structure.PillagerOutpostPools;
import net.minecraft.world.gen.feature.structure.PlainsVillagePools;
import net.minecraft.world.gen.feature.structure.SavannaVillagePools;
import net.minecraft.world.gen.feature.structure.SnowyVillagePools;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureFeatures;
import net.minecraft.world.gen.feature.structure.TaigaVillagePools;
import net.minecraft.world.gen.feature.structure.VillageConfig;
import net.minecraft.world.gen.surfacebuilders.ConfiguredSurfaceBuilders;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.common.world.MobSpawnInfoBuilder;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistries;

public class ForgeBiome
implements IBiome {
    private final Biome biomeBase;
    private final IBiomeConfig biomeConfig;

    public ForgeBiome(Biome biomeBase, IBiomeConfig biomeConfig) {
        this.biomeBase = biomeBase;
        this.biomeConfig = biomeConfig;
    }

    @Override
    public float getTemperatureAt(int x, int y, int z) {
        return this.biomeBase.func_225486_c(new BlockPos(x, y, z));
    }

    @Override
    public IBiomeConfig getBiomeConfig() {
        return this.biomeConfig;
    }

    public Biome getBiomeBase() {
        return this.biomeBase;
    }

    public static Biome createOTGBiome(boolean isOceanBiome, IWorldConfig worldConfig, IBiomeConfig biomeConfig) {
        SoundEvent event;
        BiomeGenerationSettings.Builder biomeGenerationSettingsBuilder = new BiomeGenerationSettings.Builder();
        MobSpawnInfo.Builder mobSpawnInfoBuilder = ForgeBiome.createMobSpawnInfo(biomeConfig);
        biomeGenerationSettingsBuilder.func_242517_a(ConfiguredSurfaceBuilders.field_244178_j);
        DefaultBiomeFeatures.func_243738_d((BiomeGenerationSettings.Builder)biomeGenerationSettingsBuilder);
        for (ConfigFunction res : ((BiomeConfig)biomeConfig).getResourceQueue()) {
            if (!(res instanceof RegistryResource)) continue;
            RegistryResource registryResource = (RegistryResource)res;
            GenerationStage.Decoration stage = GenerationStage.Decoration.valueOf((String)registryResource.getDecorationStage());
            ConfiguredFeature registry = (ConfiguredFeature)WorldGenRegistries.field_243653_e.func_82594_a(new ResourceLocation(registryResource.getFeatureKey()));
            if (registry != null) {
                biomeGenerationSettingsBuilder.func_242513_a(stage, registry);
                continue;
            }
            if (!OTG.getEngine().getLogger().getLogCategoryEnabled(LogCategory.DECORATION)) continue;
            OTG.getEngine().getLogger().log(LogLevel.ERROR, LogCategory.DECORATION, "Registry() " + registryResource.getFeatureKey() + " could not be found for biomeconfig " + biomeConfig.getName());
        }
        ForgeBiome.addVanillaStructures(biomeGenerationSettingsBuilder, worldConfig, biomeConfig);
        float safeTemperature = biomeConfig.getBiomeTemperature();
        if ((double)safeTemperature >= 0.1 && (double)safeTemperature <= 0.2) {
            safeTemperature = (double)safeTemperature >= 1.5 ? 0.2f : 0.1f;
        }
        BiomeAmbience.Builder biomeAmbienceBuilder = new BiomeAmbience.Builder().func_235239_a_(biomeConfig.getFogColor() != BiomeStandardValues.FOG_COLOR.getDefaultValue().intValue() ? biomeConfig.getFogColor() : worldConfig.getFogColor()).func_235248_c_(biomeConfig.getWaterFogColor() != BiomeStandardValues.WATER_FOG_COLOR.getDefaultValue().intValue() ? biomeConfig.getWaterFogColor() : 329011).func_235246_b_(biomeConfig.getWaterColor() != BiomeStandardValues.WATER_COLOR.getDefaultValue().intValue() ? biomeConfig.getWaterColor() : 4159204).func_242539_d(biomeConfig.getSkyColor() != BiomeStandardValues.SKY_COLOR.getDefaultValue().intValue() ? biomeConfig.getSkyColor() : ForgeBiome.getSkyColorForTemp(safeTemperature));
        Optional particleType = Registry.field_212632_u.func_241873_b(new ResourceLocation(biomeConfig.getParticleType()));
        if (particleType.isPresent() && particleType.get() instanceof IParticleData) {
            biomeAmbienceBuilder.func_235244_a_(new ParticleEffectAmbience((IParticleData)particleType.get(), biomeConfig.getParticleProbability()));
        }
        if ((event = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation(biomeConfig.getMusic()))) != null) {
            biomeAmbienceBuilder.func_235240_a_(new BackgroundMusicSelector(event, biomeConfig.getMusicMinDelay(), biomeConfig.getMusicMaxDelay(), biomeConfig.isReplaceCurrentMusic()));
        }
        if ((event = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation(biomeConfig.getAmbientSound()))) != null) {
            biomeAmbienceBuilder.func_235241_a_(event);
        }
        if ((event = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation(biomeConfig.getMoodSound()))) != null) {
            biomeAmbienceBuilder.func_235243_a_(new MoodSoundAmbience(event, biomeConfig.getMoodSoundDelay(), biomeConfig.getMoodSearchRange(), biomeConfig.getMoodOffset()));
        }
        if ((event = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation(biomeConfig.getAdditionsSound()))) != null) {
            biomeAmbienceBuilder.func_235242_a_(new SoundAdditionsAmbience(event, biomeConfig.getAdditionsTickChance()));
        }
        if (biomeConfig.getFoliageColor() != 0xFFFFFF) {
            biomeAmbienceBuilder.func_242540_e(biomeConfig.getFoliageColor());
        }
        if (biomeConfig.getGrassColor() != 0xFFFFFF) {
            biomeAmbienceBuilder.func_242541_f(biomeConfig.getGrassColor());
        }
        switch (biomeConfig.getGrassColorModifier()) {
            case Swamp: {
                biomeAmbienceBuilder.func_242537_a(BiomeAmbience.GrassColorModifier.SWAMP);
                break;
            }
            case DarkForest: {
                biomeAmbienceBuilder.func_242537_a(BiomeAmbience.GrassColorModifier.DARK_FOREST);
                break;
            }
        }
        ResourceLocation registryName = new ResourceLocation(biomeConfig.getRegistryKey().toResourceLocationString());
        Biome.Category category = Biome.Category.func_235103_a_((String)biomeConfig.getBiomeCategory());
        if (category == null) {
            if (OTG.getEngine().getLogger().getLogCategoryEnabled(LogCategory.CONFIGS)) {
                OTG.getEngine().getLogger().log(LogLevel.ERROR, LogCategory.CONFIGS, "Could not parse biome category " + biomeConfig.getBiomeCategory());
            }
            Biome.Category category2 = category = isOceanBiome ? Biome.Category.OCEAN : Biome.Category.NONE;
        }
        Biome.RainType rainType = (double)biomeConfig.getBiomeWetness() <= 1.0E-4 ? Biome.RainType.NONE : (biomeConfig.getBiomeTemperature() > 0.15f ? Biome.RainType.RAIN : Biome.RainType.SNOW);
        BiomeGenerationSettingsBuilder genBuilder = new BiomeGenerationSettingsBuilder(biomeGenerationSettingsBuilder.func_242508_a());
        MobSpawnInfoBuilder spawnBuilder = new MobSpawnInfoBuilder(mobSpawnInfoBuilder.func_242577_b());
        BiomeLoadingEvent event1 = new BiomeLoadingEvent(registryName, new Biome.Climate(rainType, safeTemperature, Biome.TemperatureModifier.NONE, biomeConfig.getBiomeWetness()), category, biomeConfig.getBiomeHeight(), biomeConfig.getBiomeVolatility(), biomeAmbienceBuilder.func_235238_a_(), genBuilder, spawnBuilder);
        MinecraftForge.EVENT_BUS.post((Event)event1);
        BiomeAmbience biomeAmbienceBuilder2 = event1.getEffects();
        BiomeGenerationSettingsBuilder biomeGenerationSettingsBuilder2 = event1.getGeneration();
        MobSpawnInfoBuilder mobSpawnInfoBuilder2 = event1.getSpawns();
        Biome.Builder biomeBuilder = new Biome.Builder().func_205415_a(rainType).func_205421_a(biomeConfig.getBiomeHeight()).func_205420_b(biomeConfig.getBiomeVolatility()).func_205414_c(safeTemperature).func_205417_d(biomeConfig.getBiomeWetness()).func_235097_a_(biomeAmbienceBuilder2).func_242458_a(mobSpawnInfoBuilder2.func_242577_b()).func_242457_a(biomeGenerationSettingsBuilder2.func_242508_a());
        if (biomeConfig.useFrozenOceanTemperature()) {
            biomeBuilder.func_242456_a(Biome.TemperatureModifier.FROZEN);
        }
        biomeBuilder.func_205419_a(category != null ? category : (isOceanBiome ? Biome.Category.OCEAN : Biome.Category.PLAINS));
        return (Biome)biomeBuilder.func_242455_a().setRegistryName(registryName);
    }

    private static MobSpawnInfo.Builder createMobSpawnInfo(IBiomeConfig biomeConfig) {
        MobSpawnInfo.Builder mobSpawnInfoBuilder = new MobSpawnInfo.Builder();
        ForgeBiome.addMobGroup(EntityClassification.MONSTER, mobSpawnInfoBuilder, biomeConfig.getMonsters(), biomeConfig.getName());
        ForgeBiome.addMobGroup(EntityClassification.CREATURE, mobSpawnInfoBuilder, biomeConfig.getCreatures(), biomeConfig.getName());
        ForgeBiome.addMobGroup(EntityClassification.WATER_CREATURE, mobSpawnInfoBuilder, biomeConfig.getWaterCreatures(), biomeConfig.getName());
        ForgeBiome.addMobGroup(EntityClassification.AMBIENT, mobSpawnInfoBuilder, biomeConfig.getAmbientCreatures(), biomeConfig.getName());
        ForgeBiome.addMobGroup(EntityClassification.WATER_AMBIENT, mobSpawnInfoBuilder, biomeConfig.getWaterAmbientCreatures(), biomeConfig.getName());
        ForgeBiome.addMobGroup(EntityClassification.MISC, mobSpawnInfoBuilder, biomeConfig.getMiscCreatures(), biomeConfig.getName());
        mobSpawnInfoBuilder.func_242571_a();
        return mobSpawnInfoBuilder;
    }

    private static void addMobGroup(EntityClassification entitiClassification, MobSpawnInfo.Builder mobSpawnInfoBuilder, List<WeightedMobSpawnGroup> mobSpawnGroupList, String biomeName) {
        for (WeightedMobSpawnGroup mobSpawnGroup : mobSpawnGroupList) {
            Optional entityType = EntityType.func_220327_a((String)mobSpawnGroup.getInternalName());
            if (entityType.isPresent()) {
                mobSpawnInfoBuilder.func_242575_a(entitiClassification, new MobSpawnInfo.Spawners((EntityType)entityType.get(), mobSpawnGroup.getWeight(), mobSpawnGroup.getMin(), mobSpawnGroup.getMax()));
                continue;
            }
            if (!OTG.getEngine().getLogger().getLogCategoryEnabled(LogCategory.MOBS)) continue;
            OTG.getEngine().getLogger().log(LogLevel.ERROR, LogCategory.MOBS, "Could not find entity for mob: " + mobSpawnGroup.getMob() + " in BiomeConfig " + biomeName);
        }
    }

    private static void addVanillaStructures(BiomeGenerationSettings.Builder biomeGenerationSettingsBuilder, IWorldConfig worldConfig, IBiomeConfig biomeConfig) {
        if (worldConfig.getVillagesEnabled() && biomeConfig.getVillageType() != SettingsEnums.VillageType.disabled) {
            int villageSize = biomeConfig.getVillageSize();
            SettingsEnums.VillageType villageType = biomeConfig.getVillageType();
            StructureFeature customVillage = ForgeBiome.register(((OTGBiomeResourceLocation)biomeConfig.getRegistryKey()).withBiomeResource("village").toResourceLocationString(), Structure.field_236381_q_.func_236391_a_((IFeatureConfig)new VillageConfig(() -> {
                switch (villageType) {
                    case sandstone: {
                        return DesertVillagePools.field_243774_a;
                    }
                    case savanna: {
                        return SavannaVillagePools.field_244128_a;
                    }
                    case taiga: {
                        return TaigaVillagePools.field_244193_a;
                    }
                    case wood: {
                        return PlainsVillagePools.field_244090_a;
                    }
                    case snowy: {
                        return SnowyVillagePools.field_244129_a;
                    }
                }
                return PlainsVillagePools.field_244090_a;
            }, villageSize)));
            biomeGenerationSettingsBuilder.func_242516_a(customVillage);
        }
        if (worldConfig.getStrongholdsEnabled() && biomeConfig.getStrongholdsEnabled()) {
            biomeGenerationSettingsBuilder.func_242516_a(StructureFeatures.field_244145_k);
        }
        if (worldConfig.getOceanMonumentsEnabled() && biomeConfig.getOceanMonumentsEnabled()) {
            biomeGenerationSettingsBuilder.func_242516_a(StructureFeatures.field_244146_l);
        }
        if (worldConfig.getRareBuildingsEnabled() && biomeConfig.getRareBuildingType() != SettingsEnums.RareBuildingType.disabled) {
            switch (biomeConfig.getRareBuildingType()) {
                case desertPyramid: {
                    biomeGenerationSettingsBuilder.func_242516_a(StructureFeatures.field_244140_f);
                    break;
                }
                case igloo: {
                    biomeGenerationSettingsBuilder.func_242516_a(StructureFeatures.field_244141_g);
                    break;
                }
                case jungleTemple: {
                    biomeGenerationSettingsBuilder.func_242516_a(StructureFeatures.field_244139_e);
                    break;
                }
                case swampHut: {
                    biomeGenerationSettingsBuilder.func_242516_a(StructureFeatures.field_244144_j);
                    break;
                }
            }
        }
        if (worldConfig.getWoodlandMansionsEnabled() && biomeConfig.getWoodlandMansionsEnabled()) {
            biomeGenerationSettingsBuilder.func_242516_a(StructureFeatures.field_244138_d);
        }
        if (worldConfig.getNetherFortressesEnabled() && biomeConfig.getNetherFortressesEnabled()) {
            biomeGenerationSettingsBuilder.func_242516_a(StructureFeatures.field_244149_o);
        }
        if (worldConfig.getMineshaftsEnabled() && biomeConfig.getMineShaftType() != SettingsEnums.MineshaftType.disabled) {
            float mineShaftProbability = biomeConfig.getMineShaftProbability();
            SettingsEnums.MineshaftType mineShaftType = biomeConfig.getMineShaftType();
            StructureFeature customMineShaft = ForgeBiome.register(((OTGBiomeResourceLocation)biomeConfig.getRegistryKey()).withBiomeResource("mineshaft").toResourceLocationString(), Structure.field_236367_c_.func_236391_a_((IFeatureConfig)new MineshaftConfig(mineShaftProbability, mineShaftType == SettingsEnums.MineshaftType.mesa ? MineshaftStructure.Type.MESA : MineshaftStructure.Type.NORMAL)));
            biomeGenerationSettingsBuilder.func_242516_a(customMineShaft);
        }
        if (worldConfig.getBuriedTreasureEnabled() && biomeConfig.getBuriedTreasureEnabled()) {
            float buriedTreasureProbability = biomeConfig.getBuriedTreasureProbability();
            StructureFeature customBuriedTreasure = ForgeBiome.register(((OTGBiomeResourceLocation)biomeConfig.getRegistryKey()).withBiomeResource("buried_treasure").toResourceLocationString(), Structure.field_236380_p_.func_236391_a_((IFeatureConfig)new ProbabilityConfig(buriedTreasureProbability)));
            biomeGenerationSettingsBuilder.func_242516_a(customBuriedTreasure);
        }
        if (worldConfig.getOceanRuinsEnabled() && biomeConfig.getOceanRuinsType() != SettingsEnums.OceanRuinsType.disabled) {
            float oceanRuinsLargeProbability = biomeConfig.getOceanRuinsLargeProbability();
            float oceanRuinsClusterProbability = biomeConfig.getOceanRuinsClusterProbability();
            SettingsEnums.OceanRuinsType oceanRuinsType = biomeConfig.getOceanRuinsType();
            StructureFeature customOceanRuins = ForgeBiome.register(((OTGBiomeResourceLocation)biomeConfig.getRegistryKey()).withBiomeResource("ocean_ruin").toResourceLocationString(), Structure.field_236377_m_.func_236391_a_((IFeatureConfig)new OceanRuinConfig(oceanRuinsType == SettingsEnums.OceanRuinsType.cold ? OceanRuinStructure.Type.COLD : OceanRuinStructure.Type.WARM, oceanRuinsLargeProbability, oceanRuinsClusterProbability)));
            biomeGenerationSettingsBuilder.func_242516_a(customOceanRuins);
        }
        if (worldConfig.getShipWrecksEnabled()) {
            if (biomeConfig.getShipWreckEnabled()) {
                biomeGenerationSettingsBuilder.func_242516_a(StructureFeatures.field_244142_h);
            }
            if (biomeConfig.getShipWreckBeachedEnabled()) {
                biomeGenerationSettingsBuilder.func_242516_a(StructureFeatures.field_244143_i);
            }
        }
        if (worldConfig.getPillagerOutpostsEnabled() && biomeConfig.getPillagerOutpostEnabled()) {
            int outpostSize = biomeConfig.getPillagerOutPostSize();
            StructureFeature customOutpost = ForgeBiome.register(((OTGBiomeResourceLocation)biomeConfig.getRegistryKey()).withBiomeResource("pillager_outpost").toResourceLocationString(), Structure.field_236366_b_.func_236391_a_((IFeatureConfig)new VillageConfig(() -> PillagerOutpostPools.field_244088_a, outpostSize)));
            biomeGenerationSettingsBuilder.func_242516_a(customOutpost);
        }
        if (worldConfig.getBastionRemnantsEnabled() && biomeConfig.getBastionRemnantEnabled()) {
            int bastionRemnantSize = biomeConfig.getBastionRemnantSize();
            StructureFeature customBastionRemnant = ForgeBiome.register(((OTGBiomeResourceLocation)biomeConfig.getRegistryKey()).withBiomeResource("bastion_remnant").toResourceLocationString(), Structure.field_236383_s_.func_236391_a_((IFeatureConfig)new VillageConfig(() -> BastionRemnantsPieces.field_243686_a, bastionRemnantSize)));
            biomeGenerationSettingsBuilder.func_242516_a(customBastionRemnant);
        }
        if (worldConfig.getNetherFossilsEnabled() && biomeConfig.getNetherFossilEnabled()) {
            biomeGenerationSettingsBuilder.func_242516_a(StructureFeatures.field_244150_p);
        }
        if (worldConfig.getEndCitiesEnabled() && biomeConfig.getEndCityEnabled()) {
            biomeGenerationSettingsBuilder.func_242516_a(StructureFeatures.field_244151_q);
        }
        if (worldConfig.getRuinedPortalsEnabled() && biomeConfig.getRuinedPortalType() != SettingsEnums.RuinedPortalType.disabled) {
            switch (biomeConfig.getRuinedPortalType()) {
                case normal: {
                    biomeGenerationSettingsBuilder.func_242516_a(StructureFeatures.field_244159_y);
                    break;
                }
                case desert: {
                    biomeGenerationSettingsBuilder.func_242516_a(StructureFeatures.field_244160_z);
                    break;
                }
                case jungle: {
                    biomeGenerationSettingsBuilder.func_242516_a(StructureFeatures.field_244130_A);
                    break;
                }
                case swamp: {
                    biomeGenerationSettingsBuilder.func_242516_a(StructureFeatures.field_244131_B);
                    break;
                }
                case mountain: {
                    biomeGenerationSettingsBuilder.func_242516_a(StructureFeatures.field_244132_C);
                    break;
                }
                case ocean: {
                    biomeGenerationSettingsBuilder.func_242516_a(StructureFeatures.field_244133_D);
                    break;
                }
                case nether: {
                    biomeGenerationSettingsBuilder.func_242516_a(StructureFeatures.field_244134_E);
                    break;
                }
            }
        }
    }

    private static <FC extends IFeatureConfig, F extends Structure<FC>> StructureFeature<FC, F> register(String name, StructureFeature<FC, F> structure) {
        return (StructureFeature)WorldGenRegistries.func_243663_a((Registry)WorldGenRegistries.field_243654_f, (String)name, structure);
    }

    private static int getSkyColorForTemp(float p_244206_0_) {
        float lvt_1_1_ = p_244206_0_ / 3.0f;
        lvt_1_1_ = MathHelper.func_76131_a((float)lvt_1_1_, (float)-1.0f, (float)1.0f);
        return MathHelper.func_181758_c((float)(0.62222224f - lvt_1_1_ * 0.05f), (float)(0.5f + lvt_1_1_ * 0.1f), (float)1.0f);
    }
}

