/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.biome;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.pg85.otg.OTG;
import com.pg85.otg.forge.ForgeEngine;
import com.pg85.otg.forge.presets.ForgePresetLoader;
import com.pg85.otg.gen.biome.layers.BiomeLayers;
import com.pg85.otg.gen.biome.layers.util.CachingLayerSampler;
import com.pg85.otg.interfaces.IBiome;
import com.pg85.otg.interfaces.ILayerSource;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.block.BlockState;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.RegistryLookupCodec;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class OTGBiomeProvider
extends BiomeProvider
implements ILayerSource {
    public static final Codec<OTGBiomeProvider> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("preset_name").stable().forGetter(provider -> provider.presetFolderName), (App)Codec.LONG.fieldOf("seed").stable().forGetter(provider -> provider.seed), (App)Codec.BOOL.optionalFieldOf("legacy_biome_init_layer", (Object)Boolean.FALSE, Lifecycle.stable()).forGetter(provider -> provider.legacyBiomeInitLayer), (App)Codec.BOOL.fieldOf("large_biomes").orElse((Object)false).stable().forGetter(provider -> provider.largeBiomes), (App)RegistryLookupCodec.func_244331_a((RegistryKey)Registry.field_239720_u_).forGetter(provider -> provider.registry)).apply((Applicative)instance, instance.stable(OTGBiomeProvider::new)));
    private final long seed;
    private final boolean legacyBiomeInitLayer;
    private final boolean largeBiomes;
    private final Registry<Biome> registry;
    private final ThreadLocal<CachingLayerSampler> layer;
    private final Int2ObjectMap<RegistryKey<Biome>> keyLookup;
    private final String presetFolderName;

    public OTGBiomeProvider(String presetFolderName, long seed, boolean legacyBiomeInitLayer, boolean largeBiomes, Registry<Biome> registry) {
        super(OTGBiomeProvider.getAllBiomesByPreset(presetFolderName, (MutableRegistry<Biome>)((MutableRegistry)registry)));
        this.presetFolderName = presetFolderName;
        this.seed = seed;
        this.legacyBiomeInitLayer = legacyBiomeInitLayer;
        this.largeBiomes = largeBiomes;
        this.registry = registry;
        this.layer = ThreadLocal.withInitial(() -> BiomeLayers.create(seed, ((ForgePresetLoader)OTG.getEngine().getPresetLoader()).getPresetGenerationData().get(presetFolderName), OTG.getEngine().getLogger()));
        this.keyLookup = new Int2ObjectOpenHashMap();
        this.keyLookup.defaultReturnValue((Object)Biomes.field_76771_b);
        IBiome[] biomeLookup = ((ForgePresetLoader)OTG.getEngine().getPresetLoader()).getGlobalIdMapping(presetFolderName);
        if (biomeLookup == null) {
            throw new RuntimeException("No OTG preset found with name \"" + presetFolderName + "\". Install the correct preset or update your server.properties.");
        }
        for (int biomeId = 0; biomeId < biomeLookup.length; ++biomeId) {
            IBiome biome = biomeLookup[biomeId];
            if (biome == null) continue;
            RegistryKey key = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)new ResourceLocation(biome.getBiomeConfig().getRegistryKey().toResourceLocationString()));
            this.keyLookup.put(biomeId, (Object)key);
        }
    }

    private static Stream<Supplier<Biome>> getAllBiomesByPreset(String presetFolderName, MutableRegistry<Biome> registry) {
        if (OTG.getEngine().getPluginConfig().getDeveloperModeEnabled()) {
            OTG.getEngine().getCustomObjectManager().reloadCustomObjectFiles();
            ((ForgeEngine)OTG.getEngine()).reloadPreset(presetFolderName, registry);
        } else {
            ((ForgePresetLoader)OTG.getEngine().getPresetLoader()).reRegisterBiomes(presetFolderName, registry);
        }
        List<RegistryKey<Biome>> biomesForPreset = ((ForgePresetLoader)OTG.getEngine().getPresetLoader()).getBiomeRegistryKeys(presetFolderName);
        if (biomesForPreset == null) {
            biomesForPreset = ((ForgePresetLoader)OTG.getEngine().getPresetLoader()).getBiomeRegistryKeys(OTG.getEngine().getPresetLoader().getDefaultPresetFolderName());
        }
        if (biomesForPreset == null) {
            biomesForPreset = new ArrayList<RegistryKey<Biome>>();
        }
        return biomesForPreset.stream().map(p_242638_1_ -> () -> (Biome)registry.func_243576_d(p_242638_1_));
    }

    protected Codec<? extends BiomeProvider> func_230319_a_() {
        return CODEC;
    }

    @OnlyIn(value=Dist.CLIENT)
    public BiomeProvider func_230320_a_(long seed) {
        return new OTGBiomeProvider(this.presetFolderName, seed, this.legacyBiomeInitLayer, this.largeBiomes, this.registry);
    }

    public Biome func_225526_b_(int biomeX, int biomeY, int biomeZ) {
        return (Biome)this.registry.func_230516_a_((RegistryKey)this.keyLookup.get(this.layer.get().sample(biomeX, biomeZ)));
    }

    @Override
    public CachingLayerSampler getSampler() {
        return this.layer.get();
    }

    public Set<BlockState> func_205706_b() {
        return super.func_205706_b();
    }
}

