/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.pg85.otg.forge.commands.BaseCommand;
import com.pg85.otg.forge.gen.OTGNoiseChunkGenerator;
import com.pg85.otg.interfaces.IBiomeConfig;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.entity.EntityClassification;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraftforge.common.BiomeDictionary;

public class BiomeCommand
extends BaseCommand {
    private static final String[] OPTIONS = new String[]{"info", "spawns"};

    public BiomeCommand() {
        super("biome");
        this.helpMessage = "Displays information about the biome you are in.";
        this.usage = "/otg biome";
    }

    @Override
    public void build(LiteralArgumentBuilder<CommandSource> builder) {
        builder.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"biome").executes(context -> this.showBiome((CommandSource)context.getSource(), ""))).then(Commands.func_197056_a((String)"option", (ArgumentType)StringArgumentType.word()).suggests(this::suggestTypes).executes(context -> this.showBiome((CommandSource)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"option")))));
    }

    private int showBiome(CommandSource source, String option) {
        if (!(source.func_197023_e().func_72863_F().field_186029_c instanceof OTGNoiseChunkGenerator)) {
            source.func_197030_a((ITextComponent)new StringTextComponent("OTG is not enabled in this world"), false);
            return 0;
        }
        Biome biome = source.func_197023_e().func_226691_t_(new BlockPos(source.func_197036_d().field_72450_a, source.func_197036_d().field_72448_b, source.func_197036_d().field_72449_c));
        IBiomeConfig config = ((OTGNoiseChunkGenerator)source.func_197023_e().func_72863_F().field_186029_c).getCachedBiomeProvider().getBiomeConfig((int)source.func_197036_d().field_72450_a, (int)source.func_197036_d().field_72449_c);
        source.func_197030_a((ITextComponent)new StringTextComponent("====================================================="), false);
        if (config.getIsTemplateForBiome()) {
            source.func_197030_a((ITextComponent)new StringTextComponent("According to OTG, this biome uses the ").func_240699_a_(TextFormatting.GOLD).func_230529_a_((ITextComponent)new StringTextComponent(config.getName()).func_240699_a_(TextFormatting.GREEN)).func_230529_a_((ITextComponent)new StringTextComponent(" template.").func_240699_a_(TextFormatting.GOLD)), false);
            source.func_197030_a((ITextComponent)new StringTextComponent("This biome belongs to either another mod or the vanilla game.").func_240699_a_(TextFormatting.GRAY), false);
        } else {
            source.func_197030_a((ITextComponent)new StringTextComponent("According to OTG, you are in the ").func_240699_a_(TextFormatting.GOLD).func_230529_a_((ITextComponent)new StringTextComponent(config.getName()).func_240699_a_(TextFormatting.GREEN)).func_230529_a_((ITextComponent)new StringTextComponent(" biome.").func_240699_a_(TextFormatting.GOLD)), false);
        }
        source.func_197030_a((ITextComponent)this.createComponent("Biome registry name: ", biome.getRegistryName().toString(), TextFormatting.GOLD, TextFormatting.GREEN), false);
        switch (option) {
            case "info": {
                this.showBiomeInfo(source, biome, config);
                break;
            }
            case "spawns": {
                this.showBiomeMobs(source, biome, config);
                break;
            }
        }
        return 0;
    }

    private void showBiomeInfo(CommandSource source, Biome biome, IBiomeConfig config) {
        Set types = BiomeDictionary.getTypes((RegistryKey)RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)biome.getRegistryName())).stream().map(BiomeDictionary.Type::getName).collect(Collectors.toSet());
        source.func_197030_a((ITextComponent)this.createComponent("Biome Category: ", biome.func_201856_r().toString(), TextFormatting.GOLD, TextFormatting.GREEN), false);
        source.func_197030_a((ITextComponent)this.createComponent("Biome Tags: ", String.join((CharSequence)", ", types), TextFormatting.GOLD, TextFormatting.GREEN), false);
        source.func_197030_a((ITextComponent)this.createComponent("Inherit Mobs: ", config.getInheritMobsBiomeName(), TextFormatting.GOLD, TextFormatting.GREEN), false);
        source.func_197030_a((ITextComponent)this.createComponent("Base Size: ", Integer.toString(config.getBiomeSize()), TextFormatting.GOLD, TextFormatting.GREEN).func_230529_a_((ITextComponent)this.createComponent(" Biome Rarity: ", Integer.toString(config.getBiomeRarity()), TextFormatting.GOLD, TextFormatting.GREEN)), false);
        source.func_197030_a((ITextComponent)this.createComponent("Biome Height: ", String.format("%.2f", Float.valueOf(config.getBiomeHeight())), TextFormatting.GOLD, TextFormatting.GREEN), false);
        source.func_197030_a((ITextComponent)this.createComponent("Volatility: ", String.format("%.2f", Float.valueOf(config.getBiomeVolatility())), TextFormatting.GOLD, TextFormatting.GREEN).func_230529_a_((ITextComponent)this.createComponent(" Volatility1: ", String.format("%.2f", config.getVolatility1()), TextFormatting.GOLD, TextFormatting.GREEN)).func_230529_a_((ITextComponent)this.createComponent(" Volatility2: ", String.format("%.2f", config.getVolatility2()), TextFormatting.GOLD, TextFormatting.GREEN)), false);
        source.func_197030_a((ITextComponent)this.createComponent("Base Temperature: ", String.format("%.2f", Float.valueOf(biome.func_242445_k())), TextFormatting.GOLD, TextFormatting.GREEN).func_230529_a_((ITextComponent)this.createComponent(" Current Temperature: ", String.format("%.2f", Float.valueOf(biome.func_225486_c(new BlockPos(source.func_197036_d())))), TextFormatting.GOLD, TextFormatting.GREEN)), false);
    }

    private void showBiomeMobs(CommandSource source, Biome biome, IBiomeConfig config) {
        source.func_197030_a((ITextComponent)new StringTextComponent("Spawns:").func_240699_a_(TextFormatting.GOLD), false);
        source.func_197030_a((ITextComponent)new StringTextComponent("  Monsters:").func_240699_a_(TextFormatting.GOLD), false);
        this.showSpawns(source, biome.func_242433_b().func_242559_a(EntityClassification.MONSTER));
        source.func_197030_a((ITextComponent)new StringTextComponent("  Creatures:").func_240699_a_(TextFormatting.GOLD), false);
        this.showSpawns(source, biome.func_242433_b().func_242559_a(EntityClassification.CREATURE));
        source.func_197030_a((ITextComponent)new StringTextComponent("  Water Creatures:").func_240699_a_(TextFormatting.GOLD), false);
        this.showSpawns(source, biome.func_242433_b().func_242559_a(EntityClassification.WATER_CREATURE));
        source.func_197030_a((ITextComponent)new StringTextComponent("  Ambient Creatures:").func_240699_a_(TextFormatting.GOLD), false);
        this.showSpawns(source, biome.func_242433_b().func_242559_a(EntityClassification.AMBIENT));
        source.func_197030_a((ITextComponent)new StringTextComponent("  Water Ambient:").func_240699_a_(TextFormatting.GOLD), false);
        this.showSpawns(source, biome.func_242433_b().func_242559_a(EntityClassification.WATER_AMBIENT));
        source.func_197030_a((ITextComponent)new StringTextComponent("  Misc:").func_240699_a_(TextFormatting.GOLD), false);
        this.showSpawns(source, biome.func_242433_b().func_242559_a(EntityClassification.MISC));
    }

    public void showSpawns(CommandSource source, List<MobSpawnInfo.Spawners> spawns) {
        spawns.forEach(spawn -> source.func_197030_a((ITextComponent)this.createComponent("   - Entity: ", spawn.field_242588_c.getRegistryName().toString(), TextFormatting.GOLD, TextFormatting.GREEN).func_230529_a_((ITextComponent)this.createComponent(", Weight: ", Integer.toString(spawn.field_76292_a), TextFormatting.GOLD, TextFormatting.GREEN)).func_230529_a_((ITextComponent)this.createComponent(", Min: ", Integer.toString(spawn.field_242589_d), TextFormatting.GOLD, TextFormatting.GREEN)).func_230529_a_((ITextComponent)this.createComponent(", Max: ", Integer.toString(spawn.field_242590_e), TextFormatting.GOLD, TextFormatting.GREEN)), false));
    }

    private CompletableFuture<Suggestions> suggestTypes(CommandContext<CommandSource> context, SuggestionsBuilder builder) {
        return ISuggestionProvider.func_197008_a((String[])OPTIONS, (SuggestionsBuilder)builder);
    }
}

