/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.pg85.otg.OTG;
import com.pg85.otg.forge.commands.BaseCommand;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class DataCommand
extends BaseCommand {
    private static final String[] DATA_TYPES = new String[]{"biome", "block", "entity", "sound", "particle", "configured_feature"};

    public DataCommand() {
        super("data");
        this.helpMessage = "Dumps various types of game data to files for preset development.";
        this.usage = "/otg data <type>";
        this.detailedHelp = new String[]{"<type>: The type of data to dump.", " - biome: All registered biomes.", " - block: All registered blocks.", " - entity: All registered entities.", " - sound: All registered sounds.", " - particle: All registered particles.", " - configured_feature: All registered configured features (Used to decorate biomes during worldgen)."};
    }

    @Override
    public void build(LiteralArgumentBuilder<CommandSource> builder) {
        builder.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"data").executes(context -> this.execute((CommandSource)context.getSource(), ""))).then(Commands.func_197056_a((String)"type", (ArgumentType)StringArgumentType.word()).suggests(this::suggestTypes).executes(context -> this.execute((CommandSource)context.getSource(), (String)context.getArgument("type", String.class)))));
    }

    public int execute(CommandSource source, String type) {
        IForgeRegistry registry = null;
        MutableRegistry worldGenRegistry = null;
        switch (type.toLowerCase()) {
            case "biome": {
                registry = ForgeRegistries.BIOMES;
                break;
            }
            case "block": {
                registry = ForgeRegistries.BLOCKS;
                break;
            }
            case "entity": {
                registry = ForgeRegistries.ENTITIES;
                break;
            }
            case "sound": {
                registry = ForgeRegistries.SOUND_EVENTS;
                break;
            }
            case "particle": {
                registry = ForgeRegistries.PARTICLE_TYPES;
                break;
            }
            case "configured_feature": {
                worldGenRegistry = source.func_197028_i().func_244267_aX().func_243612_b(Registry.field_243552_au);
                break;
            }
            default: {
                source.func_197030_a((ITextComponent)new StringTextComponent(this.getUsage()), false);
                return 0;
            }
        }
        Set set = registry != null ? registry.getKeys() : worldGenRegistry.func_148742_b();
        new Thread(() -> {
            try {
                Path root = OTG.getEngine().getOTGRootFolder();
                File folder = new File(root.toString() + File.separator + "output");
                if (!folder.exists()) {
                    folder.mkdirs();
                }
                String fileName = "data-output-" + type + ".txt".toLowerCase();
                File output = new File(folder, fileName);
                FileWriter writer = new FileWriter(output);
                for (ResourceLocation key : set) {
                    writer.write(key.toString() + "\n");
                }
                writer.close();
                source.func_197030_a((ITextComponent)new StringTextComponent("File exported as " + output.getPath()), true);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }).start();
        return 0;
    }

    private CompletableFuture<Suggestions> suggestTypes(CommandContext<CommandSource> context, SuggestionsBuilder builder) {
        return ISuggestionProvider.func_197008_a((String[])DATA_TYPES, (SuggestionsBuilder)builder);
    }
}

