/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.pg85.otg.OTG;
import com.pg85.otg.customobject.CustomObject;
import com.pg85.otg.customobject.bo2.BO2;
import com.pg85.otg.customobject.bo3.BO3;
import com.pg85.otg.customobject.bo3.bo3function.BO3RandomBlockFunction;
import com.pg85.otg.customobject.bo4.BO4;
import com.pg85.otg.customobject.bo4.BO4Config;
import com.pg85.otg.customobject.bo4.bo4function.BO4RandomBlockFunction;
import com.pg85.otg.customobject.bofunctions.BlockFunction;
import com.pg85.otg.customobject.config.CustomObjectResourcesManager;
import com.pg85.otg.customobject.config.io.FileSettingsReaderBO4;
import com.pg85.otg.customobject.creator.ObjectCreator;
import com.pg85.otg.customobject.creator.ObjectType;
import com.pg85.otg.customobject.structures.StructuredCustomObject;
import com.pg85.otg.customobject.util.Corner;
import com.pg85.otg.exceptions.InvalidConfigException;
import com.pg85.otg.forge.commands.BaseCommand;
import com.pg85.otg.forge.commands.ObjectUtils;
import com.pg85.otg.forge.commands.RegionCommand;
import com.pg85.otg.forge.commands.arguments.BiomeObjectArgument;
import com.pg85.otg.forge.commands.arguments.FlagsArgument;
import com.pg85.otg.forge.commands.arguments.PresetArgument;
import com.pg85.otg.forge.gen.ForgeWorldGenRegion;
import com.pg85.otg.forge.materials.ForgeMaterialData;
import com.pg85.otg.forge.util.ForgeNBTHelper;
import com.pg85.otg.interfaces.ICustomObjectManager;
import com.pg85.otg.interfaces.ILogger;
import com.pg85.otg.interfaces.IMaterialReader;
import com.pg85.otg.interfaces.IModLoadedChecker;
import com.pg85.otg.presets.Preset;
import com.pg85.otg.util.logging.LogCategory;
import com.pg85.otg.util.logging.LogLevel;
import com.pg85.otg.util.materials.LocalMaterialData;
import com.pg85.otg.util.materials.LocalMaterials;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.LeavesBlock;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.entity.Entity;
import net.minecraft.state.Property;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IWorld;

public class EditCommand
extends BaseCommand {
    private static final HashMap<Entity, EditSession> sessionsMap = new HashMap();
    private static final String[] FLAGS = new String[]{"-nofix", "-update", "-wrongleaves"};
    private static final HashSet<LocalMaterialData> gravityBlocksSet = Stream.of(LocalMaterials.SAND, LocalMaterials.RED_SAND, LocalMaterials.GRAVEL).collect(Collectors.toCollection(HashSet::new));
    private static final HashSet<ResourceLocation> updateMap = Stream.of("oak_fence", "birch_fence", "nether_brick_fence", "spruce_fence", "jungle_fence", "acacia_fence", "dark_oak_fence", "iron_door", "oak_door", "spruce_door", "birch_door", "jungle_door", "acacia_door", "dark_oak_door", "glass_pane", "white_stained_glass_pane", "orange_stained_glass_pane", "magenta_stained_glass_pane", "light_blue_stained_glass_pane", "yellow_stained_glass_pane", "lime_stained_glass_pane", "pink_stained_glass_pane", "gray_stained_glass_pane", "light_gray_stained_glass_pane", "cyan_stained_glass_pane", "purple_stained_glass_pane", "blue_stained_glass_pane", "brown_stained_glass_pane", "green_stained_glass_pane", "red_stained_glass_pane", "black_stained_glass_pane", "purpur_stairs", "oak_stairs", "cobblestone_stairs", "brick_stairs", "stone_brick_stairs", "nether_brick_stairs", "spruce_stairs", "sandstone_stairs", "birch_stairs", "jungle_stairs", "quartz_stairs", "acacia_stairs", "dark_oak_stairs", "prismarine_stairs", "prismarine_brick_stairs", "dark_prismarine_stairs", "red_sandstone_stairs", "polished_granite_stairs", "smooth_red_sandstone_stairs", "mossy_stone_brick_stairs", "polished_diorite_stairs", "mossy_cobblestone_stairs", "end_stone_brick_stairs", "stone_stairs", "smooth_sandstone_stairs", "smooth_quartz_stairs", "granite_stairs", "andesite_stairs", "red_nether_brick_stairs", "polished_andesite_stairs", "diorite_stairs", "cobblestone_wall", "mossy_cobblestone_wall", "brick_wall", "prismarine_wall", "red_sandstone_wall", "mossy_stone_brick_wall", "granite_wall", "stone_brick_wall", "nether_brick_wall", "andesite_wall", "red_nether_brick_wall", "sandstone_wall", "end_stone_brick_wall", "diorite_wall", "iron_bars", "trapped_chest", "chest", "redstone_wire", "oak_leaves", "spruce_leaves", "birch_leaves", "jungle_leaves", "acacia_leaves", "dark_oak_leaves", "vine").map(ResourceLocation::new).collect(Collectors.toCollection(HashSet::new));

    public EditCommand() {
        super("edit");
        this.helpMessage = "Allows you to edit existing BO3 and BO4 files.";
        this.usage = "Please see /otg help edit.";
    }

    @Override
    public void build(LiteralArgumentBuilder<CommandSource> builder) {
        builder.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"edit").executes(this::help)).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"preset", (ArgumentType)StringArgumentType.string()).executes(this::execute)).suggests((context, suggestionBuilder) -> PresetArgument.suggest((CommandContext<CommandSource>)context, suggestionBuilder, true)).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"object", (ArgumentType)StringArgumentType.word()).executes(this::execute)).suggests(BiomeObjectArgument::suggest).then((ArgumentBuilder)((RequiredArgumentBuilder)Commands.func_197056_a((String)"flags", (ArgumentType)FlagsArgument.create()).executes(this::execute)).suggests(this::suggestFlags)))));
        builder.then(Commands.func_197057_a((String)"canceledit").executes(this::cancelSession));
        builder.then(Commands.func_197057_a((String)"finishedit").executes(this::finish));
    }

    public int execute(CommandContext<CommandSource> context) {
        CommandSource source = (CommandSource)context.getSource();
        try {
            StructuredCustomObject inputObject;
            boolean isGlobal;
            String presetFolderName = (String)context.getArgument("preset", String.class);
            String objectName = "";
            boolean immediate = false;
            boolean doFixing = true;
            boolean leaveIllegalLeaves = false;
            try {
                objectName = (String)context.getArgument("object", String.class);
                String flags = (String)context.getArgument("flags", String.class);
                immediate = flags.contains("-update");
                doFixing = !flags.contains("-nofix");
                leaveIllegalLeaves = flags.contains("-wrongleaves");
            }
            catch (IllegalArgumentException flags) {
                // empty catch block
            }
            presetFolderName = presetFolderName != null && presetFolderName.equalsIgnoreCase("global") ? null : presetFolderName;
            boolean bl = isGlobal = presetFolderName == null;
            if (objectName.equals("")) {
                source.func_197030_a((ITextComponent)new StringTextComponent("Please supply an object name"), false);
                return 0;
            }
            if (source.func_197022_f() == null) {
                source.func_197030_a((ITextComponent)new StringTextComponent("Only players can run this command"), false);
                return 0;
            }
            try {
                inputObject = EditCommand.getStructuredObject(objectName, presetFolderName);
            }
            catch (InvalidConfigException e) {
                source.func_197030_a((ITextComponent)new StringTextComponent("Error loading object " + objectName), false);
                return 0;
            }
            if (inputObject == null) {
                source.func_197030_a((ITextComponent)new StringTextComponent("Could not find " + objectName), false);
                return 0;
            }
            ObjectType type = inputObject.getType();
            Preset preset = ObjectUtils.getPresetOrDefault(presetFolderName);
            if (preset == null) {
                source.func_197030_a((ITextComponent)new StringTextComponent("Could not find preset " + (presetFolderName == null ? "" : presetFolderName)), false);
                return 0;
            }
            ForgeWorldGenRegion worldGenRegion = ObjectUtils.getWorldGenRegion(preset, source.func_197023_e());
            RegionCommand.Region region = ObjectUtils.getRegionFromObject(source.func_197022_f().func_233580_cy_(), inputObject);
            Corner center = region.getCenter();
            ObjectUtils.cleanArea(worldGenRegion, region.getMin(), region.getMax(), true);
            ArrayList<BlockFunction<?>> extraBlocks = EditCommand.spawnAndFixObject(center.x, center.y, center.z, inputObject, worldGenRegion, doFixing, presetFolderName, OTG.getEngine().getOTGRootFolder(), OTG.getEngine().getLogger(), OTG.getEngine().getCustomObjectManager(), OTG.getEngine().getPresetLoader().getMaterialReader(presetFolderName), OTG.getEngine().getCustomObjectResourcesManager(), OTG.getEngine().getModLoadedChecker());
            Path path = ObjectUtils.getObjectFolderPath(isGlobal ? null : preset.getPresetFolder()).resolve(ObjectUtils.getFoldersFromObject(inputObject));
            if (immediate) {
                new Thread(ObjectUtils.getExportRunnable(type, region, center, inputObject, path, extraBlocks, presetFolderName, true, leaveIllegalLeaves, source, worldGenRegion)).start();
                return 0;
            }
            sessionsMap.put(source.func_197022_f(), new EditSession(type, worldGenRegion, inputObject, extraBlocks, path, preset.getFolderName(), center, leaveIllegalLeaves));
            source.func_197030_a((ITextComponent)new StringTextComponent("You can now edit the object"), false);
            source.func_197030_a((ITextComponent)new StringTextComponent("To change the area of the object, use /otg region"), false);
            source.func_197030_a((ITextComponent)new StringTextComponent("When you are done editing, do /otg finishedit"), false);
            source.func_197030_a((ITextComponent)new StringTextComponent("To cancel, do /otg canceledit"), false);
            if (!extraBlocks.isEmpty()) {
                source.func_197030_a((ITextComponent)new StringTextComponent("This object's center cannot be moved"), false);
            }
            RegionCommand.playerSelectionMap.put(source.func_197022_f(), region);
        }
        catch (Exception e) {
            source.func_197030_a((ITextComponent)new StringTextComponent("Edit command encountered an error, please check the logs."), false);
            OTG.getEngine().getLogger().log(LogLevel.ERROR, LogCategory.MAIN, "Edit command encountered an error: " + e.getClass().getName() + " - " + e.getMessage());
            OTG.getEngine().getLogger().printStackTrace(LogLevel.ERROR, LogCategory.MAIN, e);
        }
        return 0;
    }

    protected static StructuredCustomObject getStructuredObject(String objectName, String presetFolderName) throws InvalidConfigException {
        CustomObject objectToSpawn = ObjectUtils.getObject(objectName, presetFolderName);
        if (objectToSpawn instanceof BO3) {
            return (StructuredCustomObject)objectToSpawn;
        }
        if (presetFolderName == null) {
            presetFolderName = OTG.getEngine().getPresetLoader().getDefaultPresetFolderName();
        }
        if (objectToSpawn instanceof BO4) {
            File file = ((BO4)objectToSpawn).getConfig().getFile();
            return new BO4(objectName, file, new BO4Config(new FileSettingsReaderBO4(objectName, file, OTG.getEngine().getLogger()), true, presetFolderName, OTG.getEngine().getOTGRootFolder(), OTG.getEngine().getLogger(), OTG.getEngine().getCustomObjectManager(), OTG.getEngine().getPresetLoader().getMaterialReader(presetFolderName), OTG.getEngine().getCustomObjectResourcesManager(), OTG.getEngine().getModLoadedChecker()));
        }
        if (objectToSpawn instanceof BO2) {
            try {
                return new BO3(objectToSpawn.getName(), ObjectType.BO3.getObjectFilePathFromName(objectToSpawn.getName(), ((BO2)objectToSpawn).getFile().getParentFile().toPath()).toFile(), ((BO2)objectToSpawn).getConvertedConfig(presetFolderName, OTG.getEngine().getOTGRootFolder(), OTG.getEngine().getLogger(), OTG.getEngine().getCustomObjectManager(), OTG.getEngine().getPresetLoader().getMaterialReader(presetFolderName), OTG.getEngine().getCustomObjectResourcesManager(), OTG.getEngine().getModLoadedChecker()));
            }
            catch (InvalidConfigException e) {
                OTG.getEngine().getLogger().log(LogLevel.ERROR, LogCategory.MAIN, "Failed to convert BO2 " + objectName);
                OTG.getEngine().getLogger().printStackTrace(LogLevel.ERROR, LogCategory.MAIN, e);
            }
        }
        return null;
    }

    public int finish(CommandContext<CommandSource> context) {
        CommandSource source = (CommandSource)context.getSource();
        try {
            EditSession session = sessionsMap.get(source.func_197022_f());
            RegionCommand.Region region = RegionCommand.playerSelectionMap.get(source.func_197022_f());
            if (session == null) {
                source.func_197030_a((ITextComponent)new StringTextComponent("No active session, do '/otg edit' to start one"), false);
                return 0;
            }
            if (ObjectUtils.isOutsideBounds(region, session.type)) {
                source.func_197030_a((ITextComponent)new StringTextComponent("Selection is too big! Maximum size is 16x16 for BO4 and 32x32 for BO3"), false);
                return 0;
            }
            source.func_197030_a((ITextComponent)new StringTextComponent("Cleaning up..."), false);
            StructuredCustomObject object = EditCommand.exportFromSession(session, region);
            if (object != null) {
                source.func_197030_a((ITextComponent)new StringTextComponent("Successfully edited " + session.type.getType() + " " + object.getName()), false);
                OTG.getEngine().getCustomObjectManager().getGlobalObjects().addObjectToPreset(session.presetFolderName, object.getName(), object.getConfig().getFile(), object);
            } else {
                source.func_197030_a((ITextComponent)new StringTextComponent("Failed to edit " + session.type.getType() + " " + session.object.getName()), false);
            }
            ObjectUtils.cleanArea(session.genRegion, region.getMin(), region.getMax(), false);
            sessionsMap.put(source.func_197022_f(), null);
        }
        catch (Exception e) {
            source.func_197030_a((ITextComponent)new StringTextComponent("Edit command encountered an error, please check logs."), false);
            OTG.getEngine().getLogger().log(LogLevel.ERROR, LogCategory.MAIN, "Edit command encountered an error: ");
            OTG.getEngine().getLogger().printStackTrace(LogLevel.ERROR, LogCategory.MAIN, e);
        }
        return 0;
    }

    public static StructuredCustomObject exportFromSession(EditSession session, RegionCommand.Region region) {
        return ObjectCreator.createObject(session.type, region.getMin(), region.getMax(), session.extraBlocks.isEmpty() ? region.getCenter() : session.originalCenterPoint, null, session.object.getName(), false, session.leaveIllegalLeaves, session.objectPath, session.genRegion, new ForgeNBTHelper(), session.extraBlocks, session.object.getConfig(), session.presetFolderName, OTG.getEngine().getOTGRootFolder(), OTG.getEngine().getLogger(), OTG.getEngine().getCustomObjectManager(), OTG.getEngine().getPresetLoader().getMaterialReader(session.presetFolderName), OTG.getEngine().getCustomObjectResourcesManager(), OTG.getEngine().getModLoadedChecker());
    }

    public int cancelSession(CommandContext<CommandSource> context) {
        CommandSource source = (CommandSource)context.getSource();
        EditSession session = sessionsMap.get(source.func_197022_f());
        RegionCommand.Region region = RegionCommand.playerSelectionMap.get(source.func_197022_f());
        if (session != null && region != null) {
            ObjectUtils.cleanArea(session.genRegion, region.getMin(), region.getMax(), false);
            sessionsMap.put(source.func_197022_f(), null);
            source.func_197030_a((ITextComponent)new StringTextComponent("Edit session cancelled"), false);
        } else {
            source.func_197030_a((ITextComponent)new StringTextComponent("No active edit session to cancel"), false);
        }
        return 0;
    }

    protected static ArrayList<BlockFunction<?>> spawnAndFixObject(int x, int y, int z, StructuredCustomObject object, ForgeWorldGenRegion worldGenRegion, boolean fixObject, String presetFolderName, Path otgRootFolder, ILogger logger, ICustomObjectManager customObjectManager, IMaterialReader materialReader, CustomObjectResourcesManager manager, IModLoadedChecker modLoadedChecker) {
        BlockFunction<?>[] blocks = object.getConfig().getBlockFunctions(presetFolderName, otgRootFolder, logger, customObjectManager, materialReader, manager, modLoadedChecker);
        HashSet<BlockPos> updates = new HashSet<BlockPos>();
        HashSet<BlockPos> gravityBlocksToCheck = new HashSet<BlockPos>();
        Random random = new Random();
        ArrayList unspawnedBlocks = new ArrayList();
        for (BlockFunction<?> block : blocks) {
            if (block.material == null || block.nbt != null || block instanceof BO3RandomBlockFunction || block instanceof BO4RandomBlockFunction || block.material.isBlank()) {
                unspawnedBlocks.add(block);
                continue;
            }
            if (fixObject && updateMap.contains(ResourceLocation.func_208304_a((String)block.material.getRegistryName()))) {
                updates.add(new BlockPos(x + block.x, y + block.y, z + block.z));
            }
            if (gravityBlocksSet.contains(block.material)) {
                gravityBlocksToCheck.add(new BlockPos(x + block.x, y + block.y, z + block.z));
            }
            if (block.material.isLeaves()) {
                block.material = ForgeMaterialData.ofBlockState((BlockState)((BlockState)((ForgeMaterialData)block.material).internalBlock().func_206870_a((Property)LeavesBlock.field_208495_b, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)LeavesBlock.field_208494_a, (Comparable)Integer.valueOf(7)));
            }
            block.spawn(worldGenRegion, random, x + block.x, y + block.y, z + block.z);
        }
        for (BlockPos pos : gravityBlocksToCheck) {
            if (!worldGenRegion.getMaterial(pos.func_177958_n(), pos.func_177956_o() - 1, pos.func_177952_p()).isMaterial(LocalMaterials.STRUCTURE_VOID)) continue;
            worldGenRegion.setBlock(pos.func_177958_n(), pos.func_177956_o() - 1, pos.func_177952_p(), LocalMaterials.STRUCTURE_BLOCK);
        }
        if (fixObject) {
            for (BlockPos blockpos : updates) {
                BlockState blockstate = worldGenRegion.getBlockState(blockpos);
                if (blockstate.func_235714_a_((ITag)BlockTags.field_206952_E)) {
                    worldGenRegion.getInternal().func_205220_G_().func_205360_a(blockpos, (Object)blockstate.func_177230_c(), 1);
                    continue;
                }
                BlockState blockstate1 = Block.func_199770_b((BlockState)blockstate, (IWorld)worldGenRegion.getInternal(), (BlockPos)blockpos);
                worldGenRegion.setBlockState(blockpos, blockstate1, 20);
            }
        }
        return unspawnedBlocks;
    }

    public int help(CommandContext<CommandSource> context) {
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent("To use the edit command:").func_240699_a_(TextFormatting.LIGHT_PURPLE), false);
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent("/otg edit <preset> <object> [-nofix, -update]"), false);
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent(" - Preset is which preset to fetch the object from, and save it back to"), false);
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent(" - Object is the object you want to edit"), false);
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent(" - The -nofix flag disables block state fixing"), false);
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent(" - The -update flag immediately exports and cleans after fixing"), false);
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent(" - Complex objects cannot have their center moved"), false);
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent(" - An object is \"complex\" if it contains NBT or RandomBlock"), false);
        return 0;
    }

    private CompletableFuture<Suggestions> suggestFlags(CommandContext<CommandSource> context, SuggestionsBuilder builder) {
        return ISuggestionProvider.func_197008_a((String[])FLAGS, (SuggestionsBuilder)builder);
    }

    private static class EditSession {
        private final ObjectType type;
        private final ForgeWorldGenRegion genRegion;
        private final StructuredCustomObject object;
        private final ArrayList<BlockFunction<?>> extraBlocks;
        private final Path objectPath;
        private final String presetFolderName;
        private final Corner originalCenterPoint;
        private final boolean leaveIllegalLeaves;

        public EditSession(ObjectType type, ForgeWorldGenRegion genRegion, StructuredCustomObject object, ArrayList<BlockFunction<?>> extraBlocks, Path objectPath, String presetFolderName, Corner originalCenterPoint, boolean leaveIllegalLeaves) {
            this.type = type;
            this.genRegion = genRegion;
            this.object = object;
            this.extraBlocks = extraBlocks;
            this.objectPath = objectPath;
            this.presetFolderName = presetFolderName;
            this.originalCenterPoint = originalCenterPoint;
            this.leaveIllegalLeaves = leaveIllegalLeaves;
        }
    }
}

