/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.commands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.pg85.otg.OTG;
import com.pg85.otg.config.ConfigFunction;
import com.pg85.otg.config.biome.BiomeConfig;
import com.pg85.otg.constants.SettingsEnums;
import com.pg85.otg.customobject.CustomObject;
import com.pg85.otg.customobject.bo4.BO4;
import com.pg85.otg.customobject.bo4.BO4Data;
import com.pg85.otg.customobject.resource.CustomStructureResource;
import com.pg85.otg.customobject.structures.bo4.BO4CustomStructure;
import com.pg85.otg.customobject.structures.bo4.BO4CustomStructureCoordinate;
import com.pg85.otg.exceptions.InvalidConfigException;
import com.pg85.otg.forge.commands.BaseCommand;
import com.pg85.otg.forge.gen.ForgeWorldGenRegion;
import com.pg85.otg.forge.gen.OTGNoiseChunkGenerator;
import com.pg85.otg.interfaces.IBiomeConfig;
import com.pg85.otg.interfaces.IStructuredCustomObject;
import com.pg85.otg.presets.Preset;
import com.pg85.otg.util.bo3.Rotation;
import com.pg85.otg.util.logging.LogCategory;
import com.pg85.otg.util.logging.LogLevel;
import java.nio.file.Path;
import java.util.ArrayList;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.storage.FolderName;

public class ExportBO4DataCommand
extends BaseCommand {
    private static boolean isRunning = false;
    private static boolean isDone = false;
    private static int current = 0;
    private static int total = 0;
    private static String boName = "";

    public ExportBO4DataCommand() {
        super("preset");
        this.helpMessage = "Exports all BO4 files and BO3 files that have isOTGPlus:true as BO4Data files (if none exist already). BO4Data files can significantly reduce filesize and loading times, and should be used by OTG content creators when packaging presets for players.";
        this.usage = "/otg exportbo4data";
    }

    @Override
    public void build(LiteralArgumentBuilder<CommandSource> builder) {
        builder.then(Commands.func_197057_a((String)"exportbo4data").executes(context -> this.exportBO4Data((CommandSource)context.getSource())));
    }

    private int exportBO4Data(CommandSource source) {
        if (!(source.func_197023_e().func_72863_F().field_186029_c instanceof OTGNoiseChunkGenerator)) {
            source.func_197030_a((ITextComponent)new StringTextComponent("OTG is not enabled in this world"), false);
            return 0;
        }
        Preset preset = ((OTGNoiseChunkGenerator)source.func_197023_e().func_72863_F().field_186029_c).getPreset();
        if (preset.getWorldConfig().getCustomStructureType() == SettingsEnums.CustomStructureType.BO4) {
            if (!isRunning) {
                isDone = false;
                isRunning = true;
                source.func_197030_a((ITextComponent)new StringTextComponent("Exporting .BO4Data files for world, this may take a while."), false);
                source.func_197030_a((ITextComponent)new StringTextComponent("Run this command again to see progress or check the logs."), false);
                new Thread(() -> {
                    OTG.getEngine().getLogger().log(LogLevel.INFO, LogCategory.MAIN, "Initializing and exporting structure starts");
                    for (IBiomeConfig biomeConfig : preset.getAllBiomeConfigs()) {
                        for (ConfigFunction res : ((BiomeConfig)biomeConfig).getResourceQueue()) {
                            if (!(res instanceof CustomStructureResource)) continue;
                            for (IStructuredCustomObject structure : ((CustomStructureResource)res).getObjects(preset.getFolderName(), OTG.getEngine().getOTGRootFolder(), OTG.getEngine().getLogger(), OTG.getEngine().getCustomObjectManager(), OTG.getEngine().getPresetLoader().getMaterialReader(preset.getFolderName()), OTG.getEngine().getCustomObjectResourcesManager(), OTG.getEngine().getModLoadedChecker())) {
                                if (structure == null || !(structure instanceof BO4) || BO4Data.bo4DataExists(((BO4)structure).getConfig())) continue;
                                BO4CustomStructureCoordinate structureCoord = new BO4CustomStructureCoordinate(preset.getFolderName(), structure, null, Rotation.NORTH, 0, 0, 0, 0, false, false, null);
                                BO4CustomStructure structureStart = new BO4CustomStructure(source.func_197023_e().func_72905_C(), structureCoord, OTG.getEngine().getOTGRootFolder(), OTG.getEngine().getLogger(), OTG.getEngine().getCustomObjectManager(), OTG.getEngine().getPresetLoader().getMaterialReader(preset.getFolderName()), OTG.getEngine().getCustomObjectResourcesManager(), OTG.getEngine().getModLoadedChecker());
                                try {
                                    Path worldSaveFolder = source.func_197023_e().func_73046_m().func_240776_a_(FolderName.field_237247_c_).getParent();
                                    ForgeWorldGenRegion worldGenRegion = new ForgeWorldGenRegion(preset.getFolderName(), preset.getWorldConfig(), (ISeedReader)source.func_197023_e(), (OTGNoiseChunkGenerator)source.func_197023_e().func_72863_F().func_201711_g());
                                    structureStart.getMinimumSize(((OTGNoiseChunkGenerator)source.func_197023_e().func_72863_F().field_186029_c).getStructureCache(worldSaveFolder), worldGenRegion, OTG.getEngine().getOTGRootFolder(), OTG.getEngine().getLogger(), OTG.getEngine().getCustomObjectManager(), OTG.getEngine().getPresetLoader().getMaterialReader(preset.getFolderName()), OTG.getEngine().getCustomObjectResourcesManager(), OTG.getEngine().getModLoadedChecker());
                                }
                                catch (InvalidConfigException e) {
                                    ((BO4)structure).isInvalidConfig = true;
                                }
                                OTG.getEngine().getLogger().log(LogLevel.INFO, LogCategory.MAIN, "Exporting .BO4Data for structure start " + ((BO4)structure).getName());
                                boName = ((BO4)structure).getName();
                                BO4Data.generateBO4Data(((BO4)structure).getConfig(), preset.getFolderName(), OTG.getEngine().getOTGRootFolder(), OTG.getEngine().getLogger(), OTG.getEngine().getCustomObjectManager(), OTG.getEngine().getPresetLoader().getMaterialReader(preset.getFolderName()), OTG.getEngine().getCustomObjectResourcesManager(), OTG.getEngine().getModLoadedChecker());
                                OTG.getEngine().getCustomObjectManager().getGlobalObjects().unloadCustomObjectFiles();
                            }
                        }
                    }
                    ArrayList<String> boNames = OTG.getEngine().getCustomObjectManager().getGlobalObjects().getAllBONamesForPreset(preset.getFolderName(), OTG.getEngine().getLogger(), OTG.getEngine().getOTGRootFolder());
                    current = 0;
                    total = boNames.size();
                    for (String boName : boNames) {
                        ++current;
                        CustomObject bo = OTG.getEngine().getCustomObjectManager().getGlobalObjects().getObjectByName(boName, preset.getFolderName(), OTG.getEngine().getOTGRootFolder(), OTG.getEngine().getLogger(), OTG.getEngine().getCustomObjectManager(), OTG.getEngine().getPresetLoader().getMaterialReader(preset.getFolderName()), OTG.getEngine().getCustomObjectResourcesManager(), OTG.getEngine().getModLoadedChecker());
                        if (bo == null || !(bo instanceof BO4) || BO4Data.bo4DataExists(((BO4)bo).getConfig())) continue;
                        OTG.getEngine().getLogger().log(LogLevel.INFO, LogCategory.MAIN, "Exporting .BO4Data " + current + "/" + total + " " + boName);
                        BO4Data.generateBO4Data(((BO4)bo).getConfig(), preset.getFolderName(), OTG.getEngine().getOTGRootFolder(), OTG.getEngine().getLogger(), OTG.getEngine().getCustomObjectManager(), OTG.getEngine().getPresetLoader().getMaterialReader(preset.getFolderName()), OTG.getEngine().getCustomObjectResourcesManager(), OTG.getEngine().getModLoadedChecker());
                        OTG.getEngine().getCustomObjectManager().getGlobalObjects().unloadCustomObjectFiles();
                    }
                    OTG.getEngine().getLogger().log(LogLevel.INFO, LogCategory.MAIN, "Exporting .BO4Data done.");
                    isDone = true;
                }).start();
            } else if (isDone) {
                isRunning = false;
                isDone = false;
                source.func_197030_a((ITextComponent)new StringTextComponent("OTG exportbo4data is done."), false);
            } else {
                source.func_197030_a((ITextComponent)new StringTextComponent("OTG exportbo4data is running, " + (current == 0 ? "exporting structure start " + boName : " exporting " + current + "/" + total)), false);
            }
        } else {
            source.func_197030_a((ITextComponent)new StringTextComponent("The ExportBO4Data command is only available for CustomStructureType:BO4 worlds."), false);
        }
        return 0;
    }
}

