/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.commands;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.pg85.otg.OTG;
import com.pg85.otg.customobject.creator.ObjectCreator;
import com.pg85.otg.customobject.creator.ObjectType;
import com.pg85.otg.customobject.structures.StructuredCustomObject;
import com.pg85.otg.customobject.util.Corner;
import com.pg85.otg.forge.commands.BaseCommand;
import com.pg85.otg.forge.commands.ObjectUtils;
import com.pg85.otg.forge.commands.RegionCommand;
import com.pg85.otg.forge.commands.WorldEditUtil;
import com.pg85.otg.forge.commands.arguments.FlagsArgument;
import com.pg85.otg.forge.commands.arguments.PresetArgument;
import com.pg85.otg.forge.gen.ForgeWorldGenRegion;
import com.pg85.otg.forge.materials.ForgeMaterialData;
import com.pg85.otg.forge.util.ForgeNBTHelper;
import com.pg85.otg.presets.Preset;
import com.pg85.otg.util.logging.LogCategory;
import com.pg85.otg.util.logging.LogLevel;
import com.pg85.otg.util.materials.LocalMaterialData;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.block.BlockState;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.BlockStateArgument;
import net.minecraft.command.arguments.BlockStateInput;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;

public class ExportCommand
extends BaseCommand {
    private static final String[] FLAGS = new String[]{"-o", "-a", "-b", "-e", "-oa", "-ob", "-oe", "-ab", "-ae", "-be", "-oab", "-obe", "-oae", "-abe", "-oabe"};
    private static final Function<String, String> filterNamesWithSpaces = name -> name.contains(" ") ? "\"" + name + "\"" : name;

    public ExportCommand() {
        super("export");
        this.helpMessage = "Allows you to export an area as a BO3 or BO4.";
        this.usage = "Please see /otg export help.";
    }

    @Override
    public void build(LiteralArgumentBuilder<CommandSource> builder) {
        builder.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"export").executes(this::execute)).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.func_197056_a((String)"name", (ArgumentType)StringArgumentType.string()).executes(this::execute)).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"preset", (ArgumentType)StringArgumentType.string()).executes(this::execute)).suggests((context, suggestionBuilder) -> PresetArgument.suggest((CommandContext<CommandSource>)context, suggestionBuilder, true)).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"type", (ArgumentType)StringArgumentType.word()).executes(this::execute)).suggests((context, suggestionBuilder) -> this.suggestTypes((CommandContext<CommandSource>)context, suggestionBuilder, false)).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"template", (ArgumentType)new TemplateArgument()).executes(this::execute)).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"flags", (ArgumentType)FlagsArgument.create()).executes(this::execute)).suggests(this::suggestFlags).then(Commands.func_197056_a((String)"excludes", (ArgumentType)BlockStateArgument.func_197239_a()).executes(this::execute))))))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"center", (ArgumentType)BlockStateArgument.func_197239_a()).executes(this::execute)).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"preset", (ArgumentType)StringArgumentType.string()).executes(this::execute)).suggests((context, suggestionBuilder) -> PresetArgument.suggest((CommandContext<CommandSource>)context, suggestionBuilder, true)).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"type", (ArgumentType)StringArgumentType.word()).executes(this::execute)).suggests((context, suggestionBuilder) -> this.suggestTypes((CommandContext<CommandSource>)context, suggestionBuilder, false)).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"template", (ArgumentType)new TemplateArgument()).executes(this::execute)).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"flags", (ArgumentType)FlagsArgument.create()).executes(this::execute)).suggests(this::suggestFlags).then(Commands.func_197056_a((String)"excludes", (ArgumentType)BlockStateArgument.func_197239_a()).executes(this::execute))))))))).then(Commands.func_197057_a((String)"help").executes(context -> this.helpMessage((CommandSource)context.getSource()))));
    }

    public int execute(CommandContext<CommandSource> context) {
        CommandSource source = (CommandSource)context.getSource();
        try {
            StructuredCustomObject object;
            ForgeMaterialData centerBlock;
            Preset preset;
            BlockState centerBlockState;
            if (!(source.func_197022_f() instanceof ServerPlayerEntity)) {
                source.func_197030_a((ITextComponent)new StringTextComponent("Only players can execute this command"), false);
                return 0;
            }
            ServerPlayerEntity playerEntity = (ServerPlayerEntity)source.func_197022_f();
            String objectName = "";
            String presetName = null;
            ObjectType type = ObjectType.BO3;
            String templateName = "default";
            boolean overwrite = false;
            boolean isStructure = false;
            boolean includeAir = false;
            boolean isGlobal = false;
            boolean hasExcludes = false;
            try {
                centerBlockState = ((BlockStateInput)context.getArgument("center", BlockStateInput.class)).func_197231_a();
            }
            catch (IllegalArgumentException ex) {
                centerBlockState = null;
            }
            try {
                objectName = (String)context.getArgument("name", String.class);
                presetName = (String)context.getArgument("preset", String.class);
                String raw = (String)context.getArgument("type", String.class);
                type = ObjectType.valueOf(raw.toUpperCase(Locale.ROOT));
                templateName = (String)context.getArgument("template", String.class);
                String flags = (String)context.getArgument("flags", String.class);
                overwrite = flags.contains("o");
                isStructure = flags.contains("b");
                includeAir = flags.contains("a");
                hasExcludes = flags.contains("e");
            }
            catch (IllegalArgumentException raw) {
                // empty catch block
            }
            if (presetName == null || presetName.equalsIgnoreCase("global")) {
                presetName = OTG.getEngine().getPresetLoader().getDefaultPresetFolderName();
                isGlobal = true;
            }
            if (objectName.equalsIgnoreCase("")) {
                source.func_197030_a((ITextComponent)new StringTextComponent("Usage: /otg export <object name> (center block) [preset] [type] [template] [-a -b -o]").func_240699_a_(TextFormatting.LIGHT_PURPLE), false);
                source.func_197030_a((ITextComponent)new StringTextComponent("Do /otg export help for more info"), false);
                return 0;
            }
            if (type == ObjectType.BO2) {
                source.func_197030_a((ITextComponent)new StringTextComponent("Cannot export BO2 objects"), false);
                return 0;
            }
            RegionCommand.Region region = null;
            if (OTG.getEngine().getModLoadedChecker().isModLoaded("worldedit")) {
                region = WorldEditUtil.getRegionFromPlayer(playerEntity);
            }
            if (region == null) {
                region = RegionCommand.playerSelectionMap.get(source.func_197022_f());
            }
            if (region == null || region.getMin() == null || region.getMax() == null) {
                source.func_197030_a((ITextComponent)new StringTextComponent("Please define a region with /otg region mark, or worldedit"), false);
                return 0;
            }
            if (ObjectUtils.isOutsideBounds(region, type)) {
                isStructure = true;
            }
            if ((preset = ObjectUtils.getPresetOrDefault(presetName)) == null) {
                source.func_197030_a((ITextComponent)new StringTextComponent("Could not find preset " + (presetName == null ? "" : presetName)), false);
                return 0;
            }
            Path objectPath = ObjectUtils.getObjectFolderPath(isGlobal ? null : preset.getPresetFolder());
            if (!overwrite && new File(objectPath.toFile(), objectName + ".bo3").exists() && new File(objectPath.toFile(), objectName + "." + type.getType()).exists()) {
                source.func_197030_a((ITextComponent)new StringTextComponent("File already exists, run command with flag '-o' to overwrite"), false);
                return 0;
            }
            ForgeWorldGenRegion worldGenRegion = ObjectUtils.getWorldGenRegion(preset, source.func_197023_e());
            ForgeNBTHelper nbtHelper = new ForgeNBTHelper();
            Corner lowCorner = region.getMin();
            Corner highCorner = region.getMax();
            Corner center = region.getCenter() != null ? region.getCenter() : new Corner((highCorner.x - lowCorner.x) / 2 + lowCorner.x, Math.min(lowCorner.y, highCorner.y), (highCorner.z - lowCorner.z) / 2 + lowCorner.z);
            File templateFile = OTG.getEngine().getCustomObjectManager().getGlobalObjects().getTemplateFileForPreset(presetName, templateName, OTG.getEngine().getLogger(), OTG.getEngine().getOTGRootFolder());
            StructuredCustomObject template = (StructuredCustomObject)OTG.getEngine().getCustomObjectManager().getObjectLoaders().get(type.getType().toLowerCase()).loadFromFile(templateName, templateFile != null ? templateFile : new File(type.getFileNameForTemplate(templateName)), OTG.getEngine().getLogger());
            if (!template.onEnable(preset.getFolderName(), OTG.getEngine().getOTGRootFolder(), OTG.getEngine().getLogger(), OTG.getEngine().getCustomObjectManager(), OTG.getEngine().getPresetLoader().getMaterialReader(preset.getFolderName()), OTG.getEngine().getCustomObjectResourcesManager(), OTG.getEngine().getModLoadedChecker())) {
                source.func_197030_a((ITextComponent)new StringTextComponent("Failed to load template \"" + templateName + "\""), false);
                return 0;
            }
            ForgeMaterialData forgeMaterialData = centerBlock = centerBlockState == null ? null : ForgeMaterialData.ofBlockState(centerBlockState);
            if (hasExcludes) {
                BlockState excludeBlockState = ((BlockStateInput)context.getArgument("excludes", BlockStateInput.class)).func_197231_a();
                ForgeMaterialData exclude = ForgeMaterialData.ofBlockState(excludeBlockState);
                ArrayList<LocalMaterialData> excludes = new ArrayList<LocalMaterialData>();
                excludes.add(exclude);
                object = ObjectCreator.create(type, lowCorner, highCorner, center, centerBlock, objectName, includeAir, isStructure, false, objectPath, worldGenRegion, nbtHelper, null, template.getConfig(), preset.getFolderName(), OTG.getEngine().getOTGRootFolder(), OTG.getEngine().getLogger(), OTG.getEngine().getCustomObjectManager(), OTG.getEngine().getPresetLoader().getMaterialReader(preset.getFolderName()), OTG.getEngine().getCustomObjectResourcesManager(), OTG.getEngine().getModLoadedChecker(), excludes);
            } else {
                object = ObjectCreator.create(type, lowCorner, highCorner, center, centerBlock, objectName, includeAir, isStructure, false, objectPath, worldGenRegion, nbtHelper, null, template.getConfig(), preset.getFolderName(), OTG.getEngine().getOTGRootFolder(), OTG.getEngine().getLogger(), OTG.getEngine().getCustomObjectManager(), OTG.getEngine().getPresetLoader().getMaterialReader(preset.getFolderName()), OTG.getEngine().getCustomObjectResourcesManager(), OTG.getEngine().getModLoadedChecker());
            }
            if (object != null) {
                source.func_197030_a((ITextComponent)new StringTextComponent("Successfully created " + type.getType() + " " + objectName), false);
                if (isGlobal) {
                    OTG.getEngine().getCustomObjectManager().registerGlobalObject(object, object.getConfig().getFile());
                } else {
                    OTG.getEngine().getCustomObjectManager().getGlobalObjects().addObjectToPreset(preset.getFolderName(), object.getName().toLowerCase(Locale.ROOT), object.getConfig().getFile(), object);
                }
            } else {
                source.func_197030_a((ITextComponent)new StringTextComponent("Failed to create " + type.getType() + " " + objectName), false);
            }
        }
        catch (Exception e) {
            source.func_197030_a((ITextComponent)new StringTextComponent("Something went wrong, please check the logs"), false);
            OTG.getEngine().getLogger().log(LogLevel.ERROR, LogCategory.MAIN, "Error during export command: " + e.getClass().getName());
            OTG.getEngine().getLogger().printStackTrace(LogLevel.ERROR, LogCategory.MAIN, e);
        }
        return 0;
    }

    public int helpMessage(CommandSource source) {
        source.func_197030_a((ITextComponent)new StringTextComponent("Usage: /otg export <object name> (center block) [preset] [type] [template] [-a -b -o]").func_240699_a_(TextFormatting.LIGHT_PURPLE), false);
        source.func_197030_a((ITextComponent)new StringTextComponent(" - Object name is the only required argument"), false);
        source.func_197030_a((ITextComponent)new StringTextComponent(" - Center block is optional; if set, the center will be set to the first found instance of the given block."), false);
        source.func_197030_a((ITextComponent)new StringTextComponent(" - Preset determines where the object is saved, and where templates are searched for"), false);
        source.func_197030_a((ITextComponent)new StringTextComponent(" - Type is either BO3 or BO4"), false);
        source.func_197030_a((ITextComponent)new StringTextComponent(" - Template is a BO3 file whose settings are used for the exported object"), false);
        source.func_197030_a((ITextComponent)new StringTextComponent("    - Templates have file ending .BO3Template or .BO4Template"), false);
        source.func_197030_a((ITextComponent)new StringTextComponent("    - Templates are not loaded as objects"), false);
        source.func_197030_a((ITextComponent)new StringTextComponent(" - There are three flags; -a for Air blocks, -b for Branches, -o for Override"), false);
        return 0;
    }

    private CompletableFuture<Suggestions> suggestTypes(CommandContext<CommandSource> context, SuggestionsBuilder builder, boolean includeBO2) {
        Set set = Stream.of(ObjectType.values()).map(ObjectType::getType).collect(Collectors.toSet());
        if (!includeBO2) {
            set.remove("BO2");
        }
        return ISuggestionProvider.func_197005_b(set, (SuggestionsBuilder)builder);
    }

    private CompletableFuture<Suggestions> suggestFlags(CommandContext<CommandSource> context, SuggestionsBuilder builder) {
        return ISuggestionProvider.func_197008_a((String[])FLAGS, (SuggestionsBuilder)builder);
    }

    private static class TemplateArgument
    implements ArgumentType<String> {
        private TemplateArgument() {
        }

        public String parse(StringReader reader) throws CommandSyntaxException {
            return reader.readString();
        }

        public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
            String preset = (String)context.getArgument("preset", String.class);
            List<String> list = preset.equalsIgnoreCase("global") ? OTG.getEngine().getCustomObjectManager().getGlobalObjects().getGlobalTemplates(OTG.getEngine().getLogger(), OTG.getEngine().getOTGRootFolder()) : OTG.getEngine().getCustomObjectManager().getGlobalObjects().getTemplatesForPreset(preset, OTG.getEngine().getLogger(), OTG.getEngine().getOTGRootFolder());
            if (list == null) {
                list = new ArrayList();
            }
            list = list.stream().map(filterNamesWithSpaces).collect(Collectors.toList());
            list.add("default");
            return ISuggestionProvider.func_197013_a(list.stream(), (SuggestionsBuilder)builder);
        }
    }
}

