/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.commands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.pg85.otg.OTG;
import com.pg85.otg.forge.commands.BaseCommand;
import com.pg85.otg.forge.gen.OTGNoiseChunkGenerator;
import com.pg85.otg.util.logging.LogCategory;
import com.pg85.otg.util.logging.LogLevel;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class FlushCommand
extends BaseCommand {
    public FlushCommand() {
        super("flush");
        this.helpMessage = "Clears all loaded objects, forcing them to be reloaded from disk.";
        this.usage = "/otg flush";
    }

    @Override
    public void build(LiteralArgumentBuilder<CommandSource> builder) {
        builder.then(Commands.func_197057_a((String)"flush").executes(context -> this.flushCache((CommandSource)context.getSource())));
    }

    protected int flushCache(CommandSource source) {
        if (!(source.func_197023_e().func_72863_F().field_186029_c instanceof OTGNoiseChunkGenerator)) {
            source.func_197030_a((ITextComponent)new StringTextComponent("OTG is not enabled in this world"), false);
            return 0;
        }
        OTG.getEngine().getLogger().log(LogLevel.INFO, LogCategory.MAIN, "Unloading BO2/BO3/BO4 files");
        OTG.getEngine().getCustomObjectManager().reloadCustomObjectFiles();
        source.func_197030_a((ITextComponent)new StringTextComponent("Objects unloaded."), false);
        return 0;
    }
}

