/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.pg85.otg.forge.commands.BaseCommand;
import com.pg85.otg.forge.commands.OTGCommand;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import org.apache.commons.lang3.StringUtils;

public class HelpCommand
extends BaseCommand {
    public HelpCommand() {
        super("help");
        this.helpMessage = "Shows help for all OTG commands.";
        this.usage = "/otg help [command/page]";
        this.detailedHelp = new String[]{"[command/page]: The name of the command you want to view detailed help for, or the page number of the help menu you want to display."};
    }

    @Override
    public void build(LiteralArgumentBuilder<CommandSource> builder) {
        builder.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"help").executes(context -> this.showHelp((CommandSource)context.getSource(), ""))).then(Commands.func_197056_a((String)"command", (ArgumentType)StringArgumentType.word()).suggests(this::suggestHelp).executes(context -> this.showHelp((CommandSource)context.getSource(), (String)context.getArgument("command", String.class)))));
    }

    protected int showHelp(CommandSource source, String cmd) {
        if (cmd.isEmpty()) {
            this.showHelp(source, 1);
        } else if (StringUtils.isNumeric((CharSequence)cmd)) {
            this.showHelp(source, Integer.parseInt(cmd));
        } else {
            OTGCommand.getCommands().stream().filter(basecmd -> basecmd.getName().equalsIgnoreCase(cmd)).findFirst().ifPresent(command -> {
                source.func_197030_a((ITextComponent)new StringTextComponent("/otg " + command.getName() + ": ").func_240699_a_(TextFormatting.GOLD).func_230529_a_((ITextComponent)new StringTextComponent(command.getHelpMessage()).func_240699_a_(TextFormatting.GREEN)), false);
                source.func_197030_a((ITextComponent)new StringTextComponent("usage: " + command.getUsage()).func_240699_a_(TextFormatting.GRAY), false);
                for (String help : command.getDetailedHelp()) {
                    source.func_197030_a((ITextComponent)new StringTextComponent(help).func_240699_a_(TextFormatting.GRAY), false);
                }
            });
        }
        return 0;
    }

    private void showHelp(CommandSource source, int page) {
        int start = (page - 1) * 5;
        List<BaseCommand> commands = OTGCommand.getCommands();
        for (int i = start; i < commands.size() && i < start + 5; ++i) {
            BaseCommand command = commands.get(i);
            source.func_197030_a((ITextComponent)new StringTextComponent("/otg " + command.getName() + ": ").func_240699_a_(TextFormatting.GOLD).func_230529_a_((ITextComponent)new StringTextComponent(command.getHelpMessage()).func_240699_a_(TextFormatting.GREEN)), false);
            source.func_197030_a((ITextComponent)new StringTextComponent(" - usage: " + command.getUsage()).func_240699_a_(TextFormatting.GRAY), false);
        }
        source.func_197030_a((ITextComponent)new StringTextComponent("Use /otg help <page> for more commands.").func_240699_a_(TextFormatting.GOLD), false);
    }

    private CompletableFuture<Suggestions> suggestHelp(CommandContext<CommandSource> context, SuggestionsBuilder builder) {
        return ISuggestionProvider.func_197005_b((Iterable)OTGCommand.getCommands().stream().map(BaseCommand::getName).collect(Collectors.toList()), (SuggestionsBuilder)builder);
    }
}

