/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.pg85.otg.forge.biome.OTGBiomeProvider;
import com.pg85.otg.forge.commands.BaseCommand;
import com.pg85.otg.forge.gen.ForgeChunkBuffer;
import com.pg85.otg.forge.gen.OTGNoiseChunkGenerator;
import com.pg85.otg.forge.materials.ForgeMaterialData;
import com.pg85.otg.util.BlockPos2D;
import com.pg85.otg.util.ChunkCoordinate;
import com.pg85.otg.util.materials.LocalMaterials;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import javax.imageio.ImageIO;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class MapCommand
extends BaseCommand {
    private static final String[] MAP_TYPES = new String[]{"biomes", "terrain"};
    private static final Object queueLock = new Object();
    private static final Object imgLock = new Object();

    public MapCommand() {
        super("map");
        this.helpMessage = "Generates an image of the biome or terrain layout.";
        this.usage = "/otg map <biomes/terrain> [width] [height] [threads]";
        this.detailedHelp = new String[]{"<biomes/terrain>: The type of map to create.", " - biomes: Creates an image using the color specified in each biome's config file.", " - terrain: Creates an image using the colours of the blocks shaded to show the altitude of the terrain.", "[width]: Image width in pixels.", "[height]: Image height in pixels.", "[threads]: The number of threads to use while rendering the image."};
    }

    @Override
    public void build(LiteralArgumentBuilder<CommandSource> builder) {
        builder.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"map").executes(context -> this.map((CommandSource)context.getSource(), "", 2048, 2048, 0))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"type", (ArgumentType)StringArgumentType.word()).executes(context -> this.map((CommandSource)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"type"), 2048, 2048, 1))).suggests(this::suggestTypes).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"width", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> this.map((CommandSource)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"type"), IntegerArgumentType.getInteger((CommandContext)context, (String)"width"), IntegerArgumentType.getInteger((CommandContext)context, (String)"width"), 1))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"height", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> this.map((CommandSource)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"type"), IntegerArgumentType.getInteger((CommandContext)context, (String)"width"), IntegerArgumentType.getInteger((CommandContext)context, (String)"height"), 1))).then(Commands.func_197056_a((String)"threads", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> this.map((CommandSource)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"type"), IntegerArgumentType.getInteger((CommandContext)context, (String)"width"), IntegerArgumentType.getInteger((CommandContext)context, (String)"height"), IntegerArgumentType.getInteger((CommandContext)context, (String)"threads"))))))));
    }

    private int map(CommandSource source, String type, int width, int height, int threads) {
        switch (type.toLowerCase()) {
            case "biomes": {
                return MapCommand.mapBiomes(source, width, height, threads);
            }
            case "terrain": {
                return MapCommand.mapTerrain(source, width, height, threads);
            }
        }
        source.func_197030_a((ITextComponent)new StringTextComponent(this.getUsage()), false);
        return 0;
    }

    private static int mapBiomes(CommandSource source, int width, int height, int threads) {
        if (!(source.func_197023_e().func_72863_F().field_186029_c instanceof OTGNoiseChunkGenerator) || !(source.func_197023_e().func_72863_F().field_186029_c.func_202090_b() instanceof OTGBiomeProvider)) {
            source.func_197030_a((ITextComponent)new StringTextComponent("Please run this command in an OTG world."), false);
            return 1;
        }
        BufferedImage img = new BufferedImage(width, height, 1);
        Instant start = Instant.now();
        MapCommand.handleArea(width, height, img, source, (OTGNoiseChunkGenerator)source.func_197023_e().func_72863_F().field_186029_c, true, threads);
        Instant finish = Instant.now();
        Duration duration = Duration.between(start, finish);
        String fileName = source.func_197028_i().func_240793_aU_().func_76065_j() + " biomes.png";
        Path p = Paths.get(fileName, new String[0]);
        try {
            ImageIO.write((RenderedImage)img, "png", p.toAbsolutePath().toFile());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String hours = "" + (duration.toHours() > 9L ? Long.valueOf(duration.toHours()) : "0" + duration.toHours());
        String minutes = "" + (duration.toMinutes() % 60L > 9L ? Long.valueOf(duration.toMinutes() % 60L) : "0" + duration.toMinutes() % 60L);
        String seconds = "" + (duration.get(ChronoUnit.SECONDS) % 60L > 9L ? Long.valueOf(duration.get(ChronoUnit.SECONDS) % 60L) : "0" + duration.get(ChronoUnit.SECONDS) % 60L);
        source.func_197030_a((ITextComponent)new StringTextComponent("Finished mapping in " + hours + ":" + minutes + ":" + seconds + "! The resulting image is located at " + fileName + "."), true);
        return 0;
    }

    private static int mapTerrain(CommandSource source, int width, int height, int threads) {
        if (!(source.func_197023_e().func_72863_F().field_186029_c instanceof OTGNoiseChunkGenerator) || !(source.func_197023_e().func_72863_F().field_186029_c.func_202090_b() instanceof OTGBiomeProvider)) {
            source.func_197030_a((ITextComponent)new StringTextComponent("Please run this command in an OTG world."), false);
            return 1;
        }
        BufferedImage img = new BufferedImage(width, height, 1);
        Instant start = Instant.now();
        MapCommand.handleArea(width, height, img, source, (OTGNoiseChunkGenerator)source.func_197023_e().func_72863_F().field_186029_c, false, threads);
        Instant finish = Instant.now();
        Duration duration = Duration.between(start, finish);
        String fileName = source.func_197028_i().func_240793_aU_().func_76065_j() + " terrain.png";
        Path p = Paths.get(fileName, new String[0]);
        try {
            ImageIO.write((RenderedImage)img, "png", p.toAbsolutePath().toFile());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String hours = "" + (duration.toHours() > 9L ? Long.valueOf(duration.toHours()) : "0" + duration.toHours());
        String minutes = "" + (duration.toMinutes() % 60L > 9L ? Long.valueOf(duration.toMinutes() % 60L) : "0" + duration.toMinutes() % 60L);
        String seconds = "" + (duration.get(ChronoUnit.SECONDS) % 60L > 9L ? Long.valueOf(duration.get(ChronoUnit.SECONDS) % 60L) : "0" + duration.get(ChronoUnit.SECONDS) % 60L);
        source.func_197030_a((ITextComponent)new StringTextComponent("Finished mapping in " + hours + ":" + minutes + ":" + seconds + "! The resulting image is located at " + fileName + "."), true);
        return 0;
    }

    private static void handleArea(int width, int height, BufferedImage img, CommandSource source, OTGNoiseChunkGenerator generator, boolean mapBiomes, int threads) {
        int chunkZ;
        int chunkX;
        ArrayList<BlockPos2D> coordsToHandle = new ArrayList<BlockPos2D>(width * height);
        if (mapBiomes) {
            for (chunkX = 0; chunkX < (int)Math.ceil((float)width / 4.0f); ++chunkX) {
                for (chunkZ = 0; chunkZ < (int)Math.ceil((float)height / 4.0f); ++chunkZ) {
                    coordsToHandle.add(new BlockPos2D(chunkX, chunkZ));
                }
            }
        } else {
            for (chunkX = 0; chunkX < (int)Math.ceil((float)width / 16.0f); ++chunkX) {
                for (chunkZ = 0; chunkZ < (int)Math.ceil((float)height / 16.0f); ++chunkZ) {
                    coordsToHandle.add(new BlockPos2D(chunkX, chunkZ));
                }
            }
        }
        CountDownLatch latch = new CountDownLatch(threads);
        MapCommand outer = new MapCommand();
        int totalSize = coordsToHandle.size();
        for (int i = 0; i < threads; ++i) {
            MapCommand mapCommand = outer;
            mapCommand.getClass();
            mapCommand.new Worker(latch, source, generator, img, coordsToHandle, totalSize, mapBiomes, width, height).start();
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private static int shadeColor(int rgbColor, int percent) {
        int red = rgbColor >> 16 & 0xFF;
        int green = rgbColor >> 8 & 0xFF;
        int blue = rgbColor & 0xFF;
        red = (red = red * percent / 100) > 255 ? 255 : red;
        green = green * percent / 100;
        green = green > 255 ? 255 : green;
        blue = blue * percent / 100;
        blue = blue > 255 ? 255 : blue;
        return 65536 * red + 256 * green + blue;
    }

    private CompletableFuture<Suggestions> suggestTypes(CommandContext<CommandSource> context, SuggestionsBuilder builder) {
        return ISuggestionProvider.func_197008_a((String[])MAP_TYPES, (SuggestionsBuilder)builder);
    }

    public class HighestBlockInfo {
        public final ForgeMaterialData material;
        public final int y;

        public HighestBlockInfo(ForgeMaterialData material, int y) {
            this.material = material;
            this.y = y;
        }
    }

    public class Worker
    implements Runnable {
        private Thread runner;
        private final int totalSize;
        private final List<BlockPos2D> coordsToHandle;
        private final CountDownLatch latch;
        private final OTGNoiseChunkGenerator generator;
        private final CommandSource source;
        private final BufferedImage img;
        private final int progressUpdate;
        private final boolean mapBiomes;
        private final int width;
        private final int height;

        public Worker(CountDownLatch latch, CommandSource source, OTGNoiseChunkGenerator generator, BufferedImage img, List<BlockPos2D> coordsToHandle, int totalSize, boolean mapBiomes, int width, int height) {
            this.latch = latch;
            this.generator = generator;
            this.source = source;
            this.img = img;
            this.progressUpdate = (int)Math.ceil((float)totalSize / 100.0f);
            this.coordsToHandle = coordsToHandle;
            this.totalSize = totalSize;
            this.mapBiomes = mapBiomes;
            this.width = width;
            this.height = height;
        }

        public void start() {
            this.runner = new Thread(this);
            this.runner.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                int sizeLeft;
                BlockPos2D coords = null;
                Object object = queueLock;
                synchronized (object) {
                    sizeLeft = this.coordsToHandle.size();
                    if (sizeLeft > 0) {
                        coords = this.coordsToHandle.remove(sizeLeft - 1);
                    }
                }
                if (sizeLeft % this.progressUpdate == 0) {
                    this.source.func_197030_a((ITextComponent)new StringTextComponent((int)Math.floor(100.0 - (double)sizeLeft / (double)this.totalSize * 100.0) + "% Done mapping"), true);
                }
                if (coords == null) break;
                if (this.mapBiomes) {
                    this.getBiomePixel(coords);
                    continue;
                }
                this.getTerrainPixel(coords);
            }
            this.latch.countDown();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void getBiomePixel(BlockPos2D chunkCoords) {
            for (int internalX = 0; internalX < 16; ++internalX) {
                for (int internalZ = 0; internalZ < 16; ++internalZ) {
                    int noiseX = chunkCoords.x * 16 + internalX;
                    int noiseZ = chunkCoords.z * 16 + internalZ;
                    if (noiseX >= this.width || noiseZ >= this.height) continue;
                    int biomeColor = this.generator.getCachedBiomeProvider().getNoiseBiomeConfig(noiseX, noiseZ, true).getBiomeColor();
                    Object object = imgLock;
                    synchronized (object) {
                        this.img.setRGB(noiseX, noiseZ, biomeColor);
                        continue;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void getTerrainPixel(BlockPos2D chunkCoords) {
            ForgeChunkBuffer chunk = this.generator.getChunkWithoutLoadingOrCaching(this.source.func_197023_e().func_201674_k(), ChunkCoordinate.fromChunkCoords(chunkCoords.x, chunkCoords.z));
            for (int internalX = 0; internalX < 16; ++internalX) {
                for (int internalZ = 0; internalZ < 16; ++internalZ) {
                    int x = chunkCoords.x * 16 + internalX;
                    int z = chunkCoords.z * 16 + internalZ;
                    if (x >= this.width || z >= this.height) continue;
                    HighestBlockInfo highestBlockInfo = this.getHighestBlockInfoInUnloadedChunk(chunk, internalX, internalZ);
                    int min = 0;
                    int max = 255;
                    int range = max - min;
                    int distance = -min + highestBlockInfo.y;
                    float relativeDistance = (float)distance / (float)range;
                    int shadePercentage = (int)Math.floor(relativeDistance * 2.0f * 100.0f);
                    int rgbColor = MapCommand.shadeColor(highestBlockInfo.material.internalBlock().func_177230_c().func_235697_s_().field_76291_p, shadePercentage);
                    Object object = imgLock;
                    synchronized (object) {
                        this.img.setRGB(x, z, rgbColor);
                        continue;
                    }
                }
            }
        }

        private HighestBlockInfo getHighestBlockInfoInUnloadedChunk(ForgeChunkBuffer chunk, int internalX, int internalZ) {
            for (int y = chunk.getHighestBlockForColumn(internalX, internalZ); y >= 0; --y) {
                BlockState blockInChunk = chunk.getChunk().func_180495_p(new BlockPos(internalX, y, internalZ));
                if (blockInChunk == null || blockInChunk.func_177230_c() == Blocks.field_150350_a) continue;
                return new HighestBlockInfo(ForgeMaterialData.ofBlockState(blockInChunk), y);
            }
            return new HighestBlockInfo((ForgeMaterialData)LocalMaterials.AIR, 63);
        }
    }
}

