/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.commands;

import com.pg85.otg.OTG;
import com.pg85.otg.customobject.CustomObject;
import com.pg85.otg.customobject.bofunctions.BlockFunction;
import com.pg85.otg.customobject.creator.ObjectCreator;
import com.pg85.otg.customobject.creator.ObjectType;
import com.pg85.otg.customobject.structures.StructuredCustomObject;
import com.pg85.otg.customobject.util.BoundingBox;
import com.pg85.otg.customobject.util.Corner;
import com.pg85.otg.forge.commands.RegionCommand;
import com.pg85.otg.forge.gen.ForgeWorldGenRegion;
import com.pg85.otg.forge.gen.MCWorldGenRegion;
import com.pg85.otg.forge.gen.OTGNoiseChunkGenerator;
import com.pg85.otg.forge.util.ForgeNBTHelper;
import com.pg85.otg.presets.Preset;
import com.pg85.otg.util.bo3.Rotation;
import com.pg85.otg.util.gen.LocalWorldGenRegion;
import com.pg85.otg.util.materials.LocalMaterials;
import java.nio.file.Path;
import java.util.List;
import net.minecraft.command.CommandSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.server.ServerWorld;

public class ObjectUtils {
    public static Path getObjectFolderPath(Path presetFolder) {
        Path objectPath = presetFolder == null ? OTG.getEngine().getGlobalObjectsFolder() : presetFolder.resolve("Objects");
        if (!objectPath.toFile().exists() && objectPath.resolve("..").resolve("WorldObjects").toFile().exists()) {
            objectPath = objectPath.resolve("..").resolve("WorldObjects");
        }
        return objectPath;
    }

    public static Preset getPresetOrDefault(String presetName) {
        if (presetName == null) {
            return OTG.getEngine().getPresetLoader().getPresetByShortNameOrFolderName(OTG.getEngine().getPresetLoader().getDefaultPresetFolderName());
        }
        return OTG.getEngine().getPresetLoader().getPresetByShortNameOrFolderName(presetName);
    }

    public static String getFoldersFromObject(StructuredCustomObject object) {
        Path filePath = object.getConfig().getFile().toPath();
        Path parent = filePath.getParent();
        StringBuilder sb = new StringBuilder();
        while (!(parent.getFileName().toString().equalsIgnoreCase("WorldObjects") || parent.getFileName().toString().equalsIgnoreCase("Objects") || parent.getFileName().toString().equalsIgnoreCase("GlobalObjects"))) {
            sb.insert(0, "/");
            sb.insert(0, parent.getFileName());
            parent = parent.getParent();
        }
        return sb.toString();
    }

    public static void cleanArea(LocalWorldGenRegion region, Corner min, Corner max, boolean preparing) {
        for (int x1 = min.x - 1; x1 <= max.x + 1; ++x1) {
            for (int z1 = min.z - 1; z1 <= max.z + 1; ++z1) {
                for (int y1 = max.y + 1; y1 >= min.y - 1; --y1) {
                    if (preparing) {
                        region.setBlock(x1, y1, z1, LocalMaterials.STRUCTURE_VOID);
                        continue;
                    }
                    region.setBlock(x1, y1, z1, LocalMaterials.AIR);
                }
            }
        }
    }

    public static boolean isOutsideBounds(RegionCommand.Region region, ObjectType type) {
        Corner min = region.getMin();
        Corner max = region.getMax();
        int xlen = Math.abs(max.x - min.x);
        int zlen = Math.abs(max.z - min.z);
        switch (type) {
            case BO3: {
                return xlen > 31 || zlen > 31;
            }
            case BO4: {
                return xlen > 15 || zlen > 15;
            }
        }
        return false;
    }

    protected static RegionCommand.Region getRegionFromObject(BlockPos pos, StructuredCustomObject object) {
        RegionCommand.Region region = new RegionCommand.Region();
        BoundingBox box = object.getBoundingBox(Rotation.NORTH);
        pos = pos.func_177982_a(3, 0, 3);
        int lowestElevation = pos.func_177956_o() + box.getMinY();
        int highestElevation = pos.func_177956_o() + box.getMinY() + box.getHeight();
        int yshift = 0;
        if (lowestElevation <= 1) {
            yshift = -lowestElevation + 2;
        } else if (highestElevation >= 256) {
            yshift = highestElevation - 256;
        }
        Corner center = new Corner(pos.func_177958_n() + 2 + box.getWidth() / 2, pos.func_177956_o() + yshift, pos.func_177952_p() + 2 + box.getDepth() / 2);
        region.setPos(new BlockPos(center.x + box.getMinX(), lowestElevation + yshift, center.z + box.getMinZ()));
        region.setPos(new BlockPos(center.x + box.getMinX() + box.getWidth(), highestElevation + yshift, center.z + box.getMinZ() + box.getDepth()));
        region.setCenter(center);
        return region;
    }

    public static CustomObject getObject(String objectName, String presetFolderName) {
        if (presetFolderName == null) {
            presetFolderName = OTG.getEngine().getPresetLoader().getDefaultPresetFolderName();
        }
        return OTG.getEngine().getCustomObjectManager().getGlobalObjects().getObjectByName(objectName, presetFolderName, OTG.getEngine().getOTGRootFolder(), OTG.getEngine().getLogger(), OTG.getEngine().getCustomObjectManager(), OTG.getEngine().getPresetLoader().getMaterialReader(presetFolderName), OTG.getEngine().getCustomObjectResourcesManager(), OTG.getEngine().getModLoadedChecker());
    }

    protected static Runnable getExportRunnable(ObjectType type, RegionCommand.Region region, Corner center, StructuredCustomObject inputObject, Path exportPath, List<BlockFunction<?>> extraBlocks, String presetFolderName, boolean verbose, boolean leaveIllegalLeaves, CommandSource source, LocalWorldGenRegion worldGenRegion) {
        return () -> {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            StructuredCustomObject fixedObject = ObjectCreator.createObject(type, region.getMin(), region.getMax(), center, null, inputObject.getName(), false, leaveIllegalLeaves, exportPath, worldGenRegion, new ForgeNBTHelper(), extraBlocks, inputObject.getConfig(), presetFolderName, OTG.getEngine().getOTGRootFolder(), OTG.getEngine().getLogger(), OTG.getEngine().getCustomObjectManager(), OTG.getEngine().getPresetLoader().getMaterialReader(presetFolderName), OTG.getEngine().getCustomObjectResourcesManager(), OTG.getEngine().getModLoadedChecker());
            if (verbose && fixedObject != null) {
                source.func_197030_a((ITextComponent)new StringTextComponent("Successfully updated " + type.getType() + " " + inputObject.getName()), false);
                OTG.getEngine().getCustomObjectManager().getGlobalObjects().addObjectToPreset(presetFolderName, fixedObject.getName(), fixedObject.getConfig().getFile(), inputObject);
            } else if (verbose) {
                source.func_197030_a((ITextComponent)new StringTextComponent("Failed to update " + type.getType() + " " + inputObject.getName()), false);
            }
            ObjectUtils.cleanArea(worldGenRegion, region.getMin(), region.getMax(), false);
        };
    }

    protected static ForgeWorldGenRegion getWorldGenRegion(Preset preset, ServerWorld level) {
        if (level.func_72863_F().func_201711_g() instanceof OTGNoiseChunkGenerator) {
            return new ForgeWorldGenRegion(preset.getFolderName(), preset.getWorldConfig(), (ISeedReader)level, (OTGNoiseChunkGenerator)level.func_72863_F().func_201711_g());
        }
        return new MCWorldGenRegion(preset.getFolderName(), preset.getWorldConfig(), (ISeedReader)level);
    }
}

