/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.commands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.pg85.otg.forge.commands.BaseCommand;
import com.pg85.otg.forge.gen.OTGNoiseChunkGenerator;
import com.pg85.otg.presets.Preset;
import com.pg85.otg.util.materials.LocalMaterialData;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class PresetCommand
extends BaseCommand {
    public PresetCommand() {
        super("preset");
        this.helpMessage = "Displays information about the current world's preset.";
        this.usage = "/otg preset";
    }

    @Override
    public void build(LiteralArgumentBuilder<CommandSource> builder) {
        builder.then(Commands.func_197057_a((String)"preset").executes(context -> this.showPreset((CommandSource)context.getSource())));
    }

    private int showPreset(CommandSource source) {
        if (!(source.func_197023_e().func_72863_F().field_186029_c instanceof OTGNoiseChunkGenerator)) {
            source.func_197030_a((ITextComponent)new StringTextComponent("OTG is not enabled in this world"), false);
            return 0;
        }
        Preset preset = ((OTGNoiseChunkGenerator)source.func_197023_e().func_72863_F().field_186029_c).getPreset();
        source.func_197030_a((ITextComponent)new StringTextComponent("Preset: " + preset.getFolderName() + "\nDescription: " + preset.getDescription() + "\nMajor version: " + preset.getMajorVersion()), false);
        List portalBlocks = ((OTGNoiseChunkGenerator)source.func_197023_e().func_72863_F().field_186029_c).getPortalBlocks().stream().map(LocalMaterialData::getName).collect(Collectors.toList());
        if (!portalBlocks.isEmpty()) {
            source.func_197030_a((ITextComponent)new StringTextComponent("Portal Blocks: " + String.join((CharSequence)", ", portalBlocks)), false);
        }
        return 0;
    }
}

