/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.commands;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.pg85.otg.customobject.util.Corner;
import com.pg85.otg.forge.commands.BaseCommand;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class RegionCommand
extends BaseCommand {
    protected static HashMap<Entity, Region> playerSelectionMap = new HashMap();

    public RegionCommand() {
        super("region");
        this.helpMessage = "Allows for setting and modifying regions";
        this.usage = "Please see /otg help region.";
    }

    @Override
    public void build(LiteralArgumentBuilder<CommandSource> builder) {
        builder.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"region").then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"mark").executes(context -> this.mark((CommandSource)context.getSource()))).then(Commands.func_197056_a((String)"point", (ArgumentType)new RegionMarkerArgument()).executes(context -> this.mark((CommandSource)context.getSource(), (String)context.getArgument("point", String.class)))))).then(Commands.func_197057_a((String)"clear").executes(context -> this.clear((CommandSource)context.getSource())))).then(Commands.func_197057_a((String)"expand").then(Commands.func_197056_a((String)"direction", (ArgumentType)new DirectionArgument(true)).then(Commands.func_197056_a((String)"value", (ArgumentType)IntegerArgumentType.integer()).executes(context -> this.expand((CommandSource)context.getSource(), (String)context.getArgument("direction", String.class), (Integer)context.getArgument("value", Integer.class))))))).then(Commands.func_197057_a((String)"shrink").then(Commands.func_197056_a((String)"direction", (ArgumentType)new DirectionArgument(true)).then(Commands.func_197056_a((String)"value", (ArgumentType)IntegerArgumentType.integer()).executes(context -> this.shrink((CommandSource)context.getSource(), (String)context.getArgument("direction", String.class), (Integer)context.getArgument("value", Integer.class)))))));
    }

    public int mark(CommandSource source) {
        if (RegionCommand.checkForNonPlayer(source)) {
            return 0;
        }
        if (playerSelectionMap.get(source.func_197022_f()).setPos(source.func_197022_f().func_233580_cy_())) {
            source.func_197030_a((ITextComponent)new StringTextComponent("Point 1 marked"), false);
        } else {
            source.func_197030_a((ITextComponent)new StringTextComponent("Point 2 marked"), false);
        }
        return 0;
    }

    public int mark(CommandSource source, String input) {
        if (RegionCommand.checkForNonPlayer(source)) {
            return 0;
        }
        Region r = playerSelectionMap.get(source.func_197022_f());
        switch (input) {
            case "min": 
            case "pos1": 
            case "1": {
                r.setPos1(source.func_197022_f().func_233580_cy_());
                source.func_197030_a((ITextComponent)new StringTextComponent("Point 1 marked"), false);
                return 0;
            }
            case "max": 
            case "pos2": 
            case "2": {
                r.setPos2(source.func_197022_f().func_233580_cy_());
                source.func_197030_a((ITextComponent)new StringTextComponent("Point 2 marked"), false);
                return 0;
            }
            case "center": {
                r.setCenter(Region.cornerFromBlockPos(source.func_197022_f().func_233580_cy_()));
                source.func_197030_a((ITextComponent)new StringTextComponent("Center marked"), false);
                return 0;
            }
        }
        source.func_197030_a((ITextComponent)new StringTextComponent(input + " is not recognized"), false);
        return 0;
    }

    public int clear(CommandSource source) {
        if (RegionCommand.checkForNonPlayer(source)) {
            return 0;
        }
        playerSelectionMap.get(source.func_197022_f()).clear();
        source.func_197030_a((ITextComponent)new StringTextComponent("Position cleared"), false);
        return 0;
    }

    public int expand(CommandSource source, String direction, Integer value) {
        if (RegionCommand.checkForNonPlayer(source)) {
            return 0;
        }
        Region region = playerSelectionMap.get(source.func_197022_f());
        if (region.getMax() == null) {
            source.func_197030_a((ITextComponent)new StringTextComponent("Please mark two positions before modifying or exporting the region"), false);
            return 0;
        }
        switch (direction) {
            case "south": {
                if (region.pos2.func_177952_p() >= region.pos1.func_177952_p()) {
                    region.setPos2(region.pos2.func_177970_e(value.intValue()));
                    break;
                }
                region.setPos1(region.pos1.func_177970_e(value.intValue()));
                break;
            }
            case "north": {
                if (region.pos2.func_177952_p() < region.pos1.func_177952_p()) {
                    region.setPos2(region.pos2.func_177964_d(value.intValue()));
                    break;
                }
                region.setPos1(region.pos1.func_177964_d(value.intValue()));
                break;
            }
            case "east": {
                if (region.pos2.func_177958_n() >= region.pos1.func_177958_n()) {
                    region.setPos2(region.pos2.func_177965_g(value.intValue()));
                    break;
                }
                region.setPos1(region.pos1.func_177965_g(value.intValue()));
                break;
            }
            case "west": {
                if (region.pos2.func_177958_n() < region.pos1.func_177958_n()) {
                    region.setPos2(region.pos2.func_177985_f(value.intValue()));
                    break;
                }
                region.setPos1(region.pos1.func_177985_f(value.intValue()));
                break;
            }
            case "up": {
                if (region.pos2.func_177956_o() >= region.pos1.func_177956_o()) {
                    region.setPos2(region.pos2.func_177981_b(value.intValue()));
                    break;
                }
                region.setPos1(region.pos1.func_177981_b(value.intValue()));
                break;
            }
            case "down": {
                if (region.pos2.func_177956_o() < region.pos1.func_177956_o()) {
                    region.setPos2(region.pos2.func_177979_c(value.intValue()));
                    break;
                }
                region.setPos1(region.pos1.func_177979_c(value.intValue()));
                break;
            }
            default: {
                source.func_197030_a((ITextComponent)new StringTextComponent("Unrecognized direction " + direction), false);
                return 0;
            }
        }
        source.func_197030_a((ITextComponent)new StringTextComponent("Region modified"), false);
        return 0;
    }

    public int shrink(CommandSource source, String direction, Integer value) {
        if (RegionCommand.checkForNonPlayer(source)) {
            return 0;
        }
        this.expand(source, direction, -value.intValue());
        return 0;
    }

    private static boolean checkForNonPlayer(CommandSource source) {
        if (!(source.func_197022_f() instanceof ServerPlayerEntity)) {
            source.func_197030_a((ITextComponent)new StringTextComponent("Only players can execute this command"), false);
            return true;
        }
        if (!playerSelectionMap.containsKey(source.func_197022_f())) {
            playerSelectionMap.put(source.func_197022_f(), new Region());
        }
        return false;
    }

    private static class RegionMarkerArgument
    implements ArgumentType<String> {
        private final String[] options = new String[]{"1", "2", "center"};

        private RegionMarkerArgument() {
        }

        public String parse(StringReader reader) throws CommandSyntaxException {
            return reader.readString();
        }

        public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
            return ISuggestionProvider.func_197008_a((String[])this.options, (SuggestionsBuilder)builder);
        }
    }

    private static class DirectionArgument
    implements ArgumentType<String> {
        private final String[] options;

        public DirectionArgument(boolean vertical) {
            this.options = vertical ? new String[]{"north", "south", "east", "west", "up", "down"} : new String[]{"north", "south", "east", "west"};
        }

        public String parse(StringReader reader) throws CommandSyntaxException {
            return reader.readString();
        }

        public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
            return ISuggestionProvider.func_197008_a((String[])this.options, (SuggestionsBuilder)builder);
        }
    }

    public static class Region {
        private BlockPos pos1 = null;
        private BlockPos pos2 = null;
        private Corner center = null;
        private boolean flip = true;

        public boolean setPos(BlockPos blockPos) {
            if (this.flip) {
                this.pos1 = blockPos;
            } else {
                this.pos2 = blockPos;
            }
            this.flip = !this.flip;
            return !this.flip;
        }

        public static Corner cornerFromBlockPos(BlockPos blockPos) {
            return new Corner(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p());
        }

        public void clear() {
            this.pos1 = null;
            this.pos2 = null;
            this.center = null;
        }

        public Corner getMin() {
            if (this.pos1 == null || this.pos2 == null) {
                return null;
            }
            return new Corner(Math.min(this.pos1.func_177958_n(), this.pos2.func_177958_n()), Math.min(this.pos1.func_177956_o(), this.pos2.func_177956_o()), Math.min(this.pos1.func_177952_p(), this.pos2.func_177952_p()));
        }

        public Corner getMax() {
            if (this.pos1 == null || this.pos2 == null) {
                return null;
            }
            return new Corner(Math.max(this.pos1.func_177958_n(), this.pos2.func_177958_n()), Math.max(this.pos1.func_177956_o(), this.pos2.func_177956_o()), Math.max(this.pos1.func_177952_p(), this.pos2.func_177952_p()));
        }

        public void setPos1(BlockPos pos) {
            this.flip = false;
            this.pos1 = pos;
        }

        public void setPos2(BlockPos pos) {
            this.flip = true;
            this.pos2 = pos;
        }

        public Corner getCenter() {
            return this.center;
        }

        public void setCenter(Corner center) {
            this.center = center;
        }
    }
}

