/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.pg85.otg.OTG;
import com.pg85.otg.constants.SettingsEnums;
import com.pg85.otg.customobject.CustomObject;
import com.pg85.otg.customobject.bo4.BO4;
import com.pg85.otg.customobject.structures.CustomStructureCache;
import com.pg85.otg.forge.commands.BaseCommand;
import com.pg85.otg.forge.commands.ObjectUtils;
import com.pg85.otg.forge.commands.arguments.BiomeObjectArgument;
import com.pg85.otg.forge.commands.arguments.PresetArgument;
import com.pg85.otg.forge.gen.ForgeWorldGenRegion;
import com.pg85.otg.forge.gen.MCWorldGenRegion;
import com.pg85.otg.forge.gen.OTGNoiseChunkGenerator;
import com.pg85.otg.presets.Preset;
import com.pg85.otg.util.ChunkCoordinate;
import com.pg85.otg.util.bo3.Rotation;
import com.pg85.otg.util.logging.LogCategory;
import com.pg85.otg.util.logging.LogLevel;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Random;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.BlockPosArgument;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextComponentUtils;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.storage.FolderName;

public class SpawnCommand
extends BaseCommand {
    public SpawnCommand() {
        super("spawn");
        this.helpMessage = "Spawns a structure from a specific preset.";
        this.usage = "/otg spawn <preset> <object> [location] [force]";
        this.detailedHelp = new String[]{"<preset>: The name of the preset to look for the object in, or global to check GlobalObjects.", "<object>: The name of the object to spawn.", "[location]: The x, y, and z location to spawn the object at, defaults to your position.", "[force]: Whether to force the object to spawn regardless of conditions."};
    }

    @Override
    public void build(LiteralArgumentBuilder<CommandSource> builder) {
        builder.then(Commands.func_197057_a((String)"spawn").then(Commands.func_197056_a((String)"preset", (ArgumentType)StringArgumentType.string()).suggests((context, suggestionBuilder) -> PresetArgument.suggest((CommandContext<CommandSource>)context, suggestionBuilder, true)).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.func_197056_a((String)"object", (ArgumentType)StringArgumentType.word()).executes(context -> SpawnCommand.execute((CommandSource)context.getSource(), (String)context.getArgument("preset", String.class), (String)context.getArgument("object", String.class), Objects.requireNonNull(((CommandSource)context.getSource()).func_197022_f()).func_233580_cy_(), false))).suggests(BiomeObjectArgument::suggest).then(Commands.func_197056_a((String)"location", (ArgumentType)BlockPosArgument.func_197276_a()).executes(context -> SpawnCommand.execute((CommandSource)context.getSource(), (String)context.getArgument("preset", String.class), (String)context.getArgument("object", String.class), BlockPosArgument.func_197273_a((CommandContext)context, (String)"location"), false)))).then(Commands.func_197056_a((String)"force", (ArgumentType)BoolArgumentType.bool()).executes(context -> SpawnCommand.execute((CommandSource)context.getSource(), (String)context.getArgument("preset", String.class), (String)context.getArgument("object", String.class), Objects.requireNonNull(((CommandSource)context.getSource()).func_197022_f()).func_233580_cy_(), (Boolean)context.getArgument("force", Boolean.class)))))));
    }

    public static int execute(CommandSource source, String presetName, String objectName, BlockPos blockPos, boolean force) {
        try {
            presetName = presetName != null && presetName.equalsIgnoreCase("global") ? null : presetName;
            CustomObject objectToSpawn = ObjectUtils.getObject(objectName, presetName);
            if (objectToSpawn == null) {
                source.func_197030_a((ITextComponent)new StringTextComponent("Could not find an object by the name " + objectName + " in either " + presetName + " or Global objects"), false);
                return 0;
            }
            Preset preset = ObjectUtils.getPresetOrDefault(presetName);
            ForgeWorldGenRegion genRegion = source.func_197023_e().func_72863_F().func_201711_g() instanceof OTGNoiseChunkGenerator ? new ForgeWorldGenRegion(preset.getFolderName(), preset.getWorldConfig(), (ISeedReader)source.func_197023_e(), (OTGNoiseChunkGenerator)source.func_197023_e().func_72863_F().func_201711_g()) : new MCWorldGenRegion(preset.getFolderName(), preset.getWorldConfig(), (ISeedReader)source.func_197023_e());
            Path worldSaveFolder = source.func_197023_e().func_73046_m().func_240776_a_(FolderName.field_237247_c_).getParent();
            if (objectToSpawn instanceof BO4) {
                if (!(source.func_197023_e().func_72863_F().func_201711_g() instanceof OTGNoiseChunkGenerator)) {
                    source.func_197030_a((ITextComponent)new StringTextComponent("BO4 objects can only be spawned in OTG worlds/dimensions."), false);
                    return 0;
                }
                if (preset.getWorldConfig().getCustomStructureType() != SettingsEnums.CustomStructureType.BO4) {
                    source.func_197030_a((ITextComponent)new StringTextComponent("Cannot spawn a BO4 structure in an isOTGPlus:false world, use a BO3 instead or recreate the world with IsOTGPlus:true in the worldconfig."), false);
                    return 0;
                }
                int playerX = blockPos.func_177958_n();
                int playerZ = blockPos.func_177952_p();
                ChunkCoordinate playerChunk = ChunkCoordinate.fromBlockCoords(playerX, playerZ);
                if (((BO4)objectToSpawn).getName().matches(".*C[0-9]([0-9]*)R[0-9]([0-9]*)$")) {
                    int x = playerChunk.getBlockX() + ((BO4)objectToSpawn).getConfig().getminX();
                    int z = playerChunk.getBlockZ() + ((BO4)objectToSpawn).getConfig().getminZ();
                    ((BO4)objectToSpawn).trySpawnAt(preset.getFolderName(), OTG.getEngine().getOTGRootFolder(), OTG.getEngine().getLogger(), OTG.getEngine().getCustomObjectManager(), OTG.getEngine().getPresetLoader().getMaterialReader(preset.getFolderName()), OTG.getEngine().getCustomObjectResourcesManager(), null, genRegion, new Random(), Rotation.NORTH, playerChunk, x, genRegion.getHighestBlockAboveYAt(x, z), z, null, null, false, null, null, null, false, genRegion.getCachedBiomeProvider().getBiomeConfig(x, z).getWaterLevelMax(), false, false, false);
                    return 0;
                }
                CustomStructureCache cache = ((OTGNoiseChunkGenerator)source.func_197023_e().func_72863_F().func_201711_g()).getStructureCache(worldSaveFolder);
                int maxRadius = 1000;
                source.func_197030_a((ITextComponent)new StringTextComponent("Trying to plot BO4 structure within " + maxRadius + " chunks of player, with height bounds " + (force ? "disabled" : "enabled") + ". This may take a while."), false);
                for (int cycle = 1; cycle < maxRadius; ++cycle) {
                    for (int x1 = playerX - cycle; x1 <= playerX + cycle; ++x1) {
                        for (int z1 = playerZ - cycle; z1 <= playerZ + cycle; ++z1) {
                            ChunkCoordinate chunkCoordSpawned;
                            if (x1 != playerX - cycle && x1 != playerX + cycle && z1 != playerZ - cycle && z1 != playerZ + cycle) continue;
                            ChunkCoordinate chunkCoord = ChunkCoordinate.fromChunkCoords(playerChunk.getChunkX() + (x1 - playerX), playerChunk.getChunkZ() + (z1 - playerZ));
                            if (source.func_197023_e().func_217354_b(chunkCoord.getChunkX(), chunkCoord.getChunkZ()) && source.func_197023_e().func_212866_a_(chunkCoord.getChunkX(), chunkCoord.getChunkZ()).func_201589_g().func_209003_a(ChunkStatus.field_222613_i) || (chunkCoordSpawned = cache.plotBo4Structure(genRegion, (BO4)objectToSpawn, new ArrayList<String>(), chunkCoord, OTG.getEngine().getOTGRootFolder(), OTG.getEngine().getLogger(), OTG.getEngine().getCustomObjectManager(), OTG.getEngine().getPresetLoader().getMaterialReader(preset.getFolderName()), OTG.getEngine().getCustomObjectResourcesManager(), OTG.getEngine().getModLoadedChecker(), force)) == null) continue;
                            source.func_197030_a((ITextComponent)new StringTextComponent(objectToSpawn.getName() + " was spawned at: "), false);
                            IFormattableTextComponent itextcomponent = TextComponentUtils.func_240647_a_((ITextComponent)new TranslationTextComponent("chat.coordinates", new Object[]{chunkCoordSpawned.getBlockX(), "~", chunkCoordSpawned.getBlockZ()})).func_240700_a_(p_241055_1_ -> p_241055_1_.func_240712_a_(TextFormatting.GREEN).func_240715_a_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/tp @s " + chunkCoordSpawned.getBlockX() + " ~ " + chunkCoordSpawned.getBlockZ())).func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)new TranslationTextComponent("chat.coordinates.tooltip"))));
                            source.func_197030_a((ITextComponent)itextcomponent, false);
                            return 0;
                        }
                    }
                }
                source.func_197030_a((ITextComponent)new StringTextComponent(objectToSpawn.getName() + " could not be spawned. This can happen if the world is currently generating chunks, if no biomes with enough space could be found, or if there is an error in the structure's files. Enable SpawnLog:true in OTG.ini and check the logs for more information."), false);
                return 0;
            }
            if (objectToSpawn.spawnForced(null, genRegion, new Random(), Rotation.NORTH, blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p(), !(genRegion instanceof MCWorldGenRegion))) {
                source.func_197030_a((ITextComponent)new StringTextComponent(objectToSpawn.getName() + " was spawned at: "), false);
                IFormattableTextComponent itextcomponent = TextComponentUtils.func_240647_a_((ITextComponent)new TranslationTextComponent("chat.coordinates", new Object[]{blockPos.func_177958_n(), "~", blockPos.func_177952_p()})).func_240700_a_(p_241055_1_ -> p_241055_1_.func_240712_a_(TextFormatting.GREEN).func_240715_a_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/tp @s " + blockPos.func_177958_n() + " ~ " + blockPos.func_177952_p())).func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)new TranslationTextComponent("chat.coordinates.tooltip"))));
                source.func_197030_a((ITextComponent)itextcomponent, false);
            } else {
                source.func_197030_a((ITextComponent)new StringTextComponent("Failed to spawn object " + objectName), false);
            }
        }
        catch (Exception e) {
            source.func_197030_a((ITextComponent)new StringTextComponent("Something went wrong, please check logs"), false);
            OTG.getEngine().getLogger().log(LogLevel.ERROR, LogCategory.MAIN, "Error during spawn command: ");
            OTG.getEngine().getLogger().log(LogLevel.ERROR, LogCategory.MAIN, String.format("Error during spawn command: ", e.getStackTrace()));
            e.printStackTrace();
        }
        return 0;
    }
}

