/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.pg85.otg.forge.commands.BaseCommand;
import com.pg85.otg.forge.gen.OTGNoiseChunkGenerator;
import com.pg85.otg.presets.Preset;
import com.pg85.otg.util.biome.OTGBiomeResourceLocation;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;

public class TpCommand
extends BaseCommand {
    private static final DynamicCommandExceptionType ERROR_BIOME_NOT_FOUND = new DynamicCommandExceptionType(object -> new TranslationTextComponent("commands.locatebiome.notFound", new Object[]{object}));

    public TpCommand() {
        super("tp");
        this.helpMessage = "Teleports you to a specific OTG biome.";
        this.usage = "/otg tp <biome> [range]";
        this.detailedHelp = new String[]{"<biome>: The name of the biome to teleport to.", "[range]: The radius in blocks to search for the target biome, defaults to 10000.", "Note: large numbers will make the command take a long time."};
    }

    @Override
    public void build(LiteralArgumentBuilder<CommandSource> builder) {
        builder.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"tp").executes(context -> this.showHelp((CommandSource)context.getSource()))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"biome", (ArgumentType)StringArgumentType.word()).executes(context -> this.locateBiome((CommandSource)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"biome"), 10000))).suggests(this::suggestBiomes).then(Commands.func_197056_a((String)"range", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> this.locateBiome((CommandSource)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"biome"), IntegerArgumentType.getInteger((CommandContext)context, (String)"range"))))));
    }

    private int locateBiome(CommandSource source, String biome, int range) throws CommandSyntaxException {
        biome = biome.toLowerCase();
        ServerWorld world = source.func_197023_e();
        if (!(world.func_72863_F().field_186029_c instanceof OTGNoiseChunkGenerator)) {
            source.func_197030_a((ITextComponent)new StringTextComponent("OTG is not enabled in this world"), false);
            return 0;
        }
        Preset preset = ((OTGNoiseChunkGenerator)world.func_72863_F().field_186029_c).getPreset();
        ResourceLocation key = new ResourceLocation(new OTGBiomeResourceLocation(preset.getPresetFolder(), preset.getShortPresetName(), preset.getMajorVersion(), biome).toResourceLocationString());
        BlockPos pos = world.func_241116_a_((Biome)world.func_241828_r().func_243612_b(Registry.field_239720_u_).func_82594_a(key), new BlockPos(source.func_197036_d()), range, 8);
        if (pos == null) {
            throw ERROR_BIOME_NOT_FOUND.create((Object)biome);
        }
        int y = world.func_72863_F().field_186029_c.func_222529_a(pos.func_177958_n(), pos.func_177952_p(), Heightmap.Type.MOTION_BLOCKING_NO_LEAVES);
        source.func_197035_h().func_70634_a((double)pos.func_177958_n(), (double)y, (double)pos.func_177952_p());
        source.func_197030_a((ITextComponent)new StringTextComponent("Teleporting you to the nearest " + biome + "."), false);
        return 0;
    }

    private CompletableFuture<Suggestions> suggestBiomes(CommandContext<CommandSource> context, SuggestionsBuilder builder) {
        List<Object> biomes = new ArrayList();
        if (((CommandSource)context.getSource()).func_197023_e().func_72863_F().field_186029_c instanceof OTGNoiseChunkGenerator) {
            biomes = ((OTGNoiseChunkGenerator)((CommandSource)context.getSource()).func_197023_e().func_72863_F().field_186029_c).getPreset().getAllBiomeNames().stream().map(name -> name.replace(' ', '_')).collect(Collectors.toList());
        }
        return ISuggestionProvider.func_197005_b(biomes, (SuggestionsBuilder)builder);
    }

    private int showHelp(CommandSource source) {
        source.func_197030_a((ITextComponent)new StringTextComponent(this.getUsage()), false);
        return 0;
    }
}

