/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.pg85.otg.OTG;
import com.pg85.otg.customobject.bofunctions.BlockFunction;
import com.pg85.otg.customobject.creator.ObjectType;
import com.pg85.otg.customobject.structures.StructuredCustomObject;
import com.pg85.otg.customobject.util.Corner;
import com.pg85.otg.exceptions.InvalidConfigException;
import com.pg85.otg.forge.commands.BaseCommand;
import com.pg85.otg.forge.commands.EditCommand;
import com.pg85.otg.forge.commands.ObjectUtils;
import com.pg85.otg.forge.commands.RegionCommand;
import com.pg85.otg.forge.commands.arguments.FlagsArgument;
import com.pg85.otg.forge.commands.arguments.PresetArgument;
import com.pg85.otg.forge.gen.ForgeWorldGenRegion;
import com.pg85.otg.presets.Preset;
import com.pg85.otg.util.logging.LogCategory;
import com.pg85.otg.util.logging.LogLevel;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;

public class UpdateCommand
extends BaseCommand {
    private static final String[] FLAGS = new String[]{"-wrongleaves"};

    public UpdateCommand() {
        super("update");
        this.helpMessage = "Updates all the objects in a preset and places them in a folder";
        this.usage = "/otg update <preset>.";
    }

    @Override
    public void build(LiteralArgumentBuilder<CommandSource> builder) {
        builder.then(Commands.func_197057_a((String)"update").then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"preset", (ArgumentType)StringArgumentType.string()).suggests((context, suggestionBuilder) -> PresetArgument.suggest((CommandContext<CommandSource>)context, suggestionBuilder, false)).executes(this::update)).then((ArgumentBuilder)((RequiredArgumentBuilder)Commands.func_197056_a((String)"flags", (ArgumentType)FlagsArgument.create()).executes(this::update)).suggests(this::suggestFlags))));
    }

    private int update(CommandContext<CommandSource> context) {
        String presetFolderName = (String)context.getArgument("preset", String.class);
        Preset preset = OTG.getEngine().getPresetLoader().getPresetByFolderName(presetFolderName);
        CommandSource source = (CommandSource)context.getSource();
        boolean tempLeavesFlag = false;
        try {
            String flags = (String)context.getArgument("flags", String.class);
            tempLeavesFlag = flags.contains("-wrongleaves");
        }
        catch (IllegalArgumentException flags) {
            // empty catch block
        }
        boolean leaveIllegalLeaves = tempLeavesFlag;
        if (preset == null) {
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Could not find preset '" + presetFolderName + "'"), false);
            return 0;
        }
        ArrayList<String> objectNameList = OTG.getEngine().getCustomObjectManager().getGlobalObjects().getAllBONamesForPreset(presetFolderName, OTG.getEngine().getLogger(), OTG.getEngine().getOTGRootFolder());
        Path fixedObjectFolderPath = preset.getPresetFolder().resolve("Updated Objects");
        fixedObjectFolderPath.toFile().mkdirs();
        ForgeWorldGenRegion worldGenRegion = ObjectUtils.getWorldGenRegion(preset, source.func_197023_e());
        BlockPos pos = source.func_197022_f().func_233580_cy_();
        Runnable updateIteration = () -> {
            String objectName = (String)objectNameList.remove(0);
            StructuredCustomObject inputObject = null;
            try {
                inputObject = EditCommand.getStructuredObject(objectName, presetFolderName);
            }
            catch (InvalidConfigException e) {
                OTG.getEngine().getLogger().log(LogLevel.ERROR, LogCategory.MAIN, "Failed to load object " + objectName);
                return;
            }
            if (inputObject == null) {
                source.func_197030_a((ITextComponent)new StringTextComponent("Could not find " + objectName), false);
                return;
            }
            ObjectType type = inputObject.getType();
            RegionCommand.Region region = ObjectUtils.getRegionFromObject(pos, inputObject);
            Corner center = region.getCenter();
            ObjectUtils.cleanArea(worldGenRegion, region.getMin(), region.getMax(), true);
            ArrayList<BlockFunction<?>> extraBlocks = EditCommand.spawnAndFixObject(center.x, center.y, center.z, inputObject, worldGenRegion, true, presetFolderName, OTG.getEngine().getOTGRootFolder(), OTG.getEngine().getLogger(), OTG.getEngine().getCustomObjectManager(), OTG.getEngine().getPresetLoader().getMaterialReader(presetFolderName), OTG.getEngine().getCustomObjectResourcesManager(), OTG.getEngine().getModLoadedChecker());
            Thread t = new Thread(ObjectUtils.getExportRunnable(type, region, center, inputObject, fixedObjectFolderPath.resolve(ObjectUtils.getFoldersFromObject(inputObject)), extraBlocks, presetFolderName, false, leaveIllegalLeaves, source, worldGenRegion));
            t.start();
            try {
                t.join();
            }
            catch (InterruptedException e) {
                OTG.getEngine().getLogger().printStackTrace(LogLevel.ERROR, LogCategory.MAIN, e);
            }
        };
        new Thread(() -> {
            int totalLength = objectNameList.size();
            int count = 0;
            int interval = totalLength < 100 ? 20 : totalLength / 7;
            source.func_197030_a((ITextComponent)new StringTextComponent("Starting object updating! Please don't move away from the immediate area").func_240699_a_(TextFormatting.GREEN), false);
            while (!objectNameList.isEmpty()) {
                updateIteration.run();
                if (++count % interval != 0) continue;
                source.func_197030_a((ITextComponent)new StringTextComponent("Progress: Finished " + count + " of " + totalLength + " objects").func_240699_a_(TextFormatting.BLUE), false);
            }
            source.func_197030_a((ITextComponent)new StringTextComponent("Finished updating!").func_240699_a_(TextFormatting.GREEN), false);
        }).start();
        return 0;
    }

    CompletableFuture<Suggestions> suggestFlags(CommandContext<CommandSource> context, SuggestionsBuilder builder) {
        return ISuggestionProvider.func_197008_a((String[])FLAGS, (SuggestionsBuilder)builder);
    }
}

