/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.dimensions;

import com.google.gson.JsonObject;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import com.pg85.otg.OTG;
import com.pg85.otg.config.dimensions.DimensionConfig;
import com.pg85.otg.forge.biome.OTGBiomeProvider;
import com.pg85.otg.forge.gen.OTGNoiseChunkGenerator;
import com.pg85.otg.interfaces.IWorldConfig;
import com.pg85.otg.presets.Preset;
import com.pg85.otg.util.logging.LogCategory;
import com.pg85.otg.util.logging.LogLevel;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.SimpleRegistry;
import net.minecraft.world.Dimension;
import net.minecraft.world.DimensionType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.ColumnFuzzedBiomeMagnifier;
import net.minecraft.world.biome.IBiomeMagnifier;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.biome.provider.OverworldBiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.DebugChunkGenerator;
import net.minecraft.world.gen.DimensionSettings;
import net.minecraft.world.gen.FlatChunkGenerator;
import net.minecraft.world.gen.FlatGenerationSettings;
import net.minecraft.world.gen.NoiseChunkGenerator;
import net.minecraft.world.gen.settings.DimensionGeneratorSettings;
import net.minecraftforge.common.world.ForgeWorldType;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OTGDimensionType
extends DimensionType {
    public OTGDimensionType(OptionalLong fixedTime, boolean hasSkylight, boolean hasCeiling, boolean ultraWarm, boolean natural, double coordinateScale, boolean createDragonFight, boolean piglinSafe, boolean bedWorks, boolean respawnAnchorWorks, boolean hasRaids, int logicalHeight, IBiomeMagnifier biomeZoomer, ResourceLocation infiniburn, ResourceLocation effectsLocation, float ambientLight) {
        super(fixedTime, hasSkylight, hasCeiling, ultraWarm, natural, coordinateScale, createDragonFight, piglinSafe, bedWorks, respawnAnchorWorks, hasRaids, logicalHeight, biomeZoomer, infiniburn, effectsLocation, ambientLight);
    }

    public static DimensionGeneratorSettings createOTGSettings(DynamicRegistries dynamicRegistries, long seed, boolean generateStructures, boolean bonusChest, String generatorSettings) {
        MutableRegistry dimensionTypesRegistry = dynamicRegistries.func_243612_b(Registry.field_239698_ad_);
        MutableRegistry biomesRegistry = dynamicRegistries.func_243612_b(Registry.field_239720_u_);
        MutableRegistry dimensionSettingsRegistry = dynamicRegistries.func_243612_b(Registry.field_243549_ar);
        DimensionConfig dimConfig = DimensionConfig.fromDisk(generatorSettings);
        SimpleRegistry dimensions = null;
        Preset preset = null;
        String dimConfigName = null;
        if (dimConfig == null) {
            preset = OTG.getEngine().getPresetLoader().getPresetByShortNameOrFolderName(generatorSettings);
            if (preset == null) {
                OTG.getEngine().getLogger().log(LogLevel.FATAL, LogCategory.MAIN, "DimensionConfig or preset name \"" + generatorSettings + "\", provided as generator-settings in server.properties, does not exist.");
                throw new RuntimeException("DimensionConfig or preset name \"" + generatorSettings + "\", provided as generator-settings in server.properties, does not exist.");
            }
            dimConfig = new DimensionConfig();
            dimConfig.Overworld = new DimensionConfig.OTGOverWorld(preset.getFolderName(), seed, null, null);
            dimensions = DimensionType.func_242718_a((Registry)dimensionTypesRegistry, (Registry)biomesRegistry, (Registry)dimensionSettingsRegistry, (long)seed);
        } else {
            ForgeWorldType def;
            dimConfigName = generatorSettings;
            ForgeWorldType forgeWorldType = def = dimConfig.Overworld.NonOTGWorldType == null || dimConfig.Overworld.NonOTGWorldType.trim().length() == 0 ? null : (ForgeWorldType)ForgeRegistries.WORLD_TYPES.getValue(new ResourceLocation(dimConfig.Overworld.NonOTGWorldType));
            if (def != null) {
                DimensionGeneratorSettings existingDimSetting = def.createSettings(dynamicRegistries, seed, generateStructures, bonusChest, dimConfig.Overworld.NonOTGGeneratorSettings);
                dimensions = existingDimSetting.func_236224_e_();
            } else {
                MutableRegistry registry2 = dynamicRegistries.func_243612_b(Registry.field_239698_ad_);
                MutableRegistry registry = dynamicRegistries.func_243612_b(Registry.field_239720_u_);
                MutableRegistry registry1 = dynamicRegistries.func_243612_b(Registry.field_243549_ar);
                SimpleRegistry simpleregistry = DimensionType.func_242718_a((Registry)registry2, (Registry)registry, (Registry)registry1, (long)seed);
                DimensionGeneratorSettings existingDimSetting = null;
                switch (dimConfig.Overworld.NonOTGWorldType == null ? "" : dimConfig.Overworld.NonOTGWorldType) {
                    case "flat": {
                        JsonObject jsonobject = dimConfig.Overworld.NonOTGGeneratorSettings != null && !dimConfig.Overworld.NonOTGGeneratorSettings.isEmpty() ? JSONUtils.func_212745_a((String)dimConfig.Overworld.NonOTGGeneratorSettings) : new JsonObject();
                        Dynamic dynamic = new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)jsonobject);
                        existingDimSetting = new DimensionGeneratorSettings(seed, generateStructures, bonusChest, DimensionGeneratorSettings.func_242749_a((Registry)registry2, (SimpleRegistry)simpleregistry, (ChunkGenerator)new FlatChunkGenerator(FlatGenerationSettings.field_236932_a_.parse(dynamic).resultOrPartial(arg_0 -> ((Logger)LogManager.getLogger()).error(arg_0)).orElseGet(() -> OTGDimensionType.lambda$createOTGSettings$0((Registry)registry)))));
                        break;
                    }
                    case "debug_all_block_states": {
                        existingDimSetting = new DimensionGeneratorSettings(seed, generateStructures, bonusChest, DimensionGeneratorSettings.func_242749_a((Registry)registry2, (SimpleRegistry)simpleregistry, (ChunkGenerator)new DebugChunkGenerator((Registry)registry)));
                        break;
                    }
                    case "amplified": {
                        existingDimSetting = new DimensionGeneratorSettings(seed, generateStructures, bonusChest, DimensionGeneratorSettings.func_242749_a((Registry)registry2, (SimpleRegistry)simpleregistry, (ChunkGenerator)new NoiseChunkGenerator((BiomeProvider)new OverworldBiomeProvider(seed, false, false, (Registry)registry), seed, () -> OTGDimensionType.lambda$createOTGSettings$1((Registry)registry1))));
                        break;
                    }
                    case "largebiomes": {
                        existingDimSetting = new DimensionGeneratorSettings(seed, generateStructures, bonusChest, DimensionGeneratorSettings.func_242749_a((Registry)registry2, (SimpleRegistry)simpleregistry, (ChunkGenerator)new NoiseChunkGenerator((BiomeProvider)new OverworldBiomeProvider(seed, false, true, (Registry)registry), seed, () -> OTGDimensionType.lambda$createOTGSettings$2((Registry)registry1))));
                        break;
                    }
                    default: {
                        existingDimSetting = new DimensionGeneratorSettings(seed, generateStructures, bonusChest, DimensionGeneratorSettings.func_242749_a((Registry)registry2, (SimpleRegistry)simpleregistry, (ChunkGenerator)DimensionGeneratorSettings.func_242750_a((Registry)registry, (Registry)registry1, (long)seed)));
                    }
                }
                dimensions = existingDimSetting.func_236224_e_();
            }
        }
        return OTGDimensionType.createOTGDimensionGeneratorSettings(dimConfigName, dimConfig, (MutableRegistry<DimensionType>)dimensionTypesRegistry, (Registry<Biome>)biomesRegistry, (Registry<DimensionSettings>)dimensionSettingsRegistry, seed, generateStructures, bonusChest, (SimpleRegistry<Dimension>)dimensions);
    }

    public static DimensionGeneratorSettings createOTGDimensionGeneratorSettings(String dimConfigName, DimensionConfig dimConfig, MutableRegistry<DimensionType> dimensionTypesRegistry, Registry<Biome> biomesRegistry, Registry<DimensionSettings> dimensionSettingsRegistry, long seed, boolean generateFeatures, boolean generateBonusChest, SimpleRegistry<Dimension> defaultDimensions) {
        OTGNoiseChunkGenerator chunkGenerator;
        boolean nonOTGOverWorld;
        SimpleRegistry dimensions = new SimpleRegistry(Registry.field_239700_af_, Lifecycle.experimental());
        boolean bl = nonOTGOverWorld = dimConfig.Overworld.PresetFolderName == null;
        if (dimConfig.Overworld != null && dimConfig.Overworld.PresetFolderName != null && !nonOTGOverWorld) {
            OTGNoiseChunkGenerator chunkGenerator2 = new OTGNoiseChunkGenerator(dimConfig.Overworld.PresetFolderName, dimConfigName, new OTGBiomeProvider(dimConfig.Overworld.PresetFolderName, seed, false, false, biomesRegistry), seed, () -> (DimensionSettings)dimensionSettingsRegistry.func_243576_d(DimensionSettings.field_242734_c));
            OTGDimensionType.addDimension(dimConfig.Overworld.PresetFolderName, (SimpleRegistry<Dimension>)dimensions, dimensionTypesRegistry, (RegistryKey<Dimension>)Dimension.field_236053_b_, (ChunkGenerator)chunkGenerator2, (RegistryKey<DimensionType>)DimensionType.field_235999_c_);
        }
        if (dimConfig.Nether != null && dimConfig.Nether.PresetFolderName != null) {
            long dimSeed = dimConfig.Nether.Seed != -1L ? dimConfig.Nether.Seed : new Random().nextLong();
            chunkGenerator = new OTGNoiseChunkGenerator(dimConfig.Nether.PresetFolderName, dimConfigName, new OTGBiomeProvider(dimConfig.Nether.PresetFolderName, dimSeed, false, false, biomesRegistry), dimSeed, () -> (DimensionSettings)dimensionSettingsRegistry.func_243576_d(DimensionSettings.field_242736_e));
            OTGDimensionType.addDimension(dimConfig.Nether.PresetFolderName, (SimpleRegistry<Dimension>)dimensions, dimensionTypesRegistry, (RegistryKey<Dimension>)Dimension.field_236054_c_, (ChunkGenerator)chunkGenerator, (RegistryKey<DimensionType>)DimensionType.field_236000_d_);
        }
        if (dimConfig.End != null && dimConfig.End.PresetFolderName != null) {
            long dimSeed = dimConfig.End.Seed != -1L ? dimConfig.End.Seed : new Random().nextLong();
            chunkGenerator = new OTGNoiseChunkGenerator(dimConfig.End.PresetFolderName, dimConfigName, new OTGBiomeProvider(dimConfig.End.PresetFolderName, dimSeed, false, false, biomesRegistry), dimSeed, () -> (DimensionSettings)dimensionSettingsRegistry.func_243576_d(DimensionSettings.field_242737_f));
            OTGDimensionType.addDimension(dimConfig.End.PresetFolderName, (SimpleRegistry<Dimension>)dimensions, dimensionTypesRegistry, (RegistryKey<Dimension>)Dimension.field_236055_d_, (ChunkGenerator)chunkGenerator, (RegistryKey<DimensionType>)DimensionType.field_236001_e_);
        }
        if (dimConfig.Dimensions != null) {
            for (DimensionConfig.OTGDimension otgDim : dimConfig.Dimensions) {
                if (otgDim.PresetFolderName == null) continue;
                long dimSeed = otgDim.Seed != -1L ? otgDim.Seed : new Random().nextLong();
                OTGNoiseChunkGenerator chunkGenerator3 = new OTGNoiseChunkGenerator(otgDim.PresetFolderName, dimConfigName, new OTGBiomeProvider(otgDim.PresetFolderName, dimSeed, false, false, biomesRegistry), dimSeed, () -> (DimensionSettings)dimensionSettingsRegistry.func_243576_d(DimensionSettings.field_242734_c));
                RegistryKey dimRegistryKey = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239700_af_, (ResourceLocation)new ResourceLocation("otg", otgDim.PresetFolderName.trim().replace(" ", "_").toLowerCase()));
                RegistryKey dimTypeRegistryKey = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239698_ad_, (ResourceLocation)new ResourceLocation("otg", otgDim.PresetFolderName.trim().replace(" ", "_").toLowerCase()));
                OTGDimensionType.addDimension(otgDim.PresetFolderName, (SimpleRegistry<Dimension>)dimensions, dimensionTypesRegistry, (RegistryKey<Dimension>)dimRegistryKey, (ChunkGenerator)chunkGenerator3, (RegistryKey<DimensionType>)dimTypeRegistryKey);
            }
        }
        for (Map.Entry entry : defaultDimensions.func_239659_c_()) {
            RegistryKey registrykey = (RegistryKey)entry.getKey();
            if (dimConfig.Overworld != null && dimConfig.Overworld.PresetFolderName != null && registrykey == Dimension.field_236053_b_ || dimConfig.Nether != null && dimConfig.Nether.PresetFolderName != null && registrykey == Dimension.field_236054_c_ || dimConfig.End != null && dimConfig.End.PresetFolderName != null && registrykey == Dimension.field_236055_d_) continue;
            dimensions.func_218381_a(registrykey, entry.getValue(), defaultDimensions.func_241876_d(entry.getValue()));
        }
        return new DimensionGeneratorSettings(seed, generateFeatures, generateBonusChest, dimensions);
    }

    private static void addDimension(String presetFolderName, SimpleRegistry<Dimension> dimensions, MutableRegistry<DimensionType> dimensionTypeRegistry, RegistryKey<Dimension> dimRegistryKey, ChunkGenerator chunkGenerator, RegistryKey<DimensionType> dimTypeRegistryKey) {
        Preset preset = OTG.getEngine().getPresetLoader().getPresetByFolderName(presetFolderName);
        IWorldConfig worldConfig = preset.getWorldConfig();
        DimensionType otgOverWorld = new DimensionType(worldConfig.getFixedTime(), worldConfig.getHasSkyLight(), worldConfig.getHasCeiling(), worldConfig.getUltraWarm(), worldConfig.getNatural(), worldConfig.getCoordinateScale(), worldConfig.getCreateDragonFight(), worldConfig.getPiglinSafe(), worldConfig.getBedWorks(), worldConfig.getRespawnAnchorWorks(), worldConfig.getHasRaids(), worldConfig.getLogicalHeight(), (IBiomeMagnifier)ColumnFuzzedBiomeMagnifier.INSTANCE, new ResourceLocation(worldConfig.getInfiniburn()), new ResourceLocation(worldConfig.getEffectsLocation()), worldConfig.getAmbientLight());
        dimensionTypeRegistry.func_241874_a(OptionalInt.empty(), dimTypeRegistryKey, (Object)otgOverWorld, Lifecycle.stable());
        Dimension dimension = (Dimension)dimensions.func_230516_a_(dimRegistryKey);
        Supplier<DimensionType> supplier = () -> dimension == null ? (DimensionType)dimensionTypeRegistry.func_243576_d(dimTypeRegistryKey) : dimension.func_236063_b_();
        dimensions.func_218381_a(dimRegistryKey, (Object)new Dimension(supplier, chunkGenerator), Lifecycle.stable());
    }

    public static void saveDataPackFile(Path datapackFolder, String dimName, IWorldConfig worldConfig, String presetFolderName) {
        byte[] bytes2;
        Throwable throwable;
        BufferedOutputStream bos2;
        Throwable throwable2;
        FileOutputStream fos;
        String data;
        File folder = new File(datapackFolder + File.separator + "otg" + File.separator);
        File file = new File(datapackFolder + File.separator + "otg" + File.separator + "pack.mcmeta");
        if (!folder.exists()) {
            folder.mkdirs();
        }
        if (!file.exists()) {
            data = "{ \"pack\": { \"pack_format\":6, \"description\":\"OTG Dimension settings\" } }";
            try {
                fos = new FileOutputStream(file);
                throwable2 = null;
                try {
                    bos2 = new BufferedOutputStream(fos);
                    throwable = null;
                    try {
                        bytes2 = data.getBytes();
                        bos2.write(bytes2);
                        bos2.close();
                        fos.close();
                    }
                    catch (Throwable bytes2) {
                        throwable = bytes2;
                        throw bytes2;
                    }
                    finally {
                        if (bos2 != null) {
                            if (throwable != null) {
                                try {
                                    bos2.close();
                                }
                                catch (Throwable bytes2) {
                                    throwable.addSuppressed(bytes2);
                                }
                            } else {
                                bos2.close();
                            }
                        }
                    }
                }
                catch (Throwable bos2) {
                    throwable2 = bos2;
                    throw bos2;
                }
                finally {
                    if (fos != null) {
                        if (throwable2 != null) {
                            try {
                                fos.close();
                            }
                            catch (Throwable bos2) {
                                throwable2.addSuppressed(bos2);
                            }
                        } else {
                            fos.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (dimName.equals("overworld") || dimName.equals("the_end") || dimName.equals("the_nether")) {
            folder = new File(datapackFolder + File.separator + "otg" + File.separator + "data" + File.separator + "minecraft" + File.separator + "dimension_type" + File.separator);
            file = new File(datapackFolder + File.separator + "otg" + File.separator + "data" + File.separator + "minecraft" + File.separator + "dimension_type" + File.separator + dimName + ".json");
        } else {
            folder = new File(datapackFolder + File.separator + "otg" + File.separator + "data" + File.separator + "otg" + File.separator + "dimension_type" + File.separator);
            file = new File(datapackFolder + File.separator + "otg" + File.separator + "data" + File.separator + "otg" + File.separator + "dimension_type" + File.separator + dimName + ".json");
        }
        if (!folder.exists()) {
            folder.mkdirs();
        }
        data = "{ \"ultrawarm\": " + worldConfig.getUltraWarm() + ", \"infiniburn\": \"" + worldConfig.getInfiniburn() + "\", \"logical_height\": " + worldConfig.getLogicalHeight() + ", \"has_raids\": " + worldConfig.getHasRaids() + ", \"respawn_anchor_works\": " + worldConfig.getRespawnAnchorWorks() + ", \"bed_works\": " + worldConfig.getBedWorks() + ", \"piglin_safe\": " + worldConfig.getPiglinSafe() + ", \"natural\": " + worldConfig.getNatural() + ", \"coordinate_scale\": " + worldConfig.getCoordinateScale() + ", \"ambient_light\": " + worldConfig.getAmbientLight() + ", \"has_skylight\": " + worldConfig.getHasSkyLight() + ", \"has_ceiling\": " + worldConfig.getHasCeiling() + ", \"effects\": \"" + worldConfig.getEffectsLocation() + "\"" + (worldConfig.getFixedTime().isPresent() ? ", \"fixed_time\": " + worldConfig.getFixedTime().getAsLong() : "") + " }";
        try {
            fos = new FileOutputStream(file);
            throwable2 = null;
            try {
                bos2 = new BufferedOutputStream(fos);
                throwable = null;
                try {
                    bytes2 = data.getBytes();
                    bos2.write(bytes2);
                    bos2.close();
                    fos.close();
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                finally {
                    if (bos2 != null) {
                        if (throwable != null) {
                            try {
                                bos2.close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                        } else {
                            bos2.close();
                        }
                    }
                }
            }
            catch (Throwable throwable5) {
                throwable2 = throwable5;
                throw throwable5;
            }
            finally {
                if (fos != null) {
                    if (throwable2 != null) {
                        try {
                            fos.close();
                        }
                        catch (Throwable throwable6) {
                            throwable2.addSuppressed(throwable6);
                        }
                    } else {
                        fos.close();
                    }
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static /* synthetic */ DimensionSettings lambda$createOTGSettings$2(Registry registry1) {
        return (DimensionSettings)registry1.func_243576_d(DimensionSettings.field_242734_c);
    }

    private static /* synthetic */ DimensionSettings lambda$createOTGSettings$1(Registry registry1) {
        return (DimensionSettings)registry1.func_243576_d(DimensionSettings.field_242735_d);
    }

    private static /* synthetic */ FlatGenerationSettings lambda$createOTGSettings$0(Registry registry) {
        return FlatGenerationSettings.func_242869_a((Registry)registry);
    }
}

