/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.dimensions.portals;

import com.pg85.otg.forge.dimensions.portals.OTGCapabilities;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;

public class OTGPlayer {
    private final PlayerEntity player;
    private boolean isInOtgPortal = false;
    private String portalColor;
    private int otgPortalTime = 0;
    private float portalAnimTime = 0.0f;

    public OTGPlayer(PlayerEntity player) {
        this.player = player;
    }

    public static LazyOptional<OTGPlayer> get(PlayerEntity player) {
        return player.getCapability(OTGCapabilities.OTG_PLAYER_CAPABILITY);
    }

    public PlayerEntity getPlayer() {
        return this.player;
    }

    public void onUpdate() {
        this.handleOTGPortal();
    }

    private void handleOTGPortal() {
        if (this.player.field_70170_p.field_72995_K) {
            Minecraft mc = Minecraft.func_71410_x();
            if (this.isInOtgPortal) {
                if (mc.field_71462_r != null && !mc.field_71462_r.func_231177_au__()) {
                    if (mc.field_71462_r instanceof ContainerScreen) {
                        this.player.func_71053_j();
                    }
                    mc.func_147108_a(null);
                }
                if (this.portalAnimTime == 0.0f) {
                    this.playPortalSound(mc);
                }
            }
        }
        if (this.isInOtgPortal) {
            ++this.otgPortalTime;
            if (this.player.field_70170_p.field_72995_K) {
                this.portalAnimTime += 0.0125f;
                if (this.portalAnimTime > 1.0f) {
                    this.portalAnimTime = 1.0f;
                }
            }
            this.isInOtgPortal = false;
            this.portalColor = null;
        } else {
            if (this.player.field_70170_p.field_72995_K) {
                if (this.portalAnimTime > 0.0f) {
                    this.portalAnimTime -= 0.05f;
                }
                if (this.portalAnimTime < 0.0f) {
                    this.portalAnimTime = 0.0f;
                }
            }
            if (this.otgPortalTime > 0) {
                this.otgPortalTime -= 4;
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void playPortalSound(Minecraft mc) {
        mc.func_147118_V().func_147682_a((ISound)SimpleSound.func_239532_b_((SoundEvent)SoundEvents.field_187814_ei, (float)(this.getPlayer().func_70681_au().nextFloat() * 0.4f + 0.8f), (float)0.25f));
    }

    public void setPortal(boolean inPortal, String portalColor) {
        this.isInOtgPortal = inPortal;
        this.portalColor = portalColor;
    }

    public String getPortalColor() {
        return this.portalColor;
    }

    public void setPortalTime(int time) {
        this.otgPortalTime = time;
    }

    public int getPortalTime() {
        return this.otgPortalTime;
    }
}

