/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.dimensions.portals;

import com.pg85.otg.forge.dimensions.portals.OTGCapabilities;
import com.pg85.otg.forge.dimensions.portals.OTGPortalColors;
import com.pg85.otg.forge.dimensions.portals.OTGTeleporter;
import com.pg85.otg.forge.gen.OTGNoiseChunkGenerator;
import com.pg85.otg.forge.materials.ForgeMaterialData;
import com.pg85.otg.util.materials.LocalMaterialData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.NetherPortalBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.RegistryObject;

public class OTGPortalBlock
extends NetherPortalBlock {
    private final String portalColor;

    public OTGPortalBlock(AbstractBlock.Properties properties, String portalColor) {
        super(properties);
        this.portalColor = portalColor;
    }

    public static boolean checkForPortal(ServerWorld serverworld, BlockPos pos, PlayerEntity player, Hand hand, ItemStack stack, RegistryObject<OTGPortalBlock> otgPortalBlock, List<LocalMaterialData> portalBlocks) {
        if (serverworld.func_234923_W_() == World.field_234918_g_ || serverworld.func_72863_F().field_186029_c instanceof OTGNoiseChunkGenerator) {
            boolean tryPortal = false;
            for (Direction direction : Direction.values()) {
                Block blockAtPos = serverworld.func_180495_p(pos.func_177972_a(direction)).func_177230_c();
                boolean isFound = false;
                for (LocalMaterialData portalBlock : portalBlocks) {
                    if (((ForgeMaterialData)portalBlock).internalBlock().func_177230_c() != blockAtPos) continue;
                    isFound = true;
                    break;
                }
                if (!isFound || ((OTGPortalBlock)otgPortalBlock.get()).isPortal((IWorld)serverworld, pos, otgPortalBlock, portalBlocks) == null) continue;
                tryPortal = true;
                break;
            }
            if (tryPortal && ((OTGPortalBlock)otgPortalBlock.get()).trySpawnPortal((IWorld)serverworld, pos, otgPortalBlock, portalBlocks)) {
                player.func_184185_a(SoundEvents.field_187624_K, 1.0f, 1.0f);
                player.func_184609_a(hand);
                if (!player.func_184812_l_()) {
                    if (stack.func_190916_E() > 1) {
                        stack.func_190918_g(1);
                        player.func_191521_c(stack.hasContainerItem() ? stack.getContainerItem() : ItemStack.field_190927_a);
                    } else if (stack.func_77984_f()) {
                        stack.func_222118_a(1, (LivingEntity)player, p -> p.func_213334_d(hand));
                    } else {
                        player.func_184611_a(hand, stack.hasContainerItem() ? stack.getContainerItem() : ItemStack.field_190927_a);
                    }
                }
                return true;
            }
        }
        return false;
    }

    @Nullable
    public Size isPortal(IWorld world, BlockPos pos, RegistryObject<OTGPortalBlock> portalBlock, List<LocalMaterialData> portalBlocks) {
        Size otgPortalSizeX = new Size(world, pos, Direction.Axis.X, portalBlock, portalBlocks);
        if (otgPortalSizeX.isValid() && otgPortalSizeX.portalBlockCount == 0) {
            return otgPortalSizeX;
        }
        Size otgPortalSizeZ = new Size(world, pos, Direction.Axis.Z, portalBlock, portalBlocks);
        return otgPortalSizeZ.isValid() && otgPortalSizeZ.portalBlockCount == 0 ? otgPortalSizeZ : null;
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entity) {
        if (!entity.func_184218_aH() && !entity.func_184207_aI() && entity.func_184222_aU()) {
            if (entity.func_242280_ah()) {
                entity.func_242279_ag();
            } else {
                LazyOptional otgPlayer;
                if (!entity.field_70170_p.field_72995_K && !pos.equals((Object)entity.field_242271_ac)) {
                    entity.field_242271_ac = pos.func_185334_h();
                }
                if (!(otgPlayer = entity.getCapability(OTGCapabilities.OTG_PLAYER_CAPABILITY)).isPresent()) {
                    this.doTeleport(entity);
                } else {
                    otgPlayer.ifPresent(handler -> {
                        handler.setPortal(true, this.portalColor);
                        int waitTime = handler.getPortalTime();
                        if (waitTime >= entity.func_82145_z()) {
                            this.doTeleport(entity);
                            handler.setPortalTime(0);
                        }
                    });
                }
            }
        }
    }

    public boolean trySpawnPortal(IWorld worldIn, BlockPos pos, RegistryObject<OTGPortalBlock> portalBlock, List<LocalMaterialData> portalBlocks) {
        Size otgPortalSize = this.isPortal(worldIn, pos, portalBlock, portalBlocks);
        if (otgPortalSize != null) {
            otgPortalSize.placePortalBlocks(portalBlock);
            return true;
        }
        return false;
    }

    public void func_225542_b_(BlockState block, ServerWorld serverWorld, BlockPos pos, Random rand) {
        if (serverWorld.func_230315_m_().func_236043_f_() && serverWorld.func_82736_K().func_223586_b(GameRules.field_223601_d) && rand.nextInt(2000) < serverWorld.func_175659_aa().func_151525_a()) {
            Entity entity;
            while (serverWorld.func_180495_p(pos).func_203425_a((Block)this)) {
                pos = pos.func_177977_b();
            }
            EntityType entityType = null;
            Collection worlds = (Collection)serverWorld.func_73046_m().func_212370_w();
            worlds = worlds.stream().sorted((a, b) -> a.func_234923_W_().func_240901_a_().toString().compareTo(b.func_234923_W_().func_240901_a_().toString())).collect(Collectors.toList());
            ArrayList<String> usedColors = new ArrayList<String>();
            for (ServerWorld world : worlds) {
                if (world.func_234923_W_() == World.field_234918_g_ || world.func_234923_W_() == World.field_234920_i_ || world.func_234923_W_() == World.field_234919_h_ || !(world.func_72863_F().field_186029_c instanceof OTGNoiseChunkGenerator)) continue;
                OTGNoiseChunkGenerator generator = (OTGNoiseChunkGenerator)world.func_72863_F().field_186029_c;
                String portalColor = generator.getPortalColor().toLowerCase().trim();
                while (usedColors.contains(portalColor)) {
                    portalColor = OTGPortalColors.getNextPortalColor(portalColor);
                }
                usedColors.add(portalColor);
                if (!this.portalColor.equals(portalColor)) continue;
                Optional optEntityType = EntityType.func_220327_a((String)generator.getPortalMob());
                if (!optEntityType.isPresent()) break;
                entityType = (EntityType)optEntityType.get();
                break;
            }
            if (entityType != null && serverWorld.func_180495_p(pos).func_215688_a((IBlockReader)serverWorld, pos, entityType) && (entity = entityType.func_220342_a(serverWorld, (CompoundNBT)null, (ITextComponent)null, (PlayerEntity)null, pos.func_177984_a(), SpawnReason.STRUCTURE, false, false)) != null) {
                entity.func_242279_ag();
            }
        }
    }

    private void doTeleport(Entity entity) {
        if (entity.field_70170_p != null && entity.field_70170_p instanceof ServerWorld) {
            ServerWorld destination;
            ServerWorld serverWorld = (ServerWorld)entity.field_70170_p;
            MinecraftServer minecraftServer = serverWorld.func_73046_m();
            RegistryKey destinationDim = null;
            if (serverWorld.func_234923_W_() != World.field_234920_i_ && serverWorld.func_234923_W_() != World.field_234919_h_ && (serverWorld.func_234923_W_() == World.field_234918_g_ || serverWorld.func_72863_F().field_186029_c instanceof OTGNoiseChunkGenerator)) {
                Collection worlds = (Collection)entity.func_184102_h().func_212370_w();
                worlds = worlds.stream().sorted((a, b) -> a.func_234923_W_().func_240901_a_().toString().compareTo(b.func_234923_W_().func_240901_a_().toString())).collect(Collectors.toList());
                ArrayList<String> usedColors = new ArrayList<String>();
                for (ServerWorld world : worlds) {
                    if (world.func_234923_W_() == World.field_234918_g_ || world.func_234923_W_() == World.field_234920_i_ || world.func_234923_W_() == World.field_234919_h_ || !(world.func_72863_F().field_186029_c instanceof OTGNoiseChunkGenerator)) continue;
                    String portalColor = ((OTGNoiseChunkGenerator)world.func_72863_F().field_186029_c).getPortalColor().toLowerCase().trim();
                    while (usedColors.contains(portalColor)) {
                        portalColor = OTGPortalColors.getNextPortalColor(portalColor);
                    }
                    usedColors.add(portalColor);
                    if (!this.portalColor.equals(portalColor)) continue;
                    if (world.func_234923_W_() == serverWorld.func_234923_W_()) {
                        destinationDim = World.field_234918_g_;
                        break;
                    }
                    destinationDim = world.func_234923_W_();
                    break;
                }
            }
            if (minecraftServer != null && (destination = minecraftServer.func_71218_a(destinationDim)) != null && minecraftServer.func_71255_r() && !entity.func_184218_aH()) {
                entity.field_70170_p.func_217381_Z().func_76320_a("otg_portal");
                entity.func_242279_ag();
                entity.changeDimension(destination, (ITeleporter)new OTGTeleporter(destination));
                entity.field_70170_p.func_217381_Z().func_76319_b();
            }
        }
    }

    public static class Size {
        protected final IWorld world;
        public final Direction.Axis axis;
        public final Direction rightDir;
        public final Direction leftDir;
        public int portalBlockCount;
        @Nullable
        public BlockPos bottomLeft;
        public int height;
        public int width;

        public Size(IWorld worldIn, BlockPos pos, Direction.Axis axisIn, RegistryObject<OTGPortalBlock> portalBlock, List<LocalMaterialData> portalBlocks) {
            this.world = worldIn;
            this.axis = axisIn;
            if (axisIn == Direction.Axis.X) {
                this.leftDir = Direction.EAST;
                this.rightDir = Direction.WEST;
            } else {
                this.leftDir = Direction.NORTH;
                this.rightDir = Direction.SOUTH;
            }
            BlockPos blockpos = pos;
            while (pos.func_177956_o() > blockpos.func_177956_o() - 21 && pos.func_177956_o() > 0 && this.isEmptyBlock(worldIn.func_180495_p(pos.func_177977_b()))) {
                pos = pos.func_177977_b();
            }
            int i = this.getDistanceToEdge(pos, this.leftDir, portalBlocks) - 1;
            if (i >= 0) {
                this.bottomLeft = pos.func_177967_a(this.leftDir, i);
                this.width = this.getDistanceToEdge(this.bottomLeft, this.rightDir, portalBlocks);
                if (this.width < 2 || this.width > 21) {
                    this.bottomLeft = null;
                    this.width = 0;
                }
            }
            if (this.bottomLeft != null) {
                this.height = this.getPortalHeight(portalBlock, portalBlocks);
            }
        }

        protected int getDistanceToEdge(BlockPos pos, Direction directionIn, List<LocalMaterialData> portalBlocks) {
            boolean isFound;
            Block blockAtPos;
            int i;
            for (i = 0; i < 22; ++i) {
                BlockPos blockpos = pos.func_177967_a(directionIn, i);
                blockAtPos = this.world.func_180495_p(blockpos.func_177977_b()).func_177230_c();
                isFound = false;
                for (LocalMaterialData portalBlock : portalBlocks) {
                    if (((ForgeMaterialData)portalBlock).internalBlock().func_177230_c() != blockAtPos) continue;
                    isFound = true;
                    break;
                }
                if (!this.isEmptyBlock(this.world.func_180495_p(blockpos)) || !isFound) break;
            }
            BlockPos framePos = pos.func_177967_a(directionIn, i);
            blockAtPos = this.world.func_180495_p(framePos).func_177230_c();
            isFound = false;
            for (LocalMaterialData portalBlock : portalBlocks) {
                if (((ForgeMaterialData)portalBlock).internalBlock().func_177230_c() != blockAtPos) continue;
                isFound = true;
                break;
            }
            return isFound ? i : 0;
        }

        public int getHeight() {
            return this.height;
        }

        public int getWidth() {
            return this.width;
        }

        protected int getPortalHeight(RegistryObject<OTGPortalBlock> portalBlock, List<LocalMaterialData> portalBlocks) {
            this.height = 0;
            block0: while (this.height < 21) {
                for (int i = 0; i < this.width; ++i) {
                    boolean isFound;
                    Block blockAtPos;
                    BlockPos framePos;
                    BlockPos blockpos = this.bottomLeft.func_177967_a(this.rightDir, i).func_177981_b(this.height);
                    BlockState blockstate = this.world.func_180495_p(blockpos);
                    if (!this.isEmptyBlock(blockstate)) break block0;
                    Block block = blockstate.func_177230_c();
                    if (block == portalBlock.get()) {
                        ++this.portalBlockCount;
                    }
                    if (i == 0) {
                        framePos = blockpos.func_177972_a(this.leftDir);
                        blockAtPos = this.world.func_180495_p(framePos).func_177230_c();
                        isFound = false;
                        for (LocalMaterialData portalBlock2 : portalBlocks) {
                            if (((ForgeMaterialData)portalBlock2).internalBlock().func_177230_c() != blockAtPos) continue;
                            isFound = true;
                            break;
                        }
                        if (isFound) continue;
                        break block0;
                    }
                    if (i != this.width - 1) continue;
                    framePos = blockpos.func_177972_a(this.rightDir);
                    blockAtPos = this.world.func_180495_p(framePos).func_177230_c();
                    isFound = false;
                    for (LocalMaterialData portalBlock2 : portalBlocks) {
                        if (((ForgeMaterialData)portalBlock2).internalBlock().func_177230_c() != blockAtPos) continue;
                        isFound = true;
                        break;
                    }
                    if (!isFound) break block0;
                }
                ++this.height;
            }
            for (int j = 0; j < this.width; ++j) {
                BlockPos framePos = this.bottomLeft.func_177967_a(this.rightDir, j).func_177981_b(this.height);
                Block blockAtPos = this.world.func_180495_p(framePos).func_177230_c();
                boolean isFound = false;
                for (LocalMaterialData portalBlock2 : portalBlocks) {
                    if (((ForgeMaterialData)portalBlock2).internalBlock().func_177230_c() != blockAtPos) continue;
                    isFound = true;
                    break;
                }
                if (isFound) continue;
                this.height = 0;
                break;
            }
            if (this.height <= 21 && this.height >= 3) {
                return this.height;
            }
            this.bottomLeft = null;
            this.width = 0;
            this.height = 0;
            return 0;
        }

        protected boolean isEmptyBlock(BlockState pos) {
            Block block = pos.func_177230_c();
            return pos.func_196958_f() || block == Blocks.field_150355_j || block.getBlock() instanceof OTGPortalBlock;
        }

        public boolean isValid() {
            return this.bottomLeft != null && this.width >= 2 && this.width <= 21 && this.height >= 3 && this.height <= 21;
        }

        public void placePortalBlocks(RegistryObject<OTGPortalBlock> portalBlock) {
            for (int i = 0; i < this.width; ++i) {
                BlockPos blockpos = this.bottomLeft.func_177967_a(this.rightDir, i);
                for (int j = 0; j < this.height; ++j) {
                    if (!(this.world instanceof World)) continue;
                    World world = (World)this.world;
                    world.func_175656_a(blockpos.func_177981_b(j), (BlockState)((OTGPortalBlock)portalBlock.get()).func_176223_P().func_206870_a((Property)field_176550_a, (Comparable)this.axis));
                }
            }
        }

        private boolean isLargeEnough() {
            return this.portalBlockCount >= this.width * this.height;
        }

        public boolean canCreatePortal() {
            return this.isValid() && this.isLargeEnough();
        }
    }
}

