/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.event;

import com.pg85.otg.forge.dimensions.portals.OTGPortalBlock;
import com.pg85.otg.forge.dimensions.portals.OTGPortalColors;
import com.pg85.otg.forge.gen.OTGNoiseChunkGenerator;
import com.pg85.otg.util.materials.LocalMaterialData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ResourceLocationException;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="otg")
public class BlockHandler {
    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (event.getWorld().func_73046_m() != null && event.getWorld() instanceof ServerWorld && event.getWorld().func_234923_W_() != World.field_234920_i_ && event.getWorld().func_234923_W_() != World.field_234919_h_ && (event.getWorld().func_234923_W_() == World.field_234918_g_ || ((ServerWorld)event.getWorld()).func_72863_F().field_186029_c instanceof OTGNoiseChunkGenerator)) {
            BlockRayTraceResult hitVec = event.getHitVec();
            BlockPos pos = hitVec.func_216350_a().func_177972_a(hitVec.func_216354_b());
            Collection worlds = (Collection)event.getWorld().func_73046_m().func_212370_w();
            worlds = worlds.stream().sorted((a, b) -> a.func_234923_W_().func_240901_a_().toString().compareTo(b.func_234923_W_().func_240901_a_().toString())).collect(Collectors.toList());
            ArrayList<String> usedColors = new ArrayList<String>();
            for (ServerWorld world : worlds) {
                if (world.func_234923_W_() == World.field_234920_i_ || world.func_234923_W_() == World.field_234919_h_ || world.func_234923_W_() == World.field_234918_g_ || !(world.func_72863_F().field_186029_c instanceof OTGNoiseChunkGenerator)) continue;
                OTGNoiseChunkGenerator generator = (OTGNoiseChunkGenerator)world.func_72863_F().field_186029_c;
                Item ignitionItem = null;
                try {
                    ignitionItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(generator.getPortalIgnitionSource()));
                }
                catch (ResourceLocationException resourceLocationException) {
                    // empty catch block
                }
                if (ignitionItem == null) {
                    ignitionItem = Items.field_151033_d;
                }
                String portalColor = generator.getPortalColor().toLowerCase().trim();
                while (usedColors.contains(portalColor)) {
                    portalColor = OTGPortalColors.getNextPortalColor(portalColor);
                }
                usedColors.add(portalColor);
                if (event.getItemStack().func_77973_b() != ignitionItem) continue;
                RegistryObject<OTGPortalBlock> otgPortalBlock = OTGPortalColors.getPortalBlockByColor(portalColor);
                List<LocalMaterialData> portalBlocks = generator.getPortalBlocks();
                if (!OTGPortalBlock.checkForPortal((ServerWorld)event.getWorld(), pos, event.getPlayer(), event.getHand(), event.getItemStack(), otgPortalBlock, portalBlocks)) continue;
                event.setCanceled(true);
                return;
            }
        }
    }
}

