/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.event;

import com.pg85.otg.forge.network.BiomeSettingSyncWrapper;
import com.pg85.otg.forge.network.OTGClientSyncManager;
import com.pg85.otg.util.helpers.MathHelper;
import java.util.Arrays;
import net.minecraft.client.GameSettings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.lwjgl.opengl.GL11;

@Mod.EventBusSubscriber(modid="otg", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ClientFogHandler {
    private static double lastX = Double.MIN_VALUE;
    private static double lastZ = Double.MIN_VALUE;
    private static float[][] fogDensityCache = new float[0][0];
    private static boolean otgDidLastFogRender = false;

    private ClientFogHandler() {
        for (float[] row : fogDensityCache) {
            Arrays.fill(row, -1.0f);
        }
    }

    @SubscribeEvent
    public static void onRenderFog(EntityViewRenderEvent.RenderFogEvent event) {
        Entity entity = event.getInfo().func_216773_g();
        GameSettings settings = Minecraft.func_71410_x().field_71474_y;
        if (!(entity instanceof ClientPlayerEntity)) {
            ClientFogHandler.resetFogDistance(Minecraft.func_71410_x(), event.getType());
            return;
        }
        ResourceLocation key = Minecraft.func_71410_x().field_71441_e.func_241828_r().func_243612_b(Registry.field_239720_u_).func_177774_c((Object)Minecraft.func_71410_x().field_71441_e.func_226691_t_(event.getInfo().func_216780_d()));
        BiomeSettingSyncWrapper wrapper = OTGClientSyncManager.getSyncedData().get(key.toString());
        if (wrapper == null) {
            if (otgDidLastFogRender) {
                ClientFogHandler.resetFogDistance(Minecraft.func_71410_x(), event.getType());
            }
            return;
        }
        double posX = entity.func_226277_ct_();
        double posZ = entity.func_226281_cx_();
        int blockX = MathHelper.floor(posX);
        int blockZ = MathHelper.floor(posZ);
        int blendDistance = settings.field_205217_U;
        int n = blendDistance = blendDistance == 0 ? 1 : blendDistance;
        if (fogDensityCache.length < blendDistance * 2 + 1) {
            for (float[] row : fogDensityCache = new float[blendDistance * 2 + 1][blendDistance * 2 + 1]) {
                Arrays.fill(row, -1.0f);
            }
        }
        boolean hasMoved = posX != lastX || posZ != lastZ;
        float biomeFogDistance = 0.0f;
        float weightBiomeFog = 0.0f;
        BlockPos.Mutable blockPos = new BlockPos.Mutable(0, 0, 0);
        for (int x = -blendDistance; x <= blendDistance; ++x) {
            for (int z = -blendDistance; z <= blendDistance; ++z) {
                blockPos.func_181079_c(blockX + x, 0, blockZ + z);
                float fogDensity = 1.0f - ClientFogHandler.getFogDensity(x + blendDistance, z + blendDistance, blockPos, hasMoved);
                float densityWeight = 1.0f;
                double differenceX = ClientFogHandler.getDifference(entity.func_226277_ct_(), blockX, x, blendDistance);
                double differenceZ = ClientFogHandler.getDifference(entity.func_226281_cx_(), blockZ, z, blendDistance);
                if (differenceX >= 0.0) {
                    fogDensity = (float)((double)fogDensity * differenceX);
                    densityWeight = (float)((double)densityWeight * differenceX);
                }
                if (differenceZ >= 0.0) {
                    fogDensity = (float)((double)fogDensity * differenceZ);
                    densityWeight = (float)((double)densityWeight * differenceZ);
                }
                biomeFogDistance += fogDensity;
                weightBiomeFog += densityWeight;
            }
        }
        float weightMixed = (float)blendDistance * 2.0f * ((float)blendDistance * 2.0f);
        float weightDefault = weightMixed - weightBiomeFog;
        if (weightDefault < 0.0f) {
            weightDefault = 0.0f;
        }
        float fogDistanceAvg = weightBiomeFog == 0.0f ? 0.0f : biomeFogDistance / weightBiomeFog;
        float fogDistance = (biomeFogDistance * 520.0f + event.getFarPlaneDistance() * weightDefault) / weightMixed;
        float fogDistanceScaleBiome = 0.1f * (1.0f - fogDistanceAvg) + 0.75f * fogDistanceAvg;
        float fogDistanceScale = (fogDistanceScaleBiome * weightBiomeFog + 1.0f * weightDefault) / weightMixed;
        float finalFogDistance = Math.min(fogDistance, event.getFarPlaneDistance());
        float fogStart = event.getType() == FogRenderer.FogType.FOG_SKY ? 0.0f : finalFogDistance * fogDistanceScale;
        lastX = posX;
        lastZ = posZ;
        otgDidLastFogRender = true;
        GL11.glFogf((int)2915, (float)fogStart);
        GL11.glFogf((int)2916, (float)finalFogDistance);
    }

    private static void resetFogDistance(Minecraft minecraft, FogRenderer.FogType type) {
        if (otgDidLastFogRender) {
            otgDidLastFogRender = false;
            float farPlaneDistance = minecraft.field_71474_y.field_151451_c * 16;
            if (type == FogRenderer.FogType.FOG_SKY) {
                GL11.glFogf((int)2915, (float)0.0f);
            } else {
                GL11.glFogf((int)2915, (float)(farPlaneDistance * 0.75f));
            }
            GL11.glFogf((int)2916, (float)farPlaneDistance);
            for (float[] row : fogDensityCache) {
                Arrays.fill(row, -1.0f);
            }
        }
    }

    private static double getDifference(double rawCoord, int blockCoord, int pos, int distance) {
        if (pos == -distance) {
            return 1.0 - (rawCoord - (double)blockCoord);
        }
        if (pos == distance) {
            return rawCoord - (double)blockCoord;
        }
        return -1.0;
    }

    private static float getFogDensity(int x, int z, BlockPos.Mutable blockpos, boolean hasMoved) {
        float density = fogDensityCache[x][z];
        if (density != -1.0f && !hasMoved) {
            return density;
        }
        ResourceLocation key = Minecraft.func_71410_x().field_71441_e.func_241828_r().func_243612_b(Registry.field_239720_u_).func_177774_c((Object)Minecraft.func_71410_x().field_71441_e.func_226691_t_((BlockPos)blockpos));
        BiomeSettingSyncWrapper wrapper = OTGClientSyncManager.getSyncedData().get(key.toString());
        if (wrapper == null) {
            return 0.0f;
        }
        ClientFogHandler.fogDensityCache[x][z] = wrapper.getFogDensity();
        return wrapper.getFogDensity();
    }
}

