/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.event;

import com.pg85.otg.OTG;
import com.pg85.otg.customobject.CustomObjectManager;
import com.pg85.otg.customobject.config.CustomObjectResourcesManager;
import com.pg85.otg.customobject.resource.SaplingResource;
import com.pg85.otg.forge.gen.ForgeWorldGenRegion;
import com.pg85.otg.forge.gen.OTGNoiseChunkGenerator;
import com.pg85.otg.forge.materials.ForgeMaterialData;
import com.pg85.otg.interfaces.IBiomeConfig;
import com.pg85.otg.interfaces.ILogger;
import com.pg85.otg.interfaces.IMaterialReader;
import com.pg85.otg.interfaces.IModLoadedChecker;
import com.pg85.otg.interfaces.ISaplingSpawner;
import com.pg85.otg.interfaces.IWorldGenRegion;
import com.pg85.otg.presets.Preset;
import com.pg85.otg.util.materials.LocalMaterialData;
import com.pg85.otg.util.materials.LocalMaterials;
import com.pg85.otg.util.minecraft.SaplingType;
import java.nio.file.Path;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.event.world.SaplingGrowTreeEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="otg")
public class SaplingHandler {
    @SubscribeEvent
    public void onSaplingGrowTree(SaplingGrowTreeEvent event) {
        if (!(event.getWorld() instanceof ServerWorld)) {
            return;
        }
        BlockPos blockPos = event.getPos();
        if (!(((ServerWorld)event.getWorld()).func_72863_F().field_186029_c instanceof OTGNoiseChunkGenerator)) {
            return;
        }
        Preset preset = ((OTGNoiseChunkGenerator)((ServerWorld)event.getWorld()).func_72863_F().field_186029_c).getPreset();
        ForgeWorldGenRegion worldGenRegion = new ForgeWorldGenRegion(preset.getFolderName(), preset.getWorldConfig(), (ISeedReader)((ServerWorld)event.getWorld()), (OTGNoiseChunkGenerator)((ServerWorld)event.getWorld()).func_72863_F().field_186029_c);
        CustomObjectManager customObjectManager = OTG.getEngine().getCustomObjectManager();
        CustomObjectResourcesManager customObjectResourcesManager = OTG.getEngine().getCustomObjectResourcesManager();
        ILogger logger = OTG.getEngine().getLogger();
        Path otgRootFolder = OTG.getEngine().getOTGRootFolder();
        IModLoadedChecker modLoadedChecker = OTG.getEngine().getModLoadedChecker();
        IMaterialReader materialReader = OTG.getEngine().getPresetLoader().getMaterialReader(preset.getFolderName());
        IBiomeConfig biomeConfig = worldGenRegion.getCachedBiomeProvider().getBiomeConfig(blockPos.func_177958_n(), blockPos.func_177952_p());
        ForgeMaterialData material = (ForgeMaterialData)worldGenRegion.getMaterial(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p());
        BlockPos result = this.findFourSaplings(blockPos, material, worldGenRegion);
        boolean wideTrunk = false;
        if (result != null) {
            blockPos = result;
            wideTrunk = true;
        } else {
            wideTrunk = false;
        }
        ISaplingSpawner sapling = biomeConfig.getCustomSaplingGen(ForgeMaterialData.ofBlockState(material.internalBlock().func_177230_c().func_176223_P()), wideTrunk);
        if (sapling != null && sapling.hasWideTrunk() && !wideTrunk) {
            return;
        }
        if (sapling == null) {
            SaplingType saplingType = null;
            if (wideTrunk) {
                saplingType = this.getBigSaplingType(ForgeMaterialData.ofBlockState(material.internalBlock().func_177230_c().func_176223_P()));
            }
            if (saplingType == null) {
                saplingType = this.getSmallSaplingType(ForgeMaterialData.ofBlockState(material.internalBlock().func_177230_c().func_176223_P()));
            }
            if (saplingType != null) {
                sapling = biomeConfig.getSaplingGen(saplingType);
            }
        }
        if (sapling == null) {
            return;
        }
        event.setResult(Event.Result.DENY);
        if (sapling.hasWideTrunk()) {
            worldGenRegion.setBlock(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p(), LocalMaterials.AIR);
            worldGenRegion.setBlock(blockPos.func_177958_n() + 1, blockPos.func_177956_o(), blockPos.func_177952_p(), LocalMaterials.AIR);
            worldGenRegion.setBlock(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p() + 1, LocalMaterials.AIR);
            worldGenRegion.setBlock(blockPos.func_177958_n() + 1, blockPos.func_177956_o(), blockPos.func_177952_p() + 1, LocalMaterials.AIR);
        } else {
            worldGenRegion.setBlock(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p(), LocalMaterials.AIR);
        }
        boolean saplingGrown = false;
        Random random = new Random();
        for (int i = 0; i < 10; ++i) {
            if (!((SaplingResource)sapling).growSapling(worldGenRegion, random, wideTrunk, blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p(), preset.getFolderName(), otgRootFolder, logger, customObjectManager, materialReader, customObjectResourcesManager, modLoadedChecker)) continue;
            saplingGrown = true;
            break;
        }
        if (!saplingGrown) {
            int saplingX = blockPos.func_177958_n();
            int saplingY = blockPos.func_177956_o();
            int saplingZ = blockPos.func_177952_p();
            if (sapling.hasWideTrunk()) {
                worldGenRegion.setBlock(saplingX, saplingY, saplingZ, material);
                worldGenRegion.setBlock(saplingX + 1, saplingY, saplingZ, material);
                worldGenRegion.setBlock(saplingX, saplingY, saplingZ + 1, material);
                worldGenRegion.setBlock(saplingX + 1, saplingY, saplingZ + 1, material);
            } else {
                worldGenRegion.setBlock(saplingX, saplingY, saplingZ, material);
            }
        }
    }

    @SubscribeEvent
    public void onBonemealUse(BonemealEvent event) {
        if (!(event.getWorld() instanceof ServerWorld)) {
            return;
        }
        BlockPos blockPos = event.getPos();
        if (!(((ServerWorld)event.getWorld()).func_72863_F().field_186029_c instanceof OTGNoiseChunkGenerator)) {
            return;
        }
        Preset preset = ((OTGNoiseChunkGenerator)((ServerWorld)event.getWorld()).func_72863_F().field_186029_c).getPreset();
        ForgeWorldGenRegion worldGenRegion = new ForgeWorldGenRegion(preset.getFolderName(), preset.getWorldConfig(), (ISeedReader)((ServerWorld)event.getWorld()), (OTGNoiseChunkGenerator)((ServerWorld)event.getWorld()).func_72863_F().field_186029_c);
        CustomObjectManager customObjectManager = OTG.getEngine().getCustomObjectManager();
        CustomObjectResourcesManager customObjectResourcesManager = OTG.getEngine().getCustomObjectResourcesManager();
        ILogger logger = OTG.getEngine().getLogger();
        Path otgRootFolder = OTG.getEngine().getOTGRootFolder();
        IModLoadedChecker modLoadedChecker = OTG.getEngine().getModLoadedChecker();
        IMaterialReader materialReader = OTG.getEngine().getPresetLoader().getMaterialReader(preset.getFolderName());
        IBiomeConfig biomeConfig = worldGenRegion.getCachedBiomeProvider().getBiomeConfig(blockPos.func_177958_n(), blockPos.func_177952_p());
        ISaplingSpawner sapling = null;
        SaplingType type = null;
        if (ForgeMaterialData.ofBlockState(event.getBlock()).isMaterial(LocalMaterials.RED_MUSHROOM_BLOCK)) {
            type = SaplingType.RedMushroom;
        } else if (ForgeMaterialData.ofBlockState(event.getBlock()).isMaterial(LocalMaterials.BROWN_MUSHROOM_BLOCK)) {
            type = SaplingType.BrownMushroom;
        } else {
            return;
        }
        if (type != null) {
            sapling = biomeConfig.getSaplingGen(type);
        }
        if (sapling == null) {
            return;
        }
        event.setResult(Event.Result.ALLOW);
        worldGenRegion.setBlock(event.getPos().func_177958_n(), event.getPos().func_177956_o(), event.getPos().func_177952_p(), LocalMaterials.AIR);
        boolean mushroomGrown = false;
        Random random = new Random();
        for (int i = 0; i < 10; ++i) {
            if (!((SaplingResource)sapling).growSapling(worldGenRegion, random, false, blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p(), preset.getFolderName(), otgRootFolder, logger, customObjectManager, materialReader, customObjectResourcesManager, modLoadedChecker)) continue;
            mushroomGrown = true;
            break;
        }
        if (!mushroomGrown) {
            worldGenRegion.setBlock(event.getPos().func_177958_n(), event.getPos().func_177956_o(), event.getPos().func_177952_p(), ForgeMaterialData.ofBlockState(event.getBlock()));
        }
    }

    private SaplingType getSmallSaplingType(LocalMaterialData saplingMaterial) {
        if (saplingMaterial == LocalMaterials.OAK_SAPLING) {
            return SaplingType.Oak;
        }
        if (saplingMaterial == LocalMaterials.SPRUCE_SAPLING) {
            return SaplingType.Redwood;
        }
        if (saplingMaterial == LocalMaterials.BIRCH_SAPLING) {
            return SaplingType.Birch;
        }
        if (saplingMaterial == LocalMaterials.JUNGLE_SAPLING) {
            return SaplingType.SmallJungle;
        }
        if (saplingMaterial == LocalMaterials.ACACIA_SAPLING) {
            return SaplingType.Acacia;
        }
        if (saplingMaterial == LocalMaterials.BAMBOO_SAPLING) {
            return SaplingType.Bamboo;
        }
        return null;
    }

    private SaplingType getBigSaplingType(LocalMaterialData saplingMaterial) {
        if (saplingMaterial == LocalMaterials.DARK_OAK_SAPLING) {
            return SaplingType.DarkOak;
        }
        if (saplingMaterial == LocalMaterials.SPRUCE_SAPLING) {
            return SaplingType.HugeRedwood;
        }
        if (saplingMaterial == LocalMaterials.JUNGLE_SAPLING) {
            return SaplingType.BigJungle;
        }
        return null;
    }

    private BlockPos findFourSaplings(BlockPos blockPos, LocalMaterialData material, IWorldGenRegion worldGenRegion) {
        int x = blockPos.func_177958_n();
        int y = blockPos.func_177956_o();
        int z = blockPos.func_177952_p();
        for (int treeOffsetX = 0; treeOffsetX >= -1; --treeOffsetX) {
            for (int treeOffsetZ = 0; treeOffsetZ >= -1; --treeOffsetZ) {
                if (!material.isMaterial(worldGenRegion.getMaterial(x + treeOffsetX, y, z + treeOffsetZ)) || !material.isMaterial(worldGenRegion.getMaterial(x + treeOffsetX + 1, y, z + treeOffsetZ)) || !material.isMaterial(worldGenRegion.getMaterial(x + treeOffsetX, y, z + treeOffsetZ + 1)) || !material.isMaterial(worldGenRegion.getMaterial(x + treeOffsetX + 1, y, z + treeOffsetZ + 1))) continue;
                return blockPos.func_177982_a(treeOffsetX, 0, treeOffsetZ);
            }
        }
        return null;
    }
}

