/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.gen;

import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.pg85.otg.OTG;
import com.pg85.otg.forge.gen.OTGNoiseChunkGenerator;
import com.pg85.otg.forge.materials.ForgeMaterialData;
import com.pg85.otg.forge.util.ForgeNBTHelper;
import com.pg85.otg.interfaces.IBiome;
import com.pg85.otg.interfaces.IBiomeConfig;
import com.pg85.otg.interfaces.ICachedBiomeProvider;
import com.pg85.otg.interfaces.IEntityFunction;
import com.pg85.otg.interfaces.ILogger;
import com.pg85.otg.interfaces.IWorldConfig;
import com.pg85.otg.util.ChunkCoordinate;
import com.pg85.otg.util.FifoMap;
import com.pg85.otg.util.biome.ReplaceBlockMatrix;
import com.pg85.otg.util.gen.LocalWorldGenRegion;
import com.pg85.otg.util.logging.LogCategory;
import com.pg85.otg.util.logging.LogLevel;
import com.pg85.otg.util.materials.LocalMaterialData;
import com.pg85.otg.util.materials.LocalMaterials;
import com.pg85.otg.util.minecraft.TreeType;
import com.pg85.otg.util.nbt.NamedBinaryTag;
import java.text.MessageFormat;
import java.util.Optional;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.monster.GuardianEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.Features;
import net.minecraft.world.gen.feature.HugeFungusConfig;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraftforge.common.ForgeHooks;

public class ForgeWorldGenRegion
extends LocalWorldGenRegion {
    protected final ISeedReader worldGenRegion;
    private final OTGNoiseChunkGenerator chunkGenerator;
    private final FifoMap<ChunkCoordinate, Boolean> cachedHasDefaultStructureChunks = new FifoMap(2048);

    public ForgeWorldGenRegion(String presetFolderName, IWorldConfig worldConfig, WorldGenRegion worldGenRegion, OTGNoiseChunkGenerator chunkGenerator) {
        super(presetFolderName, OTG.getEngine().getPluginConfig(), worldConfig, OTG.getEngine().getLogger(), worldGenRegion.func_201679_a(), worldGenRegion.func_201680_b(), chunkGenerator.getCachedBiomeProvider());
        this.worldGenRegion = worldGenRegion;
        this.chunkGenerator = chunkGenerator;
    }

    public ForgeWorldGenRegion(String presetFolderName, IWorldConfig worldConfig, ISeedReader worldGenRegion, OTGNoiseChunkGenerator chunkGenerator) {
        super(presetFolderName, OTG.getEngine().getPluginConfig(), worldConfig, OTG.getEngine().getLogger());
        this.worldGenRegion = worldGenRegion;
        this.chunkGenerator = chunkGenerator;
    }

    public ForgeWorldGenRegion(String presetFolderName, IWorldConfig worldConfig, ISeedReader worldGenRegion) {
        super(presetFolderName, OTG.getEngine().getPluginConfig(), worldConfig, OTG.getEngine().getLogger());
        this.worldGenRegion = worldGenRegion;
        this.chunkGenerator = null;
    }

    @Override
    public ILogger getLogger() {
        return OTG.getEngine().getLogger();
    }

    @Override
    public long getSeed() {
        return this.worldGenRegion.func_72905_C();
    }

    @Override
    public Random getWorldRandom() {
        return this.worldGenRegion.func_201674_k();
    }

    @Override
    public ChunkCoordinate getSpawnChunk() {
        if (this.getWorldConfig().getSpawnPointSet()) {
            return ChunkCoordinate.fromBlockCoords(this.getWorldConfig().getSpawnPointX(), this.getWorldConfig().getSpawnPointZ());
        }
        BlockPos spawnPos = this.worldGenRegion.func_201672_e().func_241135_u_();
        return ChunkCoordinate.fromBlockCoords(spawnPos.func_177958_n(), spawnPos.func_177952_p());
    }

    public ISeedReader getInternal() {
        return this.worldGenRegion;
    }

    @Override
    public ICachedBiomeProvider getCachedBiomeProvider() {
        return this.chunkGenerator.getCachedBiomeProvider();
    }

    @Override
    public IBiome getBiomeForDecoration(int x, int z) {
        return this.decorationBiomeCache != null ? this.decorationBiomeCache.getBiome(x, z) : this.getCachedBiomeProvider().getBiome(x, z);
    }

    @Override
    public IBiomeConfig getBiomeConfigForDecoration(int x, int z) {
        return this.decorationBiomeCache != null ? this.decorationBiomeCache.getBiomeConfig(x, z) : this.getCachedBiomeProvider().getBiomeConfig(x, z);
    }

    @Override
    public double getBiomeBlocksNoiseValue(int blockX, int blockZ) {
        return this.chunkGenerator.getBiomeBlocksNoiseValue(blockX, blockZ);
    }

    @Override
    public LocalMaterialData getMaterialDirect(int x, int y, int z) {
        return ForgeMaterialData.ofBlockState(this.worldGenRegion.func_180495_p(new BlockPos(x, y, z)));
    }

    @Override
    public LocalMaterialData getMaterial(int x, int y, int z) {
        if (y >= 256 || y < 0) {
            return null;
        }
        ChunkCoordinate chunkCoord = ChunkCoordinate.fromBlockCoords(x, z);
        IChunk chunk = null;
        if (this.decorationArea == null || this.decorationArea.isInAreaBeingDecorated(x, z)) {
            IChunk iChunk = chunk = this.worldGenRegion.func_217354_b(chunkCoord.getChunkX(), chunkCoord.getChunkZ()) ? this.worldGenRegion.func_212866_a_(chunkCoord.getChunkX(), chunkCoord.getChunkZ()) : null;
        }
        if (chunk == null || !chunk.func_201589_g().func_209003_a(ChunkStatus.field_222612_h)) {
            return null;
        }
        int internalX = x & 0xF;
        int internalZ = z & 0xF;
        return ForgeMaterialData.ofBlockState(chunk.func_180495_p(new BlockPos(internalX, y, internalZ)));
    }

    @Override
    public int getBlockAboveLiquidHeight(int x, int z) {
        int highestY = this.getHighestBlockYAt(x, z, false, true, false, false, false);
        if (highestY >= 0) {
            return highestY + 1;
        }
        return -1;
    }

    @Override
    public int getBlockAboveSolidHeight(int x, int z) {
        int highestY = this.getHighestBlockYAt(x, z, true, false, true, true, false);
        if (highestY >= 0) {
            return highestY + 1;
        }
        return -1;
    }

    @Override
    public int getHighestBlockAboveYAt(int x, int z) {
        int highestY = this.getHighestBlockYAt(x, z, true, true, false, false, false);
        if (highestY >= 0) {
            return highestY + 1;
        }
        return -1;
    }

    @Override
    public int getHighestBlockYAt(int x, int z, boolean findSolid, boolean findLiquid, boolean ignoreLiquid, boolean ignoreSnow, boolean ignoreLeaves) {
        ChunkCoordinate chunkCoord = ChunkCoordinate.fromBlockCoords(x, z);
        IChunk chunk = null;
        if (this.decorationArea == null || this.decorationArea.isInAreaBeingDecorated(x, z)) {
            IChunk iChunk = chunk = this.worldGenRegion.func_217354_b(chunkCoord.getChunkX(), chunkCoord.getChunkZ()) ? this.worldGenRegion.func_212866_a_(chunkCoord.getChunkX(), chunkCoord.getChunkZ()) : null;
        }
        if (chunk == null || !chunk.func_201589_g().func_209003_a(ChunkStatus.field_222612_h)) {
            return -1;
        }
        int internalX = x & 0xF;
        int internalZ = z & 0xF;
        int heightMapy = chunk.func_201576_a(Heightmap.Type.WORLD_SURFACE, internalX, internalZ);
        return this.getHighestBlockYAt(chunk, internalX, heightMapy, internalZ, findSolid, findLiquid, ignoreLiquid, ignoreSnow, ignoreLeaves);
    }

    protected int getHighestBlockYAt(IChunk chunk, int internalX, int heightMapY, int internalZ, boolean findSolid, boolean findLiquid, boolean ignoreLiquid, boolean ignoreSnow, boolean ignoreLeaves) {
        for (int i = heightMapY; i >= 0; --i) {
            boolean isSolid;
            BlockState blockState = chunk.func_180495_p(new BlockPos(internalX, i, internalZ));
            Block block = blockState.func_177230_c();
            ForgeMaterialData material = ForgeMaterialData.ofBlockState(blockState);
            boolean isLiquid = ((LocalMaterialData)material).isLiquid();
            boolean bl = isSolid = ((LocalMaterialData)material).isSolid() && (!ignoreLeaves || block != Blocks.field_196621_O && block != Blocks.field_196619_M && block != Blocks.field_196623_P && block != Blocks.field_196620_N && block != Blocks.field_196617_K && block != Blocks.field_196618_L && block != Blocks.field_203208_V && block != Blocks.field_203206_T && block != Blocks.field_203209_W && block != Blocks.field_203207_U && block != Blocks.field_203204_R && block != Blocks.field_203205_S) || !ignoreLeaves && (block == Blocks.field_196572_aa || block == Blocks.field_196647_Y || block == Blocks.field_196574_ab || block == Blocks.field_196648_Z || block == Blocks.field_196642_W || block == Blocks.field_196645_X) || !ignoreSnow && block == Blocks.field_150433_aE;
            if (ignoreLiquid && isLiquid) continue;
            if (findSolid && isSolid || findLiquid && isLiquid) {
                return i;
            }
            if ((!findSolid || !isLiquid) && (!findLiquid || !isSolid)) continue;
            return -1;
        }
        return -1;
    }

    @Override
    public int getHeightMapHeight(int x, int z) {
        return this.worldGenRegion.func_201676_a(Heightmap.Type.WORLD_SURFACE_WG, x, z);
    }

    @Override
    public int getLightLevel(int x, int y, int z) {
        IChunk chunk;
        if (y < 0 || y >= 256) {
            return -1;
        }
        ChunkCoordinate chunkCoord = ChunkCoordinate.fromBlockCoords(x, z);
        IChunk iChunk = chunk = this.worldGenRegion.func_217354_b(chunkCoord.getChunkX(), chunkCoord.getChunkZ()) ? this.worldGenRegion.func_212866_a_(chunkCoord.getChunkX(), chunkCoord.getChunkZ()) : null;
        if (chunk != null && chunk.func_201589_g().func_209003_a(ChunkStatus.field_222614_j)) {
            return this.worldGenRegion.func_201696_r(new BlockPos(x, y, z));
        }
        return -1;
    }

    @Override
    public void setBlockDirect(int x, int y, int z, LocalMaterialData material) {
        IBiomeConfig biomeConfig = this.getCachedBiomeProvider().getBiomeConfig(x, z, true);
        if (biomeConfig.getReplaceBlocks() != null) {
            material = material.parseWithBiomeAndHeight(this.getWorldConfig().getBiomeConfigsHaveReplacement(), biomeConfig.getReplaceBlocks(), y);
        }
        this.worldGenRegion.func_180501_a(new BlockPos(x, y, z), ((ForgeMaterialData)material).internalBlock(), 3);
    }

    @Override
    public void setBlock(int x, int y, int z, LocalMaterialData material) {
        this.setBlock(x, y, z, material, null, null);
    }

    @Override
    public void setBlock(int x, int y, int z, LocalMaterialData material, NamedBinaryTag nbt) {
        this.setBlock(x, y, z, material, nbt, null);
    }

    @Override
    public void setBlock(int x, int y, int z, LocalMaterialData material, ReplaceBlockMatrix replaceBlocksMatrix) {
        this.setBlock(x, y, z, material, null, replaceBlocksMatrix);
    }

    @Override
    public void setBlock(int x, int y, int z, LocalMaterialData material, NamedBinaryTag nbt, ReplaceBlockMatrix replaceBlocksMatrix) {
        if (y < 0 || y >= 256) {
            return;
        }
        if (material.isEmpty()) {
            return;
        }
        if (this.decorationArea == null || this.decorationArea.isInAreaBeingDecorated(x, z)) {
            if (replaceBlocksMatrix != null) {
                material = material.parseWithBiomeAndHeight(this.getWorldConfig().getBiomeConfigsHaveReplacement(), replaceBlocksMatrix, y);
            }
            BlockPos pos = new BlockPos(x, y, z);
            this.worldGenRegion.func_180501_a(pos, ((ForgeMaterialData)material).internalBlock(), 18);
            if (material.isLiquid()) {
                this.worldGenRegion.func_205219_F_().func_205360_a(pos, (Object)((ForgeMaterialData)material).internalBlock().func_204520_s().func_206886_c(), 0);
            } else if (material.isMaterial(LocalMaterials.COMMAND_BLOCK)) {
                this.worldGenRegion.func_205220_G_().func_205360_a(pos, (Object)((ForgeMaterialData)material).internalBlock().func_177230_c(), 0);
            }
            if (nbt != null) {
                this.attachNBT(x, y, z, nbt, this.worldGenRegion.func_180495_p(pos));
            }
        }
    }

    private void attachNBT(int x, int y, int z, NamedBinaryTag nbt, BlockState state) {
        CompoundNBT nms = ForgeNBTHelper.getNMSFromNBTTagCompound(nbt);
        nms.func_218657_a("x", (INBT)IntNBT.func_229692_a_((int)x));
        nms.func_218657_a("y", (INBT)IntNBT.func_229692_a_((int)y));
        nms.func_218657_a("z", (INBT)IntNBT.func_229692_a_((int)z));
        TileEntity tileEntity = this.worldGenRegion.func_175625_s(new BlockPos(x, y, z));
        if (tileEntity != null) {
            try {
                tileEntity.deserializeNBT(state, nms);
            }
            catch (JsonSyntaxException e) {
                if (this.logger.getLogCategoryEnabled(LogCategory.CUSTOM_OBJECTS)) {
                    this.logger.log(LogLevel.ERROR, LogCategory.CUSTOM_OBJECTS, MessageFormat.format("Badly formatted json for tile entity with id '{0}' at {1},{2},{3}", nms.func_74779_i("id"), x, y, z));
                }
            }
        } else if (this.logger.getLogCategoryEnabled(LogCategory.CUSTOM_OBJECTS)) {
            this.logger.log(LogLevel.ERROR, LogCategory.CUSTOM_OBJECTS, MessageFormat.format("Skipping tile entity with id {0}, cannot be placed at {1},{2},{3}", nms.func_74779_i("id"), x, y, z));
        }
    }

    public TileEntity getTileEntity(BlockPos blockPos) {
        return this.worldGenRegion.func_175625_s(blockPos);
    }

    @Override
    public boolean placeTree(TreeType type, Random rand, int x, int y, int z) {
        if (y < 0 || y >= 256) {
            return false;
        }
        BlockPos blockPos = new BlockPos(x, y, z);
        try {
            switch (type) {
                case Tree: {
                    ConfiguredFeature oak = Features.field_243862_bH;
                    oak.field_222737_a.func_241855_a(this.worldGenRegion, (ChunkGenerator)this.chunkGenerator, rand, blockPos, oak.field_222738_b);
                    return true;
                }
                case BigTree: {
                    ConfiguredFeature fancy_oak = Features.field_243869_bO;
                    fancy_oak.field_222737_a.func_241855_a(this.worldGenRegion, (ChunkGenerator)this.chunkGenerator, rand, blockPos, fancy_oak.field_222738_b);
                    return true;
                }
                case Forest: 
                case Birch: {
                    ConfiguredFeature birch = Features.field_243864_bJ;
                    birch.field_222737_a.func_241855_a(this.worldGenRegion, (ChunkGenerator)this.chunkGenerator, rand, blockPos, birch.field_222738_b);
                    return true;
                }
                case TallBirch: {
                    ConfiguredFeature tall_birch = Features.field_243874_bT;
                    tall_birch.field_222737_a.func_241855_a(this.worldGenRegion, (ChunkGenerator)this.chunkGenerator, rand, blockPos, tall_birch.field_222738_b);
                    return true;
                }
                case HugeMushroom: {
                    if (rand.nextBoolean()) {
                        ConfiguredFeature huge_brown_mushroom = Features.field_243860_bF;
                        huge_brown_mushroom.field_222737_a.func_241855_a(this.worldGenRegion, (ChunkGenerator)this.chunkGenerator, rand, blockPos, huge_brown_mushroom.field_222738_b);
                    } else {
                        ConfiguredFeature huge_red_mushroom = Features.field_243861_bG;
                        huge_red_mushroom.field_222737_a.func_241855_a(this.worldGenRegion, (ChunkGenerator)this.chunkGenerator, rand, blockPos, huge_red_mushroom.field_222738_b);
                    }
                    return true;
                }
                case HugeRedMushroom: {
                    ConfiguredFeature huge_red_mushroom = Features.field_243861_bG;
                    huge_red_mushroom.field_222737_a.func_241855_a(this.worldGenRegion, (ChunkGenerator)this.chunkGenerator, rand, blockPos, huge_red_mushroom.field_222738_b);
                    return true;
                }
                case HugeBrownMushroom: {
                    ConfiguredFeature huge_brown_mushroom = Features.field_243860_bF;
                    huge_brown_mushroom.field_222737_a.func_241855_a(this.worldGenRegion, (ChunkGenerator)this.chunkGenerator, rand, blockPos, huge_brown_mushroom.field_222738_b);
                    return true;
                }
                case SwampTree: {
                    ConfiguredFeature swamp_tree = Features.field_243875_bU;
                    swamp_tree.field_222737_a.func_241855_a(this.worldGenRegion, (ChunkGenerator)this.chunkGenerator, rand, blockPos, swamp_tree.field_222738_b);
                    return true;
                }
                case Taiga1: {
                    ConfiguredFeature pine = Features.field_243867_bM;
                    pine.field_222737_a.func_241855_a(this.worldGenRegion, (ChunkGenerator)this.chunkGenerator, rand, blockPos, pine.field_222738_b);
                    return true;
                }
                case Taiga2: {
                    ConfiguredFeature spruce = Features.field_243866_bL;
                    spruce.field_222737_a.func_241855_a(this.worldGenRegion, (ChunkGenerator)this.chunkGenerator, rand, blockPos, spruce.field_222738_b);
                    return true;
                }
                case JungleTree: {
                    ConfiguredFeature mega_jungle_tree = Features.field_243871_bQ;
                    mega_jungle_tree.field_222737_a.func_241855_a(this.worldGenRegion, (ChunkGenerator)this.chunkGenerator, rand, blockPos, mega_jungle_tree.field_222738_b);
                    return true;
                }
                case CocoaTree: {
                    ConfiguredFeature jungle_tree = Features.field_243868_bN;
                    jungle_tree.field_222737_a.func_241855_a(this.worldGenRegion, (ChunkGenerator)this.chunkGenerator, rand, blockPos, jungle_tree.field_222738_b);
                    return true;
                }
                case GroundBush: {
                    ConfiguredFeature jungle_bush = Features.field_243876_bV;
                    jungle_bush.field_222737_a.func_241855_a(this.worldGenRegion, (ChunkGenerator)this.chunkGenerator, rand, blockPos, jungle_bush.field_222738_b);
                    return true;
                }
                case Acacia: {
                    ConfiguredFeature acacia = Features.field_243865_bK;
                    acacia.field_222737_a.func_241855_a(this.worldGenRegion, (ChunkGenerator)this.chunkGenerator, rand, blockPos, acacia.field_222738_b);
                    return true;
                }
                case DarkOak: {
                    ConfiguredFeature dark_oak = Features.field_243863_bI;
                    dark_oak.field_222737_a.func_241855_a(this.worldGenRegion, (ChunkGenerator)this.chunkGenerator, rand, blockPos, dark_oak.field_222738_b);
                    return true;
                }
                case HugeTaiga1: {
                    ConfiguredFeature mega_pine = Features.field_243873_bS;
                    mega_pine.field_222737_a.func_241855_a(this.worldGenRegion, (ChunkGenerator)this.chunkGenerator, rand, blockPos, mega_pine.field_222738_b);
                    return true;
                }
                case HugeTaiga2: {
                    ConfiguredFeature mega_spruce = Features.field_243872_bR;
                    mega_spruce.field_222737_a.func_241855_a(this.worldGenRegion, (ChunkGenerator)this.chunkGenerator, rand, blockPos, mega_spruce.field_222738_b);
                    return true;
                }
                case CrimsonFungi: {
                    ConfiguredFeature crimson_fungi = Features.field_243857_bC;
                    crimson_fungi.field_222737_a.func_241855_a(this.worldGenRegion, (ChunkGenerator)this.chunkGenerator, rand, blockPos, (IFeatureConfig)HugeFungusConfig.field_236300_c_);
                    return true;
                }
                case WarpedFungi: {
                    ConfiguredFeature waped_fungi = Features.field_243859_bE;
                    waped_fungi.field_222737_a.func_241855_a(this.worldGenRegion, (ChunkGenerator)this.chunkGenerator, rand, blockPos, (IFeatureConfig)HugeFungusConfig.field_236302_e_);
                    return true;
                }
                case ChorusPlant: {
                    ConfiguredFeature chorus_plant = Features.field_243944_d;
                    chorus_plant.field_222737_a.func_241855_a(this.worldGenRegion, (ChunkGenerator)this.chunkGenerator, rand, blockPos, chorus_plant.field_222738_b);
                    return true;
                }
            }
            throw new RuntimeException("Failed to handle tree of type " + type.toString());
        }
        catch (NullPointerException ex) {
            if (this.logger.getLogCategoryEnabled(LogCategory.DECORATION)) {
                this.logger.log(LogLevel.ERROR, LogCategory.DECORATION, String.format("Treegen caused an error: ", ex.getStackTrace()));
            }
            return true;
        }
    }

    @Override
    public void spawnEntity(IEntityFunction entityData) {
        if (entityData.getY() < 0 || entityData.getY() >= 256) {
            if (this.logger.getLogCategoryEnabled(LogCategory.CUSTOM_OBJECTS)) {
                this.logger.log(LogLevel.ERROR, LogCategory.CUSTOM_OBJECTS, "Failed to spawn mob for Entity() " + entityData.makeString() + ", y position out of bounds");
            }
            return;
        }
        Entity entity = null;
        Optional type1 = EntityType.func_220327_a((String)entityData.getResourceLocation().toString());
        EntityType type2 = null;
        if (!type1.isPresent()) {
            if (this.logger.getLogCategoryEnabled(LogCategory.CUSTOM_OBJECTS)) {
                this.logger.log(LogLevel.ERROR, LogCategory.CUSTOM_OBJECTS, "Could not parse mob for Entity() " + entityData.makeString() + ", mob type could not be found.");
            }
            return;
        }
        type2 = (EntityType)type1.get();
        CompoundNBT nbtTagCompound = null;
        if (entityData.getNameTagOrNBTFileName() != null && (entityData.getNameTagOrNBTFileName().toLowerCase().trim().endsWith(".txt") || entityData.getNameTagOrNBTFileName().toLowerCase().trim().endsWith(".nbt"))) {
            nbtTagCompound = new CompoundNBT();
            if (entityData.getNameTagOrNBTFileName().toLowerCase().trim().endsWith(".txt")) {
                try {
                    nbtTagCompound = JsonToNBT.func_180713_a((String)entityData.getMetaData());
                }
                catch (CommandSyntaxException e) {
                    if (this.logger.getLogCategoryEnabled(LogCategory.CUSTOM_OBJECTS)) {
                        this.logger.log(LogLevel.ERROR, LogCategory.CUSTOM_OBJECTS, "Could not parse nbt for Entity() " + entityData.makeString() + ", file: " + entityData.getNameTagOrNBTFileName());
                    }
                    return;
                }
                nbtTagCompound.func_74778_a("id", entityData.getResourceLocation());
            } else if (entityData.getNBTTag() != null) {
                nbtTagCompound = ForgeNBTHelper.getNMSFromNBTTagCompound(entityData.getNBTTag());
            }
        }
        if (nbtTagCompound == null) {
            try {
                entity = type2.func_200721_a((World)this.worldGenRegion.func_201672_e());
            }
            catch (Exception exception) {
                if (this.logger.getLogCategoryEnabled(LogCategory.CUSTOM_OBJECTS)) {
                    this.logger.log(LogLevel.ERROR, LogCategory.CUSTOM_OBJECTS, "Could not create entity for Entity() " + entityData.makeString() + ", exception: " + exception.getMessage());
                }
                return;
            }
            if (entity == null) {
                if (this.logger.getLogCategoryEnabled(LogCategory.CUSTOM_OBJECTS)) {
                    this.logger.log(LogLevel.ERROR, LogCategory.CUSTOM_OBJECTS, "Could not create entity for Entity() " + entityData.makeString() + ", MC returned null.");
                }
                return;
            }
            entity.func_70012_b(entityData.getX(), (double)entityData.getY(), entityData.getZ(), this.getWorldRandom().nextFloat() * 360.0f, 0.0f);
        } else {
            try {
                entity = EntityType.func_220335_a((CompoundNBT)nbtTagCompound, (World)this.worldGenRegion.func_201672_e(), entity1 -> {
                    entity1.func_70012_b(entityData.getX(), (double)entityData.getY(), entityData.getZ(), this.getWorldRandom().nextFloat() * 360.0f, 0.0f);
                    return entity1;
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (entity == null) {
                if (this.logger.getLogCategoryEnabled(LogCategory.CUSTOM_OBJECTS)) {
                    this.logger.log(LogLevel.ERROR, LogCategory.CUSTOM_OBJECTS, "Could not create entity for Entity() " + entityData.makeString() + ", MC returned null.");
                }
                return;
            }
        }
        for (int r = 0; r < entityData.getGroupSize(); ++r) {
            if (r != 0) {
                if (nbtTagCompound == null) {
                    try {
                        entity = type2.func_200721_a((World)this.worldGenRegion.func_201672_e());
                    }
                    catch (Exception exception) {
                        return;
                    }
                    if (entity == null) {
                        return;
                    }
                    entity.func_70012_b(entityData.getX(), (double)entityData.getY(), entityData.getZ(), this.getWorldRandom().nextFloat() * 360.0f, 0.0f);
                } else {
                    entity = EntityType.func_220335_a((CompoundNBT)nbtTagCompound, (World)this.worldGenRegion.func_201672_e(), entity1 -> {
                        entity1.func_70012_b(entityData.getX(), (double)entityData.getY(), entityData.getZ(), this.getWorldRandom().nextFloat() * 360.0f, 0.0f);
                        return entity1;
                    });
                }
                if (entity == null) {
                    return;
                }
            }
            if (!(entity instanceof MobEntity)) continue;
            ForgeMaterialData block = ForgeMaterialData.ofBlockState(this.worldGenRegion.func_180495_p(new BlockPos(entityData.getX(), (double)entityData.getY(), entityData.getZ())));
            if (((LocalMaterialData)block).isSolid() || (entity.getClassification(false) == EntityClassification.WATER_CREATURE || entity instanceof GuardianEntity) && !((LocalMaterialData)block).isLiquid()) {
                if (!this.logger.getLogCategoryEnabled(LogCategory.CUSTOM_OBJECTS)) continue;
                this.logger.log(LogLevel.ERROR, LogCategory.CUSTOM_OBJECTS, "Could not spawn entity at " + entityData.getX() + " " + entityData.getY() + " " + entityData.getZ() + " for Entity() " + entityData.makeString() + ", a solid block was found or a water mob tried to spawn outside of water.");
                continue;
            }
            MobEntity mobentity = (MobEntity)entity;
            if (ForgeHooks.canEntitySpawn((MobEntity)mobentity, (IWorld)this.worldGenRegion, (double)entityData.getX(), (double)entityData.getY(), (double)entityData.getZ(), null, (SpawnReason)SpawnReason.CHUNK_GENERATION) == -1) {
                if (!this.logger.getLogCategoryEnabled(LogCategory.CUSTOM_OBJECTS)) continue;
                this.logger.log(LogLevel.ERROR, LogCategory.CUSTOM_OBJECTS, "Forge prevented spawning for Entity() " + entityData.makeString() + ", a mod or setting is likely preventing mob spawns.");
                continue;
            }
            String nameTag = entityData.getNameTagOrNBTFileName();
            if (nameTag != null && !nameTag.toLowerCase().trim().endsWith(".txt") && !nameTag.toLowerCase().trim().endsWith(".nbt")) {
                entity.func_200203_b((ITextComponent)new StringTextComponent(nameTag));
            }
            mobentity.func_110163_bv();
            ILivingEntityData ilivingentitydata = null;
            ilivingentitydata = mobentity.func_213386_a((IServerWorld)this.worldGenRegion, this.worldGenRegion.func_175649_E(new BlockPos(entityData.getX(), (double)entityData.getY(), entityData.getZ())), SpawnReason.CHUNK_GENERATION, ilivingentitydata, nbtTagCompound);
            this.worldGenRegion.func_242417_l((Entity)mobentity);
        }
    }

    @Override
    public void placeDungeon(Random random, int x, int y, int z) {
        Feature.field_202282_ab.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_242765_a(this.worldGenRegion, (ChunkGenerator)this.chunkGenerator, random, new BlockPos(x, y, z));
    }

    @Override
    public void placeFossil(Random random, int x, int y, int z) {
        Feature.field_202316_P.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_242765_a(this.worldGenRegion, (ChunkGenerator)this.chunkGenerator, random, new BlockPos(x, y, z));
    }

    @Override
    public boolean isInsideWorldBorder(ChunkCoordinate chunkCoordinate) {
        return true;
    }

    public void setBlockState(BlockPos blockpos, BlockState blockstate1, int i) {
        this.worldGenRegion.func_180501_a(blockpos, blockstate1, i);
    }

    public BlockState getBlockState(BlockPos blockPos) {
        return this.worldGenRegion.func_180495_p(blockPos);
    }

    @Override
    public LocalMaterialData getMaterialWithoutLoading(int x, int y, int z) {
        if (y >= 256 || y < 0) {
            return null;
        }
        ChunkCoordinate chunkCoord = ChunkCoordinate.fromBlockCoords(x, z);
        IChunk chunk = null;
        if (this.decorationArea != null && this.decorationArea.isInAreaBeingDecorated(x, z)) {
            IChunk iChunk = chunk = this.worldGenRegion.func_217354_b(chunkCoord.getChunkX(), chunkCoord.getChunkZ()) ? this.worldGenRegion.func_212866_a_(chunkCoord.getChunkX(), chunkCoord.getChunkZ()) : null;
        }
        if (chunk == null || !chunk.func_201589_g().func_209003_a(ChunkStatus.field_222612_h)) {
            return this.chunkGenerator.getMaterialInUnloadedChunk(this.getWorldRandom(), x, y, z);
        }
        int internalX = x & 0xF;
        int internalZ = z & 0xF;
        return ForgeMaterialData.ofBlockState(chunk.func_180495_p(new BlockPos(internalX, y, internalZ)));
    }

    @Override
    public int getHighestBlockYAtWithoutLoading(int x, int z, boolean findSolid, boolean findLiquid, boolean ignoreLiquid, boolean ignoreSnow, boolean ignoreLeaves) {
        ChunkCoordinate chunkCoord = ChunkCoordinate.fromBlockCoords(x, z);
        IChunk chunk = null;
        if (this.decorationArea != null && this.decorationArea.isInAreaBeingDecorated(x, z)) {
            IChunk iChunk = chunk = this.worldGenRegion.func_217354_b(chunkCoord.getChunkX(), chunkCoord.getChunkZ()) ? this.worldGenRegion.func_212866_a_(chunkCoord.getChunkX(), chunkCoord.getChunkZ()) : null;
        }
        if (chunk == null || !chunk.func_201589_g().func_209003_a(ChunkStatus.field_222612_h)) {
            return this.chunkGenerator.getHighestBlockYInUnloadedChunk(this.getWorldRandom(), x, z, findSolid, findLiquid, ignoreLiquid, ignoreSnow);
        }
        int internalX = x & 0xF;
        int internalZ = z & 0xF;
        int heightMapy = chunk.func_201576_a(Heightmap.Type.WORLD_SURFACE_WG, internalX, internalZ);
        return this.getHighestBlockYAt(chunk, internalX, heightMapy, internalZ, findSolid, findLiquid, ignoreLiquid, ignoreSnow, ignoreLeaves);
    }

    @Override
    public boolean chunkHasDefaultStructure(Random worldRandom, ChunkCoordinate chunkCoordinate) {
        Boolean hasDefaultStructure = (Boolean)this.cachedHasDefaultStructureChunks.get(chunkCoordinate);
        if (hasDefaultStructure != null) {
            return hasDefaultStructure;
        }
        hasDefaultStructure = this.chunkGenerator.checkHasVanillaStructureWithoutLoading(this.worldGenRegion.func_201672_e(), chunkCoordinate);
        this.cachedHasDefaultStructureChunks.put(chunkCoordinate, new Boolean(hasDefaultStructure));
        return hasDefaultStructure;
    }
}

