/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.gen;

import com.google.gson.JsonSyntaxException;
import com.pg85.otg.forge.gen.ForgeWorldGenRegion;
import com.pg85.otg.forge.materials.ForgeMaterialData;
import com.pg85.otg.forge.util.ForgeNBTHelper;
import com.pg85.otg.interfaces.IBiome;
import com.pg85.otg.interfaces.IBiomeConfig;
import com.pg85.otg.interfaces.IWorldConfig;
import com.pg85.otg.util.ChunkCoordinate;
import com.pg85.otg.util.biome.ReplaceBlockMatrix;
import com.pg85.otg.util.logging.LogCategory;
import com.pg85.otg.util.logging.LogLevel;
import com.pg85.otg.util.materials.LocalMaterialData;
import com.pg85.otg.util.minecraft.TreeType;
import com.pg85.otg.util.nbt.NamedBinaryTag;
import java.text.MessageFormat;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.Heightmap;
import org.apache.commons.lang3.NotImplementedException;

public class MCWorldGenRegion
extends ForgeWorldGenRegion {
    public MCWorldGenRegion(String presetFolderName, IWorldConfig worldConfig, ISeedReader worldGenRegion) {
        super(presetFolderName, worldConfig, worldGenRegion);
    }

    @Override
    public IBiome getBiomeForDecoration(int worldX, int worldZ) {
        throw new NotImplementedException("This method is not available for non-OTG worlds, you're trying to use an unsupported feature.");
    }

    @Override
    public IBiomeConfig getBiomeConfigForDecoration(int worldX, int worldZ) {
        throw new NotImplementedException("This method is not available for non-OTG worlds, you're trying to use an unsupported feature.");
    }

    @Override
    public double getBiomeBlocksNoiseValue(int blockX, int blockZ) {
        throw new NotImplementedException("This method is not available for non-OTG worlds, you're trying to use an unsupported feature.");
    }

    @Override
    public LocalMaterialData getMaterial(int x, int y, int z) {
        IChunk chunk;
        if (y >= 256 || y < 0) {
            return null;
        }
        ChunkCoordinate chunkCoord = ChunkCoordinate.fromBlockCoords(x, z);
        IChunk iChunk = chunk = this.worldGenRegion.func_217354_b(chunkCoord.getChunkX(), chunkCoord.getChunkZ()) ? this.worldGenRegion.func_212866_a_(chunkCoord.getChunkX(), chunkCoord.getChunkZ()) : null;
        if (chunk == null || !chunk.func_201589_g().func_209003_a(ChunkStatus.field_222612_h)) {
            return null;
        }
        int internalX = x & 0xF;
        int internalZ = z & 0xF;
        return ForgeMaterialData.ofBlockState(chunk.func_180495_p(new BlockPos(internalX, y, internalZ)));
    }

    @Override
    public int getHighestBlockYAt(int x, int z, boolean findSolid, boolean findLiquid, boolean ignoreLiquid, boolean ignoreSnow, boolean ignoreLeaves) {
        IChunk chunk;
        ChunkCoordinate chunkCoord = ChunkCoordinate.fromBlockCoords(x, z);
        IChunk iChunk = chunk = this.worldGenRegion.func_217354_b(chunkCoord.getChunkX(), chunkCoord.getChunkZ()) ? this.worldGenRegion.func_212866_a_(chunkCoord.getChunkX(), chunkCoord.getChunkZ()) : null;
        if (chunk == null || !chunk.func_201589_g().func_209003_a(ChunkStatus.field_222612_h)) {
            return -1;
        }
        int internalX = x & 0xF;
        int internalZ = z & 0xF;
        int heightMapy = chunk.func_201576_a(Heightmap.Type.WORLD_SURFACE, internalX, internalZ);
        return this.getHighestBlockYAt(chunk, internalX, heightMapy, internalZ, findSolid, findLiquid, ignoreLiquid, ignoreSnow, ignoreLeaves);
    }

    @Override
    public void setBlock(int x, int y, int z, LocalMaterialData material, NamedBinaryTag nbt, ReplaceBlockMatrix replaceBlocksMatrix) {
        if (y < 0 || y >= 256) {
            return;
        }
        if (material.isEmpty()) {
            return;
        }
        BlockPos pos = new BlockPos(x, y, z);
        this.worldGenRegion.func_180501_a(pos, ((ForgeMaterialData)material).internalBlock(), 18);
        if (material.isLiquid()) {
            this.worldGenRegion.func_205219_F_().func_205360_a(pos, (Object)((ForgeMaterialData)material).internalBlock().func_204520_s().func_206886_c(), 0);
        }
        if (nbt != null) {
            this.attachNBT(x, y, z, nbt, this.worldGenRegion.func_180495_p(pos));
        }
    }

    private void attachNBT(int x, int y, int z, NamedBinaryTag nbt, BlockState state) {
        CompoundNBT nms = ForgeNBTHelper.getNMSFromNBTTagCompound(nbt);
        nms.func_218657_a("x", (INBT)IntNBT.func_229692_a_((int)x));
        nms.func_218657_a("y", (INBT)IntNBT.func_229692_a_((int)y));
        nms.func_218657_a("z", (INBT)IntNBT.func_229692_a_((int)z));
        TileEntity tileEntity = this.worldGenRegion.func_175625_s(new BlockPos(x, y, z));
        if (tileEntity != null) {
            try {
                tileEntity.deserializeNBT(state, nms);
            }
            catch (JsonSyntaxException e) {
                if (this.logger.getLogCategoryEnabled(LogCategory.CUSTOM_OBJECTS)) {
                    this.logger.log(LogLevel.ERROR, LogCategory.CUSTOM_OBJECTS, MessageFormat.format("Badly formatted json for tile entity with id '{0}' at {1},{2},{3}", nms.func_74779_i("id"), x, y, z));
                }
            }
        } else if (this.logger.getLogCategoryEnabled(LogCategory.CUSTOM_OBJECTS)) {
            this.logger.log(LogLevel.ERROR, LogCategory.CUSTOM_OBJECTS, MessageFormat.format("Skipping tile entity with id {0}, cannot be placed at {1},{2},{3}", nms.func_74779_i("id"), x, y, z));
        }
    }

    @Override
    public boolean placeTree(TreeType type, Random rand, int x, int y, int z) {
        throw new NotImplementedException("This method is not available for non-OTG worlds, you're trying to use an unsupported feature.");
    }

    @Override
    public void placeDungeon(Random random, int x, int y, int z) {
        throw new NotImplementedException("This method is not available for non-OTG worlds, you're trying to use an unsupported feature.");
    }

    @Override
    public void placeFossil(Random random, int x, int y, int z) {
        throw new NotImplementedException("This method is not available for non-OTG worlds, you're trying to use an unsupported feature.");
    }

    @Override
    public LocalMaterialData getMaterialWithoutLoading(int x, int y, int z) {
        throw new NotImplementedException("This method is not available for non-OTG worlds, you're trying to use an unsupported feature.");
    }

    @Override
    public int getHighestBlockYAtWithoutLoading(int x, int z, boolean findSolid, boolean findLiquid, boolean ignoreLiquid, boolean ignoreSnow, boolean ignoreLeaves) {
        throw new NotImplementedException("This method is not available for non-OTG worlds, you're trying to use an unsupported feature.");
    }

    @Override
    public boolean chunkHasDefaultStructure(Random worldRandom, ChunkCoordinate chunkCoordinate) {
        throw new NotImplementedException("This method is not available for non-OTG worlds, you're trying to use an unsupported feature.");
    }
}

