/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.gen;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.pg85.otg.OTG;
import com.pg85.otg.config.dimensions.DimensionConfig;
import com.pg85.otg.constants.SettingsEnums;
import com.pg85.otg.customobject.structures.CustomStructureCache;
import com.pg85.otg.exceptions.InvalidConfigException;
import com.pg85.otg.forge.biome.ForgeBiome;
import com.pg85.otg.forge.biome.OTGBiomeProvider;
import com.pg85.otg.forge.gen.ForgeChunkBuffer;
import com.pg85.otg.forge.gen.ForgeWorldGenRegion;
import com.pg85.otg.forge.gen.ShadowChunkGenerator;
import com.pg85.otg.forge.materials.ForgeMaterialData;
import com.pg85.otg.forge.presets.ForgePresetLoader;
import com.pg85.otg.gen.OTGChunkDecorator;
import com.pg85.otg.gen.OTGChunkGenerator;
import com.pg85.otg.interfaces.IBiome;
import com.pg85.otg.interfaces.ICachedBiomeProvider;
import com.pg85.otg.interfaces.ILayerSource;
import com.pg85.otg.interfaces.IMaterialReader;
import com.pg85.otg.interfaces.IWorldConfig;
import com.pg85.otg.presets.Preset;
import com.pg85.otg.util.ChunkCoordinate;
import com.pg85.otg.util.gen.ChunkBuffer;
import com.pg85.otg.util.gen.JigsawStructureData;
import com.pg85.otg.util.materials.LocalMaterialData;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.ReportedException;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.SectionPos;
import net.minecraft.world.Blockreader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.DimensionSettings;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.NoiseChunkGenerator;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraft.world.gen.carver.ConfiguredCarver;
import net.minecraft.world.gen.feature.jigsaw.JigsawJunction;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.structure.AbstractVillagePiece;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import net.minecraft.world.gen.settings.StructureSpreadSettings;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.FolderName;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public final class OTGNoiseChunkGenerator
extends NoiseChunkGenerator {
    public static final Codec<OTGNoiseChunkGenerator> CODEC = RecordCodecBuilder.create(p_236091_0_ -> p_236091_0_.group((App)Codec.STRING.fieldOf("preset_folder_name").forGetter(p_236090_0_ -> p_236090_0_.preset.getFolderName()), (App)Codec.STRING.fieldOf("dim_config_name").forGetter(p_236090_0_ -> p_236090_0_.dimConfigName), (App)BiomeProvider.field_235202_a_.fieldOf("biome_source").forGetter(p_236096_0_ -> p_236096_0_.field_222542_c), (App)Codec.LONG.fieldOf("seed").stable().forGetter(p_236093_0_ -> p_236093_0_.field_236084_w_), (App)DimensionSettings.field_236098_b_.fieldOf("settings").forGetter(p_236090_0_ -> p_236090_0_.field_236080_h_)).apply((Applicative)p_236091_0_, p_236091_0_.stable(OTGNoiseChunkGenerator::new)));
    private final ShadowChunkGenerator shadowChunkGenerator;
    private final OTGChunkGenerator internalGenerator;
    private final OTGChunkDecorator chunkDecorator;
    private final Preset preset;
    private final String dimConfigName;
    private final DimensionConfig dimConfig;
    private CustomStructureCache structureCache;
    private boolean portalDataProcessed = false;
    private List<LocalMaterialData> portalBlocks;
    private String portalColor;
    private String portalMob;
    private String portalIgnitionSource;

    public OTGNoiseChunkGenerator(BiomeProvider biomeProvider, long seed, Supplier<DimensionSettings> dimensionSettingsSupplier) {
        this(OTG.getEngine().getPresetLoader().getDefaultPresetFolderName(), null, biomeProvider, biomeProvider, seed, dimensionSettingsSupplier);
    }

    public OTGNoiseChunkGenerator(String presetFolderName, String dimConfigName, BiomeProvider biomeProvider, long seed, Supplier<DimensionSettings> dimensionSettingsSupplier) {
        this(presetFolderName, dimConfigName, biomeProvider, biomeProvider, seed, dimensionSettingsSupplier);
    }

    private OTGNoiseChunkGenerator(String presetFolderName, String dimConfigName, BiomeProvider biomeProvider1, BiomeProvider biomeProvider2, long seed, Supplier<DimensionSettings> dimensionSettingsSupplier) {
        super(biomeProvider1, biomeProvider2, seed, OTGNoiseChunkGenerator.overrideStructureSettings(dimensionSettingsSupplier.get(), presetFolderName));
        if (!(biomeProvider1 instanceof ILayerSource)) {
            throw new RuntimeException("OTG has detected an incompatible biome provider- try using otg:otg as the biome source name");
        }
        this.preset = OTG.getEngine().getPresetLoader().getPresetByFolderName(presetFolderName);
        if (dimConfigName != null && dimConfigName.trim().length() > 0) {
            this.dimConfigName = dimConfigName;
            this.dimConfig = DimensionConfig.fromDisk(this.dimConfigName);
        } else {
            this.dimConfigName = "";
            this.dimConfig = null;
        }
        this.shadowChunkGenerator = new ShadowChunkGenerator(OTG.getEngine().getPluginConfig().getMaxWorkerThreads());
        this.internalGenerator = new OTGChunkGenerator(this.preset, seed, (ILayerSource)biomeProvider1, ((ForgePresetLoader)OTG.getEngine().getPresetLoader()).getGlobalIdMapping(presetFolderName), OTG.getEngine().getLogger());
        this.chunkDecorator = new OTGChunkDecorator();
    }

    private static Supplier<DimensionSettings> overrideStructureSettings(DimensionSettings oldSettings, String presetFolderName) {
        DimensionStructuresSettings newSettings;
        Preset preset = OTG.getEngine().getPresetLoader().getPresetByFolderName(presetFolderName);
        IWorldConfig worldConfig = preset.getWorldConfig();
        ImmutableMap.Builder separationSettings = ImmutableMap.builder();
        if (worldConfig.getVillagesEnabled()) {
            separationSettings.put((Object)Structure.field_236381_q_, (Object)new StructureSeparationSettings(worldConfig.getVillageSpacing(), worldConfig.getVillageSeparation(), 10387312));
        }
        if (worldConfig.getRareBuildingsEnabled()) {
            separationSettings.put((Object)Structure.field_236370_f_, (Object)new StructureSeparationSettings(worldConfig.getDesertPyramidSpacing(), worldConfig.getDesertPyramidSeparation(), 14357617));
        }
        if (worldConfig.getRareBuildingsEnabled()) {
            separationSettings.put((Object)Structure.field_236371_g_, (Object)new StructureSeparationSettings(worldConfig.getIglooSpacing(), worldConfig.getIglooSeparation(), 14357618));
        }
        if (worldConfig.getRareBuildingsEnabled()) {
            separationSettings.put((Object)Structure.field_236369_e_, (Object)new StructureSeparationSettings(worldConfig.getJungleTempleSpacing(), worldConfig.getJungleTempleSeparation(), 14357619));
        }
        if (worldConfig.getRareBuildingsEnabled()) {
            separationSettings.put((Object)Structure.field_236374_j_, (Object)new StructureSeparationSettings(worldConfig.getSwampHutSpacing(), worldConfig.getSwampHutSeparation(), 14357620));
        }
        if (worldConfig.getPillagerOutpostsEnabled()) {
            separationSettings.put((Object)Structure.field_236366_b_, (Object)new StructureSeparationSettings(worldConfig.getPillagerOutpostSpacing(), worldConfig.getPillagerOutpostSeparation(), 165745296));
        }
        if (worldConfig.getStrongholdsEnabled()) {
            separationSettings.put((Object)Structure.field_236375_k_, (Object)new StructureSeparationSettings(worldConfig.getStrongholdSpacing(), worldConfig.getStrongholdSeparation(), 0));
        }
        if (worldConfig.getOceanMonumentsEnabled()) {
            separationSettings.put((Object)Structure.field_236376_l_, (Object)new StructureSeparationSettings(worldConfig.getOceanMonumentSpacing(), worldConfig.getOceanMonumentSeparation(), 10387313));
        }
        if (worldConfig.getEndCitiesEnabled()) {
            separationSettings.put((Object)Structure.field_236379_o_, (Object)new StructureSeparationSettings(worldConfig.getEndCitySpacing(), worldConfig.getEndCitySeparation(), 10387313));
        }
        if (worldConfig.getWoodlandMansionsEnabled()) {
            separationSettings.put((Object)Structure.field_236368_d_, (Object)new StructureSeparationSettings(worldConfig.getWoodlandMansionSpacing(), worldConfig.getWoodlandMansionSeparation(), 10387319));
        }
        if (worldConfig.getBuriedTreasureEnabled()) {
            separationSettings.put((Object)Structure.field_236380_p_, (Object)new StructureSeparationSettings(worldConfig.getBuriedTreasureSpacing(), worldConfig.getBuriedTreasureSeparation(), 0));
        }
        if (worldConfig.getMineshaftsEnabled()) {
            separationSettings.put((Object)Structure.field_236367_c_, (Object)new StructureSeparationSettings(worldConfig.getMineshaftSpacing(), worldConfig.getMineshaftSeparation(), 0));
        }
        if (worldConfig.getRuinedPortalsEnabled()) {
            separationSettings.put((Object)Structure.field_236372_h_, (Object)new StructureSeparationSettings(worldConfig.getRuinedPortalSpacing(), worldConfig.getRuinedPortalSeparation(), 34222645));
        }
        if (worldConfig.getShipWrecksEnabled()) {
            separationSettings.put((Object)Structure.field_236373_i_, (Object)new StructureSeparationSettings(worldConfig.getShipwreckSpacing(), worldConfig.getShipwreckSeparation(), 165745295));
        }
        if (worldConfig.getOceanRuinsEnabled()) {
            separationSettings.put((Object)Structure.field_236377_m_, (Object)new StructureSeparationSettings(worldConfig.getOceanRuinSpacing(), worldConfig.getOceanRuinSeparation(), 14357621));
        }
        if (worldConfig.getBastionRemnantsEnabled()) {
            separationSettings.put((Object)Structure.field_236383_s_, (Object)new StructureSeparationSettings(worldConfig.getBastionRemnantSpacing(), worldConfig.getBastionRemnantSeparation(), 30084232));
        }
        if (worldConfig.getNetherFortressesEnabled()) {
            separationSettings.put((Object)Structure.field_236378_n_, (Object)new StructureSeparationSettings(worldConfig.getNetherFortressSpacing(), worldConfig.getNetherFortressSeparation(), 30084232));
        }
        if (worldConfig.getNetherFossilsEnabled()) {
            separationSettings.put((Object)Structure.field_236382_r_, (Object)new StructureSeparationSettings(worldConfig.getNetherFossilSpacing(), worldConfig.getNetherFossilSeparation(), 14357921));
        }
        separationSettings.putAll(oldSettings.func_236108_a_().func_236195_a_().entrySet().stream().filter(a -> a.getKey() != Structure.field_236381_q_ && a.getKey() != Structure.field_236370_f_ && a.getKey() != Structure.field_236371_g_ && a.getKey() != Structure.field_236369_e_ && a.getKey() != Structure.field_236374_j_ && a.getKey() != Structure.field_236366_b_ && a.getKey() != Structure.field_236375_k_ && a.getKey() != Structure.field_236376_l_ && a.getKey() != Structure.field_236379_o_ && a.getKey() != Structure.field_236368_d_ && a.getKey() != Structure.field_236380_p_ && a.getKey() != Structure.field_236367_c_ && a.getKey() != Structure.field_236372_h_ && a.getKey() != Structure.field_236373_i_ && a.getKey() != Structure.field_236377_m_ && a.getKey() != Structure.field_236383_s_ && a.getKey() != Structure.field_236378_n_ && a.getKey() != Structure.field_236382_r_).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        oldSettings.field_236099_c_ = newSettings = new DimensionStructuresSettings(worldConfig.getStrongholdsEnabled() ? Optional.of(new StructureSpreadSettings(worldConfig.getStrongHoldDistance(), worldConfig.getStrongHoldSpread(), worldConfig.getStrongHoldCount())) : Optional.empty(), (Map)Maps.newHashMap((Map)separationSettings.build()));
        return () -> oldSettings;
    }

    public ICachedBiomeProvider getCachedBiomeProvider() {
        return this.internalGenerator.getCachedBiomeProvider();
    }

    public void saveStructureCache() {
        if (this.chunkDecorator.getIsSaveRequired() && this.structureCache != null) {
            this.structureCache.saveToDisk(OTG.getEngine().getLogger(), this.chunkDecorator);
        }
    }

    public Preset getPreset() {
        return this.preset;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ChunkGenerator func_230349_a_(long seed) {
        return new OTGNoiseChunkGenerator(this.preset.getFolderName(), this.dimConfigName, this.field_222542_c.func_230320_a_(seed), seed, this.field_236080_h_);
    }

    public int func_230356_f_() {
        return this.preset.getWorldConfig().getWaterLevelMax();
    }

    public void func_230352_b_(IWorld world, StructureManager manager, IChunk chunk) {
        ChunkCoordinate chunkCoord = ChunkCoordinate.fromChunkCoords(chunk.func_76632_l().field_77276_a, chunk.func_76632_l().field_77275_b);
        this.shadowChunkGenerator.queueChunksForWorkerThreads((WorldGenRegion)world, manager, chunk, (ChunkGenerator)this, (OTGBiomeProvider)this.field_222542_c, this.internalGenerator, this.func_235957_b_(), this.preset.getWorldConfig().getWorldHeightCap());
        ForgeChunkBuffer buffer = new ForgeChunkBuffer((ChunkPrimer)chunk);
        IChunk cachedChunk = this.shadowChunkGenerator.getChunkWithWait(chunkCoord);
        if (cachedChunk != null) {
            this.shadowChunkGenerator.fillWorldGenChunkFromShadowChunk(chunk, cachedChunk);
        } else {
            ObjectArrayList structures = new ObjectArrayList(10);
            ObjectArrayList junctions = new ObjectArrayList(32);
            ChunkPos pos = chunk.func_76632_l();
            int chunkX = pos.field_77276_a;
            int chunkZ = pos.field_77275_b;
            int startX = chunkX << 4;
            int startZ = chunkZ << 4;
            for (Structure structure : Structure.field_236384_t_) {
                manager.func_235011_a_(SectionPos.func_218156_a((ChunkPos)pos, (int)0), structure).forEach(arg_0 -> OTGNoiseChunkGenerator.lambda$fillFromNoise$8(pos, (ObjectList)structures, startX, startZ, (ObjectList)junctions, arg_0));
            }
            this.internalGenerator.populateNoise(this.preset.getWorldConfig().getWorldHeightCap(), world.func_201674_k(), buffer, ((ChunkBuffer)buffer).getChunkCoordinate(), (ObjectList<JigsawStructureData>)structures, (ObjectList<JigsawStructureData>)junctions);
            this.shadowChunkGenerator.setChunkGenerated(chunkCoord);
        }
    }

    public void func_225551_a_(WorldGenRegion worldGenRegion, IChunk chunk) {
        ChunkPos chunkpos = chunk.func_76632_l();
        int i = chunkpos.field_77276_a;
        int j = chunkpos.field_77275_b;
        SharedSeedRandom sharedseedrandom = new SharedSeedRandom();
        sharedseedrandom.func_202422_a(i, j);
        ChunkPos chunkpos1 = chunk.func_76632_l();
        int chunkMinX = chunkpos1.func_180334_c();
        int chunkMinZ = chunkpos1.func_180333_d();
        IBiome[] biomesForChunk = this.internalGenerator.getCachedBiomeProvider().getBiomesForChunk(ChunkCoordinate.fromBlockCoords(chunkMinX, chunkMinZ));
        for (int xInChunk = 0; xInChunk < 16; ++xInChunk) {
            for (int zInChunk = 0; zInChunk < 16; ++zInChunk) {
                int worldX = chunkMinX + xInChunk;
                int worldZ = chunkMinZ + zInChunk;
                IBiome biome = biomesForChunk[xInChunk * 16 + zInChunk];
                if (!biome.getBiomeConfig().getIsTemplateForBiome()) continue;
                int i2 = chunk.func_201576_a(Heightmap.Type.WORLD_SURFACE_WG, xInChunk, zInChunk) + 1;
                double d1 = this.field_222571_r.func_215460_a((double)worldX * 0.0625, (double)worldZ * 0.0625, 0.0625, (double)xInChunk * 0.0625) * 15.0;
                ((ForgeBiome)biome).getBiomeBase().func_206854_a((Random)sharedseedrandom, chunk, worldX, worldZ, i2, d1, ((ForgeMaterialData)biome.getBiomeConfig().getDefaultStoneBlock()).internalBlock(), ((ForgeMaterialData)biome.getBiomeConfig().getDefaultWaterBlock()).internalBlock(), this.func_230356_f_(), worldGenRegion.func_72905_C());
            }
        }
    }

    public void func_230350_a_(long seed, BiomeManager biomeManager, IChunk chunk, GenerationStage.Carving stage) {
        if (stage == GenerationStage.Carving.AIR) {
            boolean ravinesEnabled;
            ForgeBiome biome = (ForgeBiome)this.getCachedBiomeProvider().getNoiseBiome(chunk.func_76632_l().field_77276_a << 2, chunk.func_76632_l().field_77275_b << 2);
            BiomeGenerationSettings biomegenerationsettings = biome.getBiomeBase().func_242440_e();
            List list = biomegenerationsettings.func_242489_a(stage);
            List<String> defaultCaves = Arrays.asList("minecraft:cave", "minecraft:underwater_cave", "minecraft:nether_cave");
            boolean cavesEnabled = this.preset.getWorldConfig().getCavesEnabled() && list.stream().anyMatch(a -> defaultCaves.stream().anyMatch(arg_0 -> OTGNoiseChunkGenerator.lambda$null$9((Supplier)a, arg_0)));
            List<String> defaultRavines = Arrays.asList("minecraft:canyon", "minecraft:underwater_canyon");
            boolean bl = ravinesEnabled = this.preset.getWorldConfig().getRavinesEnabled() && list.stream().anyMatch(a -> defaultRavines.stream().anyMatch(arg_0 -> OTGNoiseChunkGenerator.lambda$null$11((Supplier)a, arg_0)));
            if (cavesEnabled || ravinesEnabled) {
                ChunkPrimer protoChunk = (ChunkPrimer)chunk;
                ForgeChunkBuffer chunkBuffer = new ForgeChunkBuffer(protoChunk);
                BitSet carvingMask = protoChunk.func_230345_b_(stage);
                this.internalGenerator.carve(chunkBuffer, seed, protoChunk.func_76632_l().field_77276_a, protoChunk.func_76632_l().field_77275_b, carvingMask, cavesEnabled, ravinesEnabled);
            }
        }
        this.applyNonOTGCarvers(seed, biomeManager, chunk, stage);
    }

    public void applyNonOTGCarvers(long seed, BiomeManager biomeManager, IChunk chunk, GenerationStage.Carving stage) {
        BiomeManager biomemanager = biomeManager.func_226835_a_(this.field_222542_c);
        SharedSeedRandom sharedseedrandom = new SharedSeedRandom();
        ChunkPos chunkpos = chunk.func_76632_l();
        int j = chunkpos.field_77276_a;
        int k = chunkpos.field_77275_b;
        ForgeBiome biome = (ForgeBiome)this.getCachedBiomeProvider().getNoiseBiome(chunk.func_76632_l().field_77276_a << 2, chunk.func_76632_l().field_77275_b << 2);
        BiomeGenerationSettings biomegenerationsettings = biome.getBiomeBase().func_242440_e();
        BitSet bitset = ((ChunkPrimer)chunk).func_230345_b_(stage);
        List<String> defaultCavesAndRavines = Arrays.asList("minecraft:cave", "minecraft:underwater_cave", "minecraft:nether_cave", "minecraft:canyon", "minecraft:underwater_canyon");
        for (int l = j - 8; l <= j + 8; ++l) {
            for (int i1 = k - 8; i1 <= k + 8; ++i1) {
                List list = biomegenerationsettings.func_242489_a(stage);
                ListIterator listiterator = list.listIterator();
                while (listiterator.hasNext()) {
                    int j1 = listiterator.nextIndex();
                    ConfiguredCarver configuredcarver = (ConfiguredCarver)((Supplier)listiterator.next()).get();
                    String carverRegistryName = ForgeRegistries.WORLD_CARVERS.getKey((IForgeRegistryEntry)configuredcarver.field_222732_a).toString();
                    if (!defaultCavesAndRavines.stream().noneMatch(a -> a.equals(carverRegistryName))) continue;
                    sharedseedrandom.func_202425_c(seed + (long)j1, l, i1);
                    if (!configuredcarver.func_222730_a((Random)sharedseedrandom, l, i1)) continue;
                    configuredcarver.func_227207_a_(chunk, arg_0 -> ((BiomeManager)biomemanager).func_226836_a_(arg_0), (Random)sharedseedrandom, this.func_230356_f_(), l, i1, j, k, bitset);
                }
            }
        }
    }

    public void func_230351_a_(WorldGenRegion worldGenRegion, StructureManager structureManager) {
        if (!OTG.getEngine().getPluginConfig().getDecorationEnabled()) {
            return;
        }
        int worldX = worldGenRegion.func_201679_a() * 16;
        int worldZ = worldGenRegion.func_201680_b() * 16;
        BlockPos blockpos = new BlockPos(worldX, 0, worldZ);
        SharedSeedRandom sharedseedrandom = new SharedSeedRandom();
        long decorationSeed = sharedseedrandom.func_202424_a(worldGenRegion.func_72905_C(), worldX, worldZ);
        ChunkCoordinate chunkBeingDecorated = ChunkCoordinate.fromBlockCoords(worldX, worldZ);
        ForgeWorldGenRegion forgeWorldGenRegion = new ForgeWorldGenRegion(this.preset.getFolderName(), this.preset.getWorldConfig(), worldGenRegion, this);
        IBiome biome = this.internalGenerator.getCachedBiomeProvider().getNoiseBiome((worldGenRegion.func_201679_a() << 2) + 2, (worldGenRegion.func_201680_b() << 2) + 2);
        IBiome biome1 = this.internalGenerator.getCachedBiomeProvider().getNoiseBiome(worldGenRegion.func_201679_a() << 2, worldGenRegion.func_201680_b() << 2);
        IBiome biome2 = this.internalGenerator.getCachedBiomeProvider().getNoiseBiome(worldGenRegion.func_201679_a() << 2, (worldGenRegion.func_201680_b() << 2) + 4);
        IBiome biome3 = this.internalGenerator.getCachedBiomeProvider().getNoiseBiome((worldGenRegion.func_201679_a() << 2) + 4, worldGenRegion.func_201680_b() << 2);
        IBiome biome4 = this.internalGenerator.getCachedBiomeProvider().getNoiseBiome((worldGenRegion.func_201679_a() << 2) + 4, (worldGenRegion.func_201680_b() << 2) + 4);
        Path worldSaveFolder = worldGenRegion.func_201672_e().func_73046_m().func_240776_a_(FolderName.field_237247_c_).getParent();
        if (!this.getPreset().getWorldConfig().improvedBorderDecoration()) {
            ArrayList<IBiome> biomes = new ArrayList<IBiome>();
            biomes.add(biome);
            biomes.add(biome1);
            biomes.add(biome2);
            biomes.add(biome3);
            biomes.add(biome4);
            HashMap<IBiome, Integer> map = new HashMap<IBiome, Integer>();
            Iterator iterator = biomes.iterator();
            while (iterator.hasNext()) {
                IBiome b;
                Integer val = (Integer)map.get(b = (IBiome)iterator.next());
                map.put(b, val == null ? 1 : val + 1);
            }
            Map.Entry max = null;
            for (Map.Entry ent : map.entrySet()) {
                if (max != null && (Integer)ent.getValue() <= (Integer)max.getValue()) continue;
                max = ent;
            }
            biome = (IBiome)max.getKey();
        }
        try {
            ArrayList<Integer> alreadyDecorated = new ArrayList<Integer>();
            this.chunkDecorator.decorate(this.preset.getFolderName(), chunkBeingDecorated, forgeWorldGenRegion, biome.getBiomeConfig(), this.getStructureCache(worldSaveFolder));
            ((ForgeBiome)biome).getBiomeBase().func_242427_a(structureManager, (ChunkGenerator)this, worldGenRegion, decorationSeed, sharedseedrandom, blockpos);
            alreadyDecorated.add(biome.getBiomeConfig().getOTGBiomeId());
            if (this.getPreset().getWorldConfig().improvedBorderDecoration()) {
                if (!alreadyDecorated.contains(biome1.getBiomeConfig().getOTGBiomeId())) {
                    this.chunkDecorator.decorate(this.preset.getFolderName(), chunkBeingDecorated, forgeWorldGenRegion, biome1.getBiomeConfig(), this.getStructureCache(worldSaveFolder));
                    if (!alreadyDecorated.contains(biome1.getBiomeConfig().getOTGBiomeId())) {
                        ((ForgeBiome)biome1).getBiomeBase().func_242427_a(structureManager, (ChunkGenerator)this, worldGenRegion, decorationSeed, sharedseedrandom, blockpos);
                        alreadyDecorated.add(biome1.getBiomeConfig().getOTGBiomeId());
                    }
                }
                if (!alreadyDecorated.contains(biome2.getBiomeConfig().getOTGBiomeId())) {
                    this.chunkDecorator.decorate(this.preset.getFolderName(), chunkBeingDecorated, forgeWorldGenRegion, biome2.getBiomeConfig(), this.getStructureCache(worldSaveFolder));
                    if (!alreadyDecorated.contains(biome2.getBiomeConfig().getOTGBiomeId())) {
                        ((ForgeBiome)biome2).getBiomeBase().func_242427_a(structureManager, (ChunkGenerator)this, worldGenRegion, decorationSeed, sharedseedrandom, blockpos);
                        alreadyDecorated.add(biome2.getBiomeConfig().getOTGBiomeId());
                    }
                }
                if (!alreadyDecorated.contains(biome3.getBiomeConfig().getOTGBiomeId())) {
                    this.chunkDecorator.decorate(this.preset.getFolderName(), chunkBeingDecorated, forgeWorldGenRegion, biome3.getBiomeConfig(), this.getStructureCache(worldSaveFolder));
                    if (!alreadyDecorated.contains(biome3.getBiomeConfig().getOTGBiomeId())) {
                        ((ForgeBiome)biome3).getBiomeBase().func_242427_a(structureManager, (ChunkGenerator)this, worldGenRegion, decorationSeed, sharedseedrandom, blockpos);
                        alreadyDecorated.add(biome3.getBiomeConfig().getOTGBiomeId());
                    }
                }
                if (!alreadyDecorated.contains(biome4.getBiomeConfig().getOTGBiomeId())) {
                    this.chunkDecorator.decorate(this.preset.getFolderName(), chunkBeingDecorated, forgeWorldGenRegion, biome4.getBiomeConfig(), this.getStructureCache(worldSaveFolder));
                    if (!alreadyDecorated.contains(biome4.getBiomeConfig().getOTGBiomeId())) {
                        ((ForgeBiome)biome4).getBiomeBase().func_242427_a(structureManager, (ChunkGenerator)this, worldGenRegion, decorationSeed, sharedseedrandom, blockpos);
                    }
                }
            }
            if (!(biome.getBiomeConfig().getIsTemplateForBiome() && biome1.getBiomeConfig().getIsTemplateForBiome() && biome2.getBiomeConfig().getIsTemplateForBiome() && biome3.getBiomeConfig().getIsTemplateForBiome() && biome4.getBiomeConfig().getIsTemplateForBiome())) {
                this.chunkDecorator.doSnowAndIce(forgeWorldGenRegion, chunkBeingDecorated);
            }
        }
        catch (Exception exception) {
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)exception, (String)"Biome decoration");
            crashreport.func_85058_a("Generation").func_71507_a("CenterX", (Object)worldX).func_71507_a("CenterZ", (Object)worldZ).func_71507_a("Seed", (Object)decorationSeed);
            throw new ReportedException(crashreport);
        }
    }

    public int func_222529_a(int x, int z, Heightmap.Type heightmapType) {
        return this.sampleHeightmap(x, z, null, heightmapType.func_222684_d());
    }

    public IBlockReader func_230348_a_(int x, int z) {
        BlockState[] ablockstate = new BlockState[this.internalGenerator.getNoiseSizeY() * 8];
        this.sampleHeightmap(x, x, ablockstate, null);
        return new Blockreader(ablockstate);
    }

    private int sampleHeightmap(int x, int z, @Nullable BlockState[] blockStates, @Nullable Predicate<BlockState> predicate) {
        int xStart = Math.floorDiv(x, 4);
        int zStart = Math.floorDiv(z, 4);
        int xProgress = Math.floorMod(x, 4);
        int zProgress = Math.floorMod(z, 4);
        double xLerp = (double)xProgress / 4.0;
        double zLerp = (double)zProgress / 4.0;
        double[][] noiseData = new double[4][this.internalGenerator.getNoiseSizeY() + 1];
        for (int i = 0; i < noiseData.length; ++i) {
            noiseData[i] = new double[this.internalGenerator.getNoiseSizeY() + 1];
        }
        this.internalGenerator.getNoiseColumn(noiseData[0], xStart, zStart);
        this.internalGenerator.getNoiseColumn(noiseData[1], xStart, zStart + 1);
        this.internalGenerator.getNoiseColumn(noiseData[2], xStart + 1, zStart);
        this.internalGenerator.getNoiseColumn(noiseData[3], xStart + 1, zStart + 1);
        for (int noiseY = this.internalGenerator.getNoiseSizeY() - 1; noiseY >= 0; --noiseY) {
            double x0z0y0 = noiseData[0][noiseY];
            double x0z1y0 = noiseData[1][noiseY];
            double x1z0y0 = noiseData[2][noiseY];
            double x1z1y0 = noiseData[3][noiseY];
            double x0z0y1 = noiseData[0][noiseY + 1];
            double x0z1y1 = noiseData[1][noiseY + 1];
            double x1z0y1 = noiseData[2][noiseY + 1];
            double x1z1y1 = noiseData[3][noiseY + 1];
            for (int pieceY = 7; pieceY >= 0; --pieceY) {
                double yLerp = (double)pieceY / 8.0;
                double density = MathHelper.func_219807_a((double)yLerp, (double)xLerp, (double)zLerp, (double)x0z0y0, (double)x0z0y1, (double)x1z0y0, (double)x1z0y1, (double)x0z1y0, (double)x0z1y1, (double)x1z1y0, (double)x1z1y1);
                int y = noiseY * 8 + pieceY;
                BlockState state = this.func_236086_a_(density, y);
                if (blockStates != null) {
                    blockStates[y] = state;
                }
                if (predicate == null || !predicate.test(state)) continue;
                return y + 1;
            }
        }
        return 0;
    }

    protected Codec<? extends ChunkGenerator> func_230347_a_() {
        return CODEC;
    }

    public CustomStructureCache getStructureCache(Path worldSaveFolder) {
        if (this.structureCache == null) {
            this.structureCache = OTG.getEngine().createCustomStructureCache(this.preset.getFolderName(), worldSaveFolder, this.field_236084_w_, this.preset.getWorldConfig().getCustomStructureType() == SettingsEnums.CustomStructureType.BO4);
        }
        return this.structureCache;
    }

    double getBiomeBlocksNoiseValue(int blockX, int blockZ) {
        return this.internalGenerator.getBiomeBlocksNoiseValue(blockX, blockZ);
    }

    public void stopWorkerThreads() {
        this.shadowChunkGenerator.stopWorkerThreads();
    }

    public Boolean checkHasVanillaStructureWithoutLoading(ServerWorld world, ChunkCoordinate chunkCoord) {
        return this.shadowChunkGenerator.checkHasVanillaStructureWithoutLoading(world, (ChunkGenerator)this, (OTGBiomeProvider)this.field_222542_c, this.func_235957_b_(), chunkCoord, this.internalGenerator.getCachedBiomeProvider(), false);
    }

    public int getHighestBlockYInUnloadedChunk(Random worldRandom, int x, int z, boolean findSolid, boolean findLiquid, boolean ignoreLiquid, boolean ignoreSnow) {
        return this.shadowChunkGenerator.getHighestBlockYInUnloadedChunk(this.internalGenerator, this.preset.getWorldConfig().getWorldHeightCap(), worldRandom, x, z, findSolid, findLiquid, ignoreLiquid, ignoreSnow);
    }

    public LocalMaterialData getMaterialInUnloadedChunk(Random worldRandom, int x, int y, int z) {
        return this.shadowChunkGenerator.getMaterialInUnloadedChunk(this.internalGenerator, this.preset.getWorldConfig().getWorldHeightCap(), worldRandom, x, y, z);
    }

    public ForgeChunkBuffer getChunkWithoutLoadingOrCaching(Random random, ChunkCoordinate chunkCoord) {
        return this.shadowChunkGenerator.getChunkWithoutLoadingOrCaching(this.internalGenerator, this.preset.getWorldConfig().getWorldHeightCap(), random, chunkCoord);
    }

    public String getPortalColor() {
        this.processDimensionConfigData();
        return this.portalColor;
    }

    public String getPortalMob() {
        this.processDimensionConfigData();
        return this.portalMob;
    }

    public String getPortalIgnitionSource() {
        this.processDimensionConfigData();
        return this.portalIgnitionSource;
    }

    public List<LocalMaterialData> getPortalBlocks() {
        this.processDimensionConfigData();
        return this.portalBlocks;
    }

    private void processDimensionConfigData() {
        if (!this.portalDataProcessed) {
            this.portalDataProcessed = true;
            if (this.dimConfig != null) {
                IMaterialReader materialReader = OTG.getEngine().getPresetLoader().getMaterialReader(this.preset.getFolderName());
                for (DimensionConfig.OTGDimension dim : this.dimConfig.Dimensions) {
                    if (dim.PresetFolderName == null || !this.preset.getFolderName().equals(dim.PresetFolderName)) continue;
                    if (dim.PortalBlocks != null && dim.PortalBlocks.trim().length() > 0) {
                        String[] portalBlocks = dim.PortalBlocks.split(",");
                        ArrayList<LocalMaterialData> materials = new ArrayList<LocalMaterialData>();
                        for (String materialString : portalBlocks) {
                            LocalMaterialData material = null;
                            try {
                                material = materialReader.readMaterial(materialString.trim());
                            }
                            catch (InvalidConfigException invalidConfigException) {
                                // empty catch block
                            }
                            if (material == null) continue;
                            materials.add(material);
                        }
                        this.portalBlocks = materials;
                    }
                    this.portalColor = dim.PortalColor;
                    this.portalMob = dim.PortalMob;
                    this.portalIgnitionSource = dim.PortalIgnitionSource;
                    break;
                }
            }
            if (this.portalBlocks == null || this.portalBlocks.size() == 0) {
                this.portalBlocks = this.preset.getWorldConfig().getPortalBlocks();
            }
            if (this.portalColor == null) {
                this.portalColor = this.preset.getWorldConfig().getPortalColor();
            }
            if (this.portalMob == null) {
                this.portalMob = this.preset.getWorldConfig().getPortalMob();
            }
            if (this.portalIgnitionSource == null) {
                this.portalIgnitionSource = this.preset.getWorldConfig().getPortalIgnitionSource();
            }
        }
    }

    private static /* synthetic */ boolean lambda$null$11(Supplier a, String b) {
        return b.equals(ForgeRegistries.WORLD_CARVERS.getKey((IForgeRegistryEntry)((ConfiguredCarver)a.get()).field_222732_a).toString());
    }

    private static /* synthetic */ boolean lambda$null$9(Supplier a, String b) {
        return b.equals(ForgeRegistries.WORLD_CARVERS.getKey((IForgeRegistryEntry)((ConfiguredCarver)a.get()).field_222732_a).toString());
    }

    private static /* synthetic */ void lambda$fillFromNoise$8(ChunkPos pos, ObjectList structures, int startX, int startZ, ObjectList junctions, StructureStart start) {
        for (StructurePiece piece : start.func_186161_c()) {
            if (!piece.func_214810_a(pos, 12)) continue;
            MutableBoundingBox box = piece.func_74874_b();
            if (piece instanceof AbstractVillagePiece) {
                AbstractVillagePiece villagePiece = (AbstractVillagePiece)piece;
                if (villagePiece.func_214826_b().func_214854_c() == JigsawPattern.PlacementBehaviour.RIGID) {
                    structures.add((Object)new JigsawStructureData(box.field_78897_a, box.field_78895_b, box.field_78896_c, box.field_78893_d, villagePiece.func_214830_d(), box.field_78892_f, true, 0, 0, 0));
                }
                for (JigsawJunction junction : villagePiece.func_214829_e()) {
                    int sourceX = junction.func_214895_a();
                    int sourceZ = junction.func_214893_c();
                    if (sourceX <= startX - 12 || sourceZ <= startZ - 12 || sourceX >= startX + 15 + 12 || sourceZ >= startZ + 15 + 12) continue;
                    junctions.add((Object)new JigsawStructureData(0, 0, 0, 0, 0, 0, false, junction.func_214895_a(), junction.func_214896_b(), junction.func_214893_c()));
                }
                continue;
            }
            structures.add((Object)new JigsawStructureData(box.field_78897_a, box.field_78895_b, box.field_78896_c, box.field_78893_d, 0, box.field_78892_f, false, 0, 0, 0));
        }
    }
}

