/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.gen;

import com.pg85.otg.forge.biome.ForgeBiome;
import com.pg85.otg.forge.biome.OTGBiomeProvider;
import com.pg85.otg.forge.gen.ForgeChunkBuffer;
import com.pg85.otg.forge.materials.ForgeMaterialData;
import com.pg85.otg.gen.OTGChunkGenerator;
import com.pg85.otg.interfaces.IBiome;
import com.pg85.otg.interfaces.ICachedBiomeProvider;
import com.pg85.otg.util.BlockPos2D;
import com.pg85.otg.util.ChunkCoordinate;
import com.pg85.otg.util.FifoMap;
import com.pg85.otg.util.gen.JigsawStructureData;
import com.pg85.otg.util.materials.LocalMaterialData;
import com.pg85.otg.util.materials.LocalMaterials;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.block.BlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraft.world.gen.feature.StructureFeature;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ShadowChunkGenerator {
    private final FifoMap<BlockPos2D, LocalMaterialData[]> unloadedBlockColumnsCache = new FifoMap(1024);
    private final FifoMap<ChunkCoordinate, IChunk> unloadedChunksCache = new FifoMap(512);
    private final FifoMap<ChunkCoordinate, Integer> hasVanillaStructureChunkCache = new FifoMap(2048);
    private final FifoMap<ChunkCoordinate, Integer> hasVanillaNoiseStructureChunkCache = new FifoMap(2048);
    private final Object workerLock = new Object();
    private final int maxConcurrent;
    private final Worker[] threads;
    private boolean threadsInitialized = false;
    private final LinkedList<ChunkCoordinate> chunksToLoad = new LinkedList();
    private final int maxQueueSize = 512;
    private final ChunkCoordinate[] chunksBeingLoaded;
    private final int waitTimeInMS = 25;
    private final int idleTimeInMS = 50;
    private int cacheHits = 0;
    private int cacheMisses = 0;

    public ShadowChunkGenerator(int maxConcurrentThreads) {
        this.maxConcurrent = maxConcurrentThreads;
        this.threads = new Worker[this.maxConcurrent];
        this.chunksBeingLoaded = new ChunkCoordinate[this.maxConcurrent + 1];
    }

    public void stopWorkerThreads() {
        if (this.maxConcurrent > 0) {
            for (int i = 0; i < this.maxConcurrent; ++i) {
                if (this.threads[i] == null) continue;
                this.threads[i].stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueChunksForWorkerThreads(WorldGenRegion worldGenRegion, StructureManager manager, IChunk chunk, ChunkGenerator chunkGenerator, OTGBiomeProvider biomeProvider, OTGChunkGenerator otgChunkGenerator, DimensionStructuresSettings dimensionStructuresSettings, int worldHeightCap) {
        if (this.maxConcurrent > 0) {
            if (!this.threadsInitialized) {
                for (int i = 0; i < this.maxConcurrent; ++i) {
                    Worker thread;
                    this.threads[i] = thread = new Worker(i, this.unloadedChunksCache, this.chunksToLoad, this.chunksBeingLoaded, worldGenRegion.func_201672_e(), chunkGenerator, biomeProvider, otgChunkGenerator, dimensionStructuresSettings, worldHeightCap);
                    thread.start(worldGenRegion.func_201674_k());
                }
                this.threadsInitialized = true;
            }
            Object object = this.workerLock;
            synchronized (object) {
                if (this.chunksToLoad.size() == 0) {
                    for (IChunk wgrChunk : worldGenRegion.field_201684_a) {
                        ChunkCoordinate wgrChunkCoord = ChunkCoordinate.fromChunkCoords(wgrChunk.func_76632_l().field_77276_a, wgrChunk.func_76632_l().field_77275_b);
                        if (wgrChunk == chunk || wgrChunk.func_201589_g().func_209003_a(ChunkStatus.field_222609_e) || this.unloadedChunksCache.containsKey(wgrChunkCoord)) continue;
                        boolean bFound = false;
                        for (int i = 0; i < this.chunksBeingLoaded.length; ++i) {
                            if (this.chunksBeingLoaded[i] != wgrChunkCoord) continue;
                            bFound = true;
                            break;
                        }
                        if (bFound) continue;
                        this.chunksToLoad.addFirst(wgrChunkCoord);
                        if (this.chunksToLoad.size() != this.maxQueueSize) continue;
                        break;
                    }
                }
            }
        }
    }

    private ForgeChunkBuffer getUnloadedChunk(OTGChunkGenerator otgChunkGenerator, int worldHeightCap, Random random, ChunkCoordinate chunkCoordinate) {
        ChunkPrimer chunk = new ChunkPrimer(new ChunkPos(chunkCoordinate.getChunkX(), chunkCoordinate.getChunkZ()), null);
        ForgeChunkBuffer buffer = new ForgeChunkBuffer(chunk);
        ObjectArrayList structures = new ObjectArrayList(10);
        ObjectArrayList junctions = new ObjectArrayList(32);
        otgChunkGenerator.populateNoise(worldHeightCap, random, buffer, buffer.getChunkCoordinate(), (ObjectList<JigsawStructureData>)structures, (ObjectList<JigsawStructureData>)junctions);
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IChunk getChunkWithWait(ChunkCoordinate chunkCoord) {
        IChunk cachedChunk;
        Object object = this.workerLock;
        synchronized (object) {
            cachedChunk = (IChunk)this.unloadedChunksCache.get(chunkCoord);
            if (cachedChunk != null) {
                return cachedChunk;
            }
            if (this.unloadedChunksCache.containsKey(chunkCoord)) {
                this.unloadedChunksCache.remove(chunkCoord);
                this.chunksToLoad.remove(chunkCoord);
                this.chunksBeingLoaded[this.maxConcurrent] = chunkCoord;
                return null;
            }
            boolean bFound = false;
            for (int i = 0; i < this.chunksBeingLoaded.length; ++i) {
                if (this.chunksBeingLoaded[i] != chunkCoord) continue;
                bFound = true;
                break;
            }
            if (!bFound) {
                this.chunksToLoad.remove(chunkCoord);
                this.chunksBeingLoaded[this.maxConcurrent] = chunkCoord;
                return null;
            }
        }
        while (true) {
            try {
                this.getClass();
                Thread.sleep(25L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            object = this.workerLock;
            synchronized (object) {
                cachedChunk = (IChunk)this.unloadedChunksCache.get(chunkCoord);
                if (cachedChunk != null) {
                    return cachedChunk;
                }
                if (this.unloadedChunksCache.containsKey(chunkCoord)) {
                    this.unloadedChunksCache.remove(chunkCoord);
                    this.chunksToLoad.remove(chunkCoord);
                    this.chunksBeingLoaded[this.maxConcurrent] = chunkCoord;
                    return null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillWorldGenChunkFromShadowChunk(IChunk chunk, IChunk cachedChunk) {
        ChunkCoordinate chunkCoord = ChunkCoordinate.fromChunkCoords(chunk.func_76632_l().field_77276_a, chunk.func_76632_l().field_77275_b);
        ((ChunkPrimer)chunk).field_201661_i = ((ChunkPrimer)cachedChunk).field_201661_i;
        ((ChunkPrimer)chunk).field_201657_e = ((ChunkPrimer)cachedChunk).field_201657_e;
        ((ChunkPrimer)chunk).field_201663_k = ((ChunkPrimer)cachedChunk).field_201663_k;
        ++this.cacheHits;
        Object object = this.workerLock;
        synchronized (object) {
            this.unloadedChunksCache.remove(chunkCoord);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setChunkGenerated(ChunkCoordinate chunkCoord) {
        ++this.cacheMisses;
        Object object = this.workerLock;
        synchronized (object) {
            this.chunksBeingLoaded[this.maxConcurrent] = null;
            this.chunksToLoad.remove(chunkCoord);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkHasVanillaStructureWithoutLoading(ServerWorld serverWorld, ChunkGenerator chunkGenerator, OTGBiomeProvider biomeProvider, DimensionStructuresSettings dimensionStructuresSettings, ChunkCoordinate chunkCoordinate, ICachedBiomeProvider cachedBiomeProvider, boolean noiseAffectingStructuresOnly) {
        int radiusInChunks = 5;
        if (serverWorld.func_73046_m().func_240793_aU_().func_230418_z_().func_236222_c_()) {
            FifoMap<ChunkCoordinate, Integer> fifoMap;
            FifoMap<ChunkCoordinate, Integer> fifoMap2;
            ArrayList<ChunkCoordinate> chunksToHandle = new ArrayList<ChunkCoordinate>();
            HashMap<ChunkCoordinate, Integer> chunksHandled = new HashMap<ChunkCoordinate, Integer>();
            if (noiseAffectingStructuresOnly) {
                fifoMap2 = this.hasVanillaNoiseStructureChunkCache;
                synchronized (fifoMap2) {
                    if (this.checkHasVanillaStructureWithoutLoadingCache(this.hasVanillaNoiseStructureChunkCache, chunkCoordinate, radiusInChunks, chunksToHandle)) {
                        return true;
                    }
                }
            }
            fifoMap2 = this.hasVanillaStructureChunkCache;
            synchronized (fifoMap2) {
                if (this.checkHasVanillaStructureWithoutLoadingCache(this.hasVanillaStructureChunkCache, chunkCoordinate, radiusInChunks, chunksToHandle)) {
                    return true;
                }
            }
            ArrayList[] structuresPerDistance = new ArrayList[radiusInChunks];
            structuresPerDistance[4] = new ArrayList<String>(Arrays.asList("minecraft:village", "minecraft:endcity", "minecraft:bastion_remnant", "minecraft:monument", "minecraft:mansion"));
            structuresPerDistance[3] = new ArrayList<String>(Arrays.asList(new String[0]));
            structuresPerDistance[2] = new ArrayList<String>(Arrays.asList(new String[0]));
            structuresPerDistance[1] = new ArrayList<String>(Arrays.asList("minecraft:jungle_pyramid", "minecraft:desert_pyramid", "minecraft:ruined_portal", "minecraft:swamp_hut", "minecraft:igloo", "minecraft:shipwreck", "minecraft:pillager_outpost", "minecraft:ocean_ruin"));
            structuresPerDistance[0] = new ArrayList<String>(Arrays.asList(new String[0]));
            for (ChunkCoordinate chunkToHandle : chunksToHandle) {
                ChunkPrimer chunk = new ChunkPrimer(new ChunkPos(chunkToHandle.getChunkX(), chunkToHandle.getChunkZ()), null);
                ChunkPos chunkpos = chunk.func_76632_l();
                int distance = (int)Math.floor(Math.sqrt(Math.pow(chunkToHandle.getChunkX() - chunkCoordinate.getChunkX(), 2.0) + Math.pow(chunkToHandle.getChunkZ() - chunkCoordinate.getChunkZ(), 2.0)));
                IBiome biome = cachedBiomeProvider.getNoiseBiome((chunkpos.field_77276_a << 2) + 2, (chunkpos.field_77275_b << 2) + 2);
                block25: for (Supplier supplier : ((ForgeBiome)biome).getBiomeBase().func_242440_e().func_242487_a()) {
                    StructureFeature structure = (StructureFeature)supplier.get();
                    if (structure.field_236268_b_.func_236396_f_() != GenerationStage.Decoration.SURFACE_STRUCTURES || noiseAffectingStructuresOnly && !Structure.field_236384_t_.contains(structure.field_236268_b_)) continue;
                    ResourceLocation structureRegistryKey = ForgeRegistries.STRUCTURE_FEATURES.getKey((IForgeRegistryEntry)structure.field_236268_b_);
                    String structureRegistryName = structureRegistryKey.toString();
                    if (!structureRegistryKey.func_110624_b().equals("minecraft")) {
                        FifoMap<ChunkCoordinate, Integer> fifoMap3;
                        int moddedStructuresDefaultRadius = 1;
                        if (!this.hasStructureStart(structure, dimensionStructuresSettings, serverWorld.func_72905_C(), chunkpos)) continue;
                        chunksHandled.put(chunkToHandle, new Integer(moddedStructuresDefaultRadius));
                        if (moddedStructuresDefaultRadius < distance) continue;
                        if (noiseAffectingStructuresOnly) {
                            fifoMap3 = this.hasVanillaNoiseStructureChunkCache;
                            synchronized (fifoMap3) {
                                this.hasVanillaNoiseStructureChunkCache.putAll(chunksHandled);
                            }
                        }
                        fifoMap3 = this.hasVanillaStructureChunkCache;
                        synchronized (fifoMap3) {
                            this.hasVanillaStructureChunkCache.putAll(chunksHandled);
                        }
                        return true;
                    }
                    for (int i = structuresPerDistance.length - 1; i > 0; --i) {
                        ArrayList structuresAtDistance = structuresPerDistance[i];
                        if (!structuresAtDistance.contains(structureRegistryName)) continue;
                        if (!this.hasStructureStart(structure, dimensionStructuresSettings, serverWorld.func_72905_C(), chunkpos)) continue block25;
                        chunksHandled.put(chunkToHandle, new Integer(i));
                        if (i < distance) continue block25;
                        if (noiseAffectingStructuresOnly) {
                            FifoMap<ChunkCoordinate, Integer> fifoMap4 = this.hasVanillaNoiseStructureChunkCache;
                            synchronized (fifoMap4) {
                                this.hasVanillaNoiseStructureChunkCache.putAll(chunksHandled);
                            }
                        }
                        FifoMap<ChunkCoordinate, Integer> fifoMap5 = this.hasVanillaStructureChunkCache;
                        synchronized (fifoMap5) {
                            this.hasVanillaStructureChunkCache.putAll(chunksHandled);
                        }
                        return true;
                    }
                }
                chunksHandled.putIfAbsent(chunkToHandle, new Integer(0));
            }
            if (noiseAffectingStructuresOnly) {
                fifoMap = this.hasVanillaNoiseStructureChunkCache;
                synchronized (fifoMap) {
                    this.hasVanillaNoiseStructureChunkCache.putAll(chunksHandled);
                }
            }
            fifoMap = this.hasVanillaStructureChunkCache;
            synchronized (fifoMap) {
                this.hasVanillaStructureChunkCache.putAll(chunksHandled);
            }
        }
        return false;
    }

    private boolean checkHasVanillaStructureWithoutLoadingCache(FifoMap<ChunkCoordinate, Integer> cache, ChunkCoordinate chunkCoordinate, int radiusInChunks, List<ChunkCoordinate> chunksToHandle) {
        for (int cycle = 0; cycle < radiusInChunks; ++cycle) {
            for (int xOffset = -cycle; xOffset <= cycle; ++xOffset) {
                for (int zOffset = -cycle; zOffset <= cycle; ++zOffset) {
                    int distance = (int)Math.floor(Math.sqrt(Math.pow(xOffset, 2.0) + Math.pow(zOffset, 2.0)));
                    if (distance != cycle) continue;
                    ChunkCoordinate searchChunk = ChunkCoordinate.fromChunkCoords(chunkCoordinate.getChunkX() + xOffset, chunkCoordinate.getChunkZ() + zOffset);
                    Integer result = (Integer)cache.get(searchChunk);
                    if (result != null) {
                        if (result <= 0 || result < distance) continue;
                        return true;
                    }
                    chunksToHandle.add(searchChunk);
                }
            }
        }
        return false;
    }

    private boolean hasStructureStart(StructureFeature<?, ?> structureFeature, DimensionStructuresSettings dimensionStructuresSettings, long seed, ChunkPos chunkPos) {
        StructureSeparationSettings structureSeparationSettings = dimensionStructuresSettings.func_236197_a_(structureFeature.field_236268_b_);
        if (structureSeparationSettings != null) {
            SharedSeedRandom sharedSeedRandom = new SharedSeedRandom();
            ChunkPos chunkPosPotential = structureFeature.field_236268_b_.func_236392_a_(structureSeparationSettings, seed, sharedSeedRandom, chunkPos.field_77276_a, chunkPos.field_77275_b);
            return chunkPos.field_77276_a == chunkPosPotential.field_77276_a && chunkPos.field_77275_b == chunkPosPotential.field_77275_b;
        }
        return false;
    }

    public ForgeChunkBuffer getChunkWithoutLoadingOrCaching(OTGChunkGenerator otgChunkGenerator, int worldHeightCap, Random random, ChunkCoordinate chunkCoordinate) {
        return this.getUnloadedChunk(otgChunkGenerator, worldHeightCap, random, chunkCoordinate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LocalMaterialData[] getBlockColumnInUnloadedChunk(OTGChunkGenerator otgChunkGenerator, int worldHeightCap, Random worldRandom, int x, int z) {
        BlockState blockInChunk;
        BlockPos2D blockPos = new BlockPos2D(x, z);
        ChunkCoordinate chunkCoord = ChunkCoordinate.fromBlockCoords(x, z);
        byte blockX = (byte)(x &= 0xF);
        byte blockZ = (byte)(z &= 0xF);
        LocalMaterialData[] cachedColumn = (LocalMaterialData[])this.unloadedBlockColumnsCache.get(blockPos);
        if (cachedColumn != null) {
            return cachedColumn;
        }
        IChunk chunk = this.getChunkWithWait(chunkCoord);
        if (chunk == null) {
            chunk = this.getUnloadedChunk(otgChunkGenerator, worldHeightCap, worldRandom, chunkCoord).getChunk();
            Object object = this.workerLock;
            synchronized (object) {
                this.unloadedChunksCache.put(chunkCoord, chunk);
                this.chunksBeingLoaded[this.maxConcurrent] = null;
            }
        }
        cachedColumn = new LocalMaterialData[256];
        LocalMaterialData[] blocksInColumn = new LocalMaterialData[256];
        for (int y = 0; y < 256 && (blockInChunk = chunk.func_180495_p(new BlockPos((int)blockX, y, (int)blockZ))) != null; y = (int)((short)(y + 1))) {
            blocksInColumn[y] = ForgeMaterialData.ofBlockState(blockInChunk);
        }
        this.unloadedBlockColumnsCache.put(blockPos, cachedColumn);
        return blocksInColumn;
    }

    public LocalMaterialData getMaterialInUnloadedChunk(OTGChunkGenerator otgChunkGenerator, int worldHeightCap, Random worldRandom, int x, int y, int z) {
        LocalMaterialData[] blockColumn = this.getBlockColumnInUnloadedChunk(otgChunkGenerator, worldHeightCap, worldRandom, x, z);
        return blockColumn[y];
    }

    public int getHighestBlockYInUnloadedChunk(OTGChunkGenerator otgChunkGenerator, int worldHeightCap, Random worldRandom, int x, int z, boolean findSolid, boolean findLiquid, boolean ignoreLiquid, boolean ignoreSnow) {
        int height = -1;
        LocalMaterialData[] blockColumn = this.getBlockColumnInUnloadedChunk(otgChunkGenerator, worldHeightCap, worldRandom, x, z);
        for (int y = 255; y >= 0; --y) {
            boolean isSolid;
            ForgeMaterialData material = (ForgeMaterialData)blockColumn[y];
            boolean isLiquid = material.isLiquid();
            boolean bl = isSolid = material.isSolid() || !ignoreSnow && material.isMaterial(LocalMaterials.SNOW);
            if (isLiquid && ignoreLiquid) continue;
            if (findSolid && isSolid || findLiquid && isLiquid) {
                return y;
            }
            if ((!findSolid || !isLiquid) && (!findLiquid || !isSolid)) continue;
            return -1;
        }
        return height;
    }

    private class Worker
    implements Runnable {
        private Thread runner;
        private boolean stop = false;
        private Random worldRandom;
        private final int index;
        private final FifoMap<ChunkCoordinate, IChunk> unloadedChunksCache;
        private final List<ChunkCoordinate> chunksToLoad;
        private final ChunkCoordinate[] chunksBeingLoaded;
        private final ServerWorld serverWorld;
        private final ChunkGenerator chunkGenerator;
        private final OTGBiomeProvider biomeProvider;
        private final OTGChunkGenerator otgChunkGenerator;
        private final DimensionStructuresSettings dimensionStructuresSettings;
        private final int worldHeightCap;

        Worker(int index, FifoMap<ChunkCoordinate, IChunk> unloadedChunksCache, List<ChunkCoordinate> chunksToLoad, ChunkCoordinate[] chunksBeingLoaded, ServerWorld serverWorld, ChunkGenerator chunkGenerator, OTGBiomeProvider biomeProvider, OTGChunkGenerator otgChunkGenerator, DimensionStructuresSettings dimensionStructuresSettings, int worldHeightCap) {
            this.index = index;
            this.unloadedChunksCache = unloadedChunksCache;
            this.chunksToLoad = chunksToLoad;
            this.chunksBeingLoaded = chunksBeingLoaded;
            this.serverWorld = serverWorld;
            this.chunkGenerator = chunkGenerator;
            this.biomeProvider = biomeProvider;
            this.otgChunkGenerator = otgChunkGenerator;
            this.dimensionStructuresSettings = dimensionStructuresSettings;
            this.worldHeightCap = worldHeightCap;
        }

        public void start(Random worldRandom) {
            this.runner = new Thread(this);
            this.runner.start();
            this.worldRandom = worldRandom;
        }

        public void stop() {
            this.stop = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                if (this.stop) {
                    this.stop = false;
                    return;
                }
                ChunkCoordinate coords = null;
                Object object = ShadowChunkGenerator.this.workerLock;
                synchronized (object) {
                    int sizeLeft = this.chunksToLoad.size();
                    if (sizeLeft > 0) {
                        this.chunksBeingLoaded[this.index] = coords = this.chunksToLoad.remove(sizeLeft - 1);
                    }
                }
                if (coords != null) {
                    Object cachedChunk;
                    if (!ShadowChunkGenerator.this.checkHasVanillaStructureWithoutLoading(this.serverWorld, this.chunkGenerator, this.biomeProvider, this.dimensionStructuresSettings, coords, this.otgChunkGenerator.getCachedBiomeProvider(), true)) {
                        cachedChunk = ShadowChunkGenerator.this.getUnloadedChunk(this.otgChunkGenerator, this.worldHeightCap, this.worldRandom, coords).getChunk();
                        Object object2 = ShadowChunkGenerator.this.workerLock;
                        synchronized (object2) {
                            this.unloadedChunksCache.put(coords, (IChunk)cachedChunk);
                            this.chunksBeingLoaded[this.index] = null;
                        }
                    }
                    cachedChunk = ShadowChunkGenerator.this.workerLock;
                    synchronized (cachedChunk) {
                        this.unloadedChunksCache.put(coords, null);
                        this.chunksBeingLoaded[this.index] = null;
                    }
                }
                try {
                    Thread.sleep(50L);
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }
}

