/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.gui.screens;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.pg85.otg.config.dimensions.DimensionConfig;
import com.pg85.otg.forge.gui.OTGGui;
import com.pg85.otg.forge.gui.screens.ModpackCreateWorldScreen;
import com.pg85.otg.forge.gui.screens.OTGDimensionSettingsContainer;
import com.pg85.otg.forge.gui.screens.SelectOTGPresetScreen;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.gui.DialogTexts;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.CreateWorldScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.client.gui.widget.list.ExtendedList;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.gen.settings.DimensionGeneratorSettings;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CreateOTGDimensionsScreen
extends Screen {
    public final CreateWorldScreen parent;
    public DimensionGeneratorSettings dimGenSettings;
    private final Consumer<OTGDimensionSettingsContainer> dimensionConfigConsumer;
    private ITextComponent columnType;
    private ITextComponent columnHeight;
    private DetailsList list;
    private final DimensionConfig currentSelection;
    private Button addDimButton;
    private Button removeDimButton;
    private Button editDimButton;
    private boolean uiLocked = false;
    private static DimensionConfig modpackConfig;

    public CreateOTGDimensionsScreen(CreateWorldScreen parent, Consumer<OTGDimensionSettingsContainer> dimensionConfigConsumer) {
        super((ITextComponent)CreateOTGDimensionsScreen.setTitle());
        this.parent = parent;
        this.dimensionConfigConsumer = dimensionConfigConsumer;
        if (modpackConfig != null) {
            this.currentSelection = modpackConfig;
            this.uiLocked = true;
        } else {
            this.currentSelection = OTGGui.currentSelection != null ? OTGGui.currentSelection.clone() : DimensionConfig.createDefaultConfig();
        }
    }

    private static TextComponent setTitle() {
        modpackConfig = DimensionConfig.fromDisk("Modpack");
        if (modpackConfig == null || CreateOTGDimensionsScreen.modpackConfig.ModpackName == null) {
            return new TranslationTextComponent("otg.createDimensions.customize.title");
        }
        return new StringTextComponent(CreateOTGDimensionsScreen.modpackConfig.ModpackName);
    }

    protected void func_231160_c_() {
        this.columnType = new TranslationTextComponent("otg.createDimensions.customize.dimension");
        this.columnHeight = new TranslationTextComponent("otg.createDimensions.customize.preset");
        this.list = new DetailsList();
        this.field_230705_e_.add(this.list);
        if (!this.uiLocked) {
            this.addDimButton = (Button)this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 155, this.field_230709_l_ - 52, 95, 20, (ITextComponent)new TranslationTextComponent("otg.createDimensions.customize.dimension.addDimension"), p_213007_1_ -> {
                this.currentSelection.Dimensions.add(new DimensionConfig.OTGDimension(null, -1L));
                this.list.resetRows();
                this.updateButtonValidity();
            }));
            this.removeDimButton = (Button)this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 50, this.field_230709_l_ - 52, 95, 20, (ITextComponent)new TranslationTextComponent("otg.createDimensions.customize.dimension.removeDimension"), p_213007_1_ -> {
                if (this.hasValidSelection() && this.currentSelection.Dimensions.size() > ((DetailsList.LayerEntry)this.list.func_230958_g_()).dimId - 3) {
                    this.currentSelection.Dimensions.remove(((DetailsList.LayerEntry)this.list.func_230958_g_()).dimId - 3);
                    this.list.resetRows();
                    this.updateButtonValidity();
                }
            }));
            this.editDimButton = (Button)this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 + 53, this.field_230709_l_ - 52, 95, 20, (ITextComponent)new TranslationTextComponent("otg.createDimensions.customize.dimension.editDimension"), p_213007_1_ -> {
                if (this.hasValidSelection()) {
                    this.field_230706_i_.func_147108_a((Screen)new SelectOTGPresetScreen(this, this.currentSelection, ((DetailsList.LayerEntry)this.list.func_230958_g_()).dimId));
                }
            }));
        }
        this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 155, this.field_230709_l_ - 28, 150, 20, DialogTexts.field_240632_c_, p_213010_1_ -> {
            if (!(this.parent instanceof ModpackCreateWorldScreen)) {
                this.dimensionConfigConsumer.accept(new OTGDimensionSettingsContainer(this.currentSelection, this.dimGenSettings));
            }
            this.field_230706_i_.func_147108_a((Screen)this.parent);
        }));
        this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 + 5, this.field_230709_l_ - 28, 150, 20, DialogTexts.field_240633_d_, p_213009_1_ -> this.field_230706_i_.func_147108_a((Screen)this.parent)));
        this.updateButtonValidity();
    }

    public void applySettings() {
        this.dimensionConfigConsumer.accept(new OTGDimensionSettingsContainer(this.currentSelection, this.dimGenSettings));
    }

    private void updateButtonValidity() {
        if (!this.uiLocked) {
            this.removeDimButton.field_230693_o_ = this.hasValidSelection();
            this.editDimButton.field_230693_o_ = this.hasValidSelection();
            this.addDimButton.field_230693_o_ = this.list.func_231039_at__().size() <= 13;
        }
    }

    private boolean hasValidSelection() {
        return this.list.func_230958_g_() != null;
    }

    public void func_231175_as__() {
        this.field_230706_i_.func_147108_a((Screen)this.parent);
    }

    public void func_230430_a_(MatrixStack p_230430_1_, int p_230430_2_, int p_230430_3_, float p_230430_4_) {
        this.func_230446_a_(p_230430_1_);
        this.list.func_230430_a_(p_230430_1_, p_230430_2_, p_230430_3_, p_230430_4_);
        CreateOTGDimensionsScreen.func_238472_a_((MatrixStack)p_230430_1_, (FontRenderer)this.field_230712_o_, (ITextComponent)this.field_230704_d_, (int)(this.field_230708_k_ / 2), (int)8, (int)0xFFFFFF);
        int i = this.field_230708_k_ / 2 - 92 - 16;
        CreateOTGDimensionsScreen.func_238475_b_((MatrixStack)p_230430_1_, (FontRenderer)this.field_230712_o_, (ITextComponent)this.columnType, (int)i, (int)32, (int)0xFFFFFF);
        CreateOTGDimensionsScreen.func_238475_b_((MatrixStack)p_230430_1_, (FontRenderer)this.field_230712_o_, (ITextComponent)this.columnHeight, (int)(i + 2 + 213 - this.field_230712_o_.func_238414_a_((ITextProperties)this.columnHeight)), (int)32, (int)0xFFFFFF);
        super.func_230430_a_(p_230430_1_, p_230430_2_, p_230430_3_, p_230430_4_);
    }

    @OnlyIn(value=Dist.CLIENT)
    class DetailsList
    extends ExtendedList<LayerEntry> {
        public DetailsList() {
            super(CreateOTGDimensionsScreen.this.field_230706_i_, CreateOTGDimensionsScreen.this.field_230708_k_, CreateOTGDimensionsScreen.this.field_230709_l_, 43, CreateOTGDimensionsScreen.this.field_230709_l_ - 60, 24);
            this.func_230513_b_((AbstractList.AbstractListEntry)new LayerEntry("Overworld", ((CreateOTGDimensionsScreen)CreateOTGDimensionsScreen.this).currentSelection.Overworld.PresetFolderName == null ? (((CreateOTGDimensionsScreen)CreateOTGDimensionsScreen.this).currentSelection.Overworld.NonOTGWorldType != null ? (((CreateOTGDimensionsScreen)CreateOTGDimensionsScreen.this).currentSelection.Overworld.NonOTGWorldType.equals("Default") ? "Vanilla" : ((CreateOTGDimensionsScreen)CreateOTGDimensionsScreen.this).currentSelection.Overworld.NonOTGWorldType) : "Vanilla") : ((CreateOTGDimensionsScreen)CreateOTGDimensionsScreen.this).currentSelection.Overworld.PresetFolderName, 0));
            this.func_230513_b_((AbstractList.AbstractListEntry)new LayerEntry("Nether", ((CreateOTGDimensionsScreen)CreateOTGDimensionsScreen.this).currentSelection.Nether == null || ((CreateOTGDimensionsScreen)CreateOTGDimensionsScreen.this).currentSelection.Nether.PresetFolderName == null ? "Vanilla" : ((CreateOTGDimensionsScreen)CreateOTGDimensionsScreen.this).currentSelection.Nether.PresetFolderName, 1));
            this.func_230513_b_((AbstractList.AbstractListEntry)new LayerEntry("End", ((CreateOTGDimensionsScreen)CreateOTGDimensionsScreen.this).currentSelection.End == null || ((CreateOTGDimensionsScreen)CreateOTGDimensionsScreen.this).currentSelection.End.PresetFolderName == null ? "Vanilla" : ((CreateOTGDimensionsScreen)CreateOTGDimensionsScreen.this).currentSelection.End.PresetFolderName, 2));
            int dimId = 3;
            for (DimensionConfig.OTGDimension dim : ((CreateOTGDimensionsScreen)CreateOTGDimensionsScreen.this).currentSelection.Dimensions) {
                this.func_230513_b_((AbstractList.AbstractListEntry)new LayerEntry("OTG " + (dimId - 2), dim.PresetFolderName == null ? "None" : dim.PresetFolderName, dimId));
                ++dimId;
            }
        }

        public void setSelected(@Nullable LayerEntry p_241215_1_) {
            super.func_241215_a_((AbstractList.AbstractListEntry)p_241215_1_);
            CreateOTGDimensionsScreen.this.updateButtonValidity();
        }

        protected boolean func_230971_aw__() {
            return CreateOTGDimensionsScreen.this.func_241217_q_() == this;
        }

        protected int func_230952_d_() {
            return this.field_230670_d_ - 70;
        }

        public void resetRows() {
            int i = this.func_231039_at__().indexOf(this.func_230958_g_());
            this.func_230963_j_();
            this.func_230513_b_((AbstractList.AbstractListEntry)new LayerEntry("Overworld", ((CreateOTGDimensionsScreen)CreateOTGDimensionsScreen.this).currentSelection.Overworld.PresetFolderName == null ? (((CreateOTGDimensionsScreen)CreateOTGDimensionsScreen.this).currentSelection.Overworld.NonOTGWorldType != null ? (((CreateOTGDimensionsScreen)CreateOTGDimensionsScreen.this).currentSelection.Overworld.NonOTGWorldType.equals("Default") ? "Vanilla" : ((CreateOTGDimensionsScreen)CreateOTGDimensionsScreen.this).currentSelection.Overworld.NonOTGWorldType) : "Vanilla") : ((CreateOTGDimensionsScreen)CreateOTGDimensionsScreen.this).currentSelection.Overworld.PresetFolderName, 0));
            this.func_230513_b_((AbstractList.AbstractListEntry)new LayerEntry("Nether", ((CreateOTGDimensionsScreen)CreateOTGDimensionsScreen.this).currentSelection.Nether.PresetFolderName == null ? "Vanilla" : ((CreateOTGDimensionsScreen)CreateOTGDimensionsScreen.this).currentSelection.Nether.PresetFolderName, 1));
            this.func_230513_b_((AbstractList.AbstractListEntry)new LayerEntry("End", ((CreateOTGDimensionsScreen)CreateOTGDimensionsScreen.this).currentSelection.End.PresetFolderName == null ? "Vanilla" : ((CreateOTGDimensionsScreen)CreateOTGDimensionsScreen.this).currentSelection.End.PresetFolderName, 2));
            int dimId = 3;
            for (DimensionConfig.OTGDimension dim : ((CreateOTGDimensionsScreen)CreateOTGDimensionsScreen.this).currentSelection.Dimensions) {
                this.func_230513_b_((AbstractList.AbstractListEntry)new LayerEntry("OTG " + (dimId - 2), dim.PresetFolderName == null ? "None" : dim.PresetFolderName, dimId));
                ++dimId;
            }
            List list = this.func_231039_at__();
            if (i >= 0 && i < list.size()) {
                this.setSelected((LayerEntry)((Object)list.get(i)));
            }
        }

        @OnlyIn(value=Dist.CLIENT)
        class LayerEntry
        extends ExtendedList.AbstractListEntry<LayerEntry> {
            private final String dimensionName;
            private String presetFolderName;
            private int dimId;

            private LayerEntry(String dimensionName, String presetFolderName, int dimId) {
                this.dimensionName = dimensionName;
                this.presetFolderName = presetFolderName;
                this.dimId = dimId;
            }

            public void func_230432_a_(MatrixStack p_230432_1_, int p_230432_2_, int p_230432_3_, int p_230432_4_, int p_230432_5_, int p_230432_6_, int p_230432_7_, int p_230432_8_, boolean p_230432_9_, float p_230432_10_) {
                String s = I18n.func_135052_a((String)this.dimensionName, (Object[])new Object[]{32});
                CreateOTGDimensionsScreen.this.field_230712_o_.func_238421_b_(p_230432_1_, s, (float)p_230432_4_, (float)(p_230432_3_ + 3), 0xFFFFFF);
                String s1 = I18n.func_135052_a((String)this.presetFolderName, (Object[])new Object[]{32});
                CreateOTGDimensionsScreen.this.field_230712_o_.func_238421_b_(p_230432_1_, s1, (float)(p_230432_4_ + 2 + 213 - CreateOTGDimensionsScreen.this.field_230712_o_.func_78256_a(s1)), (float)(p_230432_3_ + 3), 0xFFFFFF);
            }

            public boolean func_231044_a_(double p_231044_1_, double p_231044_3_, int p_231044_5_) {
                if (p_231044_5_ == 0 && !CreateOTGDimensionsScreen.this.uiLocked) {
                    DetailsList.this.setSelected(this);
                    if (this.dimId <= 2) {
                        DetailsList.this.field_230668_b_.func_147108_a((Screen)new SelectOTGPresetScreen(CreateOTGDimensionsScreen.this, CreateOTGDimensionsScreen.this.currentSelection, this.dimId));
                    }
                    return true;
                }
                return false;
            }
        }
    }
}

