/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.gui.screens;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.pg85.otg.config.dimensions.DimensionConfig;
import com.pg85.otg.forge.gui.OTGGui;
import com.pg85.otg.forge.gui.screens.CreateOTGDimensionsScreen;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Random;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.DialogTexts;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.BiomeGeneratorTypeScreens;
import net.minecraft.client.gui.screen.CreateWorldScreen;
import net.minecraft.client.gui.screen.DirtMessageScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.WorldOptionsScreen;
import net.minecraft.client.gui.toasts.SystemToast;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.resources.ResourcePackList;
import net.minecraft.util.FileUtil;
import net.minecraft.util.Util;
import net.minecraft.util.datafix.codec.DatapackCodec;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.GameType;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.gen.settings.DimensionGeneratorSettings;
import net.minecraft.world.storage.FolderName;
import net.minecraft.world.storage.SaveFormat;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModpackCreateWorldScreen
extends CreateWorldScreen {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ITextComponent GAME_MODEL_LABEL = new TranslationTextComponent("selectWorld.gameMode");
    private static final ITextComponent NAME_LABEL = new TranslationTextComponent("selectWorld.enterName");
    private static final ITextComponent OUTPUT_DIR_INFO = new TranslationTextComponent("selectWorld.resultFolder");
    private static final ITextComponent COMMANDS_INFO = new TranslationTextComponent("selectWorld.allowCommands.info");
    private TextFieldWidget seedEdit;
    private GameMode gameMode = GameMode.SURVIVAL;
    @Nullable
    private GameMode oldGameMode;
    private Difficulty selectedDifficulty = Difficulty.NORMAL;
    private boolean commandsChanged;
    @Nullable
    private Path tempDataPackDir;
    @Nullable
    private ResourcePackList tempDataPackRepository;
    private Button createButton;
    private Button difficultyButton;
    private Button commandsButton;
    private ITextComponent gameModeHelp1;
    private ITextComponent gameModeHelp2;
    private String initName = I18n.func_135052_a((String)"selectWorld.newWorld", (Object[])new Object[0]);
    private String initSeed = "";
    private ITextComponent title2;

    public static ModpackCreateWorldScreen create(@Nullable Screen screen) {
        DynamicRegistries.Impl dynamicregistry = DynamicRegistries.func_239770_b_();
        DimensionGeneratorSettings dimGenSettings = ForgeHooksClient.getDefaultWorldType().map(type -> type.func_241220_a_(dynamicregistry, new Random().nextLong(), true, false)).orElseGet(() -> DimensionGeneratorSettings.func_242751_a((Registry)dynamicregistry.func_243612_b(Registry.field_239698_ad_), (Registry)dynamicregistry.func_243612_b(Registry.field_239720_u_), (Registry)dynamicregistry.func_243612_b(Registry.field_243549_ar)));
        return new ModpackCreateWorldScreen(screen, DatapackCodec.field_234880_a_, new WorldOptionsScreen(dynamicregistry, dimGenSettings, ForgeHooksClient.getDefaultWorldType(), OptionalLong.empty()), dimGenSettings);
    }

    public ModpackCreateWorldScreen(@Nullable Screen screen, DatapackCodec datapackCodec, WorldOptionsScreen worldGenSettingsComponent, DimensionGeneratorSettings dimGenSettings) {
        super(screen, datapackCodec, worldGenSettingsComponent);
        Optional<BiomeGeneratorTypeScreens> preset = Optional.of(OTGGui.OTG_WORLD_TYPE);
        BiomeGeneratorTypeScreens.IFactory biomegeneratortypescreens$ifactory = (BiomeGeneratorTypeScreens.IFactory)BiomeGeneratorTypeScreens.field_239069_d_.get(preset);
        biomegeneratortypescreens$ifactory = ForgeHooksClient.getBiomeGeneratorTypeScreenFactory(preset, (BiomeGeneratorTypeScreens.IFactory)biomegeneratortypescreens$ifactory);
        if (biomegeneratortypescreens$ifactory != null) {
            ((CreateOTGDimensionsScreen)biomegeneratortypescreens$ifactory.createEditScreen((CreateWorldScreen)this, dimGenSettings)).applySettings();
        }
    }

    public void func_231023_e_() {
        this.field_146333_g.func_146178_a();
        this.seedEdit.func_146178_a();
    }

    protected void func_231160_c_() {
        int i = this.field_230708_k_ / 2 - 155;
        int j = this.field_230708_k_ / 2 + 5;
        this.field_230706_i_.field_195559_v.func_197967_a(true);
        this.field_146333_g = new TextFieldWidget(this.field_230712_o_, i, 60, 150, 20, (ITextComponent)new TranslationTextComponent("selectWorld.enterName")){

            protected IFormattableTextComponent func_230442_c_() {
                return super.func_230442_c_().func_240702_b_(". ").func_230529_a_((ITextComponent)new TranslationTextComponent("selectWorld.resultFolder")).func_240702_b_(" ").func_240702_b_(ModpackCreateWorldScreen.this.field_146336_i);
            }
        };
        this.seedEdit = new TextFieldWidget(this.field_230712_o_, j, 60, 150, 20, (ITextComponent)new TranslationTextComponent("selectWorld.enterName")){

            protected IFormattableTextComponent func_230442_c_() {
                return super.func_230442_c_().func_240702_b_(". ").func_230529_a_((ITextComponent)new TranslationTextComponent("selectWorld.resultFolder")).func_240702_b_(" ").func_240702_b_(ModpackCreateWorldScreen.this.field_146336_i);
            }
        };
        this.field_146333_g.func_146180_a(this.initName);
        this.seedEdit.func_146180_a(this.initSeed);
        this.field_146333_g.func_212954_a(p_214319_1_ -> {
            this.initName = p_214319_1_;
            this.createButton.field_230693_o_ = !this.field_146333_g.func_146179_b().isEmpty();
            this.updateResultFolder();
        });
        this.field_230705_e_.add(this.field_146333_g);
        this.seedEdit.func_212954_a(p_214319_1_ -> {
            this.initSeed = p_214319_1_;
        });
        this.field_230705_e_.add(this.seedEdit);
        this.func_230480_a_(new Button(i, 110, 150, 20, StringTextComponent.field_240750_d_, p_214316_1_ -> {
            switch (this.gameMode) {
                case SURVIVAL: {
                    this.setGameMode(GameMode.HARDCORE);
                    break;
                }
                case HARDCORE: {
                    this.setGameMode(GameMode.CREATIVE);
                    break;
                }
                case CREATIVE: {
                    this.setGameMode(GameMode.SURVIVAL);
                }
            }
            p_214316_1_.func_230994_c_(250);
        }){

            public ITextComponent func_230458_i_() {
                return new TranslationTextComponent("options.generic_value", new Object[]{GAME_MODEL_LABEL, new TranslationTextComponent("selectWorld.gameMode." + ModpackCreateWorldScreen.this.gameMode.name)});
            }

            protected IFormattableTextComponent func_230442_c_() {
                return super.func_230442_c_().func_240702_b_(". ").func_230529_a_(ModpackCreateWorldScreen.this.gameModeHelp1).func_240702_b_(" ").func_230529_a_(ModpackCreateWorldScreen.this.gameModeHelp2);
            }
        });
        this.difficultyButton = this.func_230480_a_(new Button(j, 110, 150, 20, (ITextComponent)new TranslationTextComponent("options.difficulty"), p_238956_1_ -> {
            this.field_238937_w_ = this.selectedDifficulty = this.selectedDifficulty.func_233536_d_();
            p_238956_1_.func_230994_c_(250);
        }){

            public ITextComponent func_230458_i_() {
                return new TranslationTextComponent("options.difficulty").func_240702_b_(": ").func_230529_a_(ModpackCreateWorldScreen.this.field_238937_w_.func_199285_b());
            }
        });
        this.commandsButton = this.func_230480_a_(new Button(i, 161, 150, 20, (ITextComponent)new TranslationTextComponent("selectWorld.allowCommands"), p_214322_1_ -> {
            this.commandsChanged = true;
            this.field_146340_t = !this.field_146340_t;
            p_214322_1_.func_230994_c_(250);
        }){

            public ITextComponent func_230458_i_() {
                return DialogTexts.func_244281_a((ITextComponent)super.func_230458_i_(), (ModpackCreateWorldScreen.this.field_146340_t && !ModpackCreateWorldScreen.this.field_146337_w ? 1 : 0) != 0);
            }

            protected IFormattableTextComponent func_230442_c_() {
                return super.func_230442_c_().func_240702_b_(". ").func_230529_a_((ITextComponent)new TranslationTextComponent("selectWorld.allowCommands.info"));
            }
        });
        this.func_230480_a_(new Button(j, 161, 150, 20, (ITextComponent)new StringTextComponent("Dimensions"), p_214322_1_ -> {
            Optional<BiomeGeneratorTypeScreens> preset = Optional.of(OTGGui.OTG_WORLD_TYPE);
            BiomeGeneratorTypeScreens.IFactory biomegeneratortypescreens$ifactory = (BiomeGeneratorTypeScreens.IFactory)BiomeGeneratorTypeScreens.field_239069_d_.get(preset);
            if ((biomegeneratortypescreens$ifactory = ForgeHooksClient.getBiomeGeneratorTypeScreenFactory(preset, (BiomeGeneratorTypeScreens.IFactory)biomegeneratortypescreens$ifactory)) != null) {
                this.field_230706_i_.func_147108_a(biomegeneratortypescreens$ifactory.createEditScreen((CreateWorldScreen)this, this.field_238934_c_.func_239054_a_(this.field_146337_w)));
            }
        }){

            public ITextComponent func_230458_i_() {
                return new StringTextComponent("Dimensions");
            }

            protected IFormattableTextComponent func_230442_c_() {
                return super.func_230442_c_().func_240702_b_(". ").func_230529_a_((ITextComponent)new StringTextComponent("Dimensions"));
            }
        });
        this.createButton = this.func_230480_a_(new Button(i, this.field_230709_l_ - 28, 150, 20, (ITextComponent)new TranslationTextComponent("selectWorld.create"), p_214318_1_ -> this.onCreate()));
        this.createButton.field_230693_o_ = !this.initName.isEmpty();
        this.func_230480_a_(new Button(j, this.field_230709_l_ - 28, 150, 20, DialogTexts.field_240633_d_, p_214317_1_ -> this.func_243430_k()));
        this.field_238934_c_.func_239048_a_((CreateWorldScreen)this, this.field_230706_i_, this.field_230712_o_);
        this.func_238955_g_();
        this.func_212928_a((IGuiEventListener)this.field_146333_g);
        this.setGameMode(this.gameMode);
        this.updateResultFolder();
        DimensionConfig modPackConfig = DimensionConfig.fromDisk("Modpack");
        this.title2 = modPackConfig == null || modPackConfig.ModpackName == null ? new TranslationTextComponent("otg.createDimensions.customize.title") : new StringTextComponent(modPackConfig.ModpackName);
    }

    private void updateGameModeHelp() {
        this.gameModeHelp1 = new TranslationTextComponent("selectWorld.gameMode." + this.gameMode.name + ".line1");
        this.gameModeHelp2 = new TranslationTextComponent("selectWorld.gameMode." + this.gameMode.name + ".line2");
    }

    private void updateResultFolder() {
        this.field_146336_i = this.field_146333_g.func_146179_b().trim();
        if (this.field_146336_i.isEmpty()) {
            this.field_146336_i = "World";
        }
        try {
            this.field_146336_i = FileUtil.func_214992_a((Path)this.field_230706_i_.func_71359_d().func_215781_c(), (String)this.field_146336_i, (String)"");
        }
        catch (Exception exception1) {
            this.field_146336_i = "World";
            try {
                this.field_146336_i = FileUtil.func_214992_a((Path)this.field_230706_i_.func_71359_d().func_215781_c(), (String)this.field_146336_i, (String)"");
            }
            catch (Exception exception) {
                throw new RuntimeException("Could not create save folder", exception);
            }
        }
    }

    public void func_231164_f_() {
        this.field_230706_i_.field_195559_v.func_197967_a(false);
    }

    private void onCreate() {
        this.field_230706_i_.func_241562_c_((Screen)new DirtMessageScreen((ITextComponent)new TranslationTextComponent("createWorld.preparing")));
        if (this.copyTempDataPackDirToNewWorld()) {
            this.cleanupTempResources();
            WorldSettings worldsettings = new WorldSettings(this.field_146333_g.func_146179_b().trim(), this.gameMode.gameType, this.field_146337_w, this.field_238937_w_, this.field_146340_t && !this.field_146337_w, this.field_238932_M_, this.field_238933_b_);
            this.field_230706_i_.func_238192_a_(this.field_146336_i, worldsettings, this.field_238934_c_.func_239055_b_(), this.field_238934_c_.func_239054_a_(worldsettings.func_234954_c_()).func_236220_a_(worldsettings.func_234954_c_(), this.parseSeed()));
        }
    }

    private OptionalLong parseSeed() {
        OptionalLong optionallong1;
        String s = this.seedEdit.func_146179_b();
        OptionalLong optionallong = StringUtils.isEmpty((CharSequence)s) ? OptionalLong.empty() : ((optionallong1 = ModpackCreateWorldScreen.parseLong(s)).isPresent() && optionallong1.getAsLong() != 0L ? optionallong1 : OptionalLong.of(s.hashCode()));
        return optionallong;
    }

    private static OptionalLong parseLong(String p_239053_0_) {
        try {
            return OptionalLong.of(Long.parseLong(p_239053_0_));
        }
        catch (NumberFormatException numberformatexception) {
            return OptionalLong.empty();
        }
    }

    private void setGameMode(GameMode p_228200_1_) {
        if (!this.commandsChanged) {
            boolean bl = this.field_146340_t = p_228200_1_ == GameMode.CREATIVE;
        }
        if (p_228200_1_ == GameMode.HARDCORE) {
            this.field_146337_w = true;
            this.commandsButton.field_230693_o_ = false;
            this.field_238937_w_ = Difficulty.HARD;
            this.difficultyButton.field_230693_o_ = false;
        } else {
            this.field_146337_w = false;
            this.commandsButton.field_230693_o_ = true;
            this.field_238937_w_ = this.selectedDifficulty;
            this.difficultyButton.field_230693_o_ = true;
        }
        this.gameMode = p_228200_1_;
        this.updateGameModeHelp();
    }

    public void func_238955_g_() {
    }

    public boolean func_231046_a_(int p_231046_1_, int p_231046_2_, int p_231046_3_) {
        if (super.func_231046_a_(p_231046_1_, p_231046_2_, p_231046_3_)) {
            return true;
        }
        if (p_231046_1_ != 257 && p_231046_1_ != 335) {
            return false;
        }
        this.onCreate();
        return true;
    }

    public void func_231175_as__() {
        this.func_243430_k();
    }

    public void func_243430_k() {
        this.field_230706_i_.func_147108_a(this.field_146332_f);
        this.cleanupTempResources();
    }

    private void cleanupTempResources() {
        if (this.tempDataPackRepository != null) {
            this.tempDataPackRepository.close();
        }
        this.removeTempDataPackDir();
    }

    public void func_230430_a_(MatrixStack p_230430_1_, int p_230430_2_, int p_230430_3_, float p_230430_4_) {
        this.func_230446_a_(p_230430_1_);
        ModpackCreateWorldScreen.func_238472_a_((MatrixStack)p_230430_1_, (FontRenderer)this.field_230712_o_, (ITextComponent)this.title2, (int)(this.field_230708_k_ / 2), (int)20, (int)-1);
        ModpackCreateWorldScreen.func_238475_b_((MatrixStack)p_230430_1_, (FontRenderer)this.field_230712_o_, (ITextComponent)NAME_LABEL, (int)(this.field_230708_k_ / 2 - 150), (int)47, (int)-6250336);
        ModpackCreateWorldScreen.func_238475_b_((MatrixStack)p_230430_1_, (FontRenderer)this.field_230712_o_, (ITextComponent)new StringTextComponent("").func_230529_a_(OUTPUT_DIR_INFO).func_240702_b_(" ").func_240702_b_(this.field_146336_i), (int)(this.field_230708_k_ / 2 - 150), (int)85, (int)-6250336);
        ModpackCreateWorldScreen.func_238476_c_((MatrixStack)p_230430_1_, (FontRenderer)this.field_230712_o_, (String)"Seed", (int)(this.field_230708_k_ / 2 + 10), (int)47, (int)-6250336);
        this.field_146333_g.func_230430_a_(p_230430_1_, p_230430_2_, p_230430_3_, p_230430_4_);
        this.seedEdit.func_230430_a_(p_230430_1_, p_230430_2_, p_230430_3_, p_230430_4_);
        ModpackCreateWorldScreen.func_238475_b_((MatrixStack)p_230430_1_, (FontRenderer)this.field_230712_o_, (ITextComponent)this.gameModeHelp1, (int)(this.field_230708_k_ / 2 - 150), (int)132, (int)-6250336);
        ModpackCreateWorldScreen.func_238475_b_((MatrixStack)p_230430_1_, (FontRenderer)this.field_230712_o_, (ITextComponent)this.gameModeHelp2, (int)(this.field_230708_k_ / 2 - 150), (int)144, (int)-6250336);
        if (this.commandsButton.field_230694_p_) {
            ModpackCreateWorldScreen.func_238475_b_((MatrixStack)p_230430_1_, (FontRenderer)this.field_230712_o_, (ITextComponent)COMMANDS_INFO, (int)(this.field_230708_k_ / 2 - 150), (int)182, (int)-6250336);
        }
        for (int i = 0; i < this.field_230710_m_.size(); ++i) {
            ((Widget)this.field_230710_m_.get(i)).func_230430_a_(p_230430_1_, p_230430_2_, p_230430_3_, p_230430_4_);
        }
    }

    protected <T extends IGuiEventListener> T func_230481_d_(T p_230481_1_) {
        return (T)super.func_230481_d_(p_230481_1_);
    }

    protected <T extends Widget> T func_230480_a_(T p_230480_1_) {
        return (T)super.func_230480_a_(p_230480_1_);
    }

    @Nullable
    protected Path func_238957_j_() {
        if (this.tempDataPackDir == null) {
            try {
                this.tempDataPackDir = Files.createTempDirectory("mcworld-", new FileAttribute[0]);
            }
            catch (IOException ioexception) {
                LOGGER.warn("Failed to create temporary dir", (Throwable)ioexception);
                SystemToast.func_238539_c_((Minecraft)this.field_230706_i_, (String)this.field_146336_i);
                this.func_243430_k();
            }
        }
        return this.tempDataPackDir;
    }

    private void removeTempDataPackDir() {
        if (this.tempDataPackDir != null) {
            try (Stream<Path> stream = Files.walk(this.tempDataPackDir, new FileVisitOption[0]);){
                stream.sorted(Comparator.reverseOrder()).forEach(p_238948_0_ -> {
                    try {
                        Files.delete(p_238948_0_);
                    }
                    catch (IOException ioexception1) {
                        LOGGER.warn("Failed to remove temporary file {}", p_238948_0_, (Object)ioexception1);
                    }
                });
            }
            catch (IOException ioexception) {
                LOGGER.warn("Failed to list temporary dir {}", (Object)this.tempDataPackDir);
            }
            this.tempDataPackDir = null;
        }
    }

    private static void copyBetweenDirs(Path p_238945_0_, Path p_238945_1_, Path p_238945_2_) {
        try {
            Util.func_240984_a_((Path)p_238945_0_, (Path)p_238945_1_, (Path)p_238945_2_);
        }
        catch (IOException ioexception) {
            LOGGER.warn("Failed to copy datapack file from {} to {}", (Object)p_238945_2_, (Object)p_238945_1_);
            throw new DatapackException(ioexception);
        }
    }

    private boolean copyTempDataPackDirToNewWorld() {
        if (this.tempDataPackDir != null) {
            try (SaveFormat.LevelSave saveformat$levelsave = this.field_230706_i_.func_71359_d().func_237274_c_(this.field_146336_i);
                 Stream<Path> stream = Files.walk(this.tempDataPackDir, new FileVisitOption[0]);){
                Path path = saveformat$levelsave.func_237285_a_(FolderName.field_237251_g_);
                Files.createDirectories(path, new FileAttribute[0]);
                stream.filter(p_238942_1_ -> !p_238942_1_.equals(this.tempDataPackDir)).forEach(p_238949_2_ -> ModpackCreateWorldScreen.copyBetweenDirs(this.tempDataPackDir, path, p_238949_2_));
            }
            catch (DatapackException | IOException ioexception) {
                LOGGER.warn("Failed to copy datapacks to world {}", (Object)this.field_146336_i, (Object)ioexception);
                SystemToast.func_238539_c_((Minecraft)this.field_230706_i_, (String)this.field_146336_i);
                this.func_243430_k();
                return false;
            }
        }
        return true;
    }

    @Nullable
    public static Path createTempDataPackDirFromExistingWorld(Path p_238943_0_, Minecraft p_238943_1_) {
        MutableObject mutableobject = new MutableObject();
        try (Stream<Path> stream = Files.walk(p_238943_0_, new FileVisitOption[0]);){
            stream.filter(p_238944_1_ -> !p_238944_1_.equals(p_238943_0_)).forEach(p_238947_2_ -> {
                Path path = (Path)mutableobject.getValue();
                if (path == null) {
                    try {
                        path = Files.createTempDirectory("mcworld-", new FileAttribute[0]);
                    }
                    catch (IOException ioexception1) {
                        LOGGER.warn("Failed to create temporary dir");
                        throw new DatapackException(ioexception1);
                    }
                    mutableobject.setValue((Object)path);
                }
                ModpackCreateWorldScreen.copyBetweenDirs(p_238943_0_, path, p_238947_2_);
            });
        }
        catch (DatapackException | IOException ioexception) {
            LOGGER.warn("Failed to copy datapacks from world {}", (Object)p_238943_0_, (Object)ioexception);
            SystemToast.func_238539_c_((Minecraft)p_238943_1_, (String)p_238943_0_.toString());
            return null;
        }
        return (Path)mutableobject.getValue();
    }

    @OnlyIn(value=Dist.CLIENT)
    static enum GameMode {
        SURVIVAL("survival", GameType.SURVIVAL),
        HARDCORE("hardcore", GameType.SURVIVAL),
        CREATIVE("creative", GameType.CREATIVE),
        DEBUG("spectator", GameType.SPECTATOR);

        private final String name;
        private final GameType gameType;

        private GameMode(String p_i225940_3_, GameType p_i225940_4_) {
            this.name = p_i225940_3_;
            this.gameType = p_i225940_4_;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class DatapackException
    extends RuntimeException {
        public DatapackException(Throwable p_i232309_1_) {
            super(p_i232309_1_);
        }
    }
}

