/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.gui.screens;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.pg85.otg.OTG;
import com.pg85.otg.config.dimensions.DimensionConfig;
import com.pg85.otg.forge.gui.screens.CreateOTGDimensionsScreen;
import com.pg85.otg.forge.gui.screens.OTGCustomiseOverworldScreen;
import com.pg85.otg.presets.Preset;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.client.gui.widget.list.ExtendedList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SelectOTGPresetScreen
extends Screen {
    private static final ITextComponent SELECT_PRESET = new TranslationTextComponent("otg.createWorld.customize.preset");
    private final CreateOTGDimensionsScreen parent;
    private final ArrayList<Preset> presetList = new ArrayList();
    private PresetList guiPresetList;
    private final int dimId;
    private final DimensionConfig currentSelection;
    private Preset selectedPreset;

    public SelectOTGPresetScreen(CreateOTGDimensionsScreen parent, DimensionConfig currentSelection, int dimId) {
        super((ITextComponent)new TranslationTextComponent("otg.createWorld.customize.title"));
        this.parent = parent;
        ArrayList<Preset> presetList = OTG.getEngine().getPresetLoader().getAllPresets();
        this.presetList.add(0, null);
        for (Preset preset : presetList) {
            if (dimId != 0 && preset.getFolderName() == currentSelection.Overworld.PresetFolderName || dimId != 1 && preset.getFolderName() == currentSelection.Nether.PresetFolderName || dimId != 2 && preset.getFolderName() == currentSelection.End.PresetFolderName) continue;
            boolean bFound = false;
            int dimId2 = 3;
            for (DimensionConfig.OTGDimension otgDim : currentSelection.Dimensions) {
                if (dimId != dimId2 && preset.getFolderName() == otgDim.PresetFolderName) {
                    bFound = true;
                    break;
                }
                ++dimId2;
            }
            if (bFound) continue;
            this.presetList.add(preset);
        }
        this.dimId = dimId;
        this.currentSelection = currentSelection;
    }

    public void func_231175_as__() {
        this.field_230706_i_.func_147108_a((Screen)this.parent);
    }

    protected void func_231160_c_() {
        this.field_230706_i_.field_195559_v.func_197967_a(true);
        this.guiPresetList = new PresetList();
        this.field_230705_e_.add(this.guiPresetList);
        this.guiPresetList.setSelected(this.guiPresetList.func_231039_at__().stream().filter(entry -> ((PresetList.PresetEntry)entry).preset != null && this.selectedPreset != null && Objects.equals(((PresetList.PresetEntry)entry).preset.getFolderName(), this.selectedPreset.getFolderName())).findFirst().orElse(null));
    }

    public void func_230430_a_(MatrixStack p_230430_1_, int p_230430_2_, int p_230430_3_, float p_230430_4_) {
        this.func_231165_f_(0);
        this.guiPresetList.func_230430_a_(p_230430_1_, p_230430_2_, p_230430_3_, p_230430_4_);
        SelectOTGPresetScreen.func_238472_a_((MatrixStack)p_230430_1_, (FontRenderer)this.field_230712_o_, (ITextComponent)this.field_230704_d_, (int)(this.field_230708_k_ / 2), (int)8, (int)0xFFFFFF);
        SelectOTGPresetScreen.func_238472_a_((MatrixStack)p_230430_1_, (FontRenderer)this.field_230712_o_, (ITextComponent)SELECT_PRESET, (int)(this.field_230708_k_ / 2), (int)28, (int)0xA0A0A0);
        super.func_230430_a_(p_230430_1_, p_230430_2_, p_230430_3_, p_230430_4_);
    }

    @OnlyIn(value=Dist.CLIENT)
    class PresetList
    extends ExtendedList<PresetEntry> {
        private PresetList() {
            super(SelectOTGPresetScreen.this.field_230706_i_, SelectOTGPresetScreen.this.field_230708_k_, SelectOTGPresetScreen.this.field_230709_l_, 40, SelectOTGPresetScreen.this.field_230709_l_ - 37, 16);
            SelectOTGPresetScreen.this.presetList.forEach(preset -> this.func_230513_b_((AbstractList.AbstractListEntry)new PresetEntry((Preset)preset)));
        }

        protected boolean func_230971_aw__() {
            return SelectOTGPresetScreen.this.func_241217_q_() == this;
        }

        public void setSelected(@Nullable PresetEntry p_241215_1_) {
            super.func_241215_a_((AbstractList.AbstractListEntry)p_241215_1_);
            if (p_241215_1_ != null) {
                SelectOTGPresetScreen.this.selectedPreset = p_241215_1_.preset;
                NarratorChatListener.field_193643_a.func_216864_a(p_241215_1_.preset.getFolderName());
            }
        }

        @OnlyIn(value=Dist.CLIENT)
        class PresetEntry
        extends ExtendedList.AbstractListEntry<PresetEntry> {
            private final Preset preset;
            private final ITextComponent field_243282_c;

            public PresetEntry(Preset p_i232272_2_) {
                this.preset = p_i232272_2_;
                this.field_243282_c = new StringTextComponent(p_i232272_2_ == null ? (SelectOTGPresetScreen.this.dimId == 0 ? "Non-OTG (Customize)" : (SelectOTGPresetScreen.this.dimId < 3 ? "Vanilla" : "None")) : p_i232272_2_.getFolderName());
            }

            public void func_230432_a_(MatrixStack p_230432_1_, int p_230432_2_, int p_230432_3_, int p_230432_4_, int p_230432_5_, int p_230432_6_, int p_230432_7_, int p_230432_8_, boolean p_230432_9_, float p_230432_10_) {
                AbstractGui.func_238475_b_((MatrixStack)p_230432_1_, (FontRenderer)SelectOTGPresetScreen.this.field_230712_o_, (ITextComponent)this.field_243282_c, (int)(p_230432_4_ + 5), (int)(p_230432_3_ + 2), (int)0xFFFFFF);
            }

            public boolean func_231044_a_(double p_231044_1_, double p_231044_3_, int p_231044_5_) {
                if (p_231044_5_ == 0) {
                    if (this.preset == null && SelectOTGPresetScreen.this.dimId == 0) {
                        ((SelectOTGPresetScreen)SelectOTGPresetScreen.this).currentSelection.Overworld = new DimensionConfig.OTGOverWorld(null, -1L, null, null);
                        SelectOTGPresetScreen.this.field_230706_i_.func_147108_a((Screen)OTGCustomiseOverworldScreen.create(SelectOTGPresetScreen.this.parent, SelectOTGPresetScreen.this.currentSelection));
                    } else {
                        DimensionConfig.OTGDimension otgDim = new DimensionConfig.OTGDimension(this.preset == null ? null : this.preset.getFolderName(), -1L);
                        switch (SelectOTGPresetScreen.this.dimId) {
                            case 0: {
                                ((SelectOTGPresetScreen)SelectOTGPresetScreen.this).currentSelection.Overworld = new DimensionConfig.OTGOverWorld(this.preset == null ? null : this.preset.getFolderName(), -1L, null, null);
                                break;
                            }
                            case 1: {
                                ((SelectOTGPresetScreen)SelectOTGPresetScreen.this).currentSelection.Nether = otgDim;
                                break;
                            }
                            case 2: {
                                ((SelectOTGPresetScreen)SelectOTGPresetScreen.this).currentSelection.End = otgDim;
                                break;
                            }
                            default: {
                                ((SelectOTGPresetScreen)SelectOTGPresetScreen.this).currentSelection.Dimensions.set(SelectOTGPresetScreen.this.dimId - 3, otgDim);
                            }
                        }
                        SelectOTGPresetScreen.this.field_230706_i_.func_147108_a((Screen)SelectOTGPresetScreen.this.parent);
                    }
                    return true;
                }
                return false;
            }
        }
    }
}

