/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.materials;

import com.pg85.otg.OTG;
import com.pg85.otg.util.logging.LogCategory;
import com.pg85.otg.util.logging.LogLevel;
import com.pg85.otg.util.minecraft.BlockNames;
import net.minecraft.block.AnvilBlock;
import net.minecraft.block.BannerBlock;
import net.minecraft.block.BedBlock;
import net.minecraft.block.BeetrootBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.BrewingStandBlock;
import net.minecraft.block.CactusBlock;
import net.minecraft.block.CakeBlock;
import net.minecraft.block.CarrotBlock;
import net.minecraft.block.CarvedPumpkinBlock;
import net.minecraft.block.CauldronBlock;
import net.minecraft.block.ChestBlock;
import net.minecraft.block.CocoaBlock;
import net.minecraft.block.ComparatorBlock;
import net.minecraft.block.CropsBlock;
import net.minecraft.block.DaylightDetectorBlock;
import net.minecraft.block.DetectorRailBlock;
import net.minecraft.block.DispenserBlock;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.DropperBlock;
import net.minecraft.block.EndPortalFrameBlock;
import net.minecraft.block.EndRodBlock;
import net.minecraft.block.EnderChestBlock;
import net.minecraft.block.FarmlandBlock;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.block.FireBlock;
import net.minecraft.block.FurnaceBlock;
import net.minecraft.block.GlazedTerracottaBlock;
import net.minecraft.block.HayBlock;
import net.minecraft.block.HopperBlock;
import net.minecraft.block.HugeMushroomBlock;
import net.minecraft.block.JukeboxBlock;
import net.minecraft.block.LadderBlock;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.LeverBlock;
import net.minecraft.block.NetherPortalBlock;
import net.minecraft.block.NetherWartBlock;
import net.minecraft.block.ObserverBlock;
import net.minecraft.block.PistonBlock;
import net.minecraft.block.PistonHeadBlock;
import net.minecraft.block.PotatoBlock;
import net.minecraft.block.PoweredRailBlock;
import net.minecraft.block.PressurePlateBlock;
import net.minecraft.block.RailBlock;
import net.minecraft.block.RedstoneLampBlock;
import net.minecraft.block.RedstoneWallTorchBlock;
import net.minecraft.block.RedstoneWireBlock;
import net.minecraft.block.RepeaterBlock;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.block.ShulkerBoxBlock;
import net.minecraft.block.SkullBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.SnowBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.block.StandingSignBlock;
import net.minecraft.block.StemBlock;
import net.minecraft.block.StoneButtonBlock;
import net.minecraft.block.StructureBlock;
import net.minecraft.block.SugarCaneBlock;
import net.minecraft.block.TrapDoorBlock;
import net.minecraft.block.TrappedChestBlock;
import net.minecraft.block.TripWireBlock;
import net.minecraft.block.TripWireHookBlock;
import net.minecraft.block.VineBlock;
import net.minecraft.block.WallBannerBlock;
import net.minecraft.block.WallSignBlock;
import net.minecraft.block.WallTorchBlock;
import net.minecraft.block.WeightedPressurePlateBlock;
import net.minecraft.block.WoodButtonBlock;
import net.minecraft.state.Property;
import net.minecraft.state.properties.AttachFace;
import net.minecraft.state.properties.BedPart;
import net.minecraft.state.properties.ComparatorMode;
import net.minecraft.state.properties.DoorHingeSide;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.state.properties.Half;
import net.minecraft.state.properties.PistonType;
import net.minecraft.state.properties.RailShape;
import net.minecraft.state.properties.SlabType;
import net.minecraft.state.properties.StructureMode;
import net.minecraft.util.Direction;

class ForgeLegacyMaterials {
    ForgeLegacyMaterials() {
    }

    static BlockState fromLegacyBlockName(String oldBlockName) {
        switch (oldBlockName) {
            case "stationary_water": 
            case "flowing_water": {
                return Blocks.field_150355_j.func_176223_P();
            }
            case "stationary_lava": 
            case "flowing_lava": {
                return Blocks.field_150353_l.func_176223_P();
            }
            case "stained_clay": {
                return Blocks.field_196777_fo.func_176223_P();
            }
            case "hard_clay": {
                return Blocks.field_150405_ch.func_176223_P();
            }
            case "step": {
                return Blocks.field_222401_hJ.func_176223_P();
            }
            case "sugar_cane_block": {
                return Blocks.field_196608_cF.func_176223_P();
            }
            case "melon_block": {
                return Blocks.field_150440_ba.func_176223_P();
            }
            case "water_lily": {
                return Blocks.field_196651_dG.func_176223_P();
            }
            case "soil": {
                return Blocks.field_150458_ak.func_176223_P();
            }
            case "grass": {
                return Blocks.field_196658_i.func_176223_P();
            }
            case "long_grass": {
                return Blocks.field_196804_gh.func_176223_P();
            }
            case "mycel": {
                return Blocks.field_150391_bh.func_176223_P();
            }
            case "snow_layer": {
                return Blocks.field_150433_aE.func_176223_P();
            }
            case "leaves": {
                return (BlockState)Blocks.field_196642_W.func_176223_P().func_206870_a((Property)LeavesBlock.field_208494_a, (Comparable)Integer.valueOf(1));
            }
            case "leaves_2": {
                return (BlockState)Blocks.field_196572_aa.func_176223_P().func_206870_a((Property)LeavesBlock.field_208494_a, (Comparable)Integer.valueOf(1));
            }
            case "red_rose": {
                return Blocks.field_196606_bd.func_176223_P();
            }
            case "double_plant": {
                return Blocks.field_196800_gd.func_176223_P();
            }
            case "wood_stairs": 
            case "oak_stairs": {
                return (BlockState)Blocks.field_150476_ad.func_176223_P().func_206870_a((Property)StairsBlock.field_176309_a, (Comparable)Direction.EAST);
            }
            case "birch_wood_stairs": 
            case "birch_stairs": {
                return (BlockState)Blocks.field_150487_bG.func_176223_P().func_206870_a((Property)StairsBlock.field_176309_a, (Comparable)Direction.EAST);
            }
            case "spruce_wood_stairs": 
            case "spruce_stairs": {
                return (BlockState)Blocks.field_150485_bF.func_176223_P().func_206870_a((Property)StairsBlock.field_176309_a, (Comparable)Direction.EAST);
            }
            case "jungle_wood_stairs": 
            case "jungle_stairs": {
                return (BlockState)Blocks.field_150481_bH.func_176223_P().func_206870_a((Property)StairsBlock.field_176309_a, (Comparable)Direction.EAST);
            }
            case "cobblestone_stairs": 
            case "stone_stairs": {
                return (BlockState)Blocks.field_196659_cl.func_176223_P().func_206870_a((Property)StairsBlock.field_176309_a, (Comparable)Direction.EAST);
            }
            case "nether_brick_stairs": {
                return (BlockState)Blocks.field_150387_bl.func_176223_P().func_206870_a((Property)StairsBlock.field_176309_a, (Comparable)Direction.EAST);
            }
            case "sandstone_stairs": {
                return (BlockState)Blocks.field_150372_bz.func_176223_P().func_206870_a((Property)StairsBlock.field_176309_a, (Comparable)Direction.EAST);
            }
            case "quartz_stairs": {
                return (BlockState)Blocks.field_150370_cb.func_176223_P().func_206870_a((Property)StairsBlock.field_176309_a, (Comparable)Direction.EAST);
            }
            case "acacia_stairs": {
                return (BlockState)Blocks.field_150400_ck.func_176223_P().func_206870_a((Property)StairsBlock.field_176309_a, (Comparable)Direction.EAST);
            }
            case "dark_oak_stairs": {
                return (BlockState)Blocks.field_150401_cl.func_176223_P().func_206870_a((Property)StairsBlock.field_176309_a, (Comparable)Direction.EAST);
            }
            case "red_sandstone_stairs": {
                return (BlockState)Blocks.field_180396_cN.func_176223_P().func_206870_a((Property)StairsBlock.field_176309_a, (Comparable)Direction.EAST);
            }
            case "purpur_stairs": {
                return (BlockState)Blocks.field_185769_cV.func_176223_P().func_206870_a((Property)StairsBlock.field_176309_a, (Comparable)Direction.EAST);
            }
            case "brick_stairs": {
                return (BlockState)Blocks.field_150389_bf.func_176223_P().func_206870_a((Property)StairsBlock.field_176309_a, (Comparable)Direction.EAST);
            }
            case "stone_brick_stairs": 
            case "smooth_stairs": {
                return (BlockState)Blocks.field_150390_bg.func_176223_P().func_206870_a((Property)StairsBlock.field_176309_a, (Comparable)Direction.EAST);
            }
            case "quartz_ore": {
                return Blocks.field_196766_fg.func_176223_P();
            }
            case "yellow_flower": {
                return Blocks.field_196605_bc.func_176223_P();
            }
            case "web": {
                return Blocks.field_196553_aF.func_176223_P();
            }
            case "wall_banner": {
                return Blocks.field_196843_hj.func_176223_P();
            }
            case "redstone_lamp_on": {
                return (BlockState)Blocks.field_150379_bu.func_176223_P().func_206870_a((Property)RedstoneLampBlock.field_196502_a, (Comparable)Boolean.valueOf(true));
            }
            case "redstone_lamp_off": {
                return (BlockState)Blocks.field_150379_bu.func_176223_P().func_206870_a((Property)RedstoneLampBlock.field_196502_a, (Comparable)Boolean.valueOf(false));
            }
            case "wool": {
                return Blocks.field_196556_aL.func_176223_P();
            }
            case "wooden_button": 
            case "wood_button": {
                return Blocks.field_196689_eF.func_176223_P();
            }
            case "waterlily": {
                return Blocks.field_196651_dG.func_176223_P();
            }
            case "log": 
            case "wood": {
                return Blocks.field_196617_K.func_176223_P();
            }
            case "log_2": {
                return Blocks.field_196621_O.func_176223_P();
            }
            case "magma": {
                return Blocks.field_196814_hQ.func_176223_P();
            }
            case "tallgrass": {
                return Blocks.field_150349_c.func_176223_P();
            }
            case "cobble_wall": {
                return Blocks.field_150463_bK.func_176223_P();
            }
            case "iron_fence": {
                return Blocks.field_150411_aY.func_176223_P();
            }
            case "workbench": {
                return Blocks.field_150462_ai.func_176223_P();
            }
            case "enchantment_table": {
                return Blocks.field_150381_bn.func_176223_P();
            }
            case "mob_spawner": {
                return Blocks.field_196686_dc.func_176223_P();
            }
            case "double_step": {
                return (BlockState)Blocks.field_222401_hJ.func_176223_P().func_206870_a((Property)SlabBlock.field_196505_a, (Comparable)SlabType.DOUBLE);
            }
            case "smooth_brick": {
                return Blocks.field_196696_di.func_176223_P();
            }
            case "rails": {
                return Blocks.field_150448_aq.func_176223_P();
            }
            case "fence": {
                return Blocks.field_180407_aO.func_176223_P();
            }
            case "nether_fence": {
                return Blocks.field_150386_bk.func_176223_P();
            }
            case "wood_step": {
                return Blocks.field_196622_bq.func_176223_P();
            }
            case "thin_glass": {
                return Blocks.field_150410_aZ.func_176223_P();
            }
            case "stained_glass_pane": {
                return Blocks.field_196825_gz.func_176223_P();
            }
            case "stone_plate": {
                return Blocks.field_150456_au.func_176223_P();
            }
            case "wood_plate": {
                return Blocks.field_196663_cq.func_176223_P();
            }
            case "wood_double_step": {
                return (BlockState)Blocks.field_196622_bq.func_176223_P().func_206870_a((Property)SlabBlock.field_196505_a, (Comparable)SlabType.DOUBLE);
            }
            case "brick": {
                return Blocks.field_196584_bK.func_176223_P();
            }
            case "iron_door_block": {
                return Blocks.field_150454_av.func_176223_P();
            }
            case "carpet": {
                return Blocks.field_196724_fH.func_176223_P();
            }
            case "carrot": {
                return Blocks.field_150459_bM.func_176223_P();
            }
            case "skull": {
                return Blocks.field_196703_eM.func_176223_P();
            }
            case "nether_wart": {
                return Blocks.field_150388_bm.func_176223_P();
            }
            case "nether_wart_block": {
                return Blocks.field_189878_dg.func_176223_P();
            }
            case "nether_brick": {
                return Blocks.field_196653_dH.func_176223_P();
            }
            case "red_nether_brick": {
                return Blocks.field_196817_hS.func_176223_P();
            }
            case "end_bricks": 
            case "ender_bricks": {
                return Blocks.field_196806_hJ.func_176223_P();
            }
            case "end_stone": 
            case "ender_stone": {
                return Blocks.field_150377_bs.func_176223_P();
            }
            case "mcpitman": {
                return Blocks.field_196714_eU.func_176223_P();
            }
            case "pg85": {
                return Blocks.field_235383_mw_.func_176223_P();
            }
            case "supercoder": {
                return Blocks.field_150414_aQ.func_176223_P();
            }
            case "authvin": {
                return Blocks.field_196577_ad.func_176223_P();
            }
            case "josh": {
                return Blocks.field_222422_lK.func_176223_P();
            }
            case "wahrheit": {
                return Blocks.field_222428_lQ.func_176223_P();
            }
            case "lordsmellypants": {
                return Blocks.field_150457_bL.func_176223_P();
            }
            case "frank": {
                return Blocks.field_150421_aI.func_176223_P();
            }
        }
        return null;
    }

    static BlockState fromLegacyBlockNameOrIdWithData(String blockName, int data) {
        if (blockName == null || blockName.trim().isEmpty()) {
            return null;
        }
        try {
            int blockId = Integer.parseInt(blockName);
            blockName = BlockNames.blockNameFromLegacyBlockId(blockId);
            if (blockName == null) {
                return null;
            }
        }
        catch (NumberFormatException blockId) {
            // empty catch block
        }
        try {
            switch (blockName) {
                case "grass": {
                    if (data == 0) {
                        return Blocks.field_196658_i.func_176223_P();
                    }
                }
                case "banner": 
                case "white_banner": {
                    switch (data) {
                        default: {
                            return Blocks.field_196841_hi.func_176223_P();
                        }
                        case 1: {
                            return Blocks.field_196839_hh.func_176223_P();
                        }
                        case 2: {
                            return Blocks.field_196837_hg.func_176223_P();
                        }
                        case 3: {
                            return Blocks.field_196835_hf.func_176223_P();
                        }
                        case 4: {
                            return Blocks.field_196833_he.func_176223_P();
                        }
                        case 5: {
                            return Blocks.field_196831_hd.func_176223_P();
                        }
                        case 6: {
                            return Blocks.field_196829_hc.func_176223_P();
                        }
                        case 7: {
                            return Blocks.field_196827_hb.func_176223_P();
                        }
                        case 8: {
                            return Blocks.field_196826_ha.func_176223_P();
                        }
                        case 9: {
                            return Blocks.field_196796_gZ.func_176223_P();
                        }
                        case 10: {
                            return Blocks.field_196794_gY.func_176223_P();
                        }
                        case 11: {
                            return Blocks.field_196792_gX.func_176223_P();
                        }
                        case 12: {
                            return Blocks.field_196790_gW.func_176223_P();
                        }
                        case 13: {
                            return Blocks.field_196788_gV.func_176223_P();
                        }
                        case 14: {
                            return Blocks.field_196786_gU.func_176223_P();
                        }
                        case 15: 
                    }
                    return Blocks.field_196784_gT.func_176223_P();
                }
                case "bed": 
                case "white_bed": {
                    switch (data) {
                        default: {
                            return Blocks.field_196587_am.func_176223_P();
                        }
                        case 1: {
                            return Blocks.field_196588_an.func_176223_P();
                        }
                        case 2: {
                            return Blocks.field_196589_ao.func_176223_P();
                        }
                        case 3: {
                            return Blocks.field_196590_ap.func_176223_P();
                        }
                        case 4: {
                            return Blocks.field_196592_aq.func_176223_P();
                        }
                        case 5: {
                            return Blocks.field_196593_ar.func_176223_P();
                        }
                        case 6: {
                            return Blocks.field_196594_as.func_176223_P();
                        }
                        case 7: {
                            return Blocks.field_196595_at.func_176223_P();
                        }
                        case 8: {
                            return Blocks.field_196596_au.func_176223_P();
                        }
                        case 9: {
                            return Blocks.field_196597_av.func_176223_P();
                        }
                        case 10: {
                            return Blocks.field_196598_aw.func_176223_P();
                        }
                        case 11: {
                            return Blocks.field_196599_ax.func_176223_P();
                        }
                        case 12: {
                            return Blocks.field_196600_ay.func_176223_P();
                        }
                        case 13: {
                            return Blocks.field_196601_az.func_176223_P();
                        }
                        case 14: {
                            return Blocks.field_196550_aA.func_176223_P();
                        }
                        case 15: 
                    }
                    return Blocks.field_196551_aB.func_176223_P();
                }
                case "carpet": 
                case "white_carpet": {
                    switch (data) {
                        default: {
                            return Blocks.field_196724_fH.func_176223_P();
                        }
                        case 1: {
                            return Blocks.field_196725_fI.func_176223_P();
                        }
                        case 2: {
                            return Blocks.field_196727_fJ.func_176223_P();
                        }
                        case 3: {
                            return Blocks.field_196729_fK.func_176223_P();
                        }
                        case 4: {
                            return Blocks.field_196731_fL.func_176223_P();
                        }
                        case 5: {
                            return Blocks.field_196733_fM.func_176223_P();
                        }
                        case 6: {
                            return Blocks.field_196735_fN.func_176223_P();
                        }
                        case 7: {
                            return Blocks.field_196737_fO.func_176223_P();
                        }
                        case 8: {
                            return Blocks.field_196739_fP.func_176223_P();
                        }
                        case 9: {
                            return Blocks.field_196741_fQ.func_176223_P();
                        }
                        case 10: {
                            return Blocks.field_196743_fR.func_176223_P();
                        }
                        case 11: {
                            return Blocks.field_196745_fS.func_176223_P();
                        }
                        case 12: {
                            return Blocks.field_196747_fT.func_176223_P();
                        }
                        case 13: {
                            return Blocks.field_196749_fU.func_176223_P();
                        }
                        case 14: {
                            return Blocks.field_196751_fV.func_176223_P();
                        }
                        case 15: 
                    }
                    return Blocks.field_196753_fW.func_176223_P();
                }
                case "cobblestone_wall": 
                case "cobble_wall": {
                    switch (data) {
                        default: {
                            return Blocks.field_150463_bK.func_176223_P();
                        }
                        case 1: 
                    }
                    return Blocks.field_196723_eg.func_176223_P();
                }
                case "concrete": 
                case "white_concrete": {
                    switch (data) {
                        default: {
                            return Blocks.field_196828_iC.func_176223_P();
                        }
                        case 1: {
                            return Blocks.field_196830_iD.func_176223_P();
                        }
                        case 2: {
                            return Blocks.field_196832_iE.func_176223_P();
                        }
                        case 3: {
                            return Blocks.field_196834_iF.func_176223_P();
                        }
                        case 4: {
                            return Blocks.field_196836_iG.func_176223_P();
                        }
                        case 5: {
                            return Blocks.field_196838_iH.func_176223_P();
                        }
                        case 6: {
                            return Blocks.field_196840_iI.func_176223_P();
                        }
                        case 7: {
                            return Blocks.field_196842_iJ.func_176223_P();
                        }
                        case 8: {
                            return Blocks.field_196844_iK.func_176223_P();
                        }
                        case 9: {
                            return Blocks.field_196846_iL.func_176223_P();
                        }
                        case 10: {
                            return Blocks.field_196848_iM.func_176223_P();
                        }
                        case 11: {
                            return Blocks.field_196850_iN.func_176223_P();
                        }
                        case 12: {
                            return Blocks.field_196852_iO.func_176223_P();
                        }
                        case 13: {
                            return Blocks.field_196854_iP.func_176223_P();
                        }
                        case 14: {
                            return Blocks.field_196856_iQ.func_176223_P();
                        }
                        case 15: 
                    }
                    return Blocks.field_196858_iR.func_176223_P();
                }
                case "concrete_powder": 
                case "white_concrete_powder": {
                    switch (data) {
                        default: {
                            return Blocks.field_196860_iS.func_176223_P();
                        }
                        case 1: {
                            return Blocks.field_196862_iT.func_176223_P();
                        }
                        case 2: {
                            return Blocks.field_196864_iU.func_176223_P();
                        }
                        case 3: {
                            return Blocks.field_196866_iV.func_176223_P();
                        }
                        case 4: {
                            return Blocks.field_196868_iW.func_176223_P();
                        }
                        case 5: {
                            return Blocks.field_196870_iX.func_176223_P();
                        }
                        case 6: {
                            return Blocks.field_196872_iY.func_176223_P();
                        }
                        case 7: {
                            return Blocks.field_196874_iZ.func_176223_P();
                        }
                        case 8: {
                            return Blocks.field_196877_ja.func_176223_P();
                        }
                        case 9: {
                            return Blocks.field_196878_jb.func_176223_P();
                        }
                        case 10: {
                            return Blocks.field_196879_jc.func_176223_P();
                        }
                        case 11: {
                            return Blocks.field_196880_jd.func_176223_P();
                        }
                        case 12: {
                            return Blocks.field_196881_je.func_176223_P();
                        }
                        case 13: {
                            return Blocks.field_196882_jf.func_176223_P();
                        }
                        case 14: {
                            return Blocks.field_196883_jg.func_176223_P();
                        }
                        case 15: 
                    }
                    return Blocks.field_196884_jh.func_176223_P();
                }
                case "dirt": {
                    switch (data) {
                        default: {
                            return Blocks.field_150346_d.func_176223_P();
                        }
                        case 1: {
                            return Blocks.field_196660_k.func_176223_P();
                        }
                        case 2: 
                    }
                    return Blocks.field_196661_l.func_176223_P();
                }
                case "double_plant": 
                case "sunflower": 
                case "rose_bush": 
                case "tall_grass": {
                    switch (data) {
                        default: {
                            return Blocks.field_196800_gd.func_176223_P();
                        }
                        case 1: {
                            return Blocks.field_196801_ge.func_176223_P();
                        }
                        case 2: {
                            return Blocks.field_196804_gh.func_176223_P();
                        }
                        case 3: {
                            return Blocks.field_196805_gi.func_176223_P();
                        }
                        case 4: {
                            return Blocks.field_196802_gf.func_176223_P();
                        }
                        case 5: 
                    }
                    return Blocks.field_196803_gg.func_176223_P();
                }
                case "double_stone_slab": 
                case "smooth_stone": {
                    switch (data) {
                        default: {
                            return (BlockState)Blocks.field_150333_U.func_176223_P().func_206870_a((Property)SlabBlock.field_196505_a, (Comparable)SlabType.DOUBLE);
                        }
                        case 1: {
                            return (BlockState)Blocks.field_196640_bx.func_176223_P().func_206870_a((Property)SlabBlock.field_196505_a, (Comparable)SlabType.DOUBLE);
                        }
                        case 3: {
                            return (BlockState)Blocks.field_196646_bz.func_176223_P().func_206870_a((Property)SlabBlock.field_196505_a, (Comparable)SlabType.DOUBLE);
                        }
                        case 4: {
                            return (BlockState)Blocks.field_196571_bA.func_176223_P().func_206870_a((Property)SlabBlock.field_196505_a, (Comparable)SlabType.DOUBLE);
                        }
                        case 5: {
                            return (BlockState)Blocks.field_196573_bB.func_176223_P().func_206870_a((Property)SlabBlock.field_196505_a, (Comparable)SlabType.DOUBLE);
                        }
                        case 6: {
                            return (BlockState)Blocks.field_196575_bC.func_176223_P().func_206870_a((Property)SlabBlock.field_196505_a, (Comparable)SlabType.DOUBLE);
                        }
                        case 7: 
                    }
                    return (BlockState)Blocks.field_196576_bD.func_176223_P().func_206870_a((Property)SlabBlock.field_196505_a, (Comparable)SlabType.DOUBLE);
                }
                case "double_wooden_slab": 
                case "wood_double_step": {
                    switch (data) {
                        default: {
                            return (BlockState)Blocks.field_196622_bq.func_176223_P().func_206870_a((Property)SlabBlock.field_196505_a, (Comparable)SlabType.DOUBLE);
                        }
                        case 1: {
                            return (BlockState)Blocks.field_196624_br.func_176223_P().func_206870_a((Property)SlabBlock.field_196505_a, (Comparable)SlabType.DOUBLE);
                        }
                        case 2: {
                            return (BlockState)Blocks.field_196627_bs.func_176223_P().func_206870_a((Property)SlabBlock.field_196505_a, (Comparable)SlabType.DOUBLE);
                        }
                        case 3: {
                            return (BlockState)Blocks.field_196630_bt.func_176223_P().func_206870_a((Property)SlabBlock.field_196505_a, (Comparable)SlabType.DOUBLE);
                        }
                        case 4: {
                            return (BlockState)Blocks.field_196632_bu.func_176223_P().func_206870_a((Property)SlabBlock.field_196505_a, (Comparable)SlabType.DOUBLE);
                        }
                        case 5: 
                    }
                    return (BlockState)Blocks.field_196635_bv.func_176223_P().func_206870_a((Property)SlabBlock.field_196505_a, (Comparable)SlabType.DOUBLE);
                }
                case "leaves": 
                case "oak_leaves": {
                    switch (data) {
                        default: {
                            return (BlockState)Blocks.field_196642_W.func_176223_P().func_206870_a((Property)LeavesBlock.field_208494_a, (Comparable)Integer.valueOf(1));
                        }
                        case 1: 
                        case 5: 
                        case 9: 
                        case 13: {
                            return (BlockState)Blocks.field_196645_X.func_176223_P().func_206870_a((Property)LeavesBlock.field_208494_a, (Comparable)Integer.valueOf(1));
                        }
                        case 2: 
                        case 6: 
                        case 10: 
                        case 14: {
                            return (BlockState)Blocks.field_196647_Y.func_176223_P().func_206870_a((Property)LeavesBlock.field_208494_a, (Comparable)Integer.valueOf(1));
                        }
                        case 3: 
                        case 7: 
                        case 11: 
                        case 15: 
                    }
                    return (BlockState)Blocks.field_196648_Z.func_176223_P().func_206870_a((Property)LeavesBlock.field_208494_a, (Comparable)Integer.valueOf(1));
                }
                case "leaves2": 
                case "leaves_2": 
                case "acacia_leaves": {
                    switch (data) {
                        default: {
                            return (BlockState)Blocks.field_196572_aa.func_176223_P().func_206870_a((Property)LeavesBlock.field_208494_a, (Comparable)Integer.valueOf(1));
                        }
                        case 1: 
                        case 5: 
                        case 9: 
                        case 13: 
                    }
                    return (BlockState)Blocks.field_196574_ab.func_176223_P().func_206870_a((Property)LeavesBlock.field_208494_a, (Comparable)Integer.valueOf(1));
                }
                case "monster_egg": 
                case "monster_eggs": 
                case "infested_stone": {
                    switch (data) {
                        default: {
                            return Blocks.field_196686_dc.func_176223_P();
                        }
                        case 1: {
                            return Blocks.field_196687_dd.func_176223_P();
                        }
                        case 2: {
                            return Blocks.field_196688_de.func_176223_P();
                        }
                        case 3: {
                            return Blocks.field_196690_df.func_176223_P();
                        }
                        case 4: {
                            return Blocks.field_196692_dg.func_176223_P();
                        }
                        case 5: 
                    }
                    return Blocks.field_196694_dh.func_176223_P();
                }
                case "planks": 
                case "wood": 
                case "oak_planks": {
                    switch (data) {
                        default: {
                            return Blocks.field_196662_n.func_176223_P();
                        }
                        case 1: {
                            return Blocks.field_196664_o.func_176223_P();
                        }
                        case 2: {
                            return Blocks.field_196666_p.func_176223_P();
                        }
                        case 3: {
                            return Blocks.field_196668_q.func_176223_P();
                        }
                        case 4: {
                            return Blocks.field_196670_r.func_176223_P();
                        }
                        case 5: 
                    }
                    return Blocks.field_196672_s.func_176223_P();
                }
                case "prismarine": {
                    switch (data) {
                        default: {
                            return Blocks.field_180397_cI.func_176223_P();
                        }
                        case 1: {
                            return Blocks.field_196779_gQ.func_176223_P();
                        }
                        case 2: 
                    }
                    return Blocks.field_196781_gR.func_176223_P();
                }
                case "purpur_slab": {
                    return (BlockState)Blocks.field_185771_cX.func_176223_P().func_206870_a((Property)SlabBlock.field_196505_a, (Comparable)(data == 0 ? SlabType.BOTTOM : (data == 8 ? SlabType.TOP : SlabType.BOTTOM)));
                }
                case "purpur_double_slab": {
                    return (BlockState)Blocks.field_185771_cX.func_176223_P().func_206870_a((Property)SlabBlock.field_196505_a, (Comparable)SlabType.DOUBLE);
                }
                case "red_flower": 
                case "red_rose": {
                    switch (data) {
                        default: {
                            return Blocks.field_196606_bd.func_176223_P();
                        }
                        case 1: {
                            return Blocks.field_196607_be.func_176223_P();
                        }
                        case 2: {
                            return Blocks.field_196609_bf.func_176223_P();
                        }
                        case 3: {
                            return Blocks.field_196610_bg.func_176223_P();
                        }
                        case 4: {
                            return Blocks.field_196612_bh.func_176223_P();
                        }
                        case 5: {
                            return Blocks.field_196613_bi.func_176223_P();
                        }
                        case 6: {
                            return Blocks.field_196614_bj.func_176223_P();
                        }
                        case 7: {
                            return Blocks.field_196615_bk.func_176223_P();
                        }
                        case 8: 
                    }
                    return Blocks.field_196616_bl.func_176223_P();
                }
                case "red_sandstone": {
                    switch (data) {
                        default: {
                            return Blocks.field_180395_cM.func_176223_P();
                        }
                        case 1: {
                            return Blocks.field_196798_hA.func_176223_P();
                        }
                        case 2: 
                    }
                    return Blocks.field_196582_bJ.func_176223_P();
                }
                case "red_sandstone_slab": 
                case "stone_slab2": {
                    switch (data) {
                        default: {
                            return (BlockState)Blocks.field_196578_bE.func_176223_P().func_206870_a((Property)SlabBlock.field_196505_a, (Comparable)SlabType.BOTTOM);
                        }
                        case 8: 
                    }
                    return (BlockState)Blocks.field_196578_bE.func_176223_P().func_206870_a((Property)SlabBlock.field_196505_a, (Comparable)SlabType.TOP);
                }
                case "double_red_sandstone_slab": 
                case "double_stone_slab2": {
                    return (BlockState)Blocks.field_196578_bE.func_176223_P().func_206870_a((Property)SlabBlock.field_196505_a, (Comparable)SlabType.DOUBLE);
                }
                case "sand": {
                    switch (data) {
                        default: {
                            return Blocks.field_150354_m.func_176223_P();
                        }
                        case 1: 
                    }
                    return Blocks.field_196611_F.func_176223_P();
                }
                case "sandstone": {
                    switch (data) {
                        default: {
                            return Blocks.field_150322_A.func_176223_P();
                        }
                        case 1: {
                            return Blocks.field_196583_aj.func_176223_P();
                        }
                        case 2: 
                    }
                    return Blocks.field_196580_bH.func_176223_P();
                }
                case "sapling": 
                case "oak_sapling": {
                    switch (data) {
                        default: {
                            return Blocks.field_196674_t.func_176223_P();
                        }
                        case 1: {
                            return Blocks.field_196675_u.func_176223_P();
                        }
                        case 2: {
                            return Blocks.field_196676_v.func_176223_P();
                        }
                        case 3: {
                            return Blocks.field_196678_w.func_176223_P();
                        }
                        case 4: {
                            return Blocks.field_196679_x.func_176223_P();
                        }
                        case 5: 
                    }
                    return Blocks.field_196680_y.func_176223_P();
                }
                case "skull": 
                case "skeleton_skull": {
                    return (BlockState)Blocks.field_196703_eM.func_176223_P().func_206870_a((Property)SkullBlock.field_196294_a, (Comparable)Integer.valueOf(data));
                }
                case "sponge": {
                    switch (data) {
                        default: {
                            return Blocks.field_150360_v.func_176223_P();
                        }
                        case 1: 
                    }
                    return Blocks.field_196577_ad.func_176223_P();
                }
                case "stained_glass": 
                case "white_stained_glass": {
                    switch (data) {
                        default: {
                            return Blocks.field_196807_gj.func_176223_P();
                        }
                        case 1: {
                            return Blocks.field_196808_gk.func_176223_P();
                        }
                        case 2: {
                            return Blocks.field_196809_gl.func_176223_P();
                        }
                        case 3: {
                            return Blocks.field_196810_gm.func_176223_P();
                        }
                        case 4: {
                            return Blocks.field_196811_gn.func_176223_P();
                        }
                        case 5: {
                            return Blocks.field_196812_go.func_176223_P();
                        }
                        case 6: {
                            return Blocks.field_196813_gp.func_176223_P();
                        }
                        case 7: {
                            return Blocks.field_196815_gq.func_176223_P();
                        }
                        case 8: {
                            return Blocks.field_196816_gr.func_176223_P();
                        }
                        case 9: {
                            return Blocks.field_196818_gs.func_176223_P();
                        }
                        case 10: {
                            return Blocks.field_196819_gt.func_176223_P();
                        }
                        case 11: {
                            return Blocks.field_196820_gu.func_176223_P();
                        }
                        case 12: {
                            return Blocks.field_196821_gv.func_176223_P();
                        }
                        case 13: {
                            return Blocks.field_196822_gw.func_176223_P();
                        }
                        case 14: {
                            return Blocks.field_196823_gx.func_176223_P();
                        }
                        case 15: 
                    }
                    return Blocks.field_196824_gy.func_176223_P();
                }
                case "stained_glass_pane": 
                case "white_stained_glass_pane": 
                case "thin_glass": {
                    switch (data) {
                        default: {
                            return Blocks.field_196825_gz.func_176223_P();
                        }
                        case 1: {
                            return Blocks.field_196758_gA.func_176223_P();
                        }
                        case 2: {
                            return Blocks.field_196759_gB.func_176223_P();
                        }
                        case 3: {
                            return Blocks.field_196760_gC.func_176223_P();
                        }
                        case 4: {
                            return Blocks.field_196761_gD.func_176223_P();
                        }
                        case 5: {
                            return Blocks.field_196763_gE.func_176223_P();
                        }
                        case 6: {
                            return Blocks.field_196764_gF.func_176223_P();
                        }
                        case 7: {
                            return Blocks.field_196765_gG.func_176223_P();
                        }
                        case 8: {
                            return Blocks.field_196767_gH.func_176223_P();
                        }
                        case 9: {
                            return Blocks.field_196768_gI.func_176223_P();
                        }
                        case 10: {
                            return Blocks.field_196769_gJ.func_176223_P();
                        }
                        case 11: {
                            return Blocks.field_196771_gK.func_176223_P();
                        }
                        case 12: {
                            return Blocks.field_196773_gL.func_176223_P();
                        }
                        case 13: {
                            return Blocks.field_196774_gM.func_176223_P();
                        }
                        case 14: {
                            return Blocks.field_196775_gN.func_176223_P();
                        }
                        case 15: 
                    }
                    return Blocks.field_196776_gO.func_176223_P();
                }
                case "stained_hardened_clay": 
                case "stained_clay": 
                case "white_terracotta": {
                    switch (data) {
                        default: {
                            return Blocks.field_196777_fo.func_176223_P();
                        }
                        case 1: {
                            return Blocks.field_196778_fp.func_176223_P();
                        }
                        case 2: {
                            return Blocks.field_196780_fq.func_176223_P();
                        }
                        case 3: {
                            return Blocks.field_196782_fr.func_176223_P();
                        }
                        case 4: {
                            return Blocks.field_196783_fs.func_176223_P();
                        }
                        case 5: {
                            return Blocks.field_196785_ft.func_176223_P();
                        }
                        case 6: {
                            return Blocks.field_196787_fu.func_176223_P();
                        }
                        case 7: {
                            return Blocks.field_196789_fv.func_176223_P();
                        }
                        case 8: {
                            return Blocks.field_196791_fw.func_176223_P();
                        }
                        case 9: {
                            return Blocks.field_196793_fx.func_176223_P();
                        }
                        case 10: {
                            return Blocks.field_196795_fy.func_176223_P();
                        }
                        case 11: {
                            return Blocks.field_196797_fz.func_176223_P();
                        }
                        case 12: {
                            return Blocks.field_196719_fA.func_176223_P();
                        }
                        case 13: {
                            return Blocks.field_196720_fB.func_176223_P();
                        }
                        case 14: {
                            return Blocks.field_196721_fC.func_176223_P();
                        }
                        case 15: 
                    }
                    return Blocks.field_196722_fD.func_176223_P();
                }
                case "stone": {
                    switch (data) {
                        default: {
                            return Blocks.field_150348_b.func_176223_P();
                        }
                        case 1: {
                            return Blocks.field_196650_c.func_176223_P();
                        }
                        case 2: {
                            return Blocks.field_196652_d.func_176223_P();
                        }
                        case 3: {
                            return Blocks.field_196654_e.func_176223_P();
                        }
                        case 4: {
                            return Blocks.field_196655_f.func_176223_P();
                        }
                        case 5: {
                            return Blocks.field_196656_g.func_176223_P();
                        }
                        case 6: 
                    }
                    return Blocks.field_196657_h.func_176223_P();
                }
                case "stone_slab": 
                case "step": {
                    switch (data) {
                        default: {
                            return (BlockState)Blocks.field_222401_hJ.func_176223_P().func_206870_a((Property)SlabBlock.field_196505_a, (Comparable)SlabType.BOTTOM);
                        }
                        case 1: {
                            return (BlockState)Blocks.field_196640_bx.func_176223_P().func_206870_a((Property)SlabBlock.field_196505_a, (Comparable)SlabType.BOTTOM);
                        }
                        case 3: {
                            return (BlockState)Blocks.field_196646_bz.func_176223_P().func_206870_a((Property)SlabBlock.field_196505_a, (Comparable)SlabType.BOTTOM);
                        }
                        case 4: {
                            return (BlockState)Blocks.field_196571_bA.func_176223_P().func_206870_a((Property)SlabBlock.field_196505_a, (Comparable)SlabType.BOTTOM);
                        }
                        case 5: {
                            return (BlockState)Blocks.field_196573_bB.func_176223_P().func_206870_a((Property)SlabBlock.field_196505_a, (Comparable)SlabType.BOTTOM);
                        }
                        case 6: {
                            return (BlockState)Blocks.field_196575_bC.func_176223_P().func_206870_a((Property)SlabBlock.field_196505_a, (Comparable)SlabType.BOTTOM);
                        }
                        case 7: {
                            return (BlockState)Blocks.field_196576_bD.func_176223_P().func_206870_a((Property)SlabBlock.field_196505_a, (Comparable)SlabType.BOTTOM);
                        }
                        case 8: {
                            return (BlockState)Blocks.field_222401_hJ.func_176223_P().func_206870_a((Property)SlabBlock.field_196505_a, (Comparable)SlabType.TOP);
                        }
                        case 9: {
                            return (BlockState)Blocks.field_196640_bx.func_176223_P().func_206870_a((Property)SlabBlock.field_196505_a, (Comparable)SlabType.TOP);
                        }
                        case 11: {
                            return (BlockState)Blocks.field_196646_bz.func_176223_P().func_206870_a((Property)SlabBlock.field_196505_a, (Comparable)SlabType.TOP);
                        }
                        case 12: {
                            return (BlockState)Blocks.field_196571_bA.func_176223_P().func_206870_a((Property)SlabBlock.field_196505_a, (Comparable)SlabType.TOP);
                        }
                        case 13: {
                            return (BlockState)Blocks.field_196573_bB.func_176223_P().func_206870_a((Property)SlabBlock.field_196505_a, (Comparable)SlabType.TOP);
                        }
                        case 14: {
                            return (BlockState)Blocks.field_196575_bC.func_176223_P().func_206870_a((Property)SlabBlock.field_196505_a, (Comparable)SlabType.TOP);
                        }
                        case 15: 
                    }
                    return (BlockState)Blocks.field_196576_bD.func_176223_P().func_206870_a((Property)SlabBlock.field_196505_a, (Comparable)SlabType.TOP);
                }
                case "double_step": {
                    switch (data) {
                        default: {
                            return (BlockState)Blocks.field_222401_hJ.func_176223_P().func_206870_a((Property)SlabBlock.field_196505_a, (Comparable)SlabType.DOUBLE);
                        }
                        case 1: {
                            return (BlockState)Blocks.field_196640_bx.func_176223_P().func_206870_a((Property)SlabBlock.field_196505_a, (Comparable)SlabType.DOUBLE);
                        }
                        case 3: {
                            return (BlockState)Blocks.field_196646_bz.func_176223_P().func_206870_a((Property)SlabBlock.field_196505_a, (Comparable)SlabType.DOUBLE);
                        }
                        case 4: {
                            return (BlockState)Blocks.field_196571_bA.func_176223_P().func_206870_a((Property)SlabBlock.field_196505_a, (Comparable)SlabType.DOUBLE);
                        }
                        case 5: {
                            return (BlockState)Blocks.field_196573_bB.func_176223_P().func_206870_a((Property)SlabBlock.field_196505_a, (Comparable)SlabType.DOUBLE);
                        }
                        case 6: {
                            return (BlockState)Blocks.field_196575_bC.func_176223_P().func_206870_a((Property)SlabBlock.field_196505_a, (Comparable)SlabType.DOUBLE);
                        }
                        case 7: 
                    }
                    return (BlockState)Blocks.field_196576_bD.func_176223_P().func_206870_a((Property)SlabBlock.field_196505_a, (Comparable)SlabType.DOUBLE);
                }
                case "stonebrick": 
                case "stone_bricks": 
                case "smooth_brick": {
                    switch (data) {
                        default: {
                            return Blocks.field_196696_di.func_176223_P();
                        }
                        case 1: {
                            return Blocks.field_196698_dj.func_176223_P();
                        }
                        case 2: {
                            return Blocks.field_196700_dk.func_176223_P();
                        }
                        case 3: 
                    }
                    return Blocks.field_196702_dl.func_176223_P();
                }
                case "tallgrass": 
                case "long_grass": {
                    switch (data) {
                        default: {
                            return Blocks.field_150349_c.func_176223_P();
                        }
                        case 2: 
                    }
                    return Blocks.field_196554_aH.func_176223_P();
                }
                case "wooden_slab": 
                case "wood_step": 
                case "oak_slab": {
                    switch (data) {
                        default: {
                            return (BlockState)Blocks.field_196622_bq.func_176223_P().func_206870_a((Property)SlabBlock.field_196505_a, (Comparable)SlabType.BOTTOM);
                        }
                        case 1: {
                            return (BlockState)Blocks.field_196624_br.func_176223_P().func_206870_a((Property)SlabBlock.field_196505_a, (Comparable)SlabType.BOTTOM);
                        }
                        case 2: {
                            return (BlockState)Blocks.field_196627_bs.func_176223_P().func_206870_a((Property)SlabBlock.field_196505_a, (Comparable)SlabType.BOTTOM);
                        }
                        case 3: {
                            return (BlockState)Blocks.field_196630_bt.func_176223_P().func_206870_a((Property)SlabBlock.field_196505_a, (Comparable)SlabType.BOTTOM);
                        }
                        case 4: {
                            return (BlockState)Blocks.field_196632_bu.func_176223_P().func_206870_a((Property)SlabBlock.field_196505_a, (Comparable)SlabType.BOTTOM);
                        }
                        case 5: {
                            return (BlockState)Blocks.field_196635_bv.func_176223_P().func_206870_a((Property)SlabBlock.field_196505_a, (Comparable)SlabType.BOTTOM);
                        }
                        case 8: {
                            return (BlockState)Blocks.field_196622_bq.func_176223_P().func_206870_a((Property)SlabBlock.field_196505_a, (Comparable)SlabType.TOP);
                        }
                        case 9: {
                            return (BlockState)Blocks.field_196624_br.func_176223_P().func_206870_a((Property)SlabBlock.field_196505_a, (Comparable)SlabType.TOP);
                        }
                        case 10: {
                            return (BlockState)Blocks.field_196627_bs.func_176223_P().func_206870_a((Property)SlabBlock.field_196505_a, (Comparable)SlabType.TOP);
                        }
                        case 11: {
                            return (BlockState)Blocks.field_196630_bt.func_176223_P().func_206870_a((Property)SlabBlock.field_196505_a, (Comparable)SlabType.TOP);
                        }
                        case 12: {
                            return (BlockState)Blocks.field_196632_bu.func_176223_P().func_206870_a((Property)SlabBlock.field_196505_a, (Comparable)SlabType.TOP);
                        }
                        case 13: 
                    }
                    return (BlockState)Blocks.field_196635_bv.func_176223_P().func_206870_a((Property)SlabBlock.field_196505_a, (Comparable)SlabType.TOP);
                }
                case "wool": 
                case "white_wool": {
                    switch (data) {
                        default: {
                            return Blocks.field_196556_aL.func_176223_P();
                        }
                        case 1: {
                            return Blocks.field_196557_aM.func_176223_P();
                        }
                        case 2: {
                            return Blocks.field_196558_aN.func_176223_P();
                        }
                        case 3: {
                            return Blocks.field_196559_aO.func_176223_P();
                        }
                        case 4: {
                            return Blocks.field_196560_aP.func_176223_P();
                        }
                        case 5: {
                            return Blocks.field_196561_aQ.func_176223_P();
                        }
                        case 6: {
                            return Blocks.field_196562_aR.func_176223_P();
                        }
                        case 7: {
                            return Blocks.field_196563_aS.func_176223_P();
                        }
                        case 8: {
                            return Blocks.field_196564_aT.func_176223_P();
                        }
                        case 9: {
                            return Blocks.field_196565_aU.func_176223_P();
                        }
                        case 10: {
                            return Blocks.field_196566_aV.func_176223_P();
                        }
                        case 11: {
                            return Blocks.field_196567_aW.func_176223_P();
                        }
                        case 12: {
                            return Blocks.field_196568_aX.func_176223_P();
                        }
                        case 13: {
                            return Blocks.field_196569_aY.func_176223_P();
                        }
                        case 14: {
                            return Blocks.field_196570_aZ.func_176223_P();
                        }
                        case 15: 
                    }
                    return Blocks.field_196602_ba.func_176223_P();
                }
                case "fire": {
                    return (BlockState)Blocks.field_150480_ab.func_176223_P().func_206870_a((Property)FireBlock.field_176543_a, (Comparable)Integer.valueOf(data));
                }
                case "cake": 
                case "cake_block": {
                    return (BlockState)Blocks.field_150414_aQ.func_176223_P().func_206870_a((Property)CakeBlock.field_176589_a, (Comparable)Integer.valueOf(data));
                }
                case "stone_pressure_plate": 
                case "stone_plate": {
                    return (BlockState)Blocks.field_150456_au.func_176223_P().func_206870_a((Property)PressurePlateBlock.field_176580_a, (Comparable)Boolean.valueOf(ForgeLegacyMaterials.getBit(data, 0) == 1));
                }
                case "wooden_pressure_plate": 
                case "wood_plate": 
                case "oak_pressure_plate": {
                    return (BlockState)Blocks.field_196663_cq.func_176223_P().func_206870_a((Property)PressurePlateBlock.field_176580_a, (Comparable)Boolean.valueOf(ForgeLegacyMaterials.getBit(data, 0) == 1));
                }
                case "light_weighted_pressure_plate": 
                case "gold_plate": {
                    return (BlockState)Blocks.field_150445_bS.func_176223_P().func_206870_a((Property)WeightedPressurePlateBlock.field_176579_a, (Comparable)Integer.valueOf(data));
                }
                case "heavy_weighted_pressure_plate": 
                case "iron_plate": {
                    return (BlockState)Blocks.field_150443_bT.func_176223_P().func_206870_a((Property)WeightedPressurePlateBlock.field_176579_a, (Comparable)Integer.valueOf(data));
                }
                case "snow_layer": {
                    return (BlockState)Blocks.field_150433_aE.func_176223_P().func_206870_a((Property)SnowBlock.field_176315_a, (Comparable)Integer.valueOf(data));
                }
                case "cactus": {
                    return (BlockState)Blocks.field_150434_aF.func_176223_P().func_206870_a((Property)CactusBlock.field_176587_a, (Comparable)Integer.valueOf(data));
                }
                case "reeds": {
                    return (BlockState)Blocks.field_196608_cF.func_176223_P().func_206870_a((Property)SugarCaneBlock.field_176355_a, (Comparable)Integer.valueOf(data));
                }
                case "jukebox": {
                    return (BlockState)Blocks.field_150421_aI.func_176223_P().func_206870_a((Property)JukeboxBlock.field_176432_a, (Comparable)Boolean.valueOf(data == 1));
                }
                case "wheat": 
                case "crops": {
                    return (BlockState)Blocks.field_150464_aj.func_176223_P().func_206870_a((Property)CropsBlock.field_176488_a, (Comparable)Integer.valueOf(data));
                }
                case "carrot": 
                case "carrots": {
                    return (BlockState)Blocks.field_150459_bM.func_176223_P().func_206870_a((Property)CarrotBlock.field_176488_a, (Comparable)Integer.valueOf(data));
                }
                case "potato": 
                case "potatoes": {
                    return (BlockState)Blocks.field_150469_bN.func_176223_P().func_206870_a((Property)PotatoBlock.field_176488_a, (Comparable)Integer.valueOf(data));
                }
                case "beetroot": 
                case "beetroots": {
                    return (BlockState)Blocks.field_185773_cZ.func_176223_P().func_206870_a((Property)BeetrootBlock.field_185531_a, (Comparable)Integer.valueOf(data));
                }
                case "farmland": 
                case "soil": {
                    return (BlockState)Blocks.field_150458_ak.func_176223_P().func_206870_a((Property)FarmlandBlock.field_176531_a, (Comparable)Integer.valueOf(data));
                }
                case "anvil": {
                    return ForgeLegacyMaterials.getAnvilWithData(0, data);
                }
                case "log": 
                case "oak_log": {
                    return ForgeLegacyMaterials.getLogWithData(data);
                }
                case "log_2": 
                case "acacia_log": {
                    return ForgeLegacyMaterials.getLog2WithData(data);
                }
                case "quartz_block": {
                    return ForgeLegacyMaterials.getQuartzBlockWithData(data);
                }
                case "torch": {
                    return ForgeLegacyMaterials.getTorchWithData(0, data);
                }
                case "redstone_torch_off": 
                case "redstone_torch": {
                    return ForgeLegacyMaterials.getTorchWithData(1, data);
                }
                case "redstone_torch_on": {
                    return ForgeLegacyMaterials.getTorchWithData(2, data);
                }
                case "rails": {
                    return (BlockState)Blocks.field_150448_aq.func_176223_P().func_206870_a((Property)RailBlock.field_176565_b, (Comparable)ForgeLegacyMaterials.getRailShape(data));
                }
                case "powered_rail": 
                case "golden_rail": {
                    return ForgeLegacyMaterials.getRailsWithData(0, data);
                }
                case "detector_rail": {
                    return ForgeLegacyMaterials.getRailsWithData(1, data);
                }
                case "activator_rail": {
                    return ForgeLegacyMaterials.getRailsWithData(2, data);
                }
                case "hay_block": {
                    return (BlockState)Blocks.field_150407_cf.func_176223_P().func_206870_a((Property)HayBlock.field_176298_M, (Comparable)ForgeLegacyMaterials.getPillarAxisXYZ(data));
                }
                case "bone_block": {
                    return (BlockState)Blocks.field_189880_di.func_176223_P().func_206870_a((Property)RotatedPillarBlock.field_176298_M, (Comparable)ForgeLegacyMaterials.getAxisXYZ(data));
                }
                case "wood_stairs": 
                case "oak_stairs": {
                    return ForgeLegacyMaterials.getStairsWithData(0, data);
                }
                case "birch_wood_stairs": 
                case "birch_stairs": {
                    return ForgeLegacyMaterials.getStairsWithData(1, data);
                }
                case "spruce_wood_stairs": 
                case "spruce_stairs": {
                    return ForgeLegacyMaterials.getStairsWithData(2, data);
                }
                case "jungle_wood_stairs": 
                case "jungle_stairs": {
                    return ForgeLegacyMaterials.getStairsWithData(3, data);
                }
                case "cobblestone_stairs": 
                case "stone_stairs": {
                    return ForgeLegacyMaterials.getStairsWithData(4, data);
                }
                case "brick_stairs": {
                    return ForgeLegacyMaterials.getStairsWithData(5, data);
                }
                case "nether_brick_stairs": {
                    return ForgeLegacyMaterials.getStairsWithData(7, data);
                }
                case "sandstone_stairs": {
                    return ForgeLegacyMaterials.getStairsWithData(8, data);
                }
                case "quartz_stairs": {
                    return ForgeLegacyMaterials.getStairsWithData(9, data);
                }
                case "acacia_stairs": {
                    return ForgeLegacyMaterials.getStairsWithData(10, data);
                }
                case "dark_oak_stairs": {
                    return ForgeLegacyMaterials.getStairsWithData(11, data);
                }
                case "red_sandstone_stairs": {
                    return ForgeLegacyMaterials.getStairsWithData(12, data);
                }
                case "purpur_stairs": {
                    return ForgeLegacyMaterials.getStairsWithData(13, data);
                }
                case "stone_brick_stairs": 
                case "smooth_stairs": {
                    return ForgeLegacyMaterials.getStairsWithData(14, data);
                }
                case "lever": {
                    return ForgeLegacyMaterials.getLeverOrButtonWithData(0, data);
                }
                case "stone_button": {
                    return ForgeLegacyMaterials.getLeverOrButtonWithData(1, data);
                }
                case "wood_button": 
                case "wooden_button": 
                case "oak_button": {
                    return ForgeLegacyMaterials.getLeverOrButtonWithData(2, data);
                }
                case "wooden_door": 
                case "oak_door": {
                    return ForgeLegacyMaterials.getDoorWithData(0, data);
                }
                case "iron_door_block": 
                case "iron_door": {
                    return ForgeLegacyMaterials.getDoorWithData(1, data);
                }
                case "spruce_door": {
                    return ForgeLegacyMaterials.getDoorWithData(2, data);
                }
                case "birch_door": {
                    return ForgeLegacyMaterials.getDoorWithData(3, data);
                }
                case "jungle_door": {
                    return ForgeLegacyMaterials.getDoorWithData(4, data);
                }
                case "acacia_door": {
                    return ForgeLegacyMaterials.getDoorWithData(5, data);
                }
                case "dark_oak_door": {
                    return ForgeLegacyMaterials.getDoorWithData(6, data);
                }
                case "oak_sign": 
                case "sign_post": 
                case "sign": {
                    return ForgeLegacyMaterials.getSignPostWithData(data);
                }
                case "standing_banner": {
                    return (BlockState)Blocks.field_196839_hh.func_176223_P().func_206870_a((Property)BannerBlock.field_176448_b, (Comparable)Integer.valueOf(data));
                }
                case "wall_banner": {
                    return (BlockState)Blocks.field_196843_hj.func_176223_P().func_206870_a((Property)WallBannerBlock.field_196290_a, (Comparable)ForgeLegacyMaterials.getFacingNorthSouthWestEast(data));
                }
                case "end_rod": {
                    return (BlockState)Blocks.field_185764_cQ.func_176223_P().func_206870_a((Property)EndRodBlock.field_176387_N, (Comparable)ForgeLegacyMaterials.getFacingDownUpNorthSouthWestEast(data));
                }
                case "daylight_detector": {
                    return (BlockState)Blocks.field_150453_bW.func_176223_P().func_206870_a((Property)DaylightDetectorBlock.field_176436_a, (Comparable)Integer.valueOf(data));
                }
                case "command": 
                case "command_block": {
                    return ForgeLegacyMaterials.getCommandBlockWithData(0, data);
                }
                case "command_repeating": 
                case "repeating_command_block": {
                    return ForgeLegacyMaterials.getCommandBlockWithData(1, data);
                }
                case "command_chain": 
                case "chain_command_block": {
                    return ForgeLegacyMaterials.getCommandBlockWithData(2, data);
                }
                case "white_shulker_box": {
                    return ForgeLegacyMaterials.getShulkerBoxWithData(0, data);
                }
                case "orange_shulker_box": {
                    return ForgeLegacyMaterials.getShulkerBoxWithData(1, data);
                }
                case "magenta_shulker_box": {
                    return ForgeLegacyMaterials.getShulkerBoxWithData(2, data);
                }
                case "light_blue_shulker_box": {
                    return ForgeLegacyMaterials.getShulkerBoxWithData(3, data);
                }
                case "yellow_shulker_box": {
                    return ForgeLegacyMaterials.getShulkerBoxWithData(4, data);
                }
                case "lime_shulker_box": {
                    return ForgeLegacyMaterials.getShulkerBoxWithData(5, data);
                }
                case "pink_shulker_box": {
                    return ForgeLegacyMaterials.getShulkerBoxWithData(6, data);
                }
                case "gray_shulker_box": {
                    return ForgeLegacyMaterials.getShulkerBoxWithData(7, data);
                }
                case "light_gray_shulker_box": 
                case "silver_shulker_box": {
                    return ForgeLegacyMaterials.getShulkerBoxWithData(8, data);
                }
                case "cyan_shulker_box": {
                    return ForgeLegacyMaterials.getShulkerBoxWithData(9, data);
                }
                case "purple_shulker_box": {
                    return ForgeLegacyMaterials.getShulkerBoxWithData(10, data);
                }
                case "blue_shulker_box": {
                    return ForgeLegacyMaterials.getShulkerBoxWithData(11, data);
                }
                case "brown_shulker_box": {
                    return ForgeLegacyMaterials.getShulkerBoxWithData(12, data);
                }
                case "green_shulker_box": {
                    return ForgeLegacyMaterials.getShulkerBoxWithData(13, data);
                }
                case "red_shulker_box": {
                    return ForgeLegacyMaterials.getShulkerBoxWithData(14, data);
                }
                case "black_shulker_box": {
                    return ForgeLegacyMaterials.getShulkerBoxWithData(15, data);
                }
                case "shulker_box": {
                    return ForgeLegacyMaterials.getShulkerBoxWithData(16, data);
                }
                case "ladder": {
                    return ForgeLegacyMaterials.getLadderChestOrFurnaceWithData(0, data);
                }
                case "chest": {
                    return ForgeLegacyMaterials.getLadderChestOrFurnaceWithData(1, data);
                }
                case "ender_chest": {
                    return ForgeLegacyMaterials.getLadderChestOrFurnaceWithData(2, data);
                }
                case "trapped_chest": {
                    return ForgeLegacyMaterials.getLadderChestOrFurnaceWithData(3, data);
                }
                case "furnace": {
                    return ForgeLegacyMaterials.getLadderChestOrFurnaceWithData(4, data);
                }
                case "burning_furnace": {
                    return ForgeLegacyMaterials.getLadderChestOrFurnaceWithData(5, data);
                }
                case "wall_sign": 
                case "oak_wall_sign": {
                    return ForgeLegacyMaterials.getWallSignWithData(data);
                }
                case "observer": {
                    return ForgeLegacyMaterials.getObserverWithData(data);
                }
                case "dispenser": {
                    return ForgeLegacyMaterials.getDispenserHopperDropperWithData(0, data);
                }
                case "dropper": {
                    return ForgeLegacyMaterials.getDispenserHopperDropperWithData(1, data);
                }
                case "hopper": {
                    return ForgeLegacyMaterials.getDispenserHopperDropperWithData(2, data);
                }
                case "pumpkin_stem": {
                    return (BlockState)Blocks.field_150393_bb.func_176223_P().func_206870_a((Property)StemBlock.field_176484_a, (Comparable)Integer.valueOf(data));
                }
                case "melon_stem": {
                    return (BlockState)Blocks.field_150394_bc.func_176223_P().func_206870_a((Property)StemBlock.field_176484_a, (Comparable)Integer.valueOf(data));
                }
                case "carved_pumpkin": 
                case "pumpkin": {
                    return ForgeLegacyMaterials.getJackOLanternOrPumpkinWithData(0, data);
                }
                case "jack_o_lantern": 
                case "lit_pumpkin": {
                    return ForgeLegacyMaterials.getJackOLanternOrPumpkinWithData(1, data);
                }
                case "diode_block_off": 
                case "repeater": 
                case "unpowered_repeater": {
                    return ForgeLegacyMaterials.getRepeaterWithData(0, data);
                }
                case "diode_block_on": 
                case "powered_repeater": {
                    return ForgeLegacyMaterials.getRepeaterWithData(1, data);
                }
                case "redstone": 
                case "redstone_wire": {
                    return (BlockState)Blocks.field_150488_af.func_176223_P().func_206870_a((Property)RedstoneWireBlock.field_176351_O, (Comparable)Integer.valueOf(data));
                }
                case "redstone_comparator_off": 
                case "comparator": {
                    return ForgeLegacyMaterials.getComparatorWithData(0, data);
                }
                case "redstone_comparator_on": {
                    return ForgeLegacyMaterials.getComparatorWithData(1, data);
                }
                case "bed_block": {
                    return ForgeLegacyMaterials.getBedBlockWithData(data);
                }
                case "trap_door": 
                case "trapdoor": 
                case "oak_trapdoor": {
                    return ForgeLegacyMaterials.getTrapDoorBlockWithData(0, data);
                }
                case "iron_trapdoor": {
                    return ForgeLegacyMaterials.getTrapDoorBlockWithData(1, data);
                }
                case "piston_base": 
                case "piston": {
                    return ForgeLegacyMaterials.getPistonWithData(0, data);
                }
                case "piston_sticky_base": 
                case "sticky_piston": {
                    return ForgeLegacyMaterials.getPistonWithData(1, data);
                }
                case "piston_extension": 
                case "piston_head": {
                    return ForgeLegacyMaterials.getPistonHeadWithData(data);
                }
                case "huge_mushroom_1": 
                case "brown_mushroom_block": {
                    return ForgeLegacyMaterials.getHugeMushroomWithData(0, data);
                }
                case "huge_mushroom_2": 
                case "red_mushroom_block": {
                    return ForgeLegacyMaterials.getHugeMushroomWithData(1, data);
                }
                case "vine": {
                    return ForgeLegacyMaterials.getVineWithData(data);
                }
                case "fence_gate": 
                case "oak_fence_gate": {
                    return ForgeLegacyMaterials.getFenceGateWithData(0, data);
                }
                case "spruce_fence_gate": {
                    return ForgeLegacyMaterials.getFenceGateWithData(1, data);
                }
                case "birch_fence_gate": {
                    return ForgeLegacyMaterials.getFenceGateWithData(2, data);
                }
                case "jungle_fence_gate": {
                    return ForgeLegacyMaterials.getFenceGateWithData(3, data);
                }
                case "dark_oak_fence_gate": {
                    return ForgeLegacyMaterials.getFenceGateWithData(4, data);
                }
                case "acacia_fence_gate": {
                    return ForgeLegacyMaterials.getFenceGateWithData(5, data);
                }
                case "cocoa": {
                    return ForgeLegacyMaterials.getCocoaWithData(data);
                }
                case "tripwire_hook": {
                    return ForgeLegacyMaterials.getTripWireHookWithData(data);
                }
                case "tripwire": {
                    return ForgeLegacyMaterials.getTripWireWithData(data);
                }
                case "purpur_pillar": {
                    return (BlockState)Blocks.field_185768_cU.func_176223_P().func_206870_a((Property)RotatedPillarBlock.field_176298_M, (Comparable)ForgeLegacyMaterials.getPillarAxisXYZ(data));
                }
                case "nether_wart": {
                    return (BlockState)Blocks.field_150388_bm.func_176223_P().func_206870_a((Property)NetherWartBlock.field_176486_a, (Comparable)Integer.valueOf(data));
                }
                case "brewing_stand": {
                    return (BlockState)((BlockState)((BlockState)Blocks.field_150382_bo.func_176223_P().func_206870_a((Property)BrewingStandBlock.field_176451_a[0], (Comparable)Boolean.valueOf(ForgeLegacyMaterials.getBit(data, 0) == 1))).func_206870_a((Property)BrewingStandBlock.field_176451_a[1], (Comparable)Boolean.valueOf(ForgeLegacyMaterials.getBit(data, 1) == 1))).func_206870_a((Property)BrewingStandBlock.field_176451_a[2], (Comparable)Boolean.valueOf(ForgeLegacyMaterials.getBit(data, 2) == 1));
                }
                case "cauldron": {
                    return (BlockState)Blocks.field_150383_bp.func_176223_P().func_206870_a((Property)CauldronBlock.field_176591_a, (Comparable)Integer.valueOf(data));
                }
                case "portal": {
                    return (BlockState)Blocks.field_150427_aO.func_176223_P().func_206870_a((Property)NetherPortalBlock.field_176550_a, (Comparable)ForgeLegacyMaterials.getAxisXZ(data));
                }
                case "end_portal_frame": 
                case "ender_portal_frame": {
                    return ForgeLegacyMaterials.getEndPortalFrameWithData(data);
                }
                case "structure_block": {
                    return ForgeLegacyMaterials.getStructureBlockWithData(data);
                }
                case "black_glazed_terracotta": {
                    return ForgeLegacyMaterials.getGlazedTerracottaWithData(0, data);
                }
                case "blue_glazed_terracotta": {
                    return ForgeLegacyMaterials.getGlazedTerracottaWithData(1, data);
                }
                case "brown_glazed_terracotta": {
                    return ForgeLegacyMaterials.getGlazedTerracottaWithData(2, data);
                }
                case "cyan_glazed_terracotta": {
                    return ForgeLegacyMaterials.getGlazedTerracottaWithData(3, data);
                }
                case "gray_glazed_terracotta": {
                    return ForgeLegacyMaterials.getGlazedTerracottaWithData(4, data);
                }
                case "green_glazed_terracotta": {
                    return ForgeLegacyMaterials.getGlazedTerracottaWithData(5, data);
                }
                case "light_blue_glazed_terracotta": {
                    return ForgeLegacyMaterials.getGlazedTerracottaWithData(6, data);
                }
                case "lime_glazed_terracotta": {
                    return ForgeLegacyMaterials.getGlazedTerracottaWithData(7, data);
                }
                case "magenta_glazed_terracotta": {
                    return ForgeLegacyMaterials.getGlazedTerracottaWithData(8, data);
                }
                case "orange_glazed_terracotta": {
                    return ForgeLegacyMaterials.getGlazedTerracottaWithData(9, data);
                }
                case "pink_glazed_terracotta": {
                    return ForgeLegacyMaterials.getGlazedTerracottaWithData(10, data);
                }
                case "purple_glazed_terracotta": {
                    return ForgeLegacyMaterials.getGlazedTerracottaWithData(11, data);
                }
                case "red_glazed_terracotta": {
                    return ForgeLegacyMaterials.getGlazedTerracottaWithData(12, data);
                }
                case "silver_glazed_terracotta": {
                    return ForgeLegacyMaterials.getGlazedTerracottaWithData(13, data);
                }
                case "white_glazed_terracotta": {
                    return ForgeLegacyMaterials.getGlazedTerracottaWithData(14, data);
                }
                case "yellow_glazed_terracotta": {
                    return ForgeLegacyMaterials.getGlazedTerracottaWithData(15, data);
                }
                case "snow": {
                    switch (data) {
                        case 0: {
                            return (BlockState)Blocks.field_150433_aE.func_176223_P().func_206870_a((Property)SnowBlock.field_176315_a, (Comparable)Integer.valueOf(1));
                        }
                    }
                    return (BlockState)Blocks.field_150433_aE.func_176223_P().func_206870_a((Property)SnowBlock.field_176315_a, (Comparable)Integer.valueOf(data));
                }
            }
            return null;
        }
        catch (IllegalArgumentException ex) {
            if (OTG.getEngine().getLogger().getLogCategoryEnabled(LogCategory.CONFIGS)) {
                OTG.getEngine().getLogger().log(LogLevel.ERROR, LogCategory.CONFIGS, "Could not parse block with data, illegal data: " + blockName + ":" + data + ". Exception: " + ex.getMessage());
            }
            return null;
        }
    }

    private static BlockState getAnvilWithData(int material, int data) {
        Direction orientation = ForgeLegacyMaterials.getBit(data, 0) == 0 ? Direction.NORTH : Direction.WEST;
        switch (material) {
            case 0: {
                if ((ForgeLegacyMaterials.getBit(data, 2) & ForgeLegacyMaterials.getBit(data, 3)) == 0) {
                    return (BlockState)Blocks.field_150467_bQ.func_176223_P().func_206870_a((Property)AnvilBlock.field_176506_a, (Comparable)orientation);
                }
                if (ForgeLegacyMaterials.getBit(data, 2) == 1) {
                    return (BlockState)Blocks.field_196717_eY.func_176223_P().func_206870_a((Property)AnvilBlock.field_176506_a, (Comparable)orientation);
                }
                if (ForgeLegacyMaterials.getBit(data, 3) == 1) {
                    return (BlockState)Blocks.field_196718_eZ.func_176223_P().func_206870_a((Property)AnvilBlock.field_176506_a, (Comparable)orientation);
                }
            }
            case 1: {
                return (BlockState)Blocks.field_196717_eY.func_176223_P().func_206870_a((Property)AnvilBlock.field_176506_a, (Comparable)orientation);
            }
            case 2: {
                return (BlockState)Blocks.field_196718_eZ.func_176223_P().func_206870_a((Property)AnvilBlock.field_176506_a, (Comparable)orientation);
            }
        }
        return null;
    }

    private static BlockState getLogWithData(int data) {
        int material = ForgeLegacyMaterials.getBits(data, 0, 2);
        int orientation = ForgeLegacyMaterials.getBits(data, 2, 2);
        Direction.Axis axisDirection = orientation == 0 ? Direction.Axis.Y : (orientation == 1 ? Direction.Axis.X : (orientation == 2 ? Direction.Axis.Z : Direction.Axis.Y));
        boolean bark = orientation == 3;
        switch (material) {
            case 0: {
                if (bark) {
                    return (BlockState)Blocks.field_196626_Q.func_176223_P().func_206870_a((Property)RotatedPillarBlock.field_176298_M, (Comparable)axisDirection);
                }
                return (BlockState)Blocks.field_196617_K.func_176223_P().func_206870_a((Property)RotatedPillarBlock.field_176298_M, (Comparable)axisDirection);
            }
            case 1: {
                if (bark) {
                    return (BlockState)Blocks.field_196629_R.func_176223_P().func_206870_a((Property)RotatedPillarBlock.field_176298_M, (Comparable)axisDirection);
                }
                return (BlockState)Blocks.field_196618_L.func_176223_P().func_206870_a((Property)RotatedPillarBlock.field_176298_M, (Comparable)axisDirection);
            }
            case 2: {
                if (bark) {
                    return (BlockState)Blocks.field_196631_S.func_176223_P().func_206870_a((Property)RotatedPillarBlock.field_176298_M, (Comparable)axisDirection);
                }
                return (BlockState)Blocks.field_196619_M.func_176223_P().func_206870_a((Property)RotatedPillarBlock.field_176298_M, (Comparable)axisDirection);
            }
            case 3: {
                if (bark) {
                    return (BlockState)Blocks.field_196634_T.func_176223_P().func_206870_a((Property)RotatedPillarBlock.field_176298_M, (Comparable)axisDirection);
                }
                return (BlockState)Blocks.field_196620_N.func_176223_P().func_206870_a((Property)RotatedPillarBlock.field_176298_M, (Comparable)axisDirection);
            }
        }
        return Blocks.field_196617_K.func_176223_P();
    }

    private static BlockState getLog2WithData(int data) {
        int material = ForgeLegacyMaterials.getBits(data, 0, 2);
        int orientation = ForgeLegacyMaterials.getBits(data, 2, 2);
        Direction.Axis axisDirection = orientation == 0 ? Direction.Axis.Y : (orientation == 1 ? Direction.Axis.X : (orientation == 2 ? Direction.Axis.Z : Direction.Axis.Y));
        boolean bark = orientation == 3;
        switch (material) {
            case 0: {
                if (bark) {
                    return (BlockState)Blocks.field_196637_U.func_176223_P().func_206870_a((Property)RotatedPillarBlock.field_176298_M, (Comparable)axisDirection);
                }
                return (BlockState)Blocks.field_196621_O.func_176223_P().func_206870_a((Property)RotatedPillarBlock.field_176298_M, (Comparable)axisDirection);
            }
            case 1: {
                if (bark) {
                    return (BlockState)Blocks.field_196639_V.func_176223_P().func_206870_a((Property)RotatedPillarBlock.field_176298_M, (Comparable)axisDirection);
                }
                return (BlockState)Blocks.field_196623_P.func_176223_P().func_206870_a((Property)RotatedPillarBlock.field_176298_M, (Comparable)axisDirection);
            }
        }
        return Blocks.field_196621_O.func_176223_P();
    }

    private static BlockState getQuartzBlockWithData(int data) {
        switch (data) {
            default: {
                return Blocks.field_150371_ca.func_176223_P();
            }
            case 1: {
                return Blocks.field_196772_fk.func_176223_P();
            }
            case 2: {
                return (BlockState)Blocks.field_196770_fj.func_176223_P().func_206870_a((Property)RotatedPillarBlock.field_176298_M, (Comparable)Direction.Axis.Y);
            }
            case 3: {
                return (BlockState)Blocks.field_196770_fj.func_176223_P().func_206870_a((Property)RotatedPillarBlock.field_176298_M, (Comparable)Direction.Axis.X);
            }
            case 4: 
        }
        return (BlockState)Blocks.field_196770_fj.func_176223_P().func_206870_a((Property)RotatedPillarBlock.field_176298_M, (Comparable)Direction.Axis.Z);
    }

    private static BlockState getTorchWithData(int material, int data) {
        switch (material) {
            case 0: {
                switch (data) {
                    default: {
                        return Blocks.field_150478_aa.func_176223_P();
                    }
                    case 1: {
                        return (BlockState)Blocks.field_196591_bQ.func_176223_P().func_206870_a((Property)WallTorchBlock.field_196532_a, (Comparable)Direction.EAST);
                    }
                    case 2: {
                        return (BlockState)Blocks.field_196591_bQ.func_176223_P().func_206870_a((Property)WallTorchBlock.field_196532_a, (Comparable)Direction.WEST);
                    }
                    case 3: {
                        return (BlockState)Blocks.field_196591_bQ.func_176223_P().func_206870_a((Property)WallTorchBlock.field_196532_a, (Comparable)Direction.SOUTH);
                    }
                    case 4: 
                }
                return (BlockState)Blocks.field_196591_bQ.func_176223_P().func_206870_a((Property)WallTorchBlock.field_196532_a, (Comparable)Direction.NORTH);
            }
            case 1: {
                switch (data) {
                    default: {
                        return Blocks.field_150429_aA.func_176223_P();
                    }
                    case 1: {
                        return (BlockState)((BlockState)Blocks.field_196677_cy.func_176223_P().func_206870_a((Property)RedstoneWallTorchBlock.field_196531_c, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)RedstoneWallTorchBlock.field_196530_b, (Comparable)Direction.EAST);
                    }
                    case 2: {
                        return (BlockState)((BlockState)Blocks.field_196677_cy.func_176223_P().func_206870_a((Property)RedstoneWallTorchBlock.field_196531_c, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)RedstoneWallTorchBlock.field_196530_b, (Comparable)Direction.WEST);
                    }
                    case 3: {
                        return (BlockState)((BlockState)Blocks.field_196677_cy.func_176223_P().func_206870_a((Property)RedstoneWallTorchBlock.field_196531_c, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)RedstoneWallTorchBlock.field_196530_b, (Comparable)Direction.SOUTH);
                    }
                    case 4: 
                }
                return (BlockState)((BlockState)Blocks.field_196677_cy.func_176223_P().func_206870_a((Property)RedstoneWallTorchBlock.field_196531_c, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)RedstoneWallTorchBlock.field_196530_b, (Comparable)Direction.NORTH);
            }
            case 2: {
                switch (data) {
                    default: {
                        return (BlockState)Blocks.field_150429_aA.func_176223_P().func_206870_a((Property)RedstoneWallTorchBlock.field_196531_c, (Comparable)Boolean.valueOf(true));
                    }
                    case 1: {
                        return (BlockState)((BlockState)Blocks.field_196677_cy.func_176223_P().func_206870_a((Property)RedstoneWallTorchBlock.field_196531_c, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)RedstoneWallTorchBlock.field_196530_b, (Comparable)Direction.EAST);
                    }
                    case 2: {
                        return (BlockState)((BlockState)Blocks.field_196677_cy.func_176223_P().func_206870_a((Property)RedstoneWallTorchBlock.field_196531_c, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)RedstoneWallTorchBlock.field_196530_b, (Comparable)Direction.WEST);
                    }
                    case 3: {
                        return (BlockState)((BlockState)Blocks.field_196677_cy.func_176223_P().func_206870_a((Property)RedstoneWallTorchBlock.field_196531_c, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)RedstoneWallTorchBlock.field_196530_b, (Comparable)Direction.SOUTH);
                    }
                    case 4: 
                }
                return (BlockState)((BlockState)Blocks.field_196677_cy.func_176223_P().func_206870_a((Property)RedstoneWallTorchBlock.field_196531_c, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)RedstoneWallTorchBlock.field_196530_b, (Comparable)Direction.NORTH);
            }
        }
        return null;
    }

    private static BlockState getRailsWithData(int material, int data) {
        int shape = ForgeLegacyMaterials.getBits(data, 0, 3);
        int active = ForgeLegacyMaterials.getBit(data, 3);
        switch (material) {
            case 0: {
                return (BlockState)((BlockState)Blocks.field_196552_aC.func_176223_P().func_206870_a((Property)PoweredRailBlock.field_176568_b, (Comparable)ForgeLegacyMaterials.getRailShape(shape))).func_206870_a((Property)PoweredRailBlock.field_176569_M, (Comparable)Boolean.valueOf(active == 1));
            }
            case 1: {
                return (BlockState)((BlockState)Blocks.field_150319_E.func_176223_P().func_206870_a((Property)DetectorRailBlock.field_176573_b, (Comparable)ForgeLegacyMaterials.getRailShape(shape))).func_206870_a((Property)DetectorRailBlock.field_176574_M, (Comparable)Boolean.valueOf(active == 1));
            }
            case 2: {
                return (BlockState)((BlockState)Blocks.field_150408_cc.func_176223_P().func_206870_a((Property)PoweredRailBlock.field_176568_b, (Comparable)ForgeLegacyMaterials.getRailShape(shape))).func_206870_a((Property)PoweredRailBlock.field_176569_M, (Comparable)Boolean.valueOf(active == 1));
            }
        }
        return null;
    }

    private static BlockState getStairsWithData(int material, int data) {
        int facing = ForgeLegacyMaterials.getBits(data, 0, 2);
        int half = ForgeLegacyMaterials.getBit(data, 2);
        BlockState output = null;
        switch (material) {
            case 0: {
                output = Blocks.field_150476_ad.func_176223_P();
                break;
            }
            case 1: {
                output = Blocks.field_150487_bG.func_176223_P();
                break;
            }
            case 2: {
                output = Blocks.field_150485_bF.func_176223_P();
                break;
            }
            case 3: {
                output = Blocks.field_150481_bH.func_176223_P();
                break;
            }
            case 4: {
                output = Blocks.field_196659_cl.func_176223_P();
                break;
            }
            case 5: {
                output = Blocks.field_150389_bf.func_176223_P();
                break;
            }
            case 6: {
                output = Blocks.field_222438_lb.func_176223_P();
                break;
            }
            case 7: {
                output = Blocks.field_150387_bl.func_176223_P();
                break;
            }
            case 8: {
                output = Blocks.field_150372_bz.func_176223_P();
                break;
            }
            case 9: {
                output = Blocks.field_150370_cb.func_176223_P();
                break;
            }
            case 10: {
                output = Blocks.field_150400_ck.func_176223_P();
                break;
            }
            case 11: {
                output = Blocks.field_150401_cl.func_176223_P();
                break;
            }
            case 12: {
                output = Blocks.field_180396_cN.func_176223_P();
                break;
            }
            case 13: {
                output = Blocks.field_185769_cV.func_176223_P();
                break;
            }
            case 14: {
                output = Blocks.field_150390_bg.func_176223_P();
                break;
            }
            default: {
                return null;
            }
        }
        return (BlockState)((BlockState)output.func_206870_a((Property)StairsBlock.field_176309_a, (Comparable)ForgeLegacyMaterials.getFacingEastWestSouthNorth(facing))).func_206870_a((Property)StairsBlock.field_176308_b, (Comparable)(half == 0 ? Half.BOTTOM : Half.TOP));
    }

    private static BlockState getLeverOrButtonWithData(int material, int data) {
        int facing = ForgeLegacyMaterials.getBits(data, 0, 3);
        int powered = ForgeLegacyMaterials.getBit(data, 3);
        AttachFace face = facing == 0 || facing == 7 ? AttachFace.CEILING : (facing == 1 || facing == 2 || facing == 3 || facing == 4 ? AttachFace.WALL : (facing == 5 || facing == 6 ? AttachFace.FLOOR : AttachFace.FLOOR));
        switch (material) {
            case 0: {
                return (BlockState)((BlockState)((BlockState)Blocks.field_150442_at.func_176223_P().func_206870_a((Property)LeverBlock.field_196366_M, (Comparable)face)).func_206870_a((Property)LeverBlock.field_185512_D, (Comparable)ForgeLegacyMaterials.getFacingLever(facing))).func_206870_a((Property)LeverBlock.field_176359_b, (Comparable)Boolean.valueOf(powered == 1));
            }
            case 1: {
                return (BlockState)((BlockState)((BlockState)Blocks.field_150430_aB.func_176223_P().func_206870_a((Property)StoneButtonBlock.field_196366_M, (Comparable)face)).func_206870_a((Property)StoneButtonBlock.field_185512_D, (Comparable)ForgeLegacyMaterials.getFacingButton(facing))).func_206870_a((Property)StoneButtonBlock.field_176584_b, (Comparable)Boolean.valueOf(powered == 1));
            }
            case 2: {
                return (BlockState)((BlockState)((BlockState)Blocks.field_196689_eF.func_176223_P().func_206870_a((Property)WoodButtonBlock.field_196366_M, (Comparable)face)).func_206870_a((Property)WoodButtonBlock.field_185512_D, (Comparable)ForgeLegacyMaterials.getFacingButton(facing))).func_206870_a((Property)WoodButtonBlock.field_176584_b, (Comparable)Boolean.valueOf(powered == 1));
            }
        }
        return null;
    }

    private static BlockState getDoorWithData(int material, int data) {
        BlockState blockState;
        int half = ForgeLegacyMaterials.getBit(data, 3);
        int hinge = ForgeLegacyMaterials.getBit(data, 0);
        int powered = ForgeLegacyMaterials.getBit(data, 1);
        int facing = ForgeLegacyMaterials.getBits(data, 0, 2);
        int open = ForgeLegacyMaterials.getBit(data, 2);
        switch (material) {
            case 0: {
                blockState = Blocks.field_180413_ao.func_176223_P();
                break;
            }
            case 1: {
                blockState = Blocks.field_150454_av.func_176223_P();
                break;
            }
            case 2: {
                blockState = Blocks.field_180414_ap.func_176223_P();
                break;
            }
            case 3: {
                blockState = Blocks.field_180412_aq.func_176223_P();
                break;
            }
            case 4: {
                blockState = Blocks.field_180411_ar.func_176223_P();
                break;
            }
            case 5: {
                blockState = Blocks.field_180410_as.func_176223_P();
                break;
            }
            case 6: {
                blockState = Blocks.field_180409_at.func_176223_P();
                break;
            }
            default: {
                return null;
            }
        }
        return half == 0 ? (BlockState)((BlockState)((BlockState)blockState.func_206870_a((Property)DoorBlock.field_176523_O, (Comparable)DoubleBlockHalf.LOWER)).func_206870_a((Property)DoorBlock.field_176520_a, (Comparable)ForgeLegacyMaterials.getFacingEastSouthWestNorth(facing))).func_206870_a((Property)DoorBlock.field_176519_b, (Comparable)Boolean.valueOf(open == 1)) : (BlockState)((BlockState)((BlockState)blockState.func_206870_a((Property)DoorBlock.field_176523_O, (Comparable)DoubleBlockHalf.UPPER)).func_206870_a((Property)DoorBlock.field_176521_M, (Comparable)(hinge == 0 ? DoorHingeSide.LEFT : DoorHingeSide.RIGHT))).func_206870_a((Property)DoorBlock.field_176522_N, (Comparable)Boolean.valueOf(powered == 1));
    }

    private static BlockState getSignPostWithData(int data) {
        int rotation = ForgeLegacyMaterials.getBits(data, 0, 4);
        return (BlockState)Blocks.field_222384_bX.func_176223_P().func_206870_a((Property)StandingSignBlock.field_176413_a, (Comparable)Integer.valueOf(rotation));
    }

    private static BlockState getWallSignWithData(int data) {
        int facing = ForgeLegacyMaterials.getBits(data, 0, 3);
        return (BlockState)Blocks.field_222392_ch.func_176223_P().func_206870_a((Property)WallSignBlock.field_176412_a, (Comparable)ForgeLegacyMaterials.getFacingNorthSouthWestEast(facing));
    }

    private static BlockState getCommandBlockWithData(int material, int data) {
        BlockState blockState;
        switch (material) {
            case 0: {
                blockState = Blocks.field_150483_bI.func_176223_P();
                break;
            }
            case 1: {
                blockState = Blocks.field_185776_dc.func_176223_P();
                break;
            }
            case 2: {
                blockState = Blocks.field_185777_dd.func_176223_P();
                break;
            }
            default: {
                return null;
            }
        }
        return blockState;
    }

    private static BlockState getShulkerBoxWithData(int material, int data) {
        BlockState blockState;
        switch (material) {
            case 0: {
                blockState = Blocks.field_190977_dl.func_176223_P();
                break;
            }
            case 1: {
                blockState = Blocks.field_190978_dm.func_176223_P();
                break;
            }
            case 2: {
                blockState = Blocks.field_190979_dn.func_176223_P();
                break;
            }
            case 3: {
                blockState = Blocks.field_190980_do.func_176223_P();
                break;
            }
            case 4: {
                blockState = Blocks.field_190981_dp.func_176223_P();
                break;
            }
            case 5: {
                blockState = Blocks.field_190982_dq.func_176223_P();
                break;
            }
            case 6: {
                blockState = Blocks.field_190983_dr.func_176223_P();
                break;
            }
            case 7: {
                blockState = Blocks.field_190984_ds.func_176223_P();
                break;
            }
            case 8: {
                blockState = Blocks.field_196875_ie.func_176223_P();
                break;
            }
            case 9: {
                blockState = Blocks.field_190986_du.func_176223_P();
                break;
            }
            case 10: {
                blockState = Blocks.field_190987_dv.func_176223_P();
                break;
            }
            case 11: {
                blockState = Blocks.field_190988_dw.func_176223_P();
                break;
            }
            case 12: {
                blockState = Blocks.field_190989_dx.func_176223_P();
                break;
            }
            case 13: {
                blockState = Blocks.field_190990_dy.func_176223_P();
                break;
            }
            case 14: {
                blockState = Blocks.field_190991_dz.func_176223_P();
                break;
            }
            case 15: {
                blockState = Blocks.field_190975_dA.func_176223_P();
                break;
            }
            case 16: {
                blockState = Blocks.field_204409_il.func_176223_P();
                break;
            }
            default: {
                return null;
            }
        }
        return (BlockState)blockState.func_206870_a((Property)ShulkerBoxBlock.field_190957_a, (Comparable)ForgeLegacyMaterials.getFacingDownEastNorthSouthUpWest(data));
    }

    private static BlockState getLadderChestOrFurnaceWithData(int material, int data) {
        int facing = ForgeLegacyMaterials.getBits(data, 0, 3);
        switch (material) {
            case 0: {
                return (BlockState)Blocks.field_150468_ap.func_176223_P().func_206870_a((Property)LadderBlock.field_176382_a, (Comparable)ForgeLegacyMaterials.getFacingNorthSouthWestEast(facing));
            }
            case 1: {
                return (BlockState)Blocks.field_150486_ae.func_176223_P().func_206870_a((Property)ChestBlock.field_176459_a, (Comparable)ForgeLegacyMaterials.getFacingNorthSouthWestEast(facing));
            }
            case 2: {
                return (BlockState)Blocks.field_150477_bB.func_176223_P().func_206870_a((Property)EnderChestBlock.field_176437_a, (Comparable)ForgeLegacyMaterials.getFacingNorthSouthWestEast(facing));
            }
            case 3: {
                return (BlockState)Blocks.field_150447_bR.func_176223_P().func_206870_a((Property)TrappedChestBlock.field_176459_a, (Comparable)ForgeLegacyMaterials.getFacingNorthSouthWestEast(facing));
            }
            case 4: {
                return (BlockState)((BlockState)Blocks.field_150460_al.func_176223_P().func_206870_a((Property)FurnaceBlock.field_220090_a, (Comparable)ForgeLegacyMaterials.getFacingNorthSouthWestEast(facing))).func_206870_a((Property)FurnaceBlock.field_220091_b, (Comparable)Boolean.valueOf(false));
            }
            case 5: {
                return (BlockState)((BlockState)Blocks.field_150460_al.func_176223_P().func_206870_a((Property)FurnaceBlock.field_220090_a, (Comparable)ForgeLegacyMaterials.getFacingNorthSouthWestEast(facing))).func_206870_a((Property)FurnaceBlock.field_220091_b, (Comparable)Boolean.valueOf(true));
            }
        }
        return null;
    }

    private static BlockState getDispenserHopperDropperWithData(int material, int data) {
        int facing = ForgeLegacyMaterials.getBits(data, 0, 3);
        int active = ForgeLegacyMaterials.getBit(data, 3);
        switch (material) {
            case 0: {
                return (BlockState)((BlockState)Blocks.field_150367_z.func_176223_P().func_206870_a((Property)DispenserBlock.field_176441_a, (Comparable)ForgeLegacyMaterials.getFacingDownUpNorthSouthWestEast(facing))).func_206870_a((Property)DispenserBlock.field_176440_b, (Comparable)Boolean.valueOf(active == 1));
            }
            case 1: {
                return (BlockState)((BlockState)Blocks.field_150409_cd.func_176223_P().func_206870_a((Property)DropperBlock.field_176441_a, (Comparable)ForgeLegacyMaterials.getFacingDownUpNorthSouthWestEast(facing))).func_206870_a((Property)DropperBlock.field_176440_b, (Comparable)Boolean.valueOf(active == 1));
            }
            case 2: {
                return (BlockState)((BlockState)Blocks.field_150438_bZ.func_176223_P().func_206870_a((Property)HopperBlock.field_176430_a, (Comparable)ForgeLegacyMaterials.getFacingDownUpNorthSouthWestEast(facing))).func_206870_a((Property)HopperBlock.field_176429_b, (Comparable)Boolean.valueOf(active == 1));
            }
        }
        return null;
    }

    private static BlockState getJackOLanternOrPumpkinWithData(int material, int data) {
        int facing = ForgeLegacyMaterials.getBits(data, 0, 2);
        switch (material) {
            case 0: {
                return (BlockState)Blocks.field_196625_cS.func_176223_P().func_206870_a((Property)CarvedPumpkinBlock.field_196359_a, (Comparable)ForgeLegacyMaterials.getFacingSouthWestNorthEast(facing));
            }
            case 1: {
                return (BlockState)Blocks.field_196628_cT.func_176223_P().func_206870_a((Property)CarvedPumpkinBlock.field_196359_a, (Comparable)ForgeLegacyMaterials.getFacingSouthWestNorthEast(facing));
            }
        }
        return null;
    }

    private static BlockState getObserverWithData(int data) {
        int facing = ForgeLegacyMaterials.getBits(data, 0, 3);
        int powered = ForgeLegacyMaterials.getBit(data, 3);
        return (BlockState)((BlockState)Blocks.field_190976_dk.func_176223_P().func_206870_a((Property)ObserverBlock.field_176387_N, (Comparable)ForgeLegacyMaterials.getFacingDownUpNorthSouthWestEast(facing))).func_206870_a((Property)ObserverBlock.field_190963_a, (Comparable)Boolean.valueOf(powered == 1));
    }

    private static BlockState getRepeaterWithData(int material, int data) {
        BlockState blockState;
        int facing = ForgeLegacyMaterials.getBits(data, 0, 2);
        int delay = ForgeLegacyMaterials.getBits(data, 2, 2) + 1;
        switch (material) {
            case 0: {
                blockState = (BlockState)Blocks.field_196633_cV.func_176223_P().func_206870_a((Property)RepeaterBlock.field_196348_c, (Comparable)Boolean.valueOf(false));
                break;
            }
            case 1: {
                blockState = (BlockState)Blocks.field_196633_cV.func_176223_P().func_206870_a((Property)RepeaterBlock.field_196348_c, (Comparable)Boolean.valueOf(true));
                break;
            }
            default: {
                return null;
            }
        }
        return (BlockState)((BlockState)blockState.func_206870_a((Property)RepeaterBlock.field_176410_b, (Comparable)Integer.valueOf(delay))).func_206870_a((Property)RepeaterBlock.field_185512_D, (Comparable)ForgeLegacyMaterials.getFacingSouthWestNorthEast(facing));
    }

    private static BlockState getComparatorWithData(int material, int data) {
        int facing = ForgeLegacyMaterials.getBits(data, 0, 2);
        int mode = ForgeLegacyMaterials.getBit(data, 2);
        int powered = material == 1 ? 1 : ForgeLegacyMaterials.getBit(data, 3);
        return (BlockState)((BlockState)((BlockState)Blocks.field_196762_fd.func_176223_P().func_206870_a((Property)ComparatorBlock.field_185512_D, (Comparable)ForgeLegacyMaterials.getFacingSouthWestNorthEast(facing))).func_206870_a((Property)ComparatorBlock.field_176463_b, (Comparable)(mode == 0 ? ComparatorMode.COMPARE : ComparatorMode.SUBTRACT))).func_206870_a((Property)ComparatorBlock.field_196348_c, (Comparable)Boolean.valueOf(powered == 1));
    }

    private static BlockState getBedBlockWithData(int data) {
        int facing = ForgeLegacyMaterials.getBits(data, 0, 2);
        int occupied = ForgeLegacyMaterials.getBit(data, 2);
        int part = ForgeLegacyMaterials.getBit(data, 3);
        return (BlockState)((BlockState)((BlockState)Blocks.field_196550_aA.func_176223_P().func_206870_a((Property)BedBlock.field_185512_D, (Comparable)ForgeLegacyMaterials.getFacingSouthWestNorthEast(facing))).func_206870_a((Property)BedBlock.field_176471_b, (Comparable)Boolean.valueOf(occupied == 1))).func_206870_a((Property)BedBlock.field_176472_a, (Comparable)(part == 0 ? BedPart.FOOT : BedPart.HEAD));
    }

    private static BlockState getTrapDoorBlockWithData(int material, int data) {
        BlockState blockState;
        int facing = ForgeLegacyMaterials.getBits(data, 0, 2);
        int open = ForgeLegacyMaterials.getBit(data, 2);
        int half = ForgeLegacyMaterials.getBit(data, 3);
        switch (material) {
            case 0: {
                blockState = Blocks.field_196636_cW.func_176223_P();
                break;
            }
            case 1: {
                blockState = Blocks.field_180400_cw.func_176223_P();
                break;
            }
            default: {
                return null;
            }
        }
        return (BlockState)((BlockState)((BlockState)blockState.func_206870_a((Property)TrapDoorBlock.field_185512_D, (Comparable)ForgeLegacyMaterials.getFacingSouthNorthEastWest(facing))).func_206870_a((Property)TrapDoorBlock.field_176285_M, (Comparable)(half == 0 ? Half.BOTTOM : Half.TOP))).func_206870_a((Property)TrapDoorBlock.field_176283_b, (Comparable)Boolean.valueOf(open == 1));
    }

    private static BlockState getPistonWithData(int material, int data) {
        int facing = ForgeLegacyMaterials.getBits(data, 0, 3);
        int extended = ForgeLegacyMaterials.getBit(data, 3);
        switch (material) {
            case 0: {
                return (BlockState)((BlockState)Blocks.field_150331_J.func_176223_P().func_206870_a((Property)PistonBlock.field_176320_b, (Comparable)Boolean.valueOf(extended == 1))).func_206870_a((Property)PistonBlock.field_176387_N, (Comparable)ForgeLegacyMaterials.getFacingDownUpNorthSouthWestEast(facing));
            }
            case 1: {
                return (BlockState)((BlockState)Blocks.field_150320_F.func_176223_P().func_206870_a((Property)PistonBlock.field_176320_b, (Comparable)Boolean.valueOf(extended == 1))).func_206870_a((Property)PistonBlock.field_176387_N, (Comparable)ForgeLegacyMaterials.getFacingDownUpNorthSouthWestEast(facing));
            }
        }
        return null;
    }

    private static BlockState getPistonHeadWithData(int data) {
        int facing = ForgeLegacyMaterials.getBits(data, 0, 3);
        int type = ForgeLegacyMaterials.getBit(data, 3);
        return (BlockState)((BlockState)Blocks.field_150332_K.func_176223_P().func_206870_a((Property)PistonHeadBlock.field_176387_N, (Comparable)ForgeLegacyMaterials.getFacingDownUpNorthSouthWestEast(facing))).func_206870_a((Property)PistonHeadBlock.field_176325_b, (Comparable)(type == 0 ? PistonType.DEFAULT : PistonType.STICKY));
    }

    private static BlockState getHugeMushroomWithData(int material, int data) {
        BlockState blockState;
        boolean west;
        boolean down = data == 14 || data == 15;
        boolean up = data == 1 || data == 2 || data == 3 || data == 4 || data == 5 || data == 6 || data == 7 || data == 8 || data == 9 || data == 14 || data == 15;
        boolean north = data == 1 || data == 2 || data == 3 || data == 10 || data == 14 || data == 15;
        boolean east = data == 3 || data == 6 || data == 9 || data == 10 || data == 14 || data == 15;
        boolean south = data == 7 || data == 8 || data == 9 || data == 10 || data == 14 || data == 15;
        boolean bl = west = data == 1 || data == 4 || data == 7 || data == 10 || data == 14 || data == 15;
        if (data == 10 || data == 15) {
            blockState = Blocks.field_196706_do.func_176223_P();
        } else {
            switch (material) {
                case 0: {
                    blockState = Blocks.field_150420_aW.func_176223_P();
                    break;
                }
                case 1: {
                    blockState = Blocks.field_150419_aX.func_176223_P();
                    break;
                }
                default: {
                    return null;
                }
            }
        }
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)blockState.func_206870_a((Property)HugeMushroomBlock.field_196460_A, (Comparable)Boolean.valueOf(down))).func_206870_a((Property)HugeMushroomBlock.field_196465_z, (Comparable)Boolean.valueOf(up))).func_206870_a((Property)HugeMushroomBlock.field_196459_a, (Comparable)Boolean.valueOf(north))).func_206870_a((Property)HugeMushroomBlock.field_196461_b, (Comparable)Boolean.valueOf(east))).func_206870_a((Property)HugeMushroomBlock.field_196463_c, (Comparable)Boolean.valueOf(south))).func_206870_a((Property)HugeMushroomBlock.field_196464_y, (Comparable)Boolean.valueOf(west));
    }

    private static BlockState getVineWithData(int data) {
        int south = ForgeLegacyMaterials.getBit(data, 0);
        int west = ForgeLegacyMaterials.getBit(data, 1);
        int north = ForgeLegacyMaterials.getBit(data, 2);
        int east = ForgeLegacyMaterials.getBit(data, 3);
        boolean up = data == 0;
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)Blocks.field_150395_bd.func_176223_P().func_206870_a((Property)VineBlock.field_176278_M, (Comparable)Boolean.valueOf(east == 1))).func_206870_a((Property)VineBlock.field_176273_b, (Comparable)Boolean.valueOf(north == 1))).func_206870_a((Property)VineBlock.field_176279_N, (Comparable)Boolean.valueOf(south == 1))).func_206870_a((Property)VineBlock.field_176280_O, (Comparable)Boolean.valueOf(west == 1))).func_206870_a((Property)VineBlock.field_176277_a, (Comparable)Boolean.valueOf(up));
    }

    private static BlockState getFenceGateWithData(int material, int data) {
        BlockState blockState;
        int facing = ForgeLegacyMaterials.getBits(data, 0, 2);
        int open = ForgeLegacyMaterials.getBit(data, 2);
        switch (material) {
            case 0: {
                blockState = Blocks.field_180392_bq.func_176223_P();
                break;
            }
            case 1: {
                blockState = Blocks.field_180390_bo.func_176223_P();
                break;
            }
            case 2: {
                blockState = Blocks.field_180391_bp.func_176223_P();
                break;
            }
            case 3: {
                blockState = Blocks.field_180386_br.func_176223_P();
                break;
            }
            case 4: {
                blockState = Blocks.field_180385_bs.func_176223_P();
                break;
            }
            case 5: {
                blockState = Blocks.field_180387_bt.func_176223_P();
                break;
            }
            default: {
                return null;
            }
        }
        return (BlockState)((BlockState)blockState.func_206870_a((Property)FenceGateBlock.field_185512_D, (Comparable)ForgeLegacyMaterials.getFacingSouthWestNorthEast(facing))).func_206870_a((Property)FenceGateBlock.field_176466_a, (Comparable)Boolean.valueOf(open == 1));
    }

    private static BlockState getCocoaWithData(int data) {
        int facing = ForgeLegacyMaterials.getBits(data, 0, 2);
        int age = ForgeLegacyMaterials.getBits(data, 2, 2);
        return (BlockState)((BlockState)Blocks.field_150375_by.func_176223_P().func_206870_a((Property)CocoaBlock.field_185512_D, (Comparable)ForgeLegacyMaterials.getFacingSouthWestNorthEast(facing))).func_206870_a((Property)CocoaBlock.field_176501_a, (Comparable)Integer.valueOf(age));
    }

    private static BlockState getTripWireHookWithData(int data) {
        int facing = ForgeLegacyMaterials.getBits(data, 0, 2);
        int attached = ForgeLegacyMaterials.getBit(data, 2);
        int powered = ForgeLegacyMaterials.getBit(data, 3);
        return (BlockState)((BlockState)((BlockState)Blocks.field_150479_bC.func_176223_P().func_206870_a((Property)TripWireHookBlock.field_176265_M, (Comparable)Boolean.valueOf(attached == 1))).func_206870_a((Property)TripWireHookBlock.field_176264_a, (Comparable)ForgeLegacyMaterials.getFacingSouthWestNorthEast(facing))).func_206870_a((Property)TripWireHookBlock.field_176263_b, (Comparable)Boolean.valueOf(powered == 1));
    }

    private static BlockState getEndPortalFrameWithData(int data) {
        int facing = ForgeLegacyMaterials.getBits(data, 0, 2);
        int eye = ForgeLegacyMaterials.getBit(data, 2);
        return (BlockState)((BlockState)Blocks.field_150378_br.func_176223_P().func_206870_a((Property)EndPortalFrameBlock.field_176507_b, (Comparable)Boolean.valueOf(eye == 1))).func_206870_a((Property)EndPortalFrameBlock.field_176508_a, (Comparable)ForgeLegacyMaterials.getFacingSouthWestNorthEast(facing));
    }

    private static BlockState getStructureBlockWithData(int data) {
        StructureMode structureBlockMode = data == 0 ? StructureMode.DATA : (data == 1 ? StructureMode.SAVE : (data == 2 ? StructureMode.LOAD : (data == 3 ? StructureMode.LOAD : StructureMode.DATA)));
        return (BlockState)Blocks.field_185779_df.func_176223_P().func_206870_a((Property)StructureBlock.field_185587_a, (Comparable)structureBlockMode);
    }

    private static BlockState getGlazedTerracottaWithData(int material, int data) {
        BlockState blockState;
        int facing = ForgeLegacyMaterials.getBits(data, 0, 2);
        switch (material) {
            case 0: {
                blockState = Blocks.field_192442_dQ.func_176223_P();
                break;
            }
            case 1: {
                blockState = Blocks.field_192438_dM.func_176223_P();
                break;
            }
            case 2: {
                blockState = Blocks.field_192439_dN.func_176223_P();
                break;
            }
            case 3: {
                blockState = Blocks.field_192436_dK.func_176223_P();
                break;
            }
            case 4: {
                blockState = Blocks.field_192434_dI.func_176223_P();
                break;
            }
            case 5: {
                blockState = Blocks.field_192440_dO.func_176223_P();
                break;
            }
            case 6: {
                blockState = Blocks.field_192430_dE.func_176223_P();
                break;
            }
            case 7: {
                blockState = Blocks.field_192432_dG.func_176223_P();
                break;
            }
            case 8: {
                blockState = Blocks.field_192429_dD.func_176223_P();
                break;
            }
            case 9: {
                blockState = Blocks.field_192428_dC.func_176223_P();
                break;
            }
            case 10: {
                blockState = Blocks.field_192433_dH.func_176223_P();
                break;
            }
            case 11: {
                blockState = Blocks.field_192437_dL.func_176223_P();
                break;
            }
            case 12: {
                blockState = Blocks.field_192441_dP.func_176223_P();
                break;
            }
            case 13: {
                blockState = Blocks.field_196876_iu.func_176223_P();
                break;
            }
            case 14: {
                blockState = Blocks.field_192427_dB.func_176223_P();
                break;
            }
            case 15: {
                blockState = Blocks.field_192431_dF.func_176223_P();
                break;
            }
            default: {
                return Blocks.field_192442_dQ.func_176223_P();
            }
        }
        return (BlockState)blockState.func_206870_a((Property)GlazedTerracottaBlock.field_185512_D, (Comparable)ForgeLegacyMaterials.getFacingSouthWestNorthEast(facing));
    }

    private static BlockState getTripWireWithData(int data) {
        int active = ForgeLegacyMaterials.getBit(data, 0);
        int attached = ForgeLegacyMaterials.getBit(data, 2);
        int disarmed = ForgeLegacyMaterials.getBit(data, 3);
        return (BlockState)((BlockState)((BlockState)Blocks.field_150473_bD.func_176223_P().func_206870_a((Property)TripWireBlock.field_176293_a, (Comparable)Boolean.valueOf(active == 1))).func_206870_a((Property)TripWireBlock.field_176294_M, (Comparable)Boolean.valueOf(attached == 1))).func_206870_a((Property)TripWireBlock.field_176295_N, (Comparable)Boolean.valueOf(disarmed == 1));
    }

    private static Direction.Axis getAxisXYZ(int data) {
        switch (data) {
            case 0: {
                return Direction.Axis.X;
            }
            case 1: {
                return Direction.Axis.Y;
            }
            case 2: {
                return Direction.Axis.Z;
            }
        }
        return Direction.Axis.Y;
    }

    private static Direction.Axis getAxisXZ(int data) {
        switch (data) {
            case 1: {
                return Direction.Axis.X;
            }
            case 2: {
                return Direction.Axis.Z;
            }
        }
        return Direction.Axis.X;
    }

    private static Direction getFacingSouthWestNorthEast(int data) {
        switch (data) {
            case 0: {
                return Direction.SOUTH;
            }
            case 1: {
                return Direction.WEST;
            }
            case 2: {
                return Direction.NORTH;
            }
            case 3: {
                return Direction.EAST;
            }
        }
        return Direction.SOUTH;
    }

    private static Direction getFacingNorthSouthWestEast(int data) {
        switch (data) {
            case 2: {
                return Direction.NORTH;
            }
            case 3: {
                return Direction.SOUTH;
            }
            case 4: {
                return Direction.WEST;
            }
            case 5: {
                return Direction.EAST;
            }
        }
        return Direction.NORTH;
    }

    private static Direction getFacingDownUpNorthSouthWestEast(int data) {
        switch (data) {
            case 0: {
                return Direction.DOWN;
            }
            case 1: {
                return Direction.UP;
            }
            case 2: {
                return Direction.NORTH;
            }
            case 3: {
                return Direction.SOUTH;
            }
            case 4: {
                return Direction.WEST;
            }
            case 5: {
                return Direction.EAST;
            }
        }
        return Direction.DOWN;
    }

    private static Direction getFacingSouthNorthEastWest(int data) {
        switch (data) {
            case 0: {
                return Direction.SOUTH;
            }
            case 1: {
                return Direction.NORTH;
            }
            case 2: {
                return Direction.EAST;
            }
            case 3: {
                return Direction.WEST;
            }
        }
        return Direction.SOUTH;
    }

    private static Direction getFacingEastSouthWestNorth(int data) {
        switch (data) {
            case 0: {
                return Direction.EAST;
            }
            case 1: {
                return Direction.SOUTH;
            }
            case 2: {
                return Direction.WEST;
            }
            case 3: {
                return Direction.NORTH;
            }
        }
        return Direction.EAST;
    }

    private static Direction getFacingEastWestSouthNorth(int data) {
        switch (data) {
            case 0: {
                return Direction.EAST;
            }
            case 1: {
                return Direction.WEST;
            }
            case 2: {
                return Direction.SOUTH;
            }
            case 3: {
                return Direction.NORTH;
            }
        }
        return Direction.EAST;
    }

    private static Direction getFacingDownEastNorthSouthUpWest(int data) {
        switch (data) {
            case 0: {
                return Direction.DOWN;
            }
            case 1: {
                return Direction.EAST;
            }
            case 2: {
                return Direction.NORTH;
            }
            case 3: {
                return Direction.SOUTH;
            }
            case 4: {
                return Direction.UP;
            }
            case 5: {
                return Direction.WEST;
            }
        }
        return Direction.UP;
    }

    private static Direction.Axis getPillarAxisXYZ(int data) {
        switch (data) {
            case 0: {
                return Direction.Axis.Y;
            }
            case 4: {
                return Direction.Axis.X;
            }
            case 8: {
                return Direction.Axis.Z;
            }
        }
        return Direction.Axis.Y;
    }

    private static Direction getFacingLever(int data) {
        switch (data) {
            case 0: 
            case 1: 
            case 6: {
                return Direction.EAST;
            }
            case 2: {
                return Direction.WEST;
            }
            case 3: 
            case 5: 
            case 7: {
                return Direction.SOUTH;
            }
            case 4: {
                return Direction.NORTH;
            }
        }
        return Direction.EAST;
    }

    private static Direction getFacingButton(int data) {
        switch (data) {
            case 1: {
                return Direction.EAST;
            }
            case 2: {
                return Direction.WEST;
            }
            case 3: {
                return Direction.SOUTH;
            }
            case 4: {
                return Direction.NORTH;
            }
        }
        return Direction.EAST;
    }

    private static RailShape getRailShape(int shape) {
        switch (shape) {
            case 0: {
                return RailShape.NORTH_SOUTH;
            }
            case 1: {
                return RailShape.EAST_WEST;
            }
            case 2: {
                return RailShape.ASCENDING_EAST;
            }
            case 3: {
                return RailShape.ASCENDING_WEST;
            }
            case 4: {
                return RailShape.ASCENDING_NORTH;
            }
            case 5: {
                return RailShape.ASCENDING_SOUTH;
            }
            case 6: {
                return RailShape.SOUTH_EAST;
            }
            case 7: {
                return RailShape.SOUTH_WEST;
            }
            case 8: {
                return RailShape.NORTH_WEST;
            }
            case 9: {
                return RailShape.NORTH_EAST;
            }
        }
        return RailShape.NORTH_SOUTH;
    }

    private static int getBits(int source, int index, int length) {
        int bits = 0;
        for (int i = 0; i < length; ++i) {
            bits |= ForgeLegacyMaterials.getBit(source, index + i) << i;
        }
        return bits;
    }

    private static int getBit(int source, int index) {
        return (source & 1 << index) >> index;
    }
}

