/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.materials;

import com.pg85.otg.forge.materials.ForgeMaterialTag;
import com.pg85.otg.util.OTGDirection;
import com.pg85.otg.util.materials.LocalMaterialData;
import com.pg85.otg.util.materials.LocalMaterialTag;
import com.pg85.otg.util.materials.MaterialProperties;
import com.pg85.otg.util.materials.MaterialProperty;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FallingBlock;
import net.minecraft.block.FourWayBlock;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.block.SnowBlock;
import net.minecraft.block.material.Material;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;

public class ForgeMaterialData
extends LocalMaterialData {
    static final LocalMaterialData blank = new ForgeMaterialData(null, null, true);
    private static final ConcurrentHashMap<BlockState, ForgeMaterialData> stateToMaterialDataMap = new ConcurrentHashMap();
    private final BlockState blockData;
    private String name = null;

    private ForgeMaterialData(BlockState blockData, String raw) {
        this(blockData, raw, false);
    }

    private ForgeMaterialData(BlockState blockData, String raw, boolean isBlank) {
        this.blockData = blockData;
        this.rawEntry = raw;
        this.isBlank = isBlank;
    }

    static ForgeMaterialData ofBlock(Block block, String raw) {
        return ForgeMaterialData.ofBlockState(block.func_176223_P(), raw);
    }

    public static ForgeMaterialData ofBlockState(BlockState blockData) {
        return ForgeMaterialData.ofBlockState(blockData, null);
    }

    static ForgeMaterialData ofBlockState(BlockState blockState, String raw) {
        ForgeMaterialData existingData = stateToMaterialDataMap.get(blockState);
        if (existingData != null) {
            return existingData;
        }
        ForgeMaterialData newData = new ForgeMaterialData(blockState, raw);
        existingData = stateToMaterialDataMap.putIfAbsent(blockState, newData);
        if (existingData != null) {
            return existingData;
        }
        return newData;
    }

    public BlockState internalBlock() {
        return this.blockData;
    }

    @Override
    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        if (this.isBlank) {
            return "BLANK";
        }
        this.name = this.blockData == null ? (this.rawEntry != null ? this.rawEntry : "Unknown") : (this.blockData != this.blockData.func_177230_c().func_176223_P() && (!(this.blockData.func_177230_c() instanceof LeavesBlock) || this.blockData != this.blockData.func_177230_c().func_176223_P().func_206870_a((Property)LeavesBlock.field_208494_a, (Comparable)Integer.valueOf(1))) ? this.blockData.toString().replace("Block{", "").replace("}", "") : this.blockData.func_177230_c().getRegistryName().toString());
        return this.name;
    }

    @Override
    public String getRegistryName() {
        return this.blockData == null ? null : this.blockData.func_177230_c().getRegistryName().toString();
    }

    @Override
    public boolean isLiquid() {
        return this.blockData != null && this.blockData.func_185904_a().func_76224_d();
    }

    @Override
    public boolean isSolid() {
        return this.blockData != null && this.blockData.func_185904_a().func_76220_a() && this.blockData.func_185904_a().func_76218_k();
    }

    @Override
    public boolean isEmptyOrAir() {
        return this.blockData == null || this.blockData.func_185904_a() == Material.field_151579_a;
    }

    @Override
    public boolean isNonCaveAir() {
        return this.blockData != null && this.blockData.func_177230_c() == Blocks.field_150350_a;
    }

    @Override
    public boolean isAir() {
        return this.blockData != null && this.blockData.func_185904_a() == Material.field_151579_a;
    }

    @Override
    public boolean isEmpty() {
        return this.blockData == null;
    }

    @Override
    public boolean canFall() {
        return this.blockData != null && this.blockData.func_177230_c() instanceof FallingBlock;
    }

    @Override
    public boolean canSnowFallOn() {
        if (!(this.blockData == null || this.blockData.func_203425_a(Blocks.field_150432_aD) || this.blockData.func_203425_a(Blocks.field_150403_cj) || this.blockData.func_203425_a(Blocks.field_180401_cv))) {
            if (!this.blockData.func_203425_a(Blocks.field_226907_mc_) && !this.blockData.func_203425_a(Blocks.field_150425_aM)) {
                return this.blockData.func_185904_a().func_76220_a() || this.blockData.func_203425_a(Blocks.field_150433_aE) && (Integer)this.blockData.func_177229_b((Property)SnowBlock.field_176315_a) == 8;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isMaterial(LocalMaterialData material) {
        return this.isBlank && ((ForgeMaterialData)material).isBlank || !this.isBlank && !((ForgeMaterialData)material).isBlank && Objects.equals(this.blockData.func_177230_c(), ((ForgeMaterialData)material).internalBlock().func_177230_c());
    }

    @Override
    public LocalMaterialData rotate(int rotateTimes) {
        if (this.isBlank) {
            return this;
        }
        if (this.rotated == null) {
            BlockState state = this.blockData;
            Collection properties = state.func_235904_r_();
            for (Property property : properties) {
                if (!(property instanceof DirectionProperty)) continue;
                Direction direction = (Direction)state.func_177229_b(property);
                switch (direction) {
                    case DOWN: 
                    case UP: {
                        break;
                    }
                    case NORTH: {
                        state = (BlockState)state.func_206870_a((Property)((DirectionProperty)property), (Comparable)Direction.WEST);
                        break;
                    }
                    case SOUTH: {
                        state = (BlockState)state.func_206870_a((Property)((DirectionProperty)property), (Comparable)Direction.EAST);
                        break;
                    }
                    case WEST: {
                        state = (BlockState)state.func_206870_a((Property)((DirectionProperty)property), (Comparable)Direction.SOUTH);
                        break;
                    }
                    case EAST: {
                        state = (BlockState)state.func_206870_a((Property)((DirectionProperty)property), (Comparable)Direction.NORTH);
                    }
                }
            }
            if (state.func_235901_b_((Property)RotatedPillarBlock.field_176298_M)) {
                state = ((RotatedPillarBlock)state.func_177230_c()).func_185499_a(this.blockData, Rotation.COUNTERCLOCKWISE_90);
            }
            if (state.func_235901_b_((Property)FourWayBlock.field_196411_b)) {
                boolean hasEast = (Boolean)state.func_177229_b((Property)FourWayBlock.field_196411_b);
                state = (BlockState)state.func_206870_a((Property)FourWayBlock.field_196411_b, state.func_177229_b((Property)FourWayBlock.field_196413_c));
                state = (BlockState)state.func_206870_a((Property)FourWayBlock.field_196413_c, state.func_177229_b((Property)FourWayBlock.field_196414_y));
                state = (BlockState)state.func_206870_a((Property)FourWayBlock.field_196414_y, state.func_177229_b((Property)FourWayBlock.field_196409_a));
                state = (BlockState)state.func_206870_a((Property)FourWayBlock.field_196409_a, (Comparable)Boolean.valueOf(hasEast));
            }
            this.rotated = ForgeMaterialData.ofBlockState(state);
        }
        if (rotateTimes > 1) {
            return this.rotated.rotate(rotateTimes - 1);
        }
        return this.rotated;
    }

    @Override
    public <T extends Comparable<T>> LocalMaterialData withProperty(MaterialProperty<T> materialProperty, T value) {
        IntegerProperty property = null;
        T finalVal = value;
        if (materialProperty == MaterialProperties.AGE_0_25) {
            property = BlockStateProperties.field_208172_Y;
        } else if (materialProperty == MaterialProperties.AGE_0_3) {
            property = BlockStateProperties.field_208168_U;
        } else if (materialProperty == MaterialProperties.PICKLES_1_4) {
            property = BlockStateProperties.field_208135_aj;
        } else if (materialProperty == MaterialProperties.SNOWY) {
            property = BlockStateProperties.field_208196_w;
        } else {
            if (materialProperty == MaterialProperties.HORIZONTAL_DIRECTION) {
                property = BlockStateProperties.field_208157_J;
                Direction direction = Direction.values()[((OTGDirection)((Object)value)).ordinal()];
                return ForgeMaterialData.ofBlockState((BlockState)this.blockData.func_206870_a((Property)property, (Comparable)direction));
            }
            throw new IllegalArgumentException("Unknown property: " + materialProperty);
        }
        return ForgeMaterialData.ofBlockState((BlockState)this.blockData.func_206870_a((Property)property, finalVal));
    }

    @Override
    public boolean isBlockTag(LocalMaterialTag tag) {
        return this.blockData == null ? false : this.blockData.func_235714_a_(((ForgeMaterialTag)tag).getTag());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ForgeMaterialData)) {
            return false;
        }
        ForgeMaterialData other = (ForgeMaterialData)obj;
        return this.isBlank && other.isBlank || !this.isBlank && !other.isBlank && this.blockData.func_177230_c().equals(other.internalBlock().func_177230_c());
    }

    @Override
    public int hashCode() {
        return this.blockData == null ? -1 : this.blockData.hashCode();
    }

    @Override
    public LocalMaterialData legalOrPersistentLeaves(boolean leaveIllegalLeaves) {
        if (!this.isLeaves()) {
            return this;
        }
        int i = (Integer)this.blockData.func_177229_b((Property)LeavesBlock.field_208494_a);
        if (i > 6) {
            if (leaveIllegalLeaves) {
                return ForgeMaterialData.ofBlockState((BlockState)((BlockState)this.blockData.func_206870_a((Property)LeavesBlock.field_208494_a, (Comparable)Integer.valueOf(1))).func_206870_a((Property)LeavesBlock.field_208495_b, (Comparable)Boolean.valueOf(false)));
            }
            return ForgeMaterialData.ofBlockState((BlockState)this.blockData.func_206870_a((Property)LeavesBlock.field_208495_b, (Comparable)Boolean.valueOf(true)));
        }
        return ForgeMaterialData.ofBlockState((BlockState)this.blockData.func_206870_a((Property)LeavesBlock.field_208495_b, (Comparable)Boolean.valueOf(false)));
    }
}

