/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.materials;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.pg85.otg.OTG;
import com.pg85.otg.exceptions.InvalidConfigException;
import com.pg85.otg.forge.materials.ForgeLegacyMaterials;
import com.pg85.otg.forge.materials.ForgeMaterialData;
import com.pg85.otg.forge.materials.ForgeMaterialTag;
import com.pg85.otg.interfaces.IMaterialReader;
import com.pg85.otg.util.FifoMap;
import com.pg85.otg.util.logging.LogCategory;
import com.pg85.otg.util.logging.LogLevel;
import com.pg85.otg.util.materials.LocalMaterialData;
import com.pg85.otg.util.materials.LocalMaterialTag;
import com.pg85.otg.util.minecraft.BlockNames;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.LeavesBlock;
import net.minecraft.command.arguments.BlockStateParser;
import net.minecraft.state.Property;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ResourceLocationException;
import net.minecraftforge.registries.ForgeRegistries;

public class ForgeMaterialReader
implements IMaterialReader {
    private final FifoMap<String, LocalMaterialData> cachedMaterials = new FifoMap(4096);
    private final FifoMap<String, LocalMaterialTag> cachedTags = new FifoMap(4096);

    @Override
    public LocalMaterialData readMaterial(String material) throws InvalidConfigException {
        LocalMaterialData localMaterial;
        block5: {
            if (material == null) {
                return null;
            }
            localMaterial = (LocalMaterialData)this.cachedMaterials.get(material);
            if (localMaterial != null) {
                return localMaterial;
            }
            if (this.cachedMaterials.containsKey(material)) {
                throw new InvalidConfigException("Cannot read block: " + material);
            }
            try {
                localMaterial = this.materialFromString(material);
            }
            catch (InvalidConfigException ex) {
                if (!OTG.getEngine().getLogger().getLogCategoryEnabled(LogCategory.CONFIGS)) break block5;
                OTG.getEngine().getLogger().log(LogLevel.ERROR, LogCategory.CONFIGS, "Invalid material " + material + ". Exception: " + ex.getMessage() + ". Replacing with blank.");
            }
        }
        this.cachedMaterials.put(material, localMaterial);
        return localMaterial;
    }

    @Override
    public LocalMaterialTag readTag(String tag) throws InvalidConfigException {
        if (tag == null) {
            return null;
        }
        LocalMaterialTag localTag = (LocalMaterialTag)this.cachedTags.get(tag);
        if (localTag != null) {
            return localTag;
        }
        localTag = ForgeMaterialTag.ofString(tag);
        this.cachedTags.put(tag, localTag);
        return localTag;
    }

    private LocalMaterialData materialFromString(String input) throws InvalidConfigException {
        BlockState blockState;
        if (input == null || input.trim().isEmpty()) {
            return null;
        }
        if (input.matches("minecraft:[A-Za-z_]+:[0-9]+")) {
            input = input.split(":")[1] + ":" + input.split(":")[2];
        }
        if (input.equalsIgnoreCase("blank")) {
            return ForgeMaterialData.blank;
        }
        String blockNameCorrected = input.trim().toLowerCase();
        if (!blockNameCorrected.contains(":")) {
            blockState = ForgeLegacyMaterials.fromLegacyBlockName(blockNameCorrected);
            if (blockState != null) {
                return ForgeMaterialData.ofBlockState(blockState, input);
            }
            try {
                int blockId;
                String fromLegacyIdName;
                if (blockNameCorrected.endsWith(".0")) {
                    blockNameCorrected = blockNameCorrected.substring(0, blockNameCorrected.length() - 2);
                }
                if ((fromLegacyIdName = BlockNames.blockNameFromLegacyBlockId(blockId = Integer.parseInt(blockNameCorrected))) != null && (blockState = ForgeLegacyMaterials.fromLegacyBlockName(blockNameCorrected = fromLegacyIdName)) != null) {
                    return ForgeMaterialData.ofBlockState(blockState, input);
                }
            }
            catch (NumberFormatException blockId) {
                // empty catch block
            }
        }
        BlockState state = null;
        try {
            String newInput = blockNameCorrected.contains(":") ? blockNameCorrected : "minecraft:" + blockNameCorrected;
            state = new BlockStateParser(new StringReader(newInput), true).func_197243_a(true).func_197249_b();
        }
        catch (CommandSyntaxException newInput) {
            // empty catch block
        }
        if (state != null) {
            if (state.func_177230_c() instanceof LeavesBlock) {
                return ForgeMaterialData.ofBlockState((BlockState)state.func_206870_a((Property)LeavesBlock.field_208494_a, (Comparable)Integer.valueOf(1)), input);
            }
            return ForgeMaterialData.ofBlockState(state, input);
        }
        if (blockNameCorrected.contains(":")) {
            String blockNameOrId = blockNameCorrected.substring(0, blockNameCorrected.indexOf(":"));
            try {
                int blockId = Integer.parseInt(blockNameOrId);
                blockNameOrId = BlockNames.blockNameFromLegacyBlockId(blockId);
            }
            catch (NumberFormatException blockId) {
                // empty catch block
            }
            try {
                int data = Integer.parseInt(blockNameCorrected.substring(blockNameCorrected.indexOf(":") + 1));
                blockState = ForgeLegacyMaterials.fromLegacyBlockNameOrIdWithData(blockNameOrId, data);
                if (blockState != null) {
                    return ForgeMaterialData.ofBlockState(blockState, input);
                }
                blockNameCorrected = blockNameCorrected.substring(0, blockNameCorrected.indexOf(":"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        try {
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockNameCorrected));
            if (block != null && (block != Blocks.field_150350_a || blockNameCorrected.toLowerCase().endsWith("air"))) {
                if (block instanceof LeavesBlock) {
                    return ForgeMaterialData.ofBlockState((BlockState)block.func_176223_P().func_206870_a((Property)LeavesBlock.field_208494_a, (Comparable)Integer.valueOf(1)), input);
                }
                return ForgeMaterialData.ofBlock(block, input);
            }
        }
        catch (ResourceLocationException resourceLocationException) {
            // empty catch block
        }
        blockState = ForgeLegacyMaterials.fromLegacyBlockName(blockNameCorrected.replace("minecraft:", ""));
        if (blockState != null) {
            return ForgeMaterialData.ofBlockState(blockState, input);
        }
        if (OTG.getEngine().getLogger().getLogCategoryEnabled(LogCategory.CONFIGS)) {
            OTG.getEngine().getLogger().log(LogLevel.ERROR, LogCategory.CONFIGS, "Could not parse block: " + input + ", substituting AIR.");
        }
        return ForgeMaterialData.ofBlock(Blocks.field_150350_a, input);
    }
}

