/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.materials;

import com.pg85.otg.util.materials.LocalMaterialTag;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ResourceLocationException;

public class ForgeMaterialTag
extends LocalMaterialTag {
    private final String name;
    private final ITag<Block> blockTag;

    public static LocalMaterialTag ofString(String name) {
        Optional<ITag.INamedTag> optTag;
        if (!name.contains(":") || name.startsWith("otg:")) {
            try {
                ResourceLocation otgResourceLocation = new ResourceLocation("otg:" + name.trim().toLowerCase().replace("otg:", ""));
                optTag = BlockTags.func_242174_b().stream().filter(a -> a.func_230234_a_().equals((Object)otgResourceLocation)).findFirst();
                if (optTag.isPresent()) {
                    return new ForgeMaterialTag((ITag<Block>)((ITag)optTag.get()), otgResourceLocation.toString());
                }
            }
            catch (ResourceLocationException resourceLocationException) {
                // empty catch block
            }
        }
        try {
            ResourceLocation resourceLocation = new ResourceLocation(name.trim().toLowerCase());
            optTag = BlockTags.func_242174_b().stream().filter(a -> a.func_230234_a_().equals((Object)resourceLocation)).findFirst();
            if (optTag.isPresent()) {
                return new ForgeMaterialTag((ITag<Block>)((ITag)optTag.get()), resourceLocation.toString());
            }
        }
        catch (ResourceLocationException resourceLocationException) {
            // empty catch block
        }
        return null;
    }

    private ForgeMaterialTag(ITag<Block> blockTag, String name) {
        this.blockTag = blockTag;
        this.name = name;
    }

    public ITag<Block> getTag() {
        return this.blockTag;
    }

    @Override
    public String toString() {
        return this.name;
    }
}

