/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.mixin;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class MixinConfigPlugin
implements IMixinConfigPlugin {
    public void onLoad(String mixinPackage) {
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        return true;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
        Logger logger = LogManager.getLogger((String)"otg");
        List<String> cannotBeDuplicateMixins = Arrays.asList("net.minecraft.world.gen.feature.structure.Structure");
        try {
            myTargets.stream().filter(a -> cannotBeDuplicateMixins.contains(a) && otherTargets.contains(a)).collect(Collectors.toList()).forEach(a -> {
                myTargets.remove(a);
                logger.warn("Detected conflicting mixin for class " + a + " from other mod, disabling OTG mixin to avoid problems.");
            });
        }
        catch (UnsupportedOperationException ex) {
            try {
                for (Field field : myTargets.getClass().getSuperclass().getDeclaredFields()) {
                    if (!field.getType().equals(Collection.class)) continue;
                    field.setAccessible(true);
                    Collection wrappedSet = (Collection)field.get(myTargets);
                    myTargets.stream().filter(a -> cannotBeDuplicateMixins.contains(a) && otherTargets.contains(a)).collect(Collectors.toList()).forEach(a -> {
                        wrappedSet.remove(a);
                        logger.warn("Detected conflicting mixin for class " + a + " from other mod, disabling OTG mixin to avoid problems.");
                    });
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | SecurityException e) {
                e.printStackTrace();
            }
        }
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

