/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.mixin;

import com.pg85.otg.forge.gen.OTGNoiseChunkGenerator;
import net.minecraft.entity.player.SpawnLocationHelper;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SpawnLocationHelper.class})
public class MixinSpawnLocationHelper {
    @Inject(method={"getOverworldRespawnPos"}, at={@At(value="HEAD")}, cancellable=true)
    private static void fixSpawningInGround(ServerWorld world, int x, int z, boolean needsValidSpawn, CallbackInfoReturnable<BlockPos> cir) {
        if (world.func_72863_F().field_186029_c instanceof OTGNoiseChunkGenerator) {
            Chunk chunk = world.func_212866_a_(x >> 4, z >> 4);
            int topY = chunk.func_201576_a(Heightmap.Type.MOTION_BLOCKING, x & 0xF, z & 0xF);
            int surfaceY = chunk.func_201576_a(Heightmap.Type.WORLD_SURFACE, x & 0xF, z & 0xF);
            int floorY = chunk.func_201576_a(Heightmap.Type.OCEAN_FLOOR, x & 0xF, z & 0xF);
            if (topY == surfaceY && floorY == surfaceY) {
                cir.setReturnValue((Object)new BlockPos(x, topY + 1, z));
            } else {
                cir.setReturnValue(null);
            }
        }
    }
}

