/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.network;

import com.pg85.otg.interfaces.IBiomeConfig;
import com.pg85.otg.util.biome.ColorSet;
import com.pg85.otg.util.biome.ColorThreshold;
import com.pg85.otg.util.biome.SimpleColorSet;
import java.util.ArrayList;
import net.minecraft.network.PacketBuffer;

public class BiomeSettingSyncWrapper {
    private final float fogDensity;
    private final ColorSet grassColorControl;
    private final ColorSet foliageColorControl;
    private final ColorSet waterColorControl;

    public BiomeSettingSyncWrapper(IBiomeConfig config) {
        this.fogDensity = config.getFogDensity();
        this.grassColorControl = config.getGrassColorControl();
        this.foliageColorControl = config.getFoliageColorControl();
        this.waterColorControl = config.getWaterColorControl();
    }

    public BiomeSettingSyncWrapper(PacketBuffer buffer) {
        int size;
        this.fogDensity = buffer.readFloat();
        ArrayList<ColorThreshold> grassColors = new ArrayList<ColorThreshold>();
        for (int i = size = buffer.readByte(); i > 0; --i) {
            grassColors.add(new ColorThreshold(buffer.readInt(), buffer.readFloat()));
        }
        this.grassColorControl = new SimpleColorSet(grassColors);
        ArrayList<ColorThreshold> foliageColors = new ArrayList<ColorThreshold>();
        for (int i = size = (int)buffer.readByte(); i > 0; --i) {
            foliageColors.add(new ColorThreshold(buffer.readInt(), buffer.readFloat()));
        }
        this.foliageColorControl = new SimpleColorSet(foliageColors);
        ArrayList<ColorThreshold> waterColors = new ArrayList<ColorThreshold>();
        for (int i = size = (int)buffer.readByte(); i > 0; --i) {
            waterColors.add(new ColorThreshold(buffer.readInt(), buffer.readFloat()));
        }
        this.waterColorControl = new SimpleColorSet(waterColors);
    }

    public float getFogDensity() {
        return this.fogDensity;
    }

    public ColorSet getGrassColorControl() {
        return this.grassColorControl;
    }

    public ColorSet getFoliageColorControl() {
        return this.foliageColorControl;
    }

    public ColorSet getWaterColorControl() {
        return this.waterColorControl;
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeFloat(this.fogDensity);
        buffer.writeByte((int)((byte)this.grassColorControl.getLayers().size()));
        for (ColorThreshold color : this.grassColorControl.getLayers()) {
            buffer.writeInt(color.getColor());
            buffer.writeFloat(color.getMaxNoise());
        }
        buffer.writeByte((int)((byte)this.foliageColorControl.getLayers().size()));
        for (ColorThreshold color : this.foliageColorControl.getLayers()) {
            buffer.writeInt(color.getColor());
            buffer.writeFloat(color.getMaxNoise());
        }
        buffer.writeByte((int)((byte)this.waterColorControl.getLayers().size()));
        for (ColorThreshold color : this.waterColorControl.getLayers()) {
            buffer.writeInt(color.getColor());
            buffer.writeFloat(color.getMaxNoise());
        }
    }
}

