/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.network;

import com.pg85.otg.forge.network.AcknowledgeOTGMessage;
import com.pg85.otg.forge.network.BiomeSettingSyncWrapper;
import com.pg85.otg.forge.network.OTGClientSyncManager;
import com.pg85.otg.forge.network.OTGLoginMessage;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketSyncBiomeSettings
implements OTGLoginMessage {
    private Map<String, BiomeSettingSyncWrapper> syncMap = new HashMap<String, BiomeSettingSyncWrapper>();
    private int loginIndex;

    public PacketSyncBiomeSettings() {
        this.syncMap = OTGClientSyncManager.getSyncedData();
    }

    public PacketSyncBiomeSettings(Map<String, BiomeSettingSyncWrapper> syncMap) {
        this.syncMap = syncMap;
    }

    public static void encode(PacketSyncBiomeSettings packet, PacketBuffer buffer) {
        buffer.writeInt(packet.syncMap.size());
        for (Map.Entry<String, BiomeSettingSyncWrapper> entry : packet.syncMap.entrySet()) {
            buffer.func_180714_a(entry.getKey());
            entry.getValue().encode(buffer);
        }
    }

    public static PacketSyncBiomeSettings decode(PacketBuffer buffer) {
        int size;
        PacketSyncBiomeSettings packet = new PacketSyncBiomeSettings();
        for (int i = size = buffer.readInt(); i > 0; --i) {
            String key = buffer.func_218666_n();
            BiomeSettingSyncWrapper wrapper = new BiomeSettingSyncWrapper(buffer);
            packet.syncMap.putIfAbsent(key, wrapper);
        }
        return packet;
    }

    public static PacketSyncBiomeSettings decodeSpigot(PacketBuffer buffer) {
        PacketSyncBiomeSettings packet = new PacketSyncBiomeSettings();
        int size = buffer.readInt();
        String preset = buffer.func_218666_n();
        for (int i = size; i > 0; --i) {
            String biomeName = buffer.func_218666_n();
            String key = "otg:" + preset + "." + biomeName;
            BiomeSettingSyncWrapper wrapper = new BiomeSettingSyncWrapper(buffer);
            packet.syncMap.putIfAbsent(key, wrapper);
        }
        return packet;
    }

    public static void handleLogin(PacketSyncBiomeSettings packet, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> OTGClientSyncManager.getSyncedData().putAll(packet.syncMap));
        OTGClientSyncManager.LOGIN.reply((Object)new AcknowledgeOTGMessage(), context.get());
        context.get().setPacketHandled(true);
        context.get().enqueueWork(() -> Minecraft.func_71410_x().field_71438_f.func_72712_a());
    }

    @Override
    public int getLoginIndex() {
        return this.loginIndex;
    }

    @Override
    public void setLoginIndex(int loginIndex) {
        this.loginIndex = loginIndex;
    }
}

