/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.presets;

import com.mojang.serialization.Lifecycle;
import com.pg85.otg.OTG;
import com.pg85.otg.config.biome.BiomeConfigFinder;
import com.pg85.otg.config.biome.BiomeGroup;
import com.pg85.otg.config.biome.TemplateBiome;
import com.pg85.otg.config.io.IConfigFunctionProvider;
import com.pg85.otg.config.world.WorldConfig;
import com.pg85.otg.constants.SettingsEnums;
import com.pg85.otg.forge.biome.ForgeBiome;
import com.pg85.otg.forge.materials.ForgeMaterialReader;
import com.pg85.otg.forge.network.BiomeSettingSyncWrapper;
import com.pg85.otg.forge.network.OTGClientSyncManager;
import com.pg85.otg.gen.biome.BiomeData;
import com.pg85.otg.gen.biome.layers.BiomeLayerData;
import com.pg85.otg.gen.biome.layers.NewBiomeGroup;
import com.pg85.otg.interfaces.IBiome;
import com.pg85.otg.interfaces.IBiomeConfig;
import com.pg85.otg.interfaces.IBiomeResourceLocation;
import com.pg85.otg.interfaces.ILogger;
import com.pg85.otg.interfaces.IMaterialReader;
import com.pg85.otg.interfaces.IWorldConfig;
import com.pg85.otg.presets.LocalPresetLoader;
import com.pg85.otg.presets.Preset;
import com.pg85.otg.util.biome.MCBiomeResourceLocation;
import com.pg85.otg.util.biome.OTGBiomeResourceLocation;
import com.pg85.otg.util.biome.WeightedMobSpawnGroup;
import com.pg85.otg.util.logging.LogCategory;
import com.pg85.otg.util.logging.LogLevel;
import com.pg85.otg.util.minecraft.EntityCategory;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.entity.EntityClassification;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ResourceLocationException;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ForgePresetLoader
extends LocalPresetLoader {
    private Map<String, List<RegistryKey<Biome>>> biomesByPresetFolderName = new LinkedHashMap<String, List<RegistryKey<Biome>>>();
    private HashMap<String, IBiome[]> globalIdMapping = new HashMap();
    private Map<String, BiomeLayerData> presetGenerationData = new HashMap<String, BiomeLayerData>();

    public ForgePresetLoader(Path otgRootFolder) {
        super(otgRootFolder);
    }

    @Override
    public IMaterialReader createMaterialReader() {
        return new ForgeMaterialReader();
    }

    public List<RegistryKey<Biome>> getBiomeRegistryKeys(String presetFolderName) {
        return this.biomesByPresetFolderName.get(presetFolderName);
    }

    public IBiome[] getGlobalIdMapping(String presetFolderName) {
        return this.globalIdMapping.get(presetFolderName);
    }

    public Map<String, BiomeLayerData> getPresetGenerationData() {
        HashMap<String, BiomeLayerData> clonedData = new HashMap<String, BiomeLayerData>();
        for (Map.Entry<String, BiomeLayerData> entry : this.presetGenerationData.entrySet()) {
            clonedData.put(entry.getKey(), new BiomeLayerData(entry.getValue()));
        }
        return clonedData;
    }

    public void reloadPresetFromDisk(String presetFolderName, IConfigFunctionProvider biomeResourcesManager, ILogger logger, MutableRegistry<Biome> biomeRegistry) {
        this.clearCaches();
        if (this.presetsDir.exists() && this.presetsDir.isDirectory()) {
            block0: for (File presetDir : this.presetsDir.listFiles()) {
                if (!presetDir.isDirectory() || !presetDir.getName().equals(presetFolderName)) continue;
                for (File file : presetDir.listFiles()) {
                    if (!file.getName().equals("WorldConfig.ini")) continue;
                    Preset preset = this.loadPreset(presetDir.toPath(), biomeResourcesManager, logger);
                    Preset existingPreset = (Preset)this.presets.get(preset.getFolderName());
                    existingPreset.update(preset);
                    continue block0;
                }
            }
        }
        this.registerBiomes(true, biomeRegistry);
    }

    protected void clearCaches() {
        this.globalIdMapping = new HashMap();
        this.presetGenerationData = new HashMap<String, BiomeLayerData>();
        this.biomesByPresetFolderName = new LinkedHashMap<String, List<RegistryKey<Biome>>>();
        this.materialReaderByPresetFolderName = new HashMap();
    }

    public void reRegisterBiomes(String presetFolderName, MutableRegistry<Biome> biomeRegistry) {
        this.globalIdMapping.remove(presetFolderName);
        this.presetGenerationData.remove(presetFolderName);
        this.biomesByPresetFolderName.remove(presetFolderName);
        this.registerBiomes(true, biomeRegistry);
    }

    @Override
    public void registerBiomes() {
        this.registerBiomes(false, null);
    }

    private void registerBiomes(boolean refresh, MutableRegistry<Biome> biomeRegistry) {
        for (Preset preset : this.presets.values()) {
            this.registerBiomesForPreset(refresh, preset, biomeRegistry);
        }
    }

    private void registerBiomesForPreset(boolean refresh, Preset preset, MutableRegistry<Biome> biomeRegistry) {
        HashMap<Integer, Integer> biomeColorMap = new HashMap<Integer, Integer>();
        int currentId = 1;
        ArrayList<RegistryKey> presetBiomes = new ArrayList<RegistryKey>();
        this.biomesByPresetFolderName.put(preset.getFolderName(), presetBiomes);
        IWorldConfig worldConfig = preset.getWorldConfig();
        IBiomeConfig oceanBiomeConfig = null;
        int[] oceanTemperatures = new int[]{0, 0, 0, 0};
        ArrayList<IBiomeConfig> biomeConfigs = preset.getAllBiomeConfigs();
        HashMap<Integer, List<BiomeData>> isleBiomesAtDepth = new HashMap<Integer, List<BiomeData>>();
        HashMap<Integer, List<BiomeData>> borderBiomesAtDepth = new HashMap<Integer, List<BiomeData>>();
        HashMap<String, List<Integer>> worldBiomes = new HashMap<String, List<Integer>>();
        HashMap<String, IBiomeConfig> biomeConfigsByName = new HashMap<String, IBiomeConfig>();
        LinkedHashMap<IBiomeResourceLocation, IBiomeConfig> biomeConfigsByResourceLocation = new LinkedHashMap<IBiomeResourceLocation, IBiomeConfig>();
        List<String> blackListedBiomes = worldConfig.getBlackListedBiomes();
        this.processTemplateBiomes(preset.getFolderName(), worldConfig, biomeConfigs, biomeConfigsByResourceLocation, biomeConfigsByName, blackListedBiomes);
        for (IBiomeConfig iBiomeConfig : biomeConfigs) {
            if (iBiomeConfig.getIsTemplateForBiome()) continue;
            OTGBiomeResourceLocation oTGBiomeResourceLocation = new OTGBiomeResourceLocation(preset.getPresetFolder(), preset.getShortPresetName(), preset.getMajorVersion(), iBiomeConfig.getName());
            biomeConfigsByResourceLocation.put(oTGBiomeResourceLocation, iBiomeConfig);
            biomeConfigsByName.put(iBiomeConfig.getName(), iBiomeConfig);
        }
        IBiome[] presetIdMapping = new IBiome[biomeConfigsByResourceLocation.entrySet().size()];
        for (Map.Entry entry : biomeConfigsByResourceLocation.entrySet()) {
            List biomesAtDepth;
            RegistryKey registryKey;
            Optional key;
            Biome biome;
            boolean isOceanBiome = false;
            if (((IBiomeConfig)entry.getValue()).getName().equals(worldConfig.getDefaultOceanBiome())) {
                oceanBiomeConfig = (IBiomeConfig)entry.getValue();
                isOceanBiome = true;
            }
            int otgBiomeId = isOceanBiome ? 0 : currentId;
            ResourceLocation resourceLocation = new ResourceLocation(((IBiomeResourceLocation)entry.getKey()).toResourceLocationString());
            if (((IBiomeConfig)entry.getValue()).getIsTemplateForBiome()) {
                if (refresh) {
                    biome = (Biome)biomeRegistry.func_82594_a(resourceLocation);
                    key = biomeRegistry.func_230519_c_((Object)biome);
                    registryKey = key.isPresent() ? (RegistryKey)key.get() : null;
                } else {
                    biome = (Biome)ForgeRegistries.BIOMES.getValue(resourceLocation);
                    registryKey = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)resourceLocation);
                }
            } else {
                if (!(entry.getKey() instanceof OTGBiomeResourceLocation)) {
                    if (!OTG.getEngine().getLogger().getLogCategoryEnabled(LogCategory.BIOME_REGISTRY)) continue;
                    OTG.getEngine().getLogger().log(LogLevel.ERROR, LogCategory.BIOME_REGISTRY, "Could not process template biomeconfig " + ((IBiomeConfig)entry.getValue()).getName() + ", did you set TemplateForBiome:true in the BiomeConfig?");
                    continue;
                }
                if (OTG.getEngine().getPluginConfig().getDeveloperModeEnabled()) {
                    registryKey = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)resourceLocation);
                    if (registryKey != null) {
                        ((IBiomeConfig)entry.getValue()).getBiomeDictTags().forEach(biomeDictId -> {
                            if (biomeDictId != null && biomeDictId.trim().length() > 0) {
                                BiomeDictionary.addTypes((RegistryKey)registryKey, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.getType((String)biomeDictId.trim(), (BiomeDictionary.Type[])new BiomeDictionary.Type[0])});
                            }
                        });
                        biome = ForgeBiome.createOTGBiome(isOceanBiome, preset.getWorldConfig(), (IBiomeConfig)entry.getValue());
                        if (refresh) {
                            biomeRegistry.func_241874_a(OptionalInt.empty(), registryKey, (Object)biome, Lifecycle.stable());
                        } else {
                            ForgeRegistries.BIOMES.register((IForgeRegistryEntry)biome);
                        }
                    } else {
                        biome = null;
                    }
                } else if (refresh) {
                    biome = (Biome)biomeRegistry.func_82594_a(resourceLocation);
                    key = biomeRegistry.func_230519_c_((Object)biome);
                    registryKey = key.isPresent() ? (RegistryKey)key.get() : null;
                } else {
                    registryKey = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)resourceLocation);
                    if (registryKey != null) {
                        ((IBiomeConfig)entry.getValue()).getBiomeDictTags().forEach(biomeDictId -> {
                            if (biomeDictId != null && biomeDictId.trim().length() > 0) {
                                BiomeDictionary.addTypes((RegistryKey)registryKey, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.getType((String)biomeDictId.trim(), (BiomeDictionary.Type[])new BiomeDictionary.Type[0])});
                            }
                        });
                        biome = ForgeBiome.createOTGBiome(isOceanBiome, preset.getWorldConfig(), (IBiomeConfig)entry.getValue());
                        ForgeRegistries.BIOMES.register((IForgeRegistryEntry)biome);
                    } else {
                        biome = null;
                    }
                }
            }
            if (biome == null || registryKey == null) {
                if (!OTG.getEngine().getLogger().getLogCategoryEnabled(LogCategory.BIOME_REGISTRY)) continue;
                OTG.getEngine().getLogger().log(LogLevel.ERROR, LogCategory.BIOME_REGISTRY, "Could not find biome " + resourceLocation.toString() + " for biomeconfig " + ((IBiomeConfig)entry.getValue()).getName());
                continue;
            }
            presetBiomes.add(registryKey);
            ((IBiomeConfig)entry.getValue()).setRegistryKey((IBiomeResourceLocation)entry.getKey());
            ((IBiomeConfig)entry.getValue()).setOTGBiomeId(otgBiomeId);
            OTGClientSyncManager.getSyncedData().put(resourceLocation.toString(), new BiomeSettingSyncWrapper((IBiomeConfig)entry.getValue()));
            if (((IBiomeConfig)entry.getValue()).getName().equals(worldConfig.getDefaultWarmOceanBiome())) {
                oceanTemperatures[0] = otgBiomeId;
            }
            if (((IBiomeConfig)entry.getValue()).getName().equals(worldConfig.getDefaultLukewarmOceanBiome())) {
                oceanTemperatures[1] = otgBiomeId;
            }
            if (((IBiomeConfig)entry.getValue()).getName().equals(worldConfig.getDefaultColdOceanBiome())) {
                oceanTemperatures[2] = otgBiomeId;
            }
            if (((IBiomeConfig)entry.getValue()).getName().equals(worldConfig.getDefaultFrozenOceanBiome())) {
                oceanTemperatures[3] = otgBiomeId;
            }
            ForgeBiome otgBiome = new ForgeBiome(biome, (IBiomeConfig)entry.getValue());
            if (otgBiomeId >= presetIdMapping.length) {
                OTG.getEngine().getLogger().log(LogLevel.FATAL, LogCategory.CONFIGS, "Fatal error while registering OTG biome id's for preset " + preset.getFolderName() + ", most likely you've assigned a DefaultOceanBiome that doesn't exist.");
                throw new RuntimeException("Fatal error while registering OTG biome id's for preset " + preset.getFolderName() + ", most likely you've assigned a DefaultOceanBiome that doesn't exist.");
            }
            presetIdMapping[otgBiomeId] = otgBiome;
            ArrayList<Integer> idsForBiome = (ArrayList<Integer>)worldBiomes.get(((IBiomeConfig)entry.getValue()).getName());
            if (idsForBiome == null) {
                idsForBiome = new ArrayList<Integer>();
                worldBiomes.put(((IBiomeConfig)entry.getValue()).getName(), idsForBiome);
            }
            idsForBiome.add(otgBiomeId);
            if (((IBiomeConfig)entry.getValue()).isIsleBiome()) {
                biomesAtDepth = isleBiomesAtDepth.getOrDefault(worldConfig.getBiomeMode() == SettingsEnums.BiomeMode.NoGroups ? ((IBiomeConfig)entry.getValue()).getBiomeSize() : ((IBiomeConfig)entry.getValue()).getBiomeSizeWhenIsle(), new ArrayList());
                biomesAtDepth.add(new BiomeData(otgBiomeId, worldConfig.getBiomeMode() == SettingsEnums.BiomeMode.NoGroups ? ((IBiomeConfig)entry.getValue()).getBiomeRarity() : ((IBiomeConfig)entry.getValue()).getBiomeRarityWhenIsle(), worldConfig.getBiomeMode() == SettingsEnums.BiomeMode.NoGroups ? ((IBiomeConfig)entry.getValue()).getBiomeSize() : ((IBiomeConfig)entry.getValue()).getBiomeSizeWhenIsle(), ((IBiomeConfig)entry.getValue()).getBiomeTemperature(), ((IBiomeConfig)entry.getValue()).getIsleInBiomes(), ((IBiomeConfig)entry.getValue()).getBorderInBiomes(), ((IBiomeConfig)entry.getValue()).getOnlyBorderNearBiomes(), ((IBiomeConfig)entry.getValue()).getNotBorderNearBiomes()));
                isleBiomesAtDepth.put(worldConfig.getBiomeMode() == SettingsEnums.BiomeMode.NoGroups ? ((IBiomeConfig)entry.getValue()).getBiomeSize() : ((IBiomeConfig)entry.getValue()).getBiomeSizeWhenIsle(), biomesAtDepth);
            }
            if (((IBiomeConfig)entry.getValue()).isBorderBiome()) {
                biomesAtDepth = borderBiomesAtDepth.getOrDefault(worldConfig.getBiomeMode() == SettingsEnums.BiomeMode.NoGroups ? ((IBiomeConfig)entry.getValue()).getBiomeSize() : ((IBiomeConfig)entry.getValue()).getBiomeSizeWhenBorder(), new ArrayList());
                biomesAtDepth.add(new BiomeData(otgBiomeId, ((IBiomeConfig)entry.getValue()).getBiomeRarity(), worldConfig.getBiomeMode() == SettingsEnums.BiomeMode.NoGroups ? ((IBiomeConfig)entry.getValue()).getBiomeSize() : ((IBiomeConfig)entry.getValue()).getBiomeSizeWhenBorder(), ((IBiomeConfig)entry.getValue()).getBiomeTemperature(), ((IBiomeConfig)entry.getValue()).getIsleInBiomes(), ((IBiomeConfig)entry.getValue()).getBorderInBiomes(), ((IBiomeConfig)entry.getValue()).getOnlyBorderNearBiomes(), ((IBiomeConfig)entry.getValue()).getNotBorderNearBiomes()));
                borderBiomesAtDepth.put(worldConfig.getBiomeMode() == SettingsEnums.BiomeMode.NoGroups ? ((IBiomeConfig)entry.getValue()).getBiomeSize() : ((IBiomeConfig)entry.getValue()).getBiomeSizeWhenBorder(), biomesAtDepth);
            }
            biomeColorMap.put(((IBiomeConfig)entry.getValue()).getBiomeColor(), otgBiomeId);
            if (OTG.getEngine().getLogger().getLogCategoryEnabled(LogCategory.BIOME_REGISTRY)) {
                OTG.getEngine().getLogger().log(LogLevel.INFO, LogCategory.BIOME_REGISTRY, "Registered biome " + resourceLocation.toString() + " | " + ((IBiomeConfig)entry.getValue()).getName() + " with OTG id " + otgBiomeId);
            }
            currentId += isOceanBiome ? 0 : 1;
        }
        if (oceanBiomeConfig == null) {
            System.arraycopy(presetIdMapping, 1, presetIdMapping, 0, presetIdMapping.length - 1);
        }
        this.globalIdMapping.put(preset.getFolderName(), presetIdMapping);
        BiomeLayerData biomeLayerData = new BiomeLayerData(preset.getPresetFolder(), worldConfig, oceanBiomeConfig, oceanTemperatures);
        HashSet<Integer> hashSet = new HashSet<Integer>();
        HashMap<Integer, List<NewBiomeGroup>> groupDepths = new HashMap<Integer, List<NewBiomeGroup>>();
        this.processBiomeGroups(preset.getFolderName(), worldConfig, biomeConfigsByResourceLocation, biomeConfigsByName, blackListedBiomes, hashSet, groupDepths, biomeLayerData);
        biomeLayerData.init(hashSet, groupDepths, isleBiomesAtDepth, borderBiomesAtDepth, worldBiomes, biomeColorMap, presetIdMapping);
        this.presetGenerationData.put(preset.getFolderName(), biomeLayerData);
    }

    private void processTemplateBiomes(String presetFolderName, IWorldConfig worldConfig, List<IBiomeConfig> biomeConfigs, Map<IBiomeResourceLocation, IBiomeConfig> biomeConfigsByResourceLocation, Map<String, IBiomeConfig> biomeConfigsByName, List<String> blackListedBiomes) {
        for (TemplateBiome templateBiome : ((WorldConfig)worldConfig).getTemplateBiomes()) {
            String[] tagSubStrings;
            String tagString2;
            if (OTG.getEngine().getLogger().getLogCategoryEnabled(LogCategory.BIOME_REGISTRY)) {
                OTG.getEngine().getLogger().log(LogLevel.INFO, LogCategory.BIOME_REGISTRY, "Processing " + templateBiome.toString());
            }
            List<String> templateBiomeTagStrings = templateBiome.getTags();
            IBiomeConfig biomeConfig = biomeConfigs.stream().filter(a -> a.getName().toLowerCase().trim().equals(templateBiome.getName().toLowerCase().trim())).findFirst().orElse(null);
            if (biomeConfig == null) continue;
            ArrayList<String> allowedMods = new ArrayList<String>();
            ArrayList<Biome> excludedBiomes = new ArrayList<Biome>();
            ArrayList<Biome.Category> excludedCategories = new ArrayList<Biome.Category>();
            ArrayList<BiomeDictionary.Type> excludedTags = new ArrayList<BiomeDictionary.Type>();
            ArrayList<String> excludedMods = new ArrayList<String>();
            ArrayList<String> tagStrings = new ArrayList<String>();
            for (String tagString : templateBiomeTagStrings) {
                tagString2 = tagString.trim().toLowerCase();
                tagSubStrings = tagString2.split(" ");
                if (tagSubStrings.length == 1) {
                    ResourceLocation resourceLocation;
                    if (!tagString2.startsWith("-")) {
                        if (!(tagString2.startsWith("mod.") || tagString2.startsWith("category.") || tagString2.startsWith("modcategory.") || tagString2.startsWith("mccategory.") || tagString2.startsWith("tag.") || tagString2.startsWith("modtag.") || tagString2.startsWith("mctag.") || tagString2.startsWith("-mod.") || tagString2.startsWith("-category.") || tagString2.startsWith("-modcategory.") || tagString2.startsWith("-mccategory.") || tagString2.startsWith("-tag.") || tagString2.startsWith("-modtag.") || tagString2.startsWith("-mctag."))) {
                            resourceLocation = new ResourceLocation(tagString2.replace("minecraft:", "").replace(" ", "_"));
                            Biome biome2 = (Biome)ForgeRegistries.BIOMES.getValue(resourceLocation);
                            if (biome2 != null) {
                                MCBiomeResourceLocation otgLocation = new MCBiomeResourceLocation(biome2.getRegistryName().func_110624_b(), biome2.getRegistryName().func_110623_a(), presetFolderName);
                                if (biomeConfigsByResourceLocation.containsKey(otgLocation)) continue;
                                if (OTG.getEngine().getLogger().getLogCategoryEnabled(LogCategory.BIOME_REGISTRY)) {
                                    OTG.getEngine().getLogger().log(LogLevel.INFO, LogCategory.BIOME_REGISTRY, "Biome " + biome2.getRegistryName().toString() + " found for " + templateBiome.toString() + " with entry " + tagString);
                                }
                                biomeConfigsByResourceLocation.put(otgLocation, biomeConfig.createTemplateBiome());
                                biomeConfigsByName.put(biomeConfig.getName(), biomeConfig);
                                continue;
                            }
                            if (!OTG.getEngine().getLogger().getLogCategoryEnabled(LogCategory.BIOME_REGISTRY)) continue;
                            OTG.getEngine().getLogger().log(LogLevel.WARN, LogCategory.BIOME_REGISTRY, "No biome found for TemplateBiome() " + templateBiome.toString() + " with entry " + tagString);
                            continue;
                        }
                        if (tagString2.startsWith("mod.")) {
                            allowedMods.add(tagString2.replace("mod.", ""));
                            continue;
                        }
                        tagStrings.add(tagString);
                        continue;
                    }
                    if (tagString2.startsWith("-category.") || tagString2.startsWith("-modcategory.") || tagString2.startsWith("-mccategory.") || tagString2.startsWith("-tag.") || tagString2.startsWith("-modtag.") || tagString2.startsWith("-mctag.")) {
                        resourceLocation = new ResourceLocation(tagString2.replace("minecraft:", "").replace(" ", "_").substring(1));
                        Biome biome2 = (Biome)ForgeRegistries.BIOMES.getValue(resourceLocation);
                        if (biome2 == null) continue;
                        excludedBiomes.add(biome2);
                        if (!OTG.getEngine().getLogger().getLogCategoryEnabled(LogCategory.BIOME_REGISTRY)) continue;
                        OTG.getEngine().getLogger().log(LogLevel.INFO, LogCategory.BIOME_REGISTRY, "Biome " + biome2.getRegistryName().toString() + " excluded for " + templateBiome.toString());
                        continue;
                    }
                    if (tagString2.toLowerCase().startsWith("-category.") || tagString2.toLowerCase().startsWith("-modcategory.") || tagString2.toLowerCase().startsWith("-mccategory.")) {
                        Biome.Category category = Biome.Category.func_235103_a_((String)tagString2.toLowerCase().replace("-modcategory.", "").replace("-mccategory.", "").replace("-category.", ""));
                        if (category != null) {
                            excludedCategories.add(category);
                            continue;
                        }
                        if (!OTG.getEngine().getLogger().getLogCategoryEnabled(LogCategory.BIOME_REGISTRY)) continue;
                        OTG.getEngine().getLogger().log(LogLevel.WARN, LogCategory.BIOME_REGISTRY, "Biome category " + tagString + " for " + templateBiome.toString() + " could not be found.");
                        continue;
                    }
                    if (tagString2.startsWith("-tag.") || tagString2.startsWith("-modtag.") || tagString2.startsWith("-mctag.")) {
                        BiomeDictionary.Type tag = BiomeDictionary.Type.getType((String)tagString2.replace("-modtag.", "").replace("-mctag.", "").replace("-tag.", ""), (BiomeDictionary.Type[])new BiomeDictionary.Type[0]);
                        if (tag != null) {
                            excludedTags.add(tag);
                            continue;
                        }
                        if (!OTG.getEngine().getLogger().getLogCategoryEnabled(LogCategory.CONFIGS)) continue;
                        OTG.getEngine().getLogger().log(LogLevel.ERROR, LogCategory.CONFIGS, "Biome tag " + tagString + " for " + templateBiome.toString() + " could not be found.");
                        continue;
                    }
                    if (!tagString2.startsWith("-mod.")) continue;
                    excludedMods.add(tagString2.replace("-mod.", ""));
                    continue;
                }
                tagStrings.add(tagString);
            }
            for (String tagString : tagStrings) {
                tagString2 = tagString.trim().toLowerCase();
                tagSubStrings = tagString.split(" ");
                if (tagString2.startsWith("mod.") || tagString2.startsWith("category.") || tagString2.startsWith("modcategory.") || tagString2.startsWith("mccategory.") || tagString2.startsWith("tag.") || tagString2.startsWith("modtag.") || tagString2.startsWith("mctag.") || tagString2.startsWith("-mod.") || tagString2.startsWith("-category.") || tagString2.startsWith("-modcategory.") || tagString2.startsWith("-mccategory.") || tagString2.startsWith("-tag.") || tagString2.startsWith("-modtag.") || tagString2.startsWith("-mctag.")) {
                    Set<Object> biomesForTags = new HashSet();
                    ArrayList<Biome.Category> innerExcludedCategories = new ArrayList<Biome.Category>();
                    ArrayList<BiomeDictionary.Type> innerExcludedTags = new ArrayList<BiomeDictionary.Type>();
                    ArrayList<String> innerExcludedMods = new ArrayList<String>();
                    for (String string : tagSubStrings) {
                        Biome.Category category;
                        String tagSubString22 = string.trim().toLowerCase().toLowerCase();
                        if (tagSubString22.startsWith("-category.") || tagSubString22.startsWith("-modcategory.") || tagSubString22.startsWith("-mccategory.")) {
                            category = Biome.Category.func_235103_a_((String)tagSubString22.replace("-modcategory.", "").replace("-mccategory.", "").replace("-category.", ""));
                            if (category != null) {
                                innerExcludedCategories.add(category);
                                biomesForTags.stream().filter(a -> ForgeRegistries.BIOMES.getValue(a.func_240901_a_()) != null && ((Biome)ForgeRegistries.BIOMES.getValue(a.func_240901_a_())).func_201856_r() != category).collect(Collectors.toList());
                                continue;
                            }
                            if (!OTG.getEngine().getLogger().getLogCategoryEnabled(LogCategory.BIOME_REGISTRY)) continue;
                            OTG.getEngine().getLogger().log(LogLevel.WARN, LogCategory.BIOME_REGISTRY, "Biome category " + string + " for " + templateBiome.toString() + " could not be found.");
                            continue;
                        }
                        if (!tagSubString22.startsWith("category.") && !tagSubString22.startsWith("modcategory.") && !tagSubString22.startsWith("mccategory.")) continue;
                        category = Biome.Category.func_235103_a_((String)tagSubString22.replace("modcategory.", "").replace("mccategory.", "").replace("category.", ""));
                        if (category != null) {
                            biomesForTags.addAll(ForgeRegistries.BIOMES.getValues().stream().filter(biome -> !(biome.func_201856_r() != category || excludedBiomes.contains(biome) || excludedCategories.contains(biome.func_201856_r()) || innerExcludedCategories.contains(biome.func_201856_r()) || !excludedTags.stream().allMatch(type -> !BiomeDictionary.hasType((RegistryKey)RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)biome.getRegistryName()), (BiomeDictionary.Type)type)) || blackListedBiomes.contains(biome.getRegistryName().toString()) || biome.getRegistryName().func_110624_b().equals("otg") || allowedMods.size() != 0 && !allowedMods.stream().anyMatch(mod -> biome.getRegistryName().func_110624_b().equals(mod)) || excludedMods.size() != 0 && excludedMods.stream().anyMatch(mod -> biome.getRegistryName().func_110624_b().equals(mod)))).map(b -> RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)b.getRegistryName())).collect(Collectors.toList()));
                            continue;
                        }
                        if (!OTG.getEngine().getLogger().getLogCategoryEnabled(LogCategory.BIOME_REGISTRY)) continue;
                        OTG.getEngine().getLogger().log(LogLevel.WARN, LogCategory.BIOME_REGISTRY, "Biome category " + string + " could not be found for " + templateBiome.toString() + " .");
                    }
                    ArrayList<BiomeDictionary.Type> tags = new ArrayList<BiomeDictionary.Type>();
                    ArrayList<String> tagsStrings = new ArrayList<String>();
                    for (String tagSubString3 : tagSubStrings) {
                        BiomeDictionary.Type tag;
                        String tagSubString2 = tagSubString3.trim().toLowerCase().toLowerCase();
                        if (tagSubString2.startsWith("-tag.") || tagSubString2.startsWith("-modtag.") || tagSubString2.startsWith("-mctag.")) {
                            tag = BiomeDictionary.Type.getType((String)tagSubString2.replace("-modtag.", "").replace("-mctag.", "").replace("-tag.", ""), (BiomeDictionary.Type[])new BiomeDictionary.Type[0]);
                            if (tag != null) {
                                innerExcludedTags.add(tag);
                                biomesForTags = biomesForTags.stream().filter(key -> !BiomeDictionary.hasType((RegistryKey)key, (BiomeDictionary.Type)tag)).collect(Collectors.toSet());
                                continue;
                            }
                            if (!OTG.getEngine().getLogger().getLogCategoryEnabled(LogCategory.CONFIGS)) continue;
                            OTG.getEngine().getLogger().log(LogLevel.WARN, LogCategory.BIOME_REGISTRY, "Biome tag " + tagSubString3 + " could not be found for " + templateBiome.toString() + " .");
                            continue;
                        }
                        if (!tagSubString2.startsWith("tag.") && !tagSubString2.startsWith("modtag.") && !tagSubString2.startsWith("mctag.")) continue;
                        tag = BiomeDictionary.Type.getType((String)tagSubString2.replace("modtag.", "").replace("mctag.", "").replace("tag.", ""), (BiomeDictionary.Type[])new BiomeDictionary.Type[0]);
                        if (tag != null) {
                            tags.add(tag);
                            tagsStrings.add(tagSubString2);
                            continue;
                        }
                        if (!OTG.getEngine().getLogger().getLogCategoryEnabled(LogCategory.CONFIGS)) continue;
                        OTG.getEngine().getLogger().log(LogLevel.WARN, LogCategory.BIOME_REGISTRY, "Biome tag " + tagSubString3 + " could not be found for " + templateBiome.toString() + " .");
                    }
                    ArrayList<String> innerMods = new ArrayList<String>();
                    for (String tagSubString4 : tagSubStrings) {
                        String tagSubString2 = tagSubString4.trim().toLowerCase();
                        if (tagSubString2.startsWith("-mod.")) {
                            innerExcludedMods.add(tagSubString2.replace("-mod.", ""));
                            biomesForTags = biomesForTags.stream().filter(key -> !key.func_240901_a_().func_110624_b().equals(tagSubString2.replace("-mod.", ""))).collect(Collectors.toSet());
                            continue;
                        }
                        if (!tagSubString2.startsWith("mod.")) continue;
                        innerMods.add(tagSubString2.replace("mod.", ""));
                    }
                    if (innerMods.size() > 0) {
                        biomesForTags = biomesForTags.stream().filter(key -> innerMods.stream().anyMatch(a -> a.equals(key.func_240901_a_().func_110624_b()))).collect(Collectors.toSet());
                    }
                    if (tags.size() > 0) {
                        String string = (String)tagsStrings.get(0);
                        biomesForTags.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)((BiomeDictionary.Type)tags.get(0))).stream().filter(key -> !(!tags.stream().allMatch(tag -> BiomeDictionary.hasType((RegistryKey)key, (BiomeDictionary.Type)tag)) || ForgeRegistries.BIOMES.getValue(key.func_240901_a_()) == null || excludedBiomes.contains(ForgeRegistries.BIOMES.getValue(key.func_240901_a_())) || excludedCategories.contains(((Biome)ForgeRegistries.BIOMES.getValue(key.func_240901_a_())).func_201856_r()) || innerExcludedCategories.contains(((Biome)ForgeRegistries.BIOMES.getValue(key.func_240901_a_())).func_201856_r()) || !excludedTags.stream().allMatch(type -> !BiomeDictionary.hasType((RegistryKey)RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)key.func_240901_a_()), (BiomeDictionary.Type)type)) || !innerExcludedTags.stream().allMatch(type -> !BiomeDictionary.hasType((RegistryKey)RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)key.func_240901_a_()), (BiomeDictionary.Type)type)) || blackListedBiomes.contains(key.func_240901_a_().toString()) || key.func_240901_a_().func_110624_b().equals("otg") || allowedMods.size() != 0 && !allowedMods.stream().anyMatch(mod -> key.func_240901_a_().func_110624_b().equals(mod)) || excludedMods.size() != 0 && excludedMods.stream().anyMatch(mod -> key.func_240901_a_().func_110624_b().equals(mod)) || innerMods.size() != 0 && !innerMods.stream().anyMatch(mod -> key.func_240901_a_().func_110624_b().equals(mod)) || innerExcludedMods.size() != 0 && innerExcludedMods.stream().anyMatch(mod -> key.func_240901_a_().func_110624_b().equals(mod)) || !tagType.startsWith("tag.") && (!tagType.startsWith("modtag.") || key.func_240901_a_().func_110624_b().equals("minecraft")) && (!tagType.startsWith("mctag.") || !key.func_240901_a_().func_110624_b().equals("minecraft")))).collect(Collectors.toList()));
                    }
                    if (biomesForTags.size() > 0) {
                        for (RegistryKey biomeForTag : biomesForTags) {
                            MCBiomeResourceLocation otgLocation;
                            Biome biome3 = (Biome)ForgeRegistries.BIOMES.getValue(biomeForTag.func_240901_a_());
                            if (biome3 == null || !templateBiome.temperatureAllowed(biome3.func_242445_k()) || biomeConfigsByResourceLocation.containsKey(otgLocation = new MCBiomeResourceLocation(biomeForTag.func_240901_a_().func_110624_b(), biomeForTag.func_240901_a_().func_110623_a(), presetFolderName))) continue;
                            if (OTG.getEngine().getLogger().getLogCategoryEnabled(LogCategory.BIOME_REGISTRY)) {
                                OTG.getEngine().getLogger().log(LogLevel.INFO, LogCategory.BIOME_REGISTRY, "Biome " + biomeForTag.func_240901_a_().toString() + " found for " + templateBiome.toString() + " with temperature: " + biome3.func_242445_k() + " Category: " + biome3.func_201856_r() + " Tags: " + String.join((CharSequence)",", BiomeDictionary.getTypes((RegistryKey)RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)biome3.getRegistryName())).stream().map(a -> a.getName()).collect(Collectors.toList())));
                            }
                            biomeConfigsByResourceLocation.put(otgLocation, biomeConfig.createTemplateBiome());
                            biomeConfigsByName.put(biomeConfig.getName(), biomeConfig);
                        }
                        continue;
                    }
                    if (!OTG.getEngine().getLogger().getLogCategoryEnabled(LogCategory.BIOME_REGISTRY)) continue;
                    OTG.getEngine().getLogger().log(LogLevel.WARN, LogCategory.BIOME_REGISTRY, "No tags or categories found for " + templateBiome.toString());
                    continue;
                }
                if (!OTG.getEngine().getLogger().getLogCategoryEnabled(LogCategory.BIOME_REGISTRY)) continue;
                OTG.getEngine().getLogger().log(LogLevel.WARN, LogCategory.BIOME_REGISTRY, "No tags or categories found for " + templateBiome.toString());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void processBiomeGroups(String presetFolderName, IWorldConfig worldConfig, Map<IBiomeResourceLocation, IBiomeConfig> biomeConfigsByResourceLocation, Map<String, IBiomeConfig> biomeConfigsByName, List<String> blackListedBiomes, Set<Integer> biomeDepths, Map<Integer, List<NewBiomeGroup>> groupDepths, BiomeLayerData data) {
        int genDepth = worldConfig.getGenerationDepth();
        for (BiomeGroup group : ((WorldConfig)worldConfig).getBiomeGroupManager().getGroups()) {
            String[] tagSubStrings;
            String tagString2;
            if (OTG.getEngine().getLogger().getLogCategoryEnabled(LogCategory.BIOME_REGISTRY)) {
                OTG.getEngine().getLogger().log(LogLevel.INFO, LogCategory.BIOME_REGISTRY, "Processing " + group.toString());
            }
            NewBiomeGroup bg = new NewBiomeGroup();
            bg.id = group.getGroupId();
            bg.rarity = group.getGroupRarity();
            bg.totalDepthRarity = new int[genDepth + 1];
            bg.maxRarityPerDepth = new int[genDepth + 1];
            float totalTemp = 0.0f;
            LinkedHashMap<String, IBiomeConfig> groupBiomes = new LinkedHashMap<String, IBiomeConfig>();
            List<String> templateBiomeTagStrings = group.getBiomes();
            ArrayList<String> allowedMods = new ArrayList<String>();
            ArrayList<Biome> excludedBiomes = new ArrayList<Biome>();
            ArrayList<Biome.Category> excludedCategories = new ArrayList<Biome.Category>();
            ArrayList<BiomeDictionary.Type> excludedTags = new ArrayList<BiomeDictionary.Type>();
            ArrayList<String> excludedMods = new ArrayList<String>();
            ArrayList<String> tagStrings = new ArrayList<String>();
            for (String string : templateBiomeTagStrings) {
                ResourceLocation resourceLocation;
                IBiomeConfig biomeConfig;
                tagString2 = string.trim().toLowerCase();
                tagSubStrings = tagString2.split(" ");
                if (!tagString2.startsWith("-")) {
                    if (!(tagString2.startsWith("mod.") || tagString2.startsWith("category.") || tagString2.startsWith("modcategory.") || tagString2.startsWith("mccategory.") || tagString2.startsWith("tag.") || tagString2.startsWith("modtag.") || tagString2.startsWith("mctag.") || tagString2.startsWith("-mod.") || tagString2.startsWith("-category.") || tagString2.startsWith("-modcategory.") || tagString2.startsWith("-mccategory.") || tagString2.startsWith("-tag.") || tagString2.startsWith("-modtag.") || tagString2.startsWith("-mctag."))) {
                        biomeConfig = biomeConfigsByName.get(string.trim());
                        if (biomeConfig != null) {
                            if (biomeConfig.getIsTemplateForBiome()) {
                                for (Map.Entry<IBiomeResourceLocation, IBiomeConfig> entry : biomeConfigsByResourceLocation.entrySet()) {
                                    if (!entry.getValue().getName().equals(biomeConfig.getName()) || groupBiomes.containsKey(entry.getKey().toResourceLocationString())) continue;
                                    if (OTG.getEngine().getLogger().getLogCategoryEnabled(LogCategory.BIOME_REGISTRY)) {
                                        OTG.getEngine().getLogger().log(LogLevel.INFO, LogCategory.BIOME_REGISTRY, "BiomeConfig " + biomeConfig.getName() + " found for entry " + string + " in group " + group.getName());
                                    }
                                    groupBiomes.put(entry.getKey().toResourceLocationString(), entry.getValue());
                                }
                                continue;
                            }
                            if (groupBiomes.containsKey(string.trim())) continue;
                            if (OTG.getEngine().getLogger().getLogCategoryEnabled(LogCategory.BIOME_REGISTRY)) {
                                OTG.getEngine().getLogger().log(LogLevel.INFO, LogCategory.BIOME_REGISTRY, "BiomeConfig " + biomeConfig.getName() + " found for entry " + string + " in group " + group.getName());
                            }
                            groupBiomes.put(string.trim(), biomeConfig);
                            continue;
                        }
                        if (string.trim().contains(":") && tagSubStrings.length == 1) {
                            String[] resourceLocationParts = string.trim().split(":");
                            if (resourceLocationParts.length != 2 || (biomeConfig = biomeConfigsByResourceLocation.get(new MCBiomeResourceLocation(resourceLocationParts[0], resourceLocationParts[1], presetFolderName))) == null || groupBiomes.containsKey(string.trim())) continue;
                            if (OTG.getEngine().getLogger().getLogCategoryEnabled(LogCategory.BIOME_REGISTRY)) {
                                OTG.getEngine().getLogger().log(LogLevel.INFO, LogCategory.BIOME_REGISTRY, "BiomeConfig " + biomeConfig.getName() + " found for entry " + string + " in group " + group.getName());
                            }
                            groupBiomes.put(string.trim(), biomeConfig);
                            continue;
                        }
                        if (!OTG.getEngine().getLogger().getLogCategoryEnabled(LogCategory.BIOME_REGISTRY)) continue;
                        OTG.getEngine().getLogger().log(LogLevel.INFO, LogCategory.BIOME_REGISTRY, "No biomeConfig found for entry " + string + " in group " + group.getName());
                        continue;
                    }
                    if (tagString2.startsWith("mod.") && tagSubStrings.length == 1) {
                        allowedMods.add(tagString2.replace("mod.", ""));
                        continue;
                    }
                    tagStrings.add(string);
                    continue;
                }
                biomeConfig = biomeConfigsByName.get(string.trim().replace("-", ""));
                if (biomeConfig != null) {
                    if (biomeConfig.getIsTemplateForBiome()) {
                        for (Map.Entry<IBiomeResourceLocation, IBiomeConfig> entry : biomeConfigsByResourceLocation.entrySet()) {
                            Biome biome3;
                            if (!entry.getValue().getName().equals(biomeConfig.getName()) || (biome3 = (Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation(entry.getKey().toResourceLocationString()))) == null) continue;
                            excludedBiomes.add(biome3);
                        }
                        continue;
                    }
                    Biome biome4 = (Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation(biomeConfig.getRegistryKey().toResourceLocationString()));
                    if (biome4 == null) continue;
                    excludedBiomes.add(biome4);
                    continue;
                }
                if (string.trim().contains(":") && tagSubStrings.length == 1) {
                    resourceLocation = new ResourceLocation(tagString2.replace("minecraft:", "").replace(" ", "_").substring(1));
                    Biome biome2 = (Biome)ForgeRegistries.BIOMES.getValue(resourceLocation);
                    if (biome2 == null) continue;
                    excludedBiomes.add(biome2);
                    continue;
                }
                if (tagSubStrings.length == 1 && tagString2.startsWith("-category.") || tagString2.startsWith("-modcategory.") || tagString2.startsWith("-mccategory.") || tagString2.startsWith("-tag.") || tagString2.startsWith("-modtag.") || tagString2.startsWith("-mctag.")) {
                    resourceLocation = new ResourceLocation(tagString2.replace("minecraft:", "").replace(" ", "_").substring(1));
                    Biome biome2 = (Biome)ForgeRegistries.BIOMES.getValue(resourceLocation);
                    if (biome2 == null) continue;
                    excludedBiomes.add(biome2);
                    if (!OTG.getEngine().getLogger().getLogCategoryEnabled(LogCategory.BIOME_REGISTRY)) continue;
                    OTG.getEngine().getLogger().log(LogLevel.INFO, LogCategory.BIOME_REGISTRY, "Biome " + biome2.getRegistryName().toString() + " excluded for entry " + string + " in group " + group.getName());
                    continue;
                }
                if (tagSubStrings.length == 1 && tagString2.toLowerCase().startsWith("-category.") || tagString2.toLowerCase().startsWith("-modcategory.") || tagString2.toLowerCase().startsWith("-mccategory.")) {
                    Biome.Category category = Biome.Category.func_235103_a_((String)tagString2.toLowerCase().replace("-modcategory.", "").replace("-mccategory.", "").replace("-category.", ""));
                    if (category != null) {
                        excludedCategories.add(category);
                        continue;
                    }
                    if (!OTG.getEngine().getLogger().getLogCategoryEnabled(LogCategory.BIOME_REGISTRY)) continue;
                    OTG.getEngine().getLogger().log(LogLevel.INFO, LogCategory.BIOME_REGISTRY, "Biome category " + string + " for entry " + string + " in group " + group.getName() + " could not be found.");
                    continue;
                }
                if (tagSubStrings.length == 1 && tagString2.startsWith("-tag.") || tagString2.startsWith("-modtag.") || tagString2.startsWith("-mctag.")) {
                    BiomeDictionary.Type tag = BiomeDictionary.Type.getType((String)tagString2.replace("-modtag.", "").replace("-mctag.", "").replace("-tag.", ""), (BiomeDictionary.Type[])new BiomeDictionary.Type[0]);
                    if (tag != null) {
                        excludedTags.add(tag);
                        continue;
                    }
                    if (!OTG.getEngine().getLogger().getLogCategoryEnabled(LogCategory.CONFIGS)) continue;
                    OTG.getEngine().getLogger().log(LogLevel.INFO, LogCategory.BIOME_REGISTRY, "Biome tag " + string + " for entry " + string + " in group " + group.getName() + " could not be found.");
                    continue;
                }
                if (tagSubStrings.length == 1 && tagString2.startsWith("-mod.")) {
                    excludedMods.add(tagString2.replace("-mod.", ""));
                    continue;
                }
                if (!tagString2.startsWith("-mod.") && !tagString2.startsWith("-category.") && !tagString2.startsWith("-modcategory.") && !tagString2.startsWith("-mccategory.") && !tagString2.startsWith("-tag.") && !tagString2.startsWith("-modtag.") && !tagString2.startsWith("-mctag.")) continue;
                tagStrings.add(string);
            }
            for (String string : tagStrings) {
                tagString2 = string.trim().toLowerCase();
                tagSubStrings = string.split(" ");
                if (tagString2.startsWith("mod.") || tagString2.startsWith("category.") || tagString2.startsWith("modcategory.") || tagString2.startsWith("mccategory.") || tagString2.startsWith("tag.") || tagString2.startsWith("modtag.") || tagString2.startsWith("mctag.") || tagString2.startsWith("-mod.") || tagString2.startsWith("-category.") || tagString2.startsWith("-modcategory.") || tagString2.startsWith("-mccategory.") || tagString2.startsWith("-tag.") || tagString2.startsWith("-modtag.") || tagString2.startsWith("-mctag.")) {
                    Set<Object> biomesForTags = new HashSet();
                    ArrayList<Biome.Category> innerExcludedCategories = new ArrayList<Biome.Category>();
                    ArrayList<BiomeDictionary.Type> innerExcludedTags = new ArrayList<BiomeDictionary.Type>();
                    ArrayList<String> innerExcludedMods = new ArrayList<String>();
                    for (String string2 : tagSubStrings) {
                        Biome.Category category;
                        String tagSubString22 = string2.trim().toLowerCase().toLowerCase();
                        if (tagSubString22.startsWith("-category.") || tagSubString22.startsWith("-modcategory.") || tagSubString22.startsWith("-mccategory.")) {
                            category = Biome.Category.func_235103_a_((String)tagSubString22.replace("-modcategory.", "").replace("-mccategory.", "").replace("-category.", ""));
                            if (category != null) {
                                innerExcludedCategories.add(category);
                                biomesForTags.stream().filter(a -> ForgeRegistries.BIOMES.getValue(a.func_240901_a_()) != null && ((Biome)ForgeRegistries.BIOMES.getValue(a.func_240901_a_())).func_201856_r() != category).collect(Collectors.toList());
                                continue;
                            }
                            if (!OTG.getEngine().getLogger().getLogCategoryEnabled(LogCategory.BIOME_REGISTRY)) continue;
                            OTG.getEngine().getLogger().log(LogLevel.INFO, LogCategory.BIOME_REGISTRY, "Biome category " + string + " in group " + group.getName() + " could not be found.");
                            continue;
                        }
                        if (!tagSubString22.startsWith("category.") && !tagSubString22.startsWith("modcategory.") && !tagSubString22.startsWith("mccategory.")) continue;
                        category = Biome.Category.func_235103_a_((String)tagSubString22.replace("modcategory.", "").replace("mccategory.", "").replace("category.", ""));
                        if (category != null) {
                            biomesForTags.addAll(ForgeRegistries.BIOMES.getValues().stream().filter(biome -> !(biome.func_201856_r() != category || excludedBiomes.contains(biome) || excludedCategories.contains(biome.func_201856_r()) || innerExcludedCategories.contains(biome.func_201856_r()) || !excludedTags.stream().allMatch(type -> !BiomeDictionary.hasType((RegistryKey)RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)biome.getRegistryName()), (BiomeDictionary.Type)type)) || blackListedBiomes.contains(biome.getRegistryName().toString()) || biome.getRegistryName().func_110624_b().equals("otg") || allowedMods.size() != 0 && !allowedMods.stream().anyMatch(mod -> biome.getRegistryName().func_110624_b().equals(mod)) || excludedMods.size() != 0 && excludedMods.stream().anyMatch(mod -> biome.getRegistryName().func_110624_b().equals(mod)))).map(b -> RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)b.getRegistryName())).collect(Collectors.toList()));
                            continue;
                        }
                        if (!OTG.getEngine().getLogger().getLogCategoryEnabled(LogCategory.BIOME_REGISTRY)) continue;
                        OTG.getEngine().getLogger().log(LogLevel.INFO, LogCategory.BIOME_REGISTRY, "Biome category " + string2 + " in group " + group.getName() + " could not be found.");
                    }
                    ArrayList<BiomeDictionary.Type> tags = new ArrayList<BiomeDictionary.Type>();
                    ArrayList<String> tagsStrings = new ArrayList<String>();
                    for (String tagSubString3 : tagSubStrings) {
                        BiomeDictionary.Type tag;
                        String tagSubString2 = tagSubString3.trim().toLowerCase().toLowerCase();
                        if (tagSubString2.startsWith("-tag.") || tagSubString2.startsWith("-modtag.") || tagSubString2.startsWith("-mctag.")) {
                            tag = BiomeDictionary.Type.getType((String)tagSubString2.replace("-modtag.", "").replace("-mctag.", "").replace("-tag.", ""), (BiomeDictionary.Type[])new BiomeDictionary.Type[0]);
                            if (tag != null) {
                                innerExcludedTags.add(tag);
                                biomesForTags = biomesForTags.stream().filter(key -> !BiomeDictionary.hasType((RegistryKey)key, (BiomeDictionary.Type)tag)).collect(Collectors.toSet());
                                continue;
                            }
                            if (!OTG.getEngine().getLogger().getLogCategoryEnabled(LogCategory.CONFIGS)) continue;
                            OTG.getEngine().getLogger().log(LogLevel.INFO, LogCategory.BIOME_REGISTRY, "Biome tag " + tagSubString3 + " in group " + group.getName() + " could not be found.");
                            continue;
                        }
                        if (!tagSubString2.startsWith("tag.") && !tagSubString2.startsWith("modtag.") && !tagSubString2.startsWith("mctag.")) continue;
                        tag = BiomeDictionary.Type.getType((String)tagSubString2.replace("modtag.", "").replace("mctag.", "").replace("tag.", ""), (BiomeDictionary.Type[])new BiomeDictionary.Type[0]);
                        if (tag != null) {
                            tags.add(tag);
                            tagsStrings.add(tagSubString2);
                            continue;
                        }
                        if (!OTG.getEngine().getLogger().getLogCategoryEnabled(LogCategory.CONFIGS)) continue;
                        OTG.getEngine().getLogger().log(LogLevel.INFO, LogCategory.BIOME_REGISTRY, "Biome tag " + tagSubString3 + " in group " + group.getName() + " could not be found.");
                    }
                    ArrayList<String> innerMods = new ArrayList<String>();
                    for (String tagSubString4 : tagSubStrings) {
                        String tagSubString2 = tagSubString4.trim().toLowerCase();
                        if (tagSubString2.startsWith("-mod.")) {
                            innerExcludedMods.add(tagSubString2.replace("-mod.", ""));
                            biomesForTags = biomesForTags.stream().filter(key -> !key.func_240901_a_().func_110624_b().equals(tagSubString2.replace("-mod.", ""))).collect(Collectors.toSet());
                            continue;
                        }
                        if (!tagSubString2.startsWith("mod.")) continue;
                        innerMods.add(tagSubString2.replace("mod.", ""));
                    }
                    if (innerMods.size() > 0) {
                        biomesForTags = biomesForTags.stream().filter(key -> innerMods.stream().anyMatch(a -> a.equals(key.func_240901_a_().func_110624_b()))).collect(Collectors.toSet());
                    }
                    if (tags.size() > 0) {
                        String string3 = (String)tagsStrings.get(0);
                        biomesForTags.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)((BiomeDictionary.Type)tags.get(0))).stream().filter(key -> !(!tags.stream().allMatch(tag -> BiomeDictionary.hasType((RegistryKey)key, (BiomeDictionary.Type)tag)) || ForgeRegistries.BIOMES.getValue(key.func_240901_a_()) == null || excludedBiomes.contains(ForgeRegistries.BIOMES.getValue(key.func_240901_a_())) || excludedCategories.contains(((Biome)ForgeRegistries.BIOMES.getValue(key.func_240901_a_())).func_201856_r()) || innerExcludedCategories.contains(((Biome)ForgeRegistries.BIOMES.getValue(key.func_240901_a_())).func_201856_r()) || !excludedTags.stream().allMatch(type -> !BiomeDictionary.hasType((RegistryKey)RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)key.func_240901_a_()), (BiomeDictionary.Type)type)) || !innerExcludedTags.stream().allMatch(type -> !BiomeDictionary.hasType((RegistryKey)RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)key.func_240901_a_()), (BiomeDictionary.Type)type)) || blackListedBiomes.contains(key.func_240901_a_().toString()) || key.func_240901_a_().func_110624_b().equals("otg") || allowedMods.size() != 0 && !allowedMods.stream().anyMatch(mod -> key.func_240901_a_().func_110624_b().equals(mod)) || excludedMods.size() != 0 && excludedMods.stream().anyMatch(mod -> key.func_240901_a_().func_110624_b().equals(mod)) || innerMods.size() != 0 && !innerMods.stream().anyMatch(mod -> key.func_240901_a_().func_110624_b().equals(mod)) || innerExcludedMods.size() != 0 && innerExcludedMods.stream().anyMatch(mod -> key.func_240901_a_().func_110624_b().equals(mod)) || !tagType.startsWith("tag.") && (!tagType.startsWith("modtag.") || key.func_240901_a_().func_110624_b().equals("minecraft")) && (!tagType.startsWith("mctag.") || !key.func_240901_a_().func_110624_b().equals("minecraft")))).collect(Collectors.toList()));
                    }
                    if (biomesForTags.size() > 0) {
                        for (RegistryKey biomeForTag : biomesForTags) {
                            Biome biome5 = (Biome)ForgeRegistries.BIOMES.getValue(biomeForTag.func_240901_a_());
                            if (biome5 == null || !group.temperatureAllowed(biome5.func_242445_k())) continue;
                            MCBiomeResourceLocation otgLocation = new MCBiomeResourceLocation(biomeForTag.func_240901_a_().func_110624_b(), biomeForTag.func_240901_a_().func_110623_a(), presetFolderName);
                            IBiomeConfig biomeConfig = biomeConfigsByResourceLocation.get(otgLocation);
                            if (biomeConfig != null && !groupBiomes.containsKey(biomeForTag.func_240901_a_().toString())) {
                                if (OTG.getEngine().getLogger().getLogCategoryEnabled(LogCategory.BIOME_REGISTRY)) {
                                    OTG.getEngine().getLogger().log(LogLevel.INFO, LogCategory.BIOME_REGISTRY, "BiomeConfig " + biomeConfig.getName() + " found for biome " + biome5.getRegistryName().toString() + " in group " + group.getName() + " with entry " + string);
                                }
                                groupBiomes.put(biomeForTag.func_240901_a_().toString(), biomeConfig);
                                continue;
                            }
                            if (biomeConfig != null || !OTG.getEngine().getLogger().getLogCategoryEnabled(LogCategory.BIOME_REGISTRY)) continue;
                            OTG.getEngine().getLogger().log(LogLevel.INFO, LogCategory.BIOME_REGISTRY, "No BiomeConfig found for biome " + biome5.getRegistryName().toString() + " in group " + group.getName() + " with entry " + string);
                        }
                        continue;
                    }
                    if (!OTG.getEngine().getLogger().getLogCategoryEnabled(LogCategory.BIOME_REGISTRY)) continue;
                    OTG.getEngine().getLogger().log(LogLevel.INFO, LogCategory.BIOME_REGISTRY, "No tags or categories found for group " + group.getName() + " with entry " + string);
                    continue;
                }
                if (!OTG.getEngine().getLogger().getLogCategoryEnabled(LogCategory.BIOME_REGISTRY)) continue;
                OTG.getEngine().getLogger().log(LogLevel.INFO, LogCategory.BIOME_REGISTRY, "No tags or categories found for group " + group.getName() + " with entry " + string);
            }
            for (Map.Entry entry : ((HashMap)groupBiomes).entrySet()) {
                if (entry.getValue() == null) continue;
                IBiomeConfig config = (IBiomeConfig)entry.getValue();
                BiomeData newBiomeData = new BiomeData(config.getOTGBiomeId(), config.getBiomeRarity(), config.getBiomeSize(), config.getBiomeTemperature(), config.getIsleInBiomes(), config.getBorderInBiomes(), config.getOnlyBorderNearBiomes(), config.getNotBorderNearBiomes());
                bg.biomes.add(newBiomeData);
                biomeDepths.add(config.getBiomeSize());
                totalTemp += config.getBiomeTemperature();
                bg.totalGroupRarity += config.getBiomeRarity();
                int n = config.getBiomeSize();
                bg.totalDepthRarity[n] = bg.totalDepthRarity[n] + config.getBiomeRarity();
            }
            for (int depth = 0; depth < bg.totalDepthRarity.length; ++depth) {
                void var23_32;
                int n = depth;
                while (var23_32 < bg.totalDepthRarity.length) {
                    int n2 = depth;
                    bg.maxRarityPerDepth[n2] = bg.maxRarityPerDepth[n2] + bg.totalDepthRarity[var23_32];
                    ++var23_32;
                }
            }
            bg.avgTemp = totalTemp / (float)group.getBiomes().size();
            int groupSize = group.getGenerationDepth();
            List list = groupDepths.getOrDefault(groupSize, new ArrayList());
            list.add(bg);
            groupDepths.put(groupSize, list);
            data.groupRegistry.put(bg.id, bg);
        }
    }

    @Override
    protected void mergeVanillaBiomeMobSpawnSettings(BiomeConfigFinder.BiomeConfigStub biomeConfigStub, String biomeResourceLocation) {
        String[] resourceLocationArr = biomeResourceLocation.split(":");
        String resourceDomain = resourceLocationArr.length > 1 ? resourceLocationArr[0] : null;
        String resourceLocation = resourceLocationArr.length > 1 ? resourceLocationArr[1] : resourceLocationArr[0];
        Biome biome = null;
        try {
            ResourceLocation location = new ResourceLocation(resourceDomain, resourceLocation);
            biome = (Biome)ForgeRegistries.BIOMES.getValue(location);
        }
        catch (ResourceLocationException resourceLocationException) {
            // empty catch block
        }
        if (biome != null) {
            biomeConfigStub.mergeMobs(this.getListFromMinecraftBiome(biome, EntityClassification.MONSTER), EntityCategory.MONSTER);
            biomeConfigStub.mergeMobs(this.getListFromMinecraftBiome(biome, EntityClassification.AMBIENT), EntityCategory.AMBIENT_CREATURE);
            biomeConfigStub.mergeMobs(this.getListFromMinecraftBiome(biome, EntityClassification.CREATURE), EntityCategory.CREATURE);
            biomeConfigStub.mergeMobs(this.getListFromMinecraftBiome(biome, EntityClassification.WATER_AMBIENT), EntityCategory.WATER_AMBIENT);
            biomeConfigStub.mergeMobs(this.getListFromMinecraftBiome(biome, EntityClassification.WATER_CREATURE), EntityCategory.WATER_CREATURE);
            biomeConfigStub.mergeMobs(this.getListFromMinecraftBiome(biome, EntityClassification.MISC), EntityCategory.MISC);
        } else if (OTG.getEngine().getLogger().getLogCategoryEnabled(LogCategory.MOBS)) {
            OTG.getEngine().getLogger().log(LogLevel.ERROR, LogCategory.MOBS, "Could not inherit mobs for unrecognised biome \"" + biomeResourceLocation + "\" in " + biomeConfigStub.getBiomeName() + ".bc");
        }
    }

    private List<WeightedMobSpawnGroup> getListFromMinecraftBiome(Biome biome, EntityClassification type) {
        List mobList = biome.func_242433_b().func_242559_a(type);
        ArrayList<WeightedMobSpawnGroup> result = new ArrayList<WeightedMobSpawnGroup>();
        for (MobSpawnInfo.Spawners spawner : mobList) {
            WeightedMobSpawnGroup wMSG = new WeightedMobSpawnGroup(spawner.field_242588_c.getRegistryName().toString(), spawner.field_76292_a, spawner.field_242589_d, spawner.field_242590_e);
            if (wMSG == null) continue;
            result.add(wMSG);
        }
        return result;
    }
}

