/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.util;

import com.pg85.otg.OTG;
import com.pg85.otg.forge.gen.ForgeWorldGenRegion;
import com.pg85.otg.util.gen.LocalWorldGenRegion;
import com.pg85.otg.util.logging.LogCategory;
import com.pg85.otg.util.logging.LogLevel;
import com.pg85.otg.util.nbt.LocalNBTHelper;
import com.pg85.otg.util.nbt.NamedBinaryTag;
import java.text.MessageFormat;
import java.util.Set;
import net.minecraft.nbt.ByteArrayNBT;
import net.minecraft.nbt.ByteNBT;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.DoubleNBT;
import net.minecraft.nbt.FloatNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntArrayNBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.LongNBT;
import net.minecraft.nbt.ShortNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;

public class ForgeNBTHelper
extends LocalNBTHelper {
    @Override
    public NamedBinaryTag getNBTFromLocation(LocalWorldGenRegion world, int x, int y, int z) {
        TileEntity tileEntity = ((ForgeWorldGenRegion)world).getTileEntity(new BlockPos(x, y, z));
        if (tileEntity == null) {
            return null;
        }
        CompoundNBT nbt = new CompoundNBT();
        tileEntity.func_189515_b(nbt);
        nbt.func_82580_o("x");
        nbt.func_82580_o("y");
        nbt.func_82580_o("z");
        return ForgeNBTHelper.getNBTFromNMSTagCompound(null, nbt);
    }

    public static NamedBinaryTag getNBTFromNMSTagCompound(String name, CompoundNBT compoundNBT) {
        NamedBinaryTag compoundTag = new NamedBinaryTag(NamedBinaryTag.Type.TAG_Compound, name, (Object)new NamedBinaryTag[]{new NamedBinaryTag(NamedBinaryTag.Type.TAG_End, null, (Object)null)});
        Set keys = compoundNBT.func_150296_c();
        for (String key : keys) {
            INBT nmsChildTag = compoundNBT.func_74781_a(key);
            if (nmsChildTag == null) {
                if (!OTG.getEngine().getLogger().getLogCategoryEnabled(LogCategory.CUSTOM_OBJECTS)) continue;
                OTG.getEngine().getLogger().log(LogLevel.ERROR, LogCategory.CUSTOM_OBJECTS, "Failed to read NBT property " + key + " from tag " + compoundNBT.func_74732_a());
                continue;
            }
            NamedBinaryTag.Type type = NamedBinaryTag.Type.values()[nmsChildTag.func_74732_a()];
            switch (type) {
                case TAG_End: {
                    break;
                }
                case TAG_Byte: 
                case TAG_Short: 
                case TAG_Int: 
                case TAG_Long: 
                case TAG_Float: 
                case TAG_Double: 
                case TAG_Byte_Array: 
                case TAG_String: 
                case TAG_Int_Array: {
                    compoundTag.addTag(new NamedBinaryTag(type, key, ForgeNBTHelper.getValueFromNms(nmsChildTag)));
                    break;
                }
                case TAG_List: {
                    NamedBinaryTag listChildTag = ForgeNBTHelper.getNBTFromNMSTagList(key, (ListNBT)nmsChildTag);
                    if (listChildTag == null) break;
                    compoundTag.addTag(listChildTag);
                    break;
                }
                case TAG_Compound: {
                    compoundTag.addTag(ForgeNBTHelper.getNBTFromNMSTagCompound(key, (CompoundNBT)nmsChildTag));
                    break;
                }
            }
        }
        return compoundTag;
    }

    private static NamedBinaryTag getNBTFromNMSTagList(String name, ListNBT listNBT) {
        if (listNBT.size() == 0) {
            return null;
        }
        NamedBinaryTag.Type listType = NamedBinaryTag.Type.values()[listNBT.func_230528_d__()];
        NamedBinaryTag listTag = new NamedBinaryTag(name, listType);
        block6: for (int i = 0; i < listNBT.size(); ++i) {
            INBT nmsChildTag = listNBT.get(i);
            switch (listType) {
                case TAG_End: {
                    continue block6;
                }
                case TAG_Byte: 
                case TAG_Short: 
                case TAG_Int: 
                case TAG_Long: 
                case TAG_Float: 
                case TAG_Double: 
                case TAG_Byte_Array: 
                case TAG_String: 
                case TAG_Int_Array: {
                    listTag.addTag(new NamedBinaryTag(listType, null, ForgeNBTHelper.getValueFromNms(nmsChildTag)));
                    continue block6;
                }
                case TAG_List: {
                    NamedBinaryTag listChildTag = ForgeNBTHelper.getNBTFromNMSTagList(null, (ListNBT)nmsChildTag);
                    if (listChildTag == null) continue block6;
                    listTag.addTag(listChildTag);
                    continue block6;
                }
                case TAG_Compound: {
                    listTag.addTag(ForgeNBTHelper.getNBTFromNMSTagCompound(null, (CompoundNBT)nmsChildTag));
                    continue block6;
                }
                default: {
                    if (!OTG.getEngine().getLogger().getLogCategoryEnabled(LogCategory.CUSTOM_OBJECTS)) continue block6;
                    OTG.getEngine().getLogger().log(LogLevel.ERROR, LogCategory.CUSTOM_OBJECTS, MessageFormat.format("Cannot convert list subtype {0} from it's NMS value", new Object[]{listType}));
                }
            }
        }
        return listTag;
    }

    private static Object getValueFromNms(INBT inbt) {
        NamedBinaryTag.Type type = NamedBinaryTag.Type.values()[inbt.func_74732_a()];
        switch (type) {
            case TAG_Byte: {
                return ((ByteNBT)inbt).func_150290_f();
            }
            case TAG_Short: {
                return ((ShortNBT)inbt).func_150289_e();
            }
            case TAG_Int: {
                return ((IntNBT)inbt).func_150287_d();
            }
            case TAG_Long: {
                return ((LongNBT)inbt).func_150291_c();
            }
            case TAG_Float: {
                return Float.valueOf(((FloatNBT)inbt).func_150288_h());
            }
            case TAG_Double: {
                return ((DoubleNBT)inbt).func_150286_g();
            }
            case TAG_Byte_Array: {
                return ((ByteArrayNBT)inbt).func_150292_c();
            }
            case TAG_String: {
                return inbt.func_150285_a_();
            }
            case TAG_Int_Array: {
                return ((IntArrayNBT)inbt).func_150302_c();
            }
        }
        throw new IllegalArgumentException((Object)((Object)type) + "doesn't have a simple value!");
    }

    public static CompoundNBT getNMSFromNBTTagCompound(NamedBinaryTag compoundTag) {
        CompoundNBT nmsTag = new CompoundNBT();
        NamedBinaryTag[] childTags = (NamedBinaryTag[])compoundTag.getValue();
        if (childTags == null) {
            return nmsTag;
        }
        block6: for (NamedBinaryTag tag : childTags) {
            switch (tag.getType()) {
                case TAG_End: {
                    continue block6;
                }
                case TAG_Byte: 
                case TAG_Short: 
                case TAG_Int: 
                case TAG_Long: 
                case TAG_Float: 
                case TAG_Double: 
                case TAG_Byte_Array: 
                case TAG_String: 
                case TAG_Int_Array: {
                    nmsTag.func_218657_a(tag.getName(), ForgeNBTHelper.createTagNms(tag.getType(), tag.getValue()));
                    continue block6;
                }
                case TAG_List: {
                    nmsTag.func_218657_a(tag.getName(), (INBT)ForgeNBTHelper.getNMSFromNBTTagList(tag));
                    continue block6;
                }
                case TAG_Compound: {
                    nmsTag.func_218657_a(tag.getName(), (INBT)ForgeNBTHelper.getNMSFromNBTTagCompound(tag));
                    continue block6;
                }
            }
        }
        return nmsTag;
    }

    private static ListNBT getNMSFromNBTTagList(NamedBinaryTag listTag) {
        NamedBinaryTag[] childTags;
        ListNBT nmsTag = new ListNBT();
        block5: for (NamedBinaryTag tag : childTags = (NamedBinaryTag[])listTag.getValue()) {
            switch (tag.getType()) {
                case TAG_Byte: 
                case TAG_Short: 
                case TAG_Int: 
                case TAG_Long: 
                case TAG_Float: 
                case TAG_Double: 
                case TAG_Byte_Array: 
                case TAG_String: 
                case TAG_Int_Array: {
                    nmsTag.add((Object)ForgeNBTHelper.createTagNms(tag.getType(), tag.getValue()));
                    continue block5;
                }
                case TAG_List: {
                    nmsTag.add((Object)ForgeNBTHelper.getNMSFromNBTTagList(tag));
                    continue block5;
                }
                case TAG_Compound: {
                    nmsTag.add((Object)ForgeNBTHelper.getNMSFromNBTTagCompound(tag));
                    continue block5;
                }
            }
        }
        return nmsTag;
    }

    private static INBT createTagNms(NamedBinaryTag.Type type, Object value) {
        switch (type) {
            case TAG_Byte: {
                return ByteNBT.func_229671_a_((byte)((Byte)value));
            }
            case TAG_Short: {
                return ShortNBT.func_229701_a_((short)((Short)value));
            }
            case TAG_Int: {
                return IntNBT.func_229692_a_((int)((Integer)value));
            }
            case TAG_Long: {
                return LongNBT.func_229698_a_((long)((Long)value));
            }
            case TAG_Float: {
                return FloatNBT.func_229689_a_((float)((Float)value).floatValue());
            }
            case TAG_Double: {
                return DoubleNBT.func_229684_a_((double)((Double)value));
            }
            case TAG_Byte_Array: {
                return new ByteArrayNBT((byte[])value);
            }
            case TAG_String: {
                return StringNBT.func_229705_a_((String)((String)value));
            }
            case TAG_Int_Array: {
                return new IntArrayNBT((int[])value);
            }
        }
        throw new IllegalArgumentException((Object)((Object)type) + "doesn't have a simple value!");
    }
}

